/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui.game;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;

public class TiledLayer
extends Layer {
    private static final int MAX_SIZE = Short.MAX_VALUE;
    private final int cols;
    private final int rows;
    int tileSetCellWidth;
    int tileSetCellHeight;
    int tileSetCellsCount;
    int tileSetCellsPerRow;
    private int animatedTilesCount;
    private int[] animatedTiles;
    private final int[] staticTiles;
    Image tileSet;

    public TiledLayer(int cols, int rows, Image tileSet, int cellWidth, int cellHeight) {
        int tileSetHeight;
        if (cols < 1 || cols > Short.MAX_VALUE) {
            throw new IllegalArgumentException("TiledLayer: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 cols \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 1 \u0438\u043b\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 32767.");
        }
        if (rows < 1 || rows > Short.MAX_VALUE) {
            throw new IllegalArgumentException("TiledLayer: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 rows \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 1 \u0438\u043b\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 32767.");
        }
        if (tileSet == null) {
            throw new NullPointerException("TiledLayer: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 tileSet \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (cellWidth < 1 || cellWidth > Short.MAX_VALUE) {
            throw new IllegalArgumentException("TiledLayer: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 cellWidth \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 1 \u0438\u043b\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 32767.");
        }
        if (cellHeight < 1 || cellHeight > Short.MAX_VALUE) {
            throw new IllegalArgumentException("TiledLayer: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 cellHeight \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 1 \u0438\u043b\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 32767.");
        }
        int tileSetWidth = tileSet.getWidth();
        if (tileSetWidth % cellWidth != 0 || (tileSetHeight = tileSet.getHeight()) % cellHeight != 0) {
            throw new IllegalArgumentException("TiledLayer: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u044f\u0447\u0435\u0435\u043a \u043e\u0431\u0430 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0434\u0435\u043b\u0438\u0442\u0435\u043b\u044f\u043c\u0438 \u0440\u0430\u0437\u043c\u0435\u0440\u043e\u0432 \u043d\u0430\u0431\u043e\u0440\u0430 \u043f\u043b\u0438\u0442\u043e\u043a.");
        }
        this.width = cols * cellWidth;
        this.height = rows * cellHeight;
        this.cols = cols;
        this.rows = rows;
        this.tileSetCellWidth = cellWidth;
        this.tileSetCellHeight = cellHeight;
        int tilesPerRow = tileSetWidth / cellWidth;
        this.tileSetCellsCount = tilesPerRow * (tileSetHeight / cellHeight);
        this.tileSetCellsPerRow = tilesPerRow;
        this.staticTiles = new int[cols * rows];
        this.tileSet = tileSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillCells(int startCol, int startRow, int numCols, int numRows, int tileIndex) {
        int error = 0;
        Object object = this.monitor;
        synchronized (object) {
            if (numCols < 0) {
                error = 1;
            } else if (numRows < 0) {
                error = 2;
            } else {
                int width = this.cols;
                if (!Array.isBoundValid((int)width, (int)startCol, (int)numCols) || !Array.isBoundValid((int)this.rows, (int)startRow, (int)numRows)) {
                    error = 3;
                } else if (tileIndex < -this.animatedTilesCount || tileIndex > this.tileSetCellsCount) {
                    error = 4;
                } else {
                    int[] tiles = this.staticTiles;
                    int offset = startCol + startRow * width;
                    int i = numRows;
                    while (i-- > 0) {
                        Array.fill((int[])tiles, (int)offset, (int)numCols, (int)tileIndex);
                        offset += width;
                    }
                }
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalArgumentException("TiledLayer.fillCells: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 numCols \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
            }
            case 2: {
                throw new IllegalArgumentException("TiledLayer.fillCells: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 numRows \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
            }
            case 3: {
                throw new IndexOutOfBoundsException("TiledLayer.fillCells: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
            case 4: {
                throw new IndexOutOfBoundsException("TiledLayer.fillCells: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 tileIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCell(int col, int row, int tileIndex) {
        int error = 0;
        Object object = this.monitor;
        synchronized (object) {
            int width;
            if (col < 0 || col >= (width = this.cols) || row < 0 || row >= this.rows) {
                error = 1;
            } else if (tileIndex < -this.animatedTilesCount || tileIndex > this.tileSetCellsCount) {
                error = 2;
            } else {
                this.staticTiles[col + row * width] = tileIndex;
            }
        }
        switch (error) {
            case 1: {
                throw new IndexOutOfBoundsException("TiledLayer.setCell: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
            case 2: {
                throw new IndexOutOfBoundsException("TiledLayer.setCell: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 tileIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnimatedTile(int animatedTileIndex, int staticTileIndex) {
        int error = 0;
        Object object = this.monitor;
        synchronized (object) {
            if (animatedTileIndex < -this.animatedTilesCount || animatedTileIndex >= 0) {
                error = 1;
            } else if (staticTileIndex < 0 || staticTileIndex > this.tileSetCellsCount) {
                error = 2;
            } else {
                this.animatedTiles[animatedTileIndex ^ 0xFFFFFFFF] = staticTileIndex;
            }
        }
        switch (error) {
            case 1: {
                throw new IndexOutOfBoundsException("TiledLayer.setAnimatedTile: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 animatedTileIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
            case 2: {
                throw new IndexOutOfBoundsException("TiledLayer.setAnimatedTile: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 staticTileIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStaticTileSet(Image tileSet, int cellWidth, int cellHeight) {
        int tileSetHeight;
        if (tileSet == null) {
            throw new NullPointerException("TiledLayer.setStaticTileSet: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 tileSet \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (cellWidth < 1 || cellWidth > Short.MAX_VALUE) {
            throw new IllegalArgumentException("TiledLayer.setStaticTileSet: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 cellWidth \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 1 \u0438\u043b\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 32767.");
        }
        if (cellHeight < 1 || cellHeight > Short.MAX_VALUE) {
            throw new IllegalArgumentException("TiledLayer.setStaticTileSet: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 cellHeight \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 1 \u0438\u043b\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 32767.");
        }
        int tileSetWidth = tileSet.getWidth();
        if (tileSetWidth % cellWidth != 0 || (tileSetHeight = tileSet.getHeight()) % cellHeight != 0) {
            throw new IllegalArgumentException("TiledLayer.setStaticTileSet: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u044f\u0447\u0435\u0435\u043a \u043e\u0431\u0430 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0434\u0435\u043b\u0438\u0442\u0435\u043b\u044f\u043c\u0438 \u0440\u0430\u0437\u043c\u0435\u0440\u043e\u0432 \u043d\u0430\u0431\u043e\u0440\u0430 \u043f\u043b\u0438\u0442\u043e\u043a.");
        }
        Object object = this.monitor;
        synchronized (object) {
            int newCellsCount;
            int oldCellsCount = this.tileSetCellsCount;
            this.width = this.cols * cellWidth;
            this.height = this.rows * cellHeight;
            this.tileSetCellWidth = cellWidth;
            this.tileSetCellHeight = cellHeight;
            int tilesPerRow = tileSetWidth / cellWidth;
            this.tileSetCellsCount = newCellsCount = tilesPerRow * (tileSetHeight / cellHeight);
            this.tileSetCellsPerRow = tilesPerRow;
            this.tileSet = tileSet;
            if (newCellsCount < oldCellsCount) {
                this.animatedTilesCount = 0;
                this.animatedTiles = null;
                int[] tiles = this.staticTiles;
                Array.fill((int[])this.staticTiles, (int)0, (int)tiles.length, (int)0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createAnimatedTile(int staticTileIndex) {
        int result;
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            if (staticTileIndex < 0 || staticTileIndex > this.tileSetCellsCount) {
                error = true;
                result = 0;
            } else {
                int len = this.animatedTilesCount;
                result = ~len;
                int[] tiles = this.animatedTiles;
                if (this.animatedTiles == null) {
                    tiles = this.animatedTiles = new int[7];
                } else if (len == tiles.length) {
                    int[] nArray = tiles;
                    tiles = this.animatedTiles = new int[(len << 1) + 1];
                    Array.copy((int[])nArray, (int)0, (int[])this.animatedTiles, (int)0, (int)len);
                }
                tiles[len++] = staticTileIndex;
                this.animatedTilesCount = len;
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("TiledLayer.createAnimatedTile: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 staticTileIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCell(int col, int row) {
        int result;
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            int width;
            if (col < 0 || col >= (width = this.cols) || row < 0 || row >= this.rows) {
                error = true;
                result = 0;
            } else {
                result = this.staticTiles[col + row * width];
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("TiledLayer.getCell: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAnimatedTile(int animatedTileIndex) {
        int result;
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            if (animatedTileIndex < -this.animatedTilesCount || animatedTileIndex >= 0) {
                error = true;
                result = 0;
            } else {
                result = this.animatedTiles[~animatedTileIndex];
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("TiledLayer.getAnimatedTile: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 animatedTileIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(Graphics render) {
        if (render == null) {
            throw new NullPointerException("TiledLayer.paint: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 render \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (!this.visibility) {
            return;
        }
        Object object = this.monitor;
        synchronized (object) {
            int left = this.left;
            int top = this.top;
            int cols = this.cols;
            int rows = this.rows;
            int cellWidth = this.tileSetCellWidth;
            int cellHeight = this.tileSetCellHeight;
            int cellsPerRow = this.tileSetCellsPerRow;
            int clip = render.getClipX();
            int scol = left > clip ? 0 : (clip - left) / cellWidth;
            int fcol = left > (clip += render.getClipWidth() - 1) ? -1 : (clip - left) / cellWidth;
            clip = render.getClipY();
            int srow = top > clip ? 0 : (clip - top) / cellHeight;
            int frow = top > (clip += render.getClipHeight() - 1) ? -1 : (clip - top) / cellHeight;
            int[] animatedTiles = this.animatedTiles;
            int[] staticTiles = this.staticTiles;
            Image tileSet = this.tileSet;
            int offset = srow * cols;
            int y = top + srow * cellHeight;
            int row = srow;
            while (row <= frow && row < rows) {
                int x = left + scol * cellWidth;
                int col = scol;
                while (col <= fcol && col < cols) {
                    int tileIndex = staticTiles[offset + col];
                    if (tileIndex < 0) {
                        tileIndex = animatedTiles[~tileIndex];
                    }
                    if (tileIndex-- > 0) {
                        int tileSetLeft = tileIndex % cellsPerRow * cellWidth;
                        int tileSetTop = tileIndex / cellsPerRow * cellHeight;
                        render.drawRegion(tileSet, tileSetLeft, tileSetTop, cellWidth, cellHeight, 0, x, y, 0);
                    }
                    x += cellWidth;
                    ++col;
                }
                offset += cols;
                y += cellHeight;
                ++row;
            }
        }
    }

    public final int getColumns() {
        return this.cols;
    }

    public final int getRows() {
        return this.rows;
    }

    public final int getCellWidth() {
        return this.tileSetCellWidth;
    }

    public final int getCellHeight() {
        return this.tileSetCellHeight;
    }

    final int getTileIndex(int col, int row) {
        int result = this.staticTiles[col + row * this.cols];
        if (result < 0) {
            result = this.animatedTiles[~result];
        }
        return result;
    }
}

