/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.lcdui;

import malik.emulator.microedition.lcdui.InputMode;
import malik.emulator.microedition.lcdui.SystemInputMode;

public final class AvailableInputModes {
    public static final AvailableInputModes instance = new AvailableInputModes();
    private final InputMode[] modes;
    private final InputMode system;

    private AvailableInputModes() {
        String className;
        int len = 0;
        Object[] modes = new InputMode[3];
        SystemInputMode system = new SystemInputMode();
        while ((className = System.getProperty("input.mode.".concat(Integer.toString(len)))) != null) {
            InputMode mode;
            try {
                mode = (InputMode)Class.forName(className).newInstance();
            }
            catch (Exception exception) {
                break;
            }
            if (len == modes.length) {
                Object[] objectArray = modes;
                modes = new InputMode[(len << 1) + 1];
                Array.copy((Object[])objectArray, (int)0, (Object[])modes, (int)0, (int)len);
            }
            modes[len++] = mode;
            if (len > 0) continue;
        }
        if (len < modes.length) {
            Object[] objectArray = modes;
            modes = new InputMode[len];
            Array.copy((Object[])objectArray, (int)0, (Object[])modes, (int)0, (int)len);
        }
        this.modes = modes;
        this.system = system;
    }

    public int size() {
        return this.modes.length;
    }

    public InputMode system() {
        return this.system;
    }

    public InputMode get(int index) {
        InputMode[] modes = this.modes;
        Array.checkIndex((String)"AvailableInputModes.get", (int)modes.length, (int)index);
        return modes[index];
    }

    public InputMode get(String characterSubset) {
        InputMode[] modes = this.modes;
        int i = this.modes.length;
        while (i-- > 0) {
            InputMode current = modes[i];
            if (!current.isCharacterSubset(characterSubset)) continue;
            return current;
        }
        return this.system;
    }
}

