/*
 * Decompiled with CFR 0.152.
 */
package javax.bluetooth;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.bluetooth.UUID;

public class DataElement {
    public static final int NULL = 0;
    public static final int U_INT_1 = 8;
    public static final int U_INT_2 = 9;
    public static final int U_INT_4 = 10;
    public static final int U_INT_8 = 11;
    public static final int U_INT_16 = 12;
    public static final int INT_1 = 16;
    public static final int INT_2 = 17;
    public static final int INT_4 = 18;
    public static final int INT_8 = 19;
    public static final int INT_16 = 20;
    public static final int URL = 64;
    public static final int UUID = 24;
    public static final int BOOL = 40;
    public static final int STRING = 32;
    public static final int DATSEQ = 48;
    public static final int DATALT = 56;
    private final byte type;
    private final Object value;

    public DataElement(int type) {
        Sequence value;
        switch (type) {
            case 0: {
                value = null;
                break;
            }
            case 48: 
            case 56: {
                value = new Sequence();
                break;
            }
            default: {
                throw new IllegalArgumentException("DataElement: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 type \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
        }
        this.type = (byte)type;
        this.value = value;
    }

    public DataElement(boolean value) {
        this.type = (byte)40;
        this.value = value ? Boolean.TRUE : Boolean.FALSE;
    }

    public DataElement(int type, long value) {
        switch (type) {
            case 8: {
                if (value >= 0L && value <= 255L) break;
                throw new IllegalArgumentException("DataElement: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 value \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
            case 9: {
                if (value >= 0L && value <= 65535L) break;
                throw new IllegalArgumentException("DataElement: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 value \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
            case 10: {
                if (value >= 0L && value <= 0xFFFFFFFFL) break;
                throw new IllegalArgumentException("DataElement: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 value \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
            case 16: {
                if (value >= -128L && value <= 127L) break;
                throw new IllegalArgumentException("DataElement: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 value \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
            case 17: {
                if (value >= -32768L && value <= 32767L) break;
                throw new IllegalArgumentException("DataElement: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 value \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
            case 18: {
                if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) break;
                throw new IllegalArgumentException("DataElement: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 value \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
            case 19: {
                break;
            }
            default: {
                throw new IllegalArgumentException("DataElement: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 type \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
        }
        this.type = (byte)type;
        this.value = new Long(value);
    }

    public DataElement(int type, Object value) {
        switch (type) {
            case 11: {
                byte[] copy;
                if (!(value instanceof byte[]) || (copy = (byte[])value).length != 8) {
                    throw new IllegalArgumentException("DataElement: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 value \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
                }
                byte[] byArray = copy;
                copy = new byte[8];
                Array.copy((byte[])byArray, (int)0, (byte[])copy, (int)0, (int)8);
                value = copy;
                break;
            }
            case 12: 
            case 20: {
                byte[] copy;
                if (!(value instanceof byte[]) || (copy = (byte[])value).length != 16) {
                    throw new IllegalArgumentException("DataElement: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 value \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
                }
                byte[] byArray = copy;
                copy = new byte[16];
                Array.copy((byte[])byArray, (int)0, (byte[])copy, (int)0, (int)16);
                value = copy;
                break;
            }
            case 32: 
            case 64: {
                if (value instanceof String) break;
                throw new IllegalArgumentException("DataElement: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 value \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
            case 24: {
                if (value instanceof UUID) break;
                throw new IllegalArgumentException("DataElement: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 value \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
            default: {
                throw new IllegalArgumentException("DataElement: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 type \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
        }
        this.type = (byte)type;
        this.value = value;
    }

    public void addElement(DataElement element) {
        Object value = this.value;
        if (!(value instanceof Sequence)) {
            throw new ClassCastException("DataElement.addElement: \u044d\u0442\u043e\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0442\u0438\u043f\u0430 DATSEQ \u0438\u043b\u0438 DATALT.");
        }
        if (element == null) {
            throw new NullPointerException("DataElement.addElement: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 element \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        ((Sequence)value).addElement(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void insertElementAt(DataElement element, int index) {
        value = this.value;
        if (!(value instanceof Sequence)) {
            throw new ClassCastException("DataElement.insertElementAt: \u044d\u0442\u043e\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0442\u0438\u043f\u0430 DATSEQ \u0438\u043b\u0438 DATALT.");
        }
        if (element == null) {
            throw new NullPointerException("DataElement.insertElementAt: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 element \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        error = false;
        var5_5 = value;
        synchronized (var5_5) {
            if (index < 0) ** GOTO lbl-1000
            seq = (Sequence)value;
            if (index > seq.length) lbl-1000:
            // 2 sources

            {
                error = true;
            } else {
                seq.insertElementAt(element, index);
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("DataElement.insertElementAt: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 index \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    public boolean removeElement(DataElement element) {
        Object value = this.value;
        if (!(value instanceof Sequence)) {
            throw new ClassCastException("DataElement.removeElement: \u044d\u0442\u043e\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0442\u0438\u043f\u0430 DATSEQ \u0438\u043b\u0438 DATALT.");
        }
        if (element == null) {
            throw new NullPointerException("DataElement.removeElement: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 element \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        return ((Sequence)value).removeElement(element);
    }

    public boolean getBoolean() {
        Object value = this.value;
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new ClassCastException("DataElement.getBoolean: \u044d\u0442\u043e\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0442\u0438\u043f\u0430 BOOL.");
    }

    public int getSize() {
        Object value = this.value;
        if (value instanceof Sequence) {
            return ((Sequence)value).length;
        }
        throw new ClassCastException("DataElement.getSize: \u044d\u0442\u043e\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0442\u0438\u043f\u0430 DATSEQ \u0438\u043b\u0438 DATALT.");
    }

    public int getDataType() {
        return this.type;
    }

    public long getLong() {
        Object value = this.value;
        if (value instanceof Long) {
            return (Long)value;
        }
        throw new ClassCastException("DataElement.getLong: \u044d\u0442\u043e\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0442\u0438\u043f\u0430 U_INT_1, U_INT_2, U_INT_4, INT_1, INT_2, INT_4 \u0438\u043b\u0438 INT_8.");
    }

    public Object getValue() {
        Object value = this.value;
        if (value instanceof byte[]) {
            byte[] byArray = (byte[])value;
            byte[] result = byArray;
            int len = result.length;
            result = new byte[len];
            Array.copy((byte[])byArray, (int)0, (byte[])result, (int)0, (int)len);
            return result;
        }
        if (value instanceof Sequence) {
            return ((Sequence)value).elements();
        }
        if (value instanceof String || value instanceof UUID) {
            return value;
        }
        throw new ClassCastException("DataElement.getValue: \u044d\u0442\u043e\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0442\u0438\u043f\u0430 U_INT_8, U_INT_16, INT_16, URL, UUID, STRING, DATSEQ \u0438\u043b\u0438 DATALT.");
    }

    private static final class Sequence {
        int length;
        Object[] elements = new DataElement[3];

        public synchronized void addElement(DataElement element) {
            Object[] elems = this.elements;
            int len = this.length;
            if (this.elements.length == len) {
                Object[] objectArray = elems;
                this.elements = new DataElement[(len << 1) + 1];
                elems = this.elements;
                Array.copy((Object[])objectArray, (int)0, (Object[])this.elements, (int)0, (int)len);
            }
            elems[len++] = element;
            this.length = len;
        }

        public void insertElementAt(DataElement element, int index) {
            Object[] elems = this.elements;
            int len = this.length;
            if (this.elements.length == len) {
                Object[] objectArray = elems;
                this.elements = new DataElement[(len << 1) + 1];
                elems = this.elements;
                Array.copy((Object[])objectArray, (int)0, (Object[])this.elements, (int)0, (int)len);
            }
            if (index < len) {
                Array.copy((Object[])elems, (int)index, (Object[])elems, (int)(index + 1), (int)(len - index));
            }
            elems[index] = element;
            this.length = len + 1;
        }

        public synchronized boolean removeElement(DataElement element) {
            int len;
            Object[] elems = this.elements;
            int index = Array.findf((Object[])this.elements, (int)0, (Object)element);
            if (index > (len = this.length - 1)) {
                return false;
            }
            if (index < len) {
                Array.copy((Object[])elems, (int)(index + 1), (Object[])elems, (int)index, (int)(len - index));
            }
            this.length = len;
            elems[this.length] = null;
            return true;
        }

        public Enumeration elements() {
            return new Enumeration(this){
                private int index;
                final /* synthetic */ Sequence this$1;
                {
                    this.this$1 = sequence;
                }

                public boolean hasMoreElements() {
                    return this.index < this.this$1.length;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object nextElement() {
                    Sequence parent;
                    boolean error = false;
                    Sequence sequence = parent = this.this$1;
                    synchronized (parent) {
                        Object result;
                        int i = this.index;
                        if (i >= parent.length) {
                            error = true;
                            result = null;
                        } else {
                            result = parent.elements[i++];
                            this.index = i;
                        }
                        // ** MonitorExit[var4_3] (shouldn't be in output)
                        if (error) {
                            throw new NoSuchElementException("Enumeration.nextElement: \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c.");
                        }
                        return result;
                    }
                }
            };
        }
    }
}

