/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.fileformats.graphics.jpeg;

import java.io.DataInputStream;
import java.io.IOException;
import malik.emulator.fileformats.ExtendedDataInputStream;
import malik.emulator.fileformats.InvalidDataFormatException;
import malik.emulator.fileformats.graphics.jpeg.Chunk;

final class StartOfScanChunk
extends Chunk {
    public int spectralSelectionBegin;
    public int spectralSelectionEnd;
    public int approximateBitPositionHigh;
    public int approximateBitPositionLow;
    private byte[] componentsIds;

    public StartOfScanChunk() {
        super(65498);
    }

    public void loadFromDataStream(ExtendedDataInputStream stream) throws IOException {
        int chunkLen = Chunk.readSize((DataInputStream)stream);
        if (chunkLen < 6 || stream.readUnsignedByte() << 1 != (chunkLen -= 4)) {
            throw new InvalidDataFormatException("JPEGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        byte[] componentData = new byte[chunkLen];
        stream.readFully(componentData);
        this.spectralSelectionBegin = stream.readUnsignedByte();
        this.spectralSelectionEnd = stream.readUnsignedByte();
        byte byte0 = stream.readByte();
        this.approximateBitPositionHigh = byte0 >> 4 & 0xF;
        this.approximateBitPositionLow = byte0 & 0xF;
        this.componentsIds = componentData;
    }

    public boolean isVeryProgressive() {
        int begin = this.spectralSelectionBegin;
        int end = this.spectralSelectionEnd;
        int high = this.approximateBitPositionHigh;
        int low = this.approximateBitPositionLow;
        return (begin <= 0 && end <= 0 || begin <= end && end <= 63) && low <= 13 && high <= 13 && (high <= 0 || high == low + 1) && (begin <= 0 || this.getComponentsCount() == 1);
    }

    public boolean isACProgressive() {
        return this.spectralSelectionBegin != 0 && this.spectralSelectionEnd != 0;
    }

    public boolean isDCProgressive() {
        return (this.spectralSelectionBegin | this.spectralSelectionEnd) == 0;
    }

    public int getComponentsCount() {
        return this.componentsIds.length >> 1;
    }

    public int getComponentId(int index) {
        return this.componentsIds[index << 1] & 0xFF;
    }

    public int getComponentChaffmanTableId(int index, int table) {
        return this.componentsIds[(index << 1) + 1] >> ((table ^ 1) << 2) & 0xF | table << 4;
    }
}

