/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;

public abstract class InputStream {
    public abstract int read() throws IOException;

    public void close() throws IOException {
    }

    public void reset() throws IOException {
        throw new IOException("InputStream.reset: \u043a\u043b\u0430\u0441\u0441 " + this.getClass().getName() + " \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u043c\u0435\u0442\u043e\u0434 reset.");
    }

    public void mark(int readLimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read(byte[] dst) throws IOException {
        if (dst == null) {
            throw new NullPointerException("InputStream.read: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int length = dst.length;
        int result = 0;
        while (result < length) {
            int data = this.read();
            if (data < 0) break;
            dst[result++] = (byte)data;
        }
        return result;
    }

    public int read(byte[] dst, int offset, int length) throws IOException {
        if (dst == null) {
            throw new NullPointerException("InputStream.read: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = dst.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("InputStream.read: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int result = 0;
        while (result < length) {
            int data = this.read();
            if (data < 0) break;
            dst[offset++] = (byte)data;
            ++result;
        }
        return result;
    }

    public int available() throws IOException {
        return 0;
    }

    public long skip(long bytesCount) throws IOException {
        long remaining = bytesCount;
        while (remaining > 0L && this.read() >= 0) {
            --remaining;
        }
        return bytesCount - remaining;
    }
}

