/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import malik.emulator.util.StackTraceElement;
import malik.emulator.util.StringBuilder;
import malik.emulator.util.ThrowableStackTrace;

public class Throwable {
    private static Thread DISABLE_STACK_TRACE_FOR;
    private int address;
    private final Object monitor;
    private final int ignore;
    private final StackTraceElement[] trace;
    private final String message;

    static {
        MalikInterrupt.register(0, new ArithmeticExceptionHandler());
        MalikInterrupt.register(1, new NullPointerExceptionHandler());
        MalikInterrupt.register(2, new MemoryFaultExceptionHandler());
        MalikInterrupt.register(3, new ExecutionExceptionHandler());
        MalikInterrupt.register(4, new OperandExceptionHandler());
        MalikInterrupt.register(5, new StackFaultExceptionHandler());
        MalikInterrupt.register(6, new StackOverflowExceptionHandler());
        MalikInterrupt.register(7, new UnknownOperationExceptionHandler());
        MalikInterrupt.register(8, new ArrayIndexOutOfBoundsExceptionHandler());
        MalikInterrupt.register(9, new UnhandledExceptionHandler());
        MalikInterrupt.register(32, new ThrowStatementInterruptHandler());
        MalikInterrupt.register(33, new IsEnabledInterruptHandler());
        MalikInterrupt.register(34, new SetEnabledInterruptHandler());
    }

    static void disableStackTrace() {
        DISABLE_STACK_TRACE_FOR = Thread.currentThread();
    }

    static void enableStackTrace() {
        DISABLE_STACK_TRACE_FOR = null;
    }

    public Throwable() {
        this(null, false);
    }

    public Throwable(String message) {
        this(message, false);
    }

    Throwable(String message, boolean implicit) {
        int ignore;
        StackTraceElement[] trace;
        Thread current;
        Class thisType = this.getClass();
        Class errorType = MalikSystem.getClassInstance("Ljava/lang/Error;");
        if (thisType != errorType && !thisType.isInheritedFrom(errorType) && ThrowableStackTrace.enabled() && (current = Thread.currentThread()) != DISABLE_STACK_TRACE_FOR) {
            trace = StackTracer.trace(current);
            ignore = this.getIgnore(trace, implicit);
        } else {
            ignore = 0;
            trace = null;
        }
        this.monitor = new Object();
        this.ignore = ignore;
        this.trace = trace;
        this.message = message;
    }

    public String toString() {
        String msg = this.getMessage();
        String cls = this.getClass().getName();
        return msg == null ? cls : new StringBuilder().append(cls).append(": ").append(msg).toString();
    }

    public void printStackTrace() {
        System.err.print(this.stackTraceToString());
    }

    public String getMessage() {
        return this.message;
    }

    public final void printRealStackTrace() {
        System.err.print(this.stackTraceToString());
    }

    public final String getRealMessage() {
        return this.message;
    }

    final int dummyThrowable() {
        return this.address ^ this.monitor.hashCode();
    }

    private int getIgnore(StackTraceElement[] trace, boolean implicit) {
        int result = 0;
        int limit = trace.length - 1;
        Class currType = this.getClass();
        Class thisType = MalikSystem.getClassInstance("Ljava/lang/Throwable;");
        while (true) {
            StackTraceElement element2;
            StackTraceElement element1;
            if (result < limit && (element1 = trace[result]) != null && (element2 = trace[result + 1]) != null && element1.getClassName().equals(element2.getClassName()) && "<init>".equals(element2.getMethodName())) {
                ++result;
                continue;
            }
            if (currType == thisType || result == limit) break;
            ++result;
            currType = currType.superType;
            if (currType == null) break;
        }
        int i = implicit && result < limit ? (result += 2) : ++result;
        while (i-- > 0) {
            trace[i] = null;
        }
        return result;
    }

    private String stackTraceToString() {
        String newline;
        int thisIgnore = this.ignore;
        StackTraceElement[] thisTrace = this.trace;
        StringBuilder result = new StringBuilder().append(this.getClass().getName());
        String msg = this.message;
        if (msg != null) {
            result.append(": ").append(msg);
        }
        if ((newline = System.getProperty("line.separator")) == null) {
            newline = "\n";
        }
        result.append(newline);
        if (thisTrace != null) {
            int len = thisTrace.length;
            int i = thisIgnore;
            while (i < len) {
                StackTraceElement element = thisTrace[i];
                if (element != null) {
                    result.append("    \u0432 ").append(element.toString()).append(newline);
                }
                ++i;
            }
        }
        return result.toString();
    }
}

