/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Date;
import java.util.TimeZone;
import malik.emulator.time.GregorianCalendar;

public abstract class Calendar {
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_WEEK = 7;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int SUNDAY = 1;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int AM = 0;
    public static final int PM = 1;
    private static final int FIELDS = 15;
    protected long time;
    protected boolean[] isSet;
    protected int[] fields;
    private boolean isTimeSet;
    private TimeZone zone;

    public static Calendar getInstance() {
        return new GregorianCalendar();
    }

    public static Calendar getInstance(TimeZone zone) {
        Calendar result = Calendar.getInstance();
        result.setTimeZone(zone);
        return result;
    }

    protected Calendar() {
        TimeZone z = TimeZone.getDefault();
        if (z == null) {
            throw new RuntimeException("Calendar: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0447\u0430\u0441\u043e\u0432\u043e\u0439 \u043f\u043e\u044f\u0441, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e.");
        }
        this.fields = new int[15];
        this.isSet = new boolean[15];
        this.zone = z;
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public boolean equals(Object ref) {
        block2: {
            block3: {
                if (ref == this) break block2;
                if (!(ref instanceof Calendar)) break block3;
                Calendar c = (Calendar)ref;
                if (this.getTimeInMillis() == c.getTimeInMillis() && this.getTimeZone().equals(c.getTimeZone())) break block2;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        long t = this.getTimeInMillis();
        return (int)(t ^ t >>> 32) ^ this.getTimeZone().hashCode();
    }

    public void setTimeZone(TimeZone zone) {
        this.zone = zone;
        this.getTimeInMillis();
        this.computeFields();
    }

    public boolean before(Object when) {
        return when instanceof Calendar && this.getTimeInMillis() < ((Calendar)when).getTimeInMillis();
    }

    public boolean after(Object when) {
        return when instanceof Calendar && this.getTimeInMillis() > ((Calendar)when).getTimeInMillis();
    }

    public TimeZone getTimeZone() {
        return this.zone;
    }

    public final void set(int field, int value) {
        this.isTimeSet = false;
        this.isSet[field] = true;
        this.fields[field] = value;
    }

    public final void setTime(Date time) {
        this.setTimeInMillis(time.getTime());
    }

    public final int get(int field) {
        switch (field) {
            default: {
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                this.getTimeInMillis();
                this.computeFields();
            }
        }
        return this.fields[field];
    }

    public final Date getTime() {
        return new Date(this.getTimeInMillis());
    }

    protected abstract void computeFields();

    protected abstract void computeTime();

    protected void setTimeInMillis(long millis) {
        this.isTimeSet = true;
        this.fields[7] = 0;
        this.time = millis;
        this.computeFields();
    }

    protected long getTimeInMillis() {
        if (!this.isTimeSet) {
            this.computeTime();
            this.isTimeSet = true;
        }
        return this.time;
    }
}

