/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.fileformats.text.mapped;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import malik.emulator.fileformats.InvalidDataFormatException;
import malik.emulator.fileformats.text.mapped.CustomKeyValueList;
import malik.emulator.i18n.Helper;

public class PropertiesFile
extends CustomKeyValueList {
    public static final char ESCAPE = '\\';
    public static final char COMMENT_START_1 = '!';
    public static final char COMMENT_START_2 = '#';
    public static final char KEY_VALUE_SEPARATOR_1 = ' ';
    public static final char KEY_VALUE_SEPARATOR_2 = ':';
    public static final char KEY_VALUE_SEPARATOR_3 = '=';
    public static final char UNICODE_CHAR = 'u';
    public static final String ENCODING = "ISO-8859-1";
    private String key;
    private String value;

    private static int skipWhiteSpace(char[] stream, int offset) {
        char c;
        int i = offset;
        while ((c = stream[i]) > '\u0000' && c <= ' ' && c != '\n' && c != '\r') {
            ++i;
        }
        return i;
    }

    private static int skipEmptySpace(char[] stream, int offset) {
        char c;
        int i = offset;
        while ((c = stream[i]) > '\u0000' && c <= ' ') {
            ++i;
        }
        return i;
    }

    private static int skipComment(char[] stream, int offset) {
        char c;
        int i = offset;
        ++i;
        while ((c = stream[i]) != '\u0000' && c != '\n' && c != '\r') {
            ++i;
        }
        if (c != '\u0000') {
            i += c == '\r' && stream[i + 1] == '\n' ? 2 : 1;
        }
        return i;
    }

    public void loadFromInputStream(InputStream stream) throws IOException, InvalidDataFormatException {
        this.loadFromInputStream(stream, ENCODING);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadFromInputStream(InputStream stream, String encoding) throws IOException, InvalidDataFormatException, UnsupportedEncodingException {
        size = stream.available();
        b = new byte[size + 4];
        stream.read(b, 0, size);
        s = Helper.byteToCharArray(b, 0, size + 4, encoding);
        this.clear();
        try {
            i = size >= 1 && s[0] == '\ufeff' ? 1 : 0;
            ** GOTO lbl21
            {
                i = PropertiesFile.skipEmptySpace(s, PropertiesFile.skipComment(s, i));
                do {
                    if ((c = s[i]) == '!' || c == '#') continue block3;
                    if (s[i] == '\u0000') return;
                    if (i >= size) {
                        return;
                    }
                    c = s[i = PropertiesFile.skipWhiteSpace(s, this.parseKey(s, i))];
                    if (c == ':' || c == '=') {
                        i = PropertiesFile.skipWhiteSpace(s, i + 1);
                    }
                    i = this.parseValue(s, i);
                    this.set(this.key, this.value);
lbl21:
                    // 2 sources

                    i = PropertiesFile.skipEmptySpace(s, i);
                    if (s[i] == '\u0000') return;
                } while (i < size);
            }
            return;
        }
        finally {
            this.key = null;
            this.value = null;
        }
    }

    public void loadFromDataStream(DataInputStream stream) throws IOException, InvalidDataFormatException {
        this.loadFromInputStream(stream, ENCODING);
    }

    public void loadFromDataStream(DataInputStream stream, String encoding) throws IOException, InvalidDataFormatException, UnsupportedEncodingException {
        this.loadFromInputStream(stream, encoding);
    }

    private int parseKey(char[] stream, int offset) {
        int i = offset;
        StringBuffer result = new StringBuffer();
        while (true) {
            char c;
            if ((c = stream[i]) > ' ' && c != '\\' && c != ':' && c != '=') {
                ++i;
                continue;
            }
            if (i > offset) {
                result.append(stream, offset, i - offset);
            }
            if (c != '\\') break;
            c = stream[++i];
            switch (c) {
                default: {
                    break;
                }
                case '\r': {
                    if (stream[i + 1] == '\n') {
                        ++i;
                    }
                }
                case '\n': {
                    i = PropertiesFile.skipWhiteSpace(stream, i + 1);
                    break;
                }
                case 'u': {
                    ++i;
                    int u = 0;
                    int j = 4;
                    while (j-- > 0) {
                        c = stream[i];
                        if (c >= '0' && c <= '9') {
                            u = (u << 4) + (c - 48);
                        } else if (c >= 'A' && c <= 'F') {
                            u = (u << 4) + (c - 55);
                        } else {
                            if (c < 'a' || c > 'f') break;
                            u = (u << 4) + (c - 87);
                        }
                        ++i;
                    }
                    result.append((char)u);
                    break;
                }
                case ' ': 
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    result.append(c);
                }
            }
            offset = ++i;
        }
        this.key = result.toString().intern();
        return i;
    }

    private int parseValue(char[] stream, int offset) {
        int i = offset;
        StringBuffer result = new StringBuffer();
        while (true) {
            char c;
            if ((c = stream[i]) >= ' ' && c != '\\') {
                ++i;
                continue;
            }
            if (i > offset) {
                result.append(stream, offset, i - offset);
            }
            if (c != '\\') break;
            c = stream[++i];
            switch (c) {
                default: {
                    break;
                }
                case '\r': {
                    if (stream[i + 1] == '\n') {
                        ++i;
                    }
                }
                case '\n': {
                    i = PropertiesFile.skipWhiteSpace(stream, i + 1);
                    break;
                }
                case 'u': {
                    ++i;
                    int u = 0;
                    int j = 4;
                    while (j-- > 0) {
                        c = stream[i];
                        if (c >= '0' && c <= '9') {
                            u = (u << 4) + (c - 48);
                        } else if (c >= 'A' && c <= 'F') {
                            u = (u << 4) + (c - 55);
                        } else {
                            if (c < 'a' || c > 'f') break;
                            u = (u << 4) + (c - 87);
                        }
                        ++i;
                    }
                    result.append((char)u);
                    break;
                }
                case ' ': 
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    result.append(c);
                }
            }
            offset = ++i;
        }
        this.value = result.toString().intern();
        return i;
    }
}

