/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.media.graphics;

public final class GraphicBuffer {
    private int offset;
    private int scanlength;
    private int width;
    private int height;
    private int[] pixels;

    public GraphicBuffer(int[] pixels, int offset, int scanlength, int width, int height) {
        int length = width + (height - 1) * scanlength;
        if (pixels == null) {
            throw new NullPointerException("GraphicBuffer: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 pixels \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("GraphicBuffer: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0431\u0443\u0444\u0435\u0440\u0430 \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.");
        }
        if (scanlength < width) {
            throw new IllegalArgumentException("GraphicBuffer: \u0434\u043b\u0438\u043d\u0430 \u043b\u0438\u043d\u0438\u0438 \u0441\u043a\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0448\u0438\u0440\u0438\u043d\u044b.");
        }
        int lim = offset + length;
        int len = pixels.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("GraphicBuffer: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        this.offset = offset;
        this.scanlength = scanlength;
        this.width = width;
        this.height = height;
        this.pixels = pixels;
    }

    public boolean equals(Object ref) {
        block2: {
            block3: {
                if (ref == this) break block2;
                if (!(ref instanceof GraphicBuffer)) break block3;
                GraphicBuffer g = (GraphicBuffer)ref;
                if (this.getBase() == g.getBase() && this.scanlength == g.scanlength && this.width == g.width && this.height == g.height) break block2;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getBase() ^ this.scanlength ^ this.width ^ this.height << 16;
    }

    public String toString() {
        return "\u0413\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0431\u0443\u0444\u0435\u0440[\u0431\u0430\u0437\u0430=0x" + Integer.toHexString(this.getBase()) + ", \u0434\u043b\u0438\u043d\u0430 \u043b\u0438\u043d\u0438\u0438 \u0441\u043a\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f=" + this.scanlength + ", \u0448\u0438\u0440\u0438\u043d\u0430=" + this.width + ", \u0432\u044b\u0441\u043e\u0442\u0430=" + this.height + "]";
    }

    public void setPixel(int x, int y, int colorARGB) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            this.pixels[this.offset + x + y * this.scanlength] = colorARGB;
        }
    }

    public int getPixel(int x, int y) {
        return x >= 0 && x < this.width && y >= 0 && y < this.height ? this.pixels[this.offset + x + y * this.scanlength] : 0;
    }

    public int getBase() {
        return Array.getFirstElementAddress((Object)this.pixels) + (this.offset << 2);
    }

    public int getSizes() {
        return this.width | this.height << 16;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getScanlength() {
        return this.scanlength;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int[] getPixels() {
        return this.pixels;
    }
}

