/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ScreenGraphics;
import javax.microedition.lcdui.Ticker;
import malik.emulator.application.KeyboardEvent;
import malik.emulator.application.PointerEvent;
import malik.emulator.microedition.DeviceManager;
import malik.emulator.microedition.DeviceSettings;

public abstract class Canvas
extends Displayable {
    public static final int UP = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 5;
    public static final int DOWN = 6;
    public static final int FIRE = 8;
    public static final int GAME_A = 9;
    public static final int GAME_B = 10;
    public static final int GAME_C = 11;
    public static final int GAME_D = 12;
    public static final int KEY_POUND = 35;
    public static final int KEY_STAR = 42;
    public static final int KEY_NUM0 = 48;
    public static final int KEY_NUM1 = 49;
    public static final int KEY_NUM2 = 50;
    public static final int KEY_NUM3 = 51;
    public static final int KEY_NUM4 = 52;
    public static final int KEY_NUM5 = 53;
    public static final int KEY_NUM6 = 54;
    public static final int KEY_NUM7 = 55;
    public static final int KEY_NUM8 = 56;
    public static final int KEY_NUM9 = 57;
    private boolean focused;

    protected Canvas() {
        super(DeviceManager.getInstance().getSettings().getMIDletProperty("MIDlet-Name"), null, false);
    }

    protected Canvas(String title) {
        super(title, null, false);
    }

    protected Canvas(String title, Ticker ticker, boolean fullScreen) {
        super(title, ticker, fullScreen);
    }

    public void setFullScreenMode(boolean fullScreen) {
        super.setFullScreenMode(fullScreen);
    }

    public int getWidth() {
        return this.getTotalWidth();
    }

    public int getHeight() {
        return this.getClientHeight();
    }

    public boolean hasRepeatEvents() {
        return true;
    }

    public boolean hasPointerEvents() {
        return true;
    }

    public boolean hasPointerMotionEvents() {
        return true;
    }

    public boolean isDoubleBuffered() {
        return true;
    }

    public int getGameAction(int keyCode) {
        return DeviceManager.getInstance().getSettings().keyCodeToGameAction(keyCode);
    }

    public int getKeyCode(int gameAction) {
        return DeviceManager.getInstance().getSettings().gameActionToKeyCode(gameAction);
    }

    public String getKeyName(int keyCode) {
        return DeviceManager.getInstance().getSettings().getKeyName(keyCode);
    }

    public final void repaint() {
        this.requestPaintClient(0, 0, this.getTotalWidth(), this.getClientHeight());
    }

    public final void repaint(int clipLeft, int clipTop, int clipWidth, int clipHeight) {
        this.requestPaintClient(clipLeft, clipTop, clipWidth, clipHeight);
    }

    public final void serviceRepaints() {
        this.servicePaint();
    }

    protected abstract void paint(Graphics var1);

    protected void sizeChanged(int width, int height) {
    }

    protected void showNotify() {
    }

    protected void hideNotify() {
    }

    protected void keyPressed(int keyCode) {
    }

    protected void keyRepeated(int keyCode) {
    }

    protected void keyReleased(int keyCode) {
    }

    protected void pointerPressed(int x, int y) {
    }

    protected void pointerDragged(int x, int y) {
    }

    protected void pointerReleased(int x, int y) {
    }

    void paint(ScreenGraphics render) {
        this.paint((Graphics)render);
    }

    void paintBackground(ScreenGraphics render, int width, int height, byte visibleElements, byte drawingElements) {
        super.paintBackground(render, width, height, visibleElements, (byte)(drawingElements & 0xFFFFFFFD));
    }

    void paintClient(ScreenGraphics render, int width, int height, int clipLeft, int clipTop, int clipWidth, int clipHeight, Image clipBuffer) {
        if (!this.isFullScreenMode()) {
            int translatedX = render.getTranslateX();
            int translatedY = render.getTranslateY();
            render.restricts(translatedX, translatedY, width, height);
            render.setStartPoint(translatedX, translatedY);
            render.setClip(0, 0, width, height);
        }
        if (!this.isMenuOpened()) {
            render.clipRect(clipLeft, clipTop, clipWidth, clipHeight);
        }
        if (clipBuffer != null) {
            render.drawImage(clipBuffer, 0, 0, 0);
            return;
        }
        this.paint(render);
    }

    void onShow() {
        this.show();
    }

    void onHide() {
        this.hide();
    }

    boolean onKeyboardEvent(KeyboardEvent event) {
        if (!super.onKeyboardEvent(event)) {
            this.keyboardEvent(event);
        }
        return true;
    }

    boolean onPointerEvent(PointerEvent event) {
        if (!super.onPointerEvent(event)) {
            switch (event.getAction()) {
                case 10: 
                case 14: {
                    if (event.getButton() != 0) break;
                    byte e = this.getElements();
                    int t = ((e & 8) != 0 ? this.getTickerHeight() : 0) + ((e & 4) != 0 ? this.getTitleHeight() : 0);
                    int w = this.getTotalWidth();
                    int h = this.getTotalHeight() - t - ((e & 1) != 0 ? this.getPanelHeight() : 0);
                    int x = event.getX();
                    int y = event.getY() - t;
                    if (x < 0 || x >= w || y < 0 || y >= h) break;
                    this.focused = true;
                    this.pointerPressed(x, y);
                    break;
                }
                case 9: {
                    if (!this.focused) break;
                    byte e = this.getElements();
                    int t = ((e & 8) != 0 ? this.getTickerHeight() : 0) + ((e & 4) != 0 ? this.getTitleHeight() : 0);
                    int x = event.getX();
                    int y = event.getY() - t;
                    this.pointerDragged(x, y);
                    break;
                }
                case 11: 
                case 15: {
                    if (!this.focused || event.getButton() != 0) break;
                    byte e = this.getElements();
                    int t = ((e & 8) != 0 ? this.getTickerHeight() : 0) + ((e & 4) != 0 ? this.getTitleHeight() : 0);
                    int x = event.getX();
                    int y = event.getY() - t;
                    this.focused = false;
                    this.pointerReleased(x, y);
                }
            }
        }
        return true;
    }

    void show() {
        this.showNotify();
    }

    void hide() {
        this.hideNotify();
    }

    void keyboardEvent(KeyboardEvent event) {
        DeviceSettings settings = DeviceManager.getInstance().getSettings();
        switch (event.getAction()) {
            case 6: {
                int keyCode = settings.getKeyCode(event.getKey());
                if (keyCode == 0) break;
                this.keyPressed(keyCode);
                break;
            }
            case 5: {
                int keyCode;
                if (!settings.isKeyRepeatedEvent() || (keyCode = settings.getKeyCode(event.getKey())) == 0) break;
                this.keyRepeated(keyCode);
                break;
            }
            case 7: {
                int keyCode = settings.getKeyCode(event.getKey());
                if (keyCode == 0) break;
                this.keyReleased(keyCode);
            }
        }
    }
}

