/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.ScreenGraphics;
import javax.microedition.lcdui.Ticker;
import malik.emulator.application.KeyboardEvent;
import malik.emulator.application.PointerEvent;

public abstract class CustomBackgroundScreen
extends Displayable {
    protected static final byte ALL = -1;
    protected static final byte NONE = 0;
    protected static final byte PANEL = 1;
    protected static final byte CLIENT = 2;
    protected static final byte TITLE = 4;
    protected static final byte TICKER = 8;

    protected CustomBackgroundScreen(String title) {
        super(title, null, false);
    }

    protected CustomBackgroundScreen(String title, Ticker ticker, boolean fullScreen) {
        super(title, ticker, fullScreen);
    }

    public void setFullScreenMode(boolean fullScreen) {
        super.setFullScreenMode(fullScreen);
    }

    public boolean isFullScreenMode() {
        return super.isFullScreenMode();
    }

    public int getWidth() {
        return this.getTotalWidth();
    }

    public int getHeight() {
        return this.getClientHeight();
    }

    protected abstract void paintBackground(Graphics var1, int var2, int var3, byte var4, byte var5);

    protected abstract void paintTicker(Graphics var1, int var2, int var3, Ticker var4);

    protected abstract void paintTitle(Graphics var1, int var2, int var3, String var4);

    protected abstract void paintClient(Graphics var1, int var2, int var3);

    protected abstract void paintPanel(Graphics var1, int var2, int var3, Command[] var4, int var5);

    protected abstract int getPanelCommandIndex(int var1, int var2, int var3, int var4);

    protected float getTickerScroll() {
        return super.getTickerScroll();
    }

    protected int getTickerHeight() {
        return super.getTickerHeight();
    }

    protected int getTitleHeight() {
        return super.getTitleHeight();
    }

    protected int getPanelHeight() {
        return super.getPanelHeight();
    }

    protected Font getTickerFont() {
        return super.getTickerFont();
    }

    protected Font getTitleFont() {
        return super.getTitleFont();
    }

    protected Font getNormalCommandFont() {
        return super.getNormalCommandFont();
    }

    protected Font getDefaultCommandFont() {
        return super.getDefaultCommandFont();
    }

    protected void showNotify() {
    }

    protected void hideNotify() {
    }

    protected void keyboardNotify(KeyboardEvent event) {
    }

    protected void pointerNotify(PointerEvent event) {
    }

    protected void commandNotify(Command command) {
    }

    protected final void repaint() {
        this.requestPaint((byte)2);
    }

    protected final void repaint(int clipLeft, int clipTop, int clipWidth, int clipHeight) {
        this.requestPaintClient(clipLeft, clipTop, clipWidth, clipHeight);
    }

    protected final void repaint(byte elements) {
        this.requestPaint(elements);
    }

    protected final void repaintAll() {
        this.requestPaintAll();
    }

    protected final void serviceRepaints() {
        this.servicePaint();
    }

    void paint(ScreenGraphics render) {
        this.paintClient(render, this.getTotalWidth(), this.getClientHeight());
    }

    void paintBackground(ScreenGraphics render, int width, int height, byte visibleElements, byte drawingElements) {
        this.paintBackground((Graphics)render, width, height, visibleElements, drawingElements);
    }

    void paintTicker(ScreenGraphics render, int width, int height, Ticker ticker) {
        this.paintTicker((Graphics)render, width, height, ticker);
    }

    void paintTitle(ScreenGraphics render, int width, int height, String title) {
        this.paintTitle((Graphics)render, width, height, title);
    }

    void paintPanel(ScreenGraphics render, int width, int height, Command[] commands, int pressedCommandIndex) {
        this.paintPanel((Graphics)render, width, height, commands, pressedCommandIndex);
    }

    void onShow() {
        this.showNotify();
    }

    void onHide() {
        this.hideNotify();
    }

    void onCommandAction(Command command) {
        try {
            this.commandNotify(command);
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
        super.onCommandAction(command);
    }

    boolean onKeyboardEvent(KeyboardEvent event) {
        if (!super.onKeyboardEvent(event)) {
            this.keyboardNotify(event);
        }
        return true;
    }

    boolean onPointerEvent(PointerEvent event) {
        if (!super.onPointerEvent(event)) {
            int ty = 0;
            byte elements = this.getElements();
            if ((elements & 8) != 0) {
                ty += this.getTickerHeight();
            }
            if ((elements & 4) != 0) {
                ty += this.getTitleHeight();
            }
            event.translate(0, ty);
            this.pointerNotify(event);
        }
        return true;
    }

    int getCommandIndexAt(int x, int y, int panelWidth, int panelHeight) {
        return this.getPanelCommandIndex(x, y, panelWidth, panelHeight);
    }
}

