/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.lcdui;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Input;
import malik.emulator.application.KeyboardEvent;
import malik.emulator.microedition.DeviceManager;
import malik.emulator.microedition.lcdui.AvailableInputModes;
import malik.emulator.microedition.lcdui.CharacterDestination;
import malik.emulator.microedition.lcdui.CharacterList;
import malik.emulator.microedition.lcdui.CommandOwner;
import malik.emulator.microedition.lcdui.InputMode;
import malik.emulator.microedition.lcdui.MultilinedStringBuilder;
import malik.emulator.microedition.lcdui.StringList;

public final class InputStringBuilder
extends MultilinedStringBuilder
implements CharacterDestination {
    public static final char PASSWORD_CHAR = '\u2022';
    public static final int CAPACITY = 4096;
    static final String[][] charsets;
    static final Command[] commands;
    static final Command commandLine;
    static final Command commandChar;
    static final Command commandMode;
    static final Command commandCopy;
    static final Command commandPaste;
    static final Command commandSelect;
    static final Command commandInsert;
    static final Command commandBack;
    static String clipboard;
    private boolean modified;
    int constraints;
    int caretPosition;
    int maximumLength;
    final char[] realstr;
    private InputMode mode;

    static {
        Command line = new Command("\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u043f\u0435\u0440\u0435\u043d\u043e\u0441 \u0441\u0442\u0440\u043e\u043a\u0438", 1, Integer.MIN_VALUE);
        Command charset = new Command("\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0441\u0438\u043c\u0432\u043e\u043b\u2026", 1, Integer.MIN_VALUE);
        Command mode = new Command("\u042f\u0437\u044b\u043a \u0432\u0432\u043e\u0434\u0430\u2026", 1, Integer.MIN_VALUE);
        Command copy = new Command("\u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c", 1, Integer.MIN_VALUE);
        Command paste = new Command("\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c", 1, Integer.MIN_VALUE);
        Command select = new Command("\u0412\u044b\u0431\u0440\u0430\u0442\u044c", 4, 0);
        Command insert = new Command("\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c", 4, 0);
        Command back = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 0);
        charsets = new String[][]{{"\u0411\u0430\u0437\u043e\u0432\u0430\u044f \u043b\u0430\u0442\u0438\u043d\u0438\u0446\u0430", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"}, {"\u041a\u0438\u0440\u0438\u043b\u043b\u0438\u0446\u0430 (\u0440\u0443\u0441\u0441\u043a\u0438\u0439 \u044f\u0437\u044b\u043a)", "\u0410\u0411\u0412\u0413\u0414\u0415\u0401\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f\u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f"}, {"\u041a\u0438\u0440\u0438\u043b\u043b\u0438\u0446\u0430 (\u0432\u0441\u044f)", "\u0400\u0402\u0403\u0404\u0405\u0406\u0407\u0408\u0409\u040a\u040b\u040c\u040d\u040e\u040f\u0410\u0411\u0412\u0413\u0414\u0415\u0401\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f\u0450\u0452\u0453\u0454\u0455\u0456\u0457\u0458\u0459\u045a\u045b\u045c\u045d\u045e\u045f\u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f"}, {"\u041f\u0440\u043e\u0447\u0438\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u044b", " '\"#$%&()+-*/<=>,.:;!?@[\\]^_`{|}~\u00a7\u00a1\u00bf\u2026\u00a4\u00a2\u00a3\u00a5\u20ac\u2116\u2022\u00b7\u00b0\u00b9\u00b2\u00b3\u00bc\u00bd\u00be\u2030\u00b1\u00d7\u00f7\u00b5\u2013\u2014\u00a9\u00ae\u2122\u2039\u203a\u00ab\u00bb"}};
        commands = new Command[]{line, charset, mode, copy, paste};
        commandLine = line;
        commandChar = charset;
        commandMode = mode;
        commandCopy = copy;
        commandPaste = paste;
        commandSelect = select;
        commandInsert = insert;
        commandBack = back;
        clipboard = "";
    }

    public static boolean isConstraintsValid(int constraints) {
        return (constraints & 0xFFFF) < 6 && constraints >>> 16 < 64;
    }

    public static boolean isConstraintsMatch(int constraints, char[] src, int offset, int length) {
        if (!InputStringBuilder.isConstraintsValid(constraints)) {
            throw new IllegalArgumentException("InputStringBuilder.isConstraintsMatch: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 constraints \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (src == null) {
            return true;
        }
        long bounds = Array.intersectBound((int)src.length, (int)offset, (int)length);
        offset = (int)bounds;
        length = (int)(bounds >> 32);
        switch (constraints & 0xFFFF) {
            case 0: 
            case 1: 
            case 4: {
                return true;
            }
            case 2: {
                int j = offset;
                int i = 0;
                while (i < length) {
                    switch (src[j]) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break;
                        }
                        case '-': {
                            if (i <= 0) break;
                            return false;
                        }
                        default: {
                            return false;
                        }
                    }
                    ++j;
                    ++i;
                }
                return true;
            }
            case 3: {
                int j = offset;
                int i = 0;
                while (i < length) {
                    switch (src[j]) {
                        case '#': 
                        case '*': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break;
                        }
                        case '+': {
                            if (i <= 0) break;
                            return false;
                        }
                        default: {
                            return false;
                        }
                    }
                    ++j;
                    ++i;
                }
                return true;
            }
            case 5: {
                boolean f = false;
                int j = offset;
                int i = 0;
                while (i < length) {
                    switch (src[j]) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break;
                        }
                        case '.': {
                            if (f) {
                                return false;
                            }
                            f = true;
                            break;
                        }
                        case '-': {
                            if (i <= 0) break;
                            return false;
                        }
                        default: {
                            return false;
                        }
                    }
                    ++j;
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isConstraintsMatch(int constraints, String string) {
        if (!InputStringBuilder.isConstraintsValid(constraints)) {
            throw new IllegalArgumentException("InputStringBuilder.isConstraintsMatch: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 constraints \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (string == null) {
            return true;
        }
        int length = string.length();
        switch (constraints & 0xFFFF) {
            case 0: 
            case 1: 
            case 4: {
                return true;
            }
            case 2: {
                int i = 0;
                while (i < length) {
                    switch (string.charAt(i)) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break;
                        }
                        case '-': {
                            if (i <= 0) break;
                            return false;
                        }
                        default: {
                            return false;
                        }
                    }
                    ++i;
                }
                return true;
            }
            case 3: {
                int i = 0;
                while (i < length) {
                    switch (string.charAt(i)) {
                        case '#': 
                        case '*': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break;
                        }
                        case '+': {
                            if (i <= 0) break;
                            return false;
                        }
                        default: {
                            return false;
                        }
                    }
                    ++i;
                }
                return true;
            }
            case 5: {
                boolean f = false;
                int i = 0;
                while (i < length) {
                    switch (string.charAt(i)) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break;
                        }
                        case '.': {
                            if (f) {
                                return false;
                            }
                            f = true;
                            break;
                        }
                        case '-': {
                            if (i <= 0) break;
                            return false;
                        }
                        default: {
                            return false;
                        }
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public InputStringBuilder(String inputText, int maximumLength, int constraints) {
        super(4096);
        if (inputText == null) {
            inputText = "";
        }
        if (maximumLength <= 0) {
            throw new IllegalArgumentException("InputStringBuilder: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 maximumLength \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (!InputStringBuilder.isConstraintsValid(constraints)) {
            throw new IllegalArgumentException("InputStringBuilder: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 constraints \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (!InputStringBuilder.isConstraintsMatch(constraints, inputText)) {
            throw new IllegalArgumentException("InputStringBuilder: \u0442\u0435\u043a\u0441\u0442 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u043c.");
        }
        int length = inputText.length();
        if (length > maximumLength) {
            throw new IllegalArgumentException("InputStringBuilder: \u0434\u043b\u0438\u043d\u0430 \u0442\u0435\u043a\u0441\u0442\u0430 \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0435\u0442 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0443\u044e \u0434\u043b\u0438\u043d\u0443.");
        }
        if (length > 4096) {
            length = 4096;
        }
        if (maximumLength > 4096) {
            maximumLength = 4096;
        }
        char[] content = this.content;
        char[] realstr = new char[4096];
        inputText.getChars(0, length, realstr, 0);
        if ((constraints & 0x10000) == 0) {
            Array.copy((char[])realstr, (int)0, (char[])content, (int)0, (int)4096);
        } else {
            Array.fill((char[])content, (int)0, (int)4096, (int)8226);
        }
        this.length = length;
        this.modified = true;
        this.constraints = constraints;
        this.maximumLength = maximumLength;
        this.realstr = realstr;
        this.mode = AvailableInputModes.instance.system();
    }

    public void clear() {
        this.length = 0;
        this.caretPosition = 0;
        this.modified = true;
    }

    public void set(int position, char character) {
        int len = this.length;
        if (position < 0 || position >= len) {
            throw new StringIndexOutOfBoundsException("StringBuilder.set: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 position \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        char[] buffer = this.realstr;
        char previous = this.realstr[position];
        if (previous != character) {
            buffer[position] = character;
            int constraints = this.constraints;
            if (!InputStringBuilder.isConstraintsMatch(constraints, buffer, 0, len)) {
                buffer[position] = previous;
            } else {
                if ((constraints & 0x10000) == 0) {
                    this.content[position] = character;
                }
                this.modified = true;
            }
        }
    }

    public void insert(char character) {
        if (character == '\b') {
            int oldPos = this.caretPosition;
            if (oldPos > 0) {
                int oldLen = this.length;
                int newLen = oldLen - 1;
                int remLen = oldLen - oldPos;
                int newPos = oldPos - 1;
                char[] buffer = this.realstr;
                Array.copy((char[])this.realstr, (int)oldPos, (char[])buffer, (int)newPos, (int)remLen);
                if ((this.constraints & 0x10000) == 0) {
                    Array.copy((char[])buffer, (int)0, (char[])this.content, (int)0, (int)4096);
                }
                this.length = newLen;
                this.caretPosition = newPos;
                this.modified = true;
            }
        } else {
            int oldLen = this.length;
            int newLen = oldLen + 1;
            if (newLen <= this.maximumLength) {
                int oldPos = this.caretPosition;
                int remLen = oldLen - oldPos;
                int newPos = oldPos + 1;
                char[] buffer = this.realstr;
                Array.copy((char[])this.realstr, (int)oldPos, (char[])buffer, (int)newPos, (int)remLen);
                buffer[oldPos] = character;
                int constraints = this.constraints;
                if (!InputStringBuilder.isConstraintsMatch(constraints, buffer, 0, newLen)) {
                    Array.copy((char[])buffer, (int)newPos, (char[])buffer, (int)oldPos, (int)remLen);
                } else {
                    if ((constraints & 0x10000) == 0) {
                        Array.copy((char[])buffer, (int)0, (char[])this.content, (int)0, (int)4096);
                    }
                    this.length = newLen;
                    this.caretPosition = newPos;
                    this.modified = true;
                }
            }
        }
    }

    public void insert(String string) {
        int oldLen;
        int newLen;
        int delta = string != null ? string.length() : 0;
        if (delta > 0 && (newLen = (oldLen = this.length) + delta) <= this.maximumLength) {
            int oldPos = this.caretPosition;
            int remLen = oldLen - oldPos;
            int newPos = oldPos + delta;
            char[] buffer = this.realstr;
            Array.copy((char[])this.realstr, (int)oldPos, (char[])buffer, (int)newPos, (int)remLen);
            string.getChars(0, delta, buffer, oldPos);
            int constraints = this.constraints;
            if (!InputStringBuilder.isConstraintsMatch(constraints, buffer, 0, newLen)) {
                Array.copy((char[])buffer, (int)newPos, (char[])buffer, (int)oldPos, (int)remLen);
            } else {
                if ((constraints & 0x10000) == 0) {
                    Array.copy((char[])buffer, (int)0, (char[])this.content, (int)0, (int)4096);
                }
                this.length = newLen;
                this.caretPosition = newPos;
                this.modified = true;
            }
        }
    }

    public void keyboardEvent(KeyboardEvent event) {
        if ((this.constraints & 0x20000) == 0 && event.getAction() != 7) {
            switch (event.getKey()) {
                case 9: {
                    break;
                }
                case 13: {
                    this.insert('\n');
                    break;
                }
                case 8: {
                    this.insert('\b');
                    break;
                }
                default: {
                    this.mode.keyboardEvent(event, this);
                }
            }
        }
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public void setConstraints(int constraints) {
        if (!InputStringBuilder.isConstraintsValid(constraints)) {
            throw new IllegalArgumentException("InputStringBuilder.setConstraints: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 constraints \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        int oldConstraints = this.constraints;
        if (oldConstraints != constraints) {
            char[] buffer = this.realstr;
            if (!InputStringBuilder.isConstraintsMatch(constraints, buffer, 0, this.length)) {
                this.length = 0;
                this.caretPosition = 0;
                this.modified = true;
            }
            if ((oldConstraints & 0x10000) == 0 && (constraints & 0x10000) != 0) {
                Array.fill((char[])this.content, (int)0, (int)4096, (int)8226);
                this.modified = true;
            } else if ((oldConstraints & 0x10000) != 0 && (constraints & 0x10000) == 0) {
                Array.copy((char[])buffer, (int)0, (char[])this.content, (int)0, (int)4096);
                this.modified = true;
            }
            this.constraints = constraints;
        }
    }

    public void setCaretPosition(int caretPosition) {
        int len = this.length;
        if (caretPosition < 0) {
            caretPosition = 0;
        }
        if (caretPosition > len) {
            caretPosition = len;
        }
        if (this.caretPosition != caretPosition) {
            this.caretPosition = caretPosition;
            this.modified = true;
        }
    }

    public void setMaximumLength(int maximumLength) {
        if (maximumLength <= 0) {
            throw new IllegalArgumentException("InputStringBuilder.setMaximumLength: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 maximumLength \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (maximumLength > 4096) {
            maximumLength = 4096;
        }
        if (this.maximumLength != maximumLength) {
            if (this.length > maximumLength) {
                this.length = maximumLength;
                this.modified = true;
            }
            if (this.caretPosition > maximumLength) {
                this.caretPosition = maximumLength;
                this.modified = true;
            }
            this.maximumLength = maximumLength;
        }
    }

    public void setInputText(String inputText) {
        int newLen;
        if (inputText == null) {
            inputText = "";
        }
        if ((newLen = inputText.length()) > this.maximumLength) {
            throw new IllegalArgumentException("InputStringBuilder.setInputText: \u0434\u043b\u0438\u043d\u0430 \u0442\u0435\u043a\u0441\u0442\u0430 \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0435\u0442 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0443\u044e \u0434\u043b\u0438\u043d\u0443.");
        }
        int constraints = this.constraints;
        if (!InputStringBuilder.isConstraintsMatch(constraints, inputText)) {
            throw new IllegalArgumentException("InputStringBuilder.setInputText: \u0442\u0435\u043a\u0441\u0442 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u043c.");
        }
        if (newLen > 0) {
            char[] buffer = this.realstr;
            inputText.getChars(0, newLen, buffer, 0);
            if ((constraints & 0x10000) == 0) {
                Array.copy((char[])buffer, (int)0, (char[])this.content, (int)0, (int)4096);
            }
        }
        this.length = newLen;
        this.caretPosition = newLen;
        this.modified = true;
    }

    public void setInputMode(InputMode mode) {
        this.mode = mode == null ? AvailableInputModes.instance.system() : mode;
    }

    public boolean isModified() {
        boolean result = this.modified;
        this.modified = false;
        return result;
    }

    public int getConstraints() {
        return this.constraints;
    }

    public int getCaretPosition() {
        return this.caretPosition;
    }

    public int getMaximumLength() {
        return this.maximumLength;
    }

    public String getInputText() {
        return new String(this.realstr, 0, this.length);
    }

    public InputMode getInputMode() {
        return this.mode;
    }

    public Input newInput() {
        return new Input(){

            public void insert(char[] src, int offset, int length, int position) {
                InputStringBuilder.this.insert(position, src, offset, length);
            }

            public void insert(String text, int position) {
                InputStringBuilder.this.insert(position, text);
            }

            public void delete(int offset, int length) {
                InputStringBuilder.this.delete(offset, offset + length);
            }

            public void setConstraints(int constraints) {
                InputStringBuilder.this.setConstraints(constraints);
            }

            public void setChars(char[] src, int offset, int length) {
                InputStringBuilder parent = InputStringBuilder.this;
                parent.clear();
                parent.append(src, offset, length);
            }

            public void setString(String inputText) {
                InputStringBuilder parent = InputStringBuilder.this;
                parent.clear();
                parent.append(inputText);
            }

            public void setInitialInputMode(String characterSubset) {
                InputStringBuilder.this.setInputMode(AvailableInputModes.instance.get(characterSubset));
            }

            public int setMaxSize(int maximumSize) {
                if (maximumSize > 4096) {
                    maximumSize = 4096;
                }
                InputStringBuilder.this.setMaximumLength(maximumSize);
                return maximumSize;
            }

            public int size() {
                return InputStringBuilder.this.length();
            }

            public int getConstraints() {
                return InputStringBuilder.this.constraints;
            }

            public int getCaretPosition() {
                return InputStringBuilder.this.caretPosition;
            }

            public int getChars(char[] dst) {
                InputStringBuilder parent = InputStringBuilder.this;
                int result = parent.length();
                Array.copy((char[])parent.realstr, (int)0, (char[])dst, (int)0, (int)result);
                return result;
            }

            public int getMaxSize() {
                return InputStringBuilder.this.maximumLength;
            }

            public String getString() {
                return InputStringBuilder.this.getInputText();
            }
        };
    }

    protected void insertChar(int position, char character) {
        this.insertChar(position, this.length, character);
    }

    protected void insertArray(int position, char[] src, int offset, int length) {
        this.insertArray(position, this.length, src, offset, length);
    }

    protected void insertString(int position, String string) {
        this.insertString(position, this.length, string);
    }

    protected void appendChar(char character) {
        int oldLen = this.length;
        this.insertChar(oldLen, oldLen, character);
    }

    protected void appendArray(char[] src, int offset, int length) {
        int oldLen = this.length;
        this.insertArray(oldLen, oldLen, src, offset, length);
    }

    protected void appendString(String string) {
        int oldLen = this.length;
        this.insertString(oldLen, oldLen, string);
    }

    protected void deletePortion(int beginPosition, int endPosition) {
        int oldLength = this.length;
        if (beginPosition < 0) {
            beginPosition = 0;
        }
        if (beginPosition > oldLength) {
            beginPosition = oldLength;
        }
        if (endPosition < beginPosition) {
            endPosition = beginPosition;
        }
        if (endPosition > oldLength) {
            endPosition = oldLength;
        }
        if (beginPosition < endPosition) {
            int delta = oldLength - endPosition;
            char[] buffer = this.content;
            Array.copy((char[])this.content, (int)endPosition, (char[])buffer, (int)beginPosition, (int)delta);
            buffer = this.realstr;
            Array.copy((char[])this.realstr, (int)endPosition, (char[])buffer, (int)beginPosition, (int)delta);
            delta = endPosition - beginPosition;
            this.length = oldLength - delta;
            int oldPosition = this.caretPosition;
            if (oldPosition >= endPosition) {
                this.caretPosition = oldPosition - delta;
            } else if (oldPosition >= beginPosition) {
                this.caretPosition = beginPosition;
            }
            this.modified = true;
        }
    }

    private void insertChar(int position, int oldLen, char character) {
        int newLen = oldLen + 1;
        if (newLen <= this.maximumLength) {
            int oldPos = position < 0 ? 0 : (position > oldLen ? oldLen : position);
            int remLen = oldLen - oldPos;
            int newPos = oldPos + 1;
            char[] buffer = this.realstr;
            Array.copy((char[])this.realstr, (int)oldPos, (char[])buffer, (int)newPos, (int)remLen);
            buffer[oldPos] = character;
            int constraints = this.constraints;
            if (!InputStringBuilder.isConstraintsMatch(constraints, buffer, 0, newLen)) {
                Array.copy((char[])buffer, (int)newPos, (char[])buffer, (int)oldPos, (int)remLen);
            } else {
                if ((constraints & 0x10000) == 0) {
                    Array.copy((char[])buffer, (int)0, (char[])this.content, (int)0, (int)4096);
                }
                this.length = newLen;
                if (oldPos <= (oldPos = this.caretPosition)) {
                    this.caretPosition = oldPos + 1;
                }
                this.modified = true;
            }
        }
    }

    private void insertArray(int position, int oldLen, char[] src, int offset, int length) {
        int newLen;
        if (length > 0 && (newLen = oldLen + length) <= this.maximumLength) {
            int oldPos = position < 0 ? 0 : (position > oldLen ? oldLen : position);
            int remLen = oldLen - oldPos;
            int newPos = oldPos + length;
            char[] buffer = this.realstr;
            Array.copy((char[])this.realstr, (int)oldPos, (char[])buffer, (int)newPos, (int)remLen);
            Array.copy((char[])src, (int)offset, (char[])buffer, (int)oldPos, (int)length);
            int constraints = this.constraints;
            if (!InputStringBuilder.isConstraintsMatch(constraints, buffer, 0, newLen)) {
                Array.copy((char[])buffer, (int)newPos, (char[])buffer, (int)oldPos, (int)remLen);
            } else {
                if ((constraints & 0x10000) == 0) {
                    Array.copy((char[])buffer, (int)0, (char[])this.content, (int)0, (int)4096);
                }
                this.length = newLen;
                if (oldPos <= (oldPos = this.caretPosition)) {
                    this.caretPosition = oldPos + length;
                }
                this.modified = true;
            }
        }
    }

    private void insertString(int position, int oldLen, String string) {
        int newLen;
        int length = string.length();
        if (length > 0 && (newLen = oldLen + length) <= this.maximumLength) {
            int oldPos = position < 0 ? 0 : (position > oldLen ? oldLen : position);
            int remLen = oldLen - oldPos;
            int newPos = oldPos + length;
            char[] buffer = this.realstr;
            Array.copy((char[])this.realstr, (int)oldPos, (char[])buffer, (int)newPos, (int)remLen);
            string.getChars(0, length, buffer, oldPos);
            int constraints = this.constraints;
            if (!InputStringBuilder.isConstraintsMatch(constraints, buffer, 0, newLen)) {
                Array.copy((char[])buffer, (int)newPos, (char[])buffer, (int)oldPos, (int)remLen);
            } else {
                if ((constraints & 0x10000) == 0) {
                    Array.copy((char[])buffer, (int)0, (char[])this.content, (int)0, (int)4096);
                }
                this.length = newLen;
                if (oldPos <= (oldPos = this.caretPosition)) {
                    this.caretPosition = oldPos + length;
                }
                this.modified = true;
            }
        }
    }

    public class AdditionalCapabilities
    implements CommandListener,
    CommandOwner {
        private final boolean lineSeparatorAllowed;
        private int modeIndex;
        private final CharacterList[] screensWithChars;
        private StringList screenSelectCharset;
        private StringList screenSelectMode;
        protected Displayable source;
        protected final Object monitor;

        public AdditionalCapabilities(boolean lineSeparatorAllowed, Object monitor) {
            this.lineSeparatorAllowed = lineSeparatorAllowed;
            this.screensWithChars = new CharacterList[charsets.length];
            this.monitor = monitor == null ? new Object() : monitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commandAction(Command command, Displayable screen) {
            InputStringBuilder parent = InputStringBuilder.this;
            if (command == commandLine) {
                Object object = this.monitor;
                synchronized (object) {
                    parent.insert('\n');
                }
                return;
            }
            if (command == commandChar) {
                DeviceManager.getInstance().getCurrentDisplay().setCurrent(this.getScreenSelectCharset());
                this.source = screen;
                return;
            }
            if (command == commandMode) {
                DeviceManager.getInstance().getCurrentDisplay().setCurrent(this.getScreenSelectMode());
                this.source = screen;
                return;
            }
            if (command == commandCopy) {
                Object object = this.monitor;
                synchronized (object) {
                    String text = parent.getInputText();
                    if (text.length() > 0) {
                        clipboard = text;
                    }
                }
                return;
            }
            if (command == commandPaste) {
                Object object = this.monitor;
                synchronized (object) {
                    parent.insert(clipboard);
                }
                return;
            }
            StringList screen1 = this.screenSelectCharset;
            if (screen == screen1) {
                if (command == commandSelect) {
                    DeviceManager.getInstance().getCurrentDisplay().setCurrent(this.getScreenWithChars(screen1.getSelectedIndex()));
                    return;
                }
                if (command == commandBack) {
                    DeviceManager.getInstance().getCurrentDisplay().setCurrent(this.source);
                    this.source = null;
                }
                return;
            }
            screen1 = this.screenSelectMode;
            if (screen == screen1) {
                if (command == commandSelect) {
                    int index;
                    this.modeIndex = index = screen1.getSelectedIndex();
                    parent.setInputMode(AvailableInputModes.instance.get(index));
                }
                DeviceManager.getInstance().getCurrentDisplay().setCurrent(this.source);
                this.source = null;
                return;
            }
            if (screen instanceof CharacterList) {
                if (command == commandInsert) {
                    Object object = this.monitor;
                    synchronized (object) {
                        parent.insert(((CharacterList)screen).getSelectedChar());
                    }
                    return;
                }
                if (command == commandBack) {
                    DeviceManager.getInstance().getCurrentDisplay().setCurrent(this.screenSelectCharset);
                }
            }
        }

        public boolean isMyOwnedCommand(Command command) {
            Object[] commands = InputStringBuilder.commands;
            return Array.findf((Object[])InputStringBuilder.commands, (int)0, (Object)command) < commands.length;
        }

        public Command[] getMyOwnedCommands() {
            Command[] result;
            int constraints = InputStringBuilder.this.constraints;
            int type = 0xFFFF & constraints;
            boolean any = type == 0 || type == 1 || type == 4;
            switch ((constraints & 0x30000) >> 16) {
                case 3: {
                    result = new Command[]{};
                    break;
                }
                case 2: {
                    result = new Command[]{commandCopy};
                    break;
                }
                case 1: {
                    if (!any) {
                        result = new Command[]{commandPaste};
                        break;
                    }
                    if (this.lineSeparatorAllowed) {
                        result = new Command[]{commandLine, commandChar, commandMode, commandPaste};
                        break;
                    }
                    result = new Command[]{commandChar, commandMode, commandPaste};
                    break;
                }
                default: {
                    result = !any ? new Command[]{commandCopy, commandPaste} : (this.lineSeparatorAllowed ? new Command[]{commandLine, commandChar, commandMode, commandCopy, commandPaste} : new Command[]{commandChar, commandMode, commandCopy, commandPaste});
                }
            }
            return result;
        }

        public final InputStringBuilder parentBuilder() {
            return InputStringBuilder.this;
        }

        private Displayable getScreenWithChars(int index) {
            CharacterList[] array = this.screensWithChars;
            CharacterList result = this.screensWithChars[index];
            if (result == null) {
                String[] charset = charsets[index];
                result = array[index] = new CharacterList(charset[0], null, charset[1]);
                array[index].setCommandListener(this);
                result.addCommand(commandInsert);
                result.addCommand(commandBack);
            }
            return result;
        }

        private Displayable getScreenSelectCharset() {
            StringList result = this.screenSelectCharset;
            if (result == null) {
                String[][] charsets = InputStringBuilder.charsets;
                result = this.screenSelectCharset = new StringList("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u0430\u0431\u043e\u0440 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432", null);
                this.screenSelectCharset.setCommandListener(this);
                int len = charsets.length;
                int i = 0;
                while (i < len) {
                    result.append(charsets[i][0]);
                    ++i;
                }
                result.addCommand(commandSelect);
                result.addCommand(commandBack);
            }
            return result;
        }

        private Displayable getScreenSelectMode() {
            StringList result = this.screenSelectMode;
            if (result == null) {
                AvailableInputModes modes = AvailableInputModes.instance;
                result = this.screenSelectMode = new StringList("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u044f\u0437\u044b\u043a \u0432\u0432\u043e\u0434\u0430", null);
                this.screenSelectMode.setCommandListener(this);
                int len = modes.size();
                int i = 0;
                while (i < len) {
                    result.append(modes.get(i).getLocalizedName());
                    ++i;
                }
                result.addCommand(commandSelect);
                result.addCommand(commandBack);
            }
            result.setSelectedIndex(this.modeIndex);
            return result;
        }
    }
}

