/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.lcdui;

import javax.microedition.lcdui.CustomSurfaceScreen;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.ScrollBar;
import malik.emulator.application.KeyboardEvent;
import malik.emulator.application.PointerEvent;
import malik.emulator.media.graphics.RasterCanvas;
import malik.emulator.microedition.DeviceManager;
import malik.emulator.microedition.DeviceSettings;
import malik.emulator.microedition.lcdui.MultilinedStringBuilder;
import malik.emulator.microedition.lcdui.ScrollBarStyle;
import malik.emulator.microedition.lcdui.TextMenu;
import malik.emulator.util.StringBuilder;

public class StringList
extends CustomSurfaceScreen
implements TextMenu {
    private static final int INITIAL_SCROLL = 32;
    private int selected;
    private int scroll;
    private int count;
    private String[] elements;
    private Font font;
    private final Object monitor;

    public StringList(String title, ScrollBarStyle style) {
        this(title, style, null);
    }

    public StringList(String title, ScrollBarStyle style, String[] list) {
        super(title, 0, true, style);
        int length = list == null ? 0 : list.length;
        String[] elements = new String[length <= 15 ? 15 : StringBuilder.optimalCapacity((int)length)];
        Font font = Font.getFont(0, 1, 8);
        int i = length;
        while (i-- > 0) {
            String s = list[i];
            String string = elements[i] = s == null ? "" : s;
        }
        this.scroll = 32;
        this.count = length;
        this.elements = elements;
        this.font = font;
        this.monitor = new Object();
        super.getScrollBar().setRange(font.getHeight() * length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(int elementIndex, String text) {
        if (text == null) {
            text = "";
        }
        Object object = this.monitor;
        synchronized (object) {
            int len = this.count;
            if (elementIndex > len) {
                elementIndex = len;
            }
            if (elementIndex < 0) {
                elementIndex = 0;
            }
            Object[] list = this.elements;
            if (len == this.elements.length) {
                Object[] objectArray = list;
                this.elements = new String[(len << 1) + 1];
                list = this.elements;
                Array.copy((Object[])objectArray, (int)0, (Object[])this.elements, (int)0, (int)len);
            }
            if (elementIndex < len) {
                Array.copy((Object[])list, (int)elementIndex, (Object[])list, (int)(elementIndex + 1), (int)(len - elementIndex));
            }
            list[elementIndex] = text;
            this.count = ++len;
            int sel = this.selected;
            if (len > 1 && sel >= elementIndex) {
                this.selected = ++sel;
            }
            super.getScrollBar().setRange(this.font.getHeight() * len);
            this.correctScrollBarPosition(sel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int elementIndex) {
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            int len;
            if (elementIndex < 0 || elementIndex > (len = this.count - 1)) {
                error = true;
            } else {
                Object[] list = this.elements;
                if (elementIndex < len) {
                    Array.copy((Object[])list, (int)(elementIndex + 1), (Object[])list, (int)elementIndex, (int)(len - elementIndex));
                }
                this.count = len;
                list[this.count] = null;
                int sel = this.selected;
                if (len > 0) {
                    if (sel == elementIndex) {
                        if (sel >= len) {
                            sel = len - 1;
                        }
                        this.selected = sel;
                        this.scroll = 32;
                    } else if (sel > elementIndex) {
                        this.selected = --sel;
                    }
                }
                super.getScrollBar().setRange(this.font.getHeight() * len);
                this.correctScrollBarPosition(sel);
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("StringList.delete: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        Object object = this.monitor;
        synchronized (object) {
            Array.fill((Object[])this.elements, (int)0, (int)this.count, null);
            this.selected = 0;
            this.scroll = 32;
            this.count = 0;
            super.getScrollBar().setRange(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedIndex(int elementIndex) {
        Object object = this.monitor;
        synchronized (object) {
            int lim = this.count - 1;
            if (elementIndex > lim) {
                elementIndex = lim;
            }
            if (elementIndex < 0) {
                elementIndex = 0;
            }
            this.selected = elementIndex;
            this.correctScrollBarPosition(this.selected);
            this.scroll = 32;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(int elementIndex, String text) {
        boolean error = false;
        if (text == null) {
            text = "";
        }
        Object object = this.monitor;
        synchronized (object) {
            if (elementIndex < 0 || elementIndex >= this.count) {
                error = true;
            } else {
                this.elements[elementIndex] = text;
                this.repaint();
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("StringList.setString: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFont(Font font) {
        if (font == null) {
            font = Font.getFont(0, 1, 8);
        }
        Object object = this.monitor;
        synchronized (object) {
            this.font = font;
            super.getScrollBar().setRange(font.getHeight() * this.count);
            this.correctScrollBarPosition(this.selected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int append(String text) {
        int result;
        if (text == null) {
            text = "";
        }
        Object object = this.monitor;
        synchronized (object) {
            int len;
            result = len = this.count;
            Object[] list = this.elements;
            if (len == this.elements.length) {
                Object[] objectArray = list;
                this.elements = new String[(len << 1) + 1];
                list = this.elements;
                Array.copy((Object[])objectArray, (int)0, (Object[])this.elements, (int)0, (int)len);
            }
            list[len++] = text;
            this.count = len;
            super.getScrollBar().setRange(this.font.getHeight() * len);
        }
        return result;
    }

    public int getSize() {
        return this.count;
    }

    public int getSelectedIndex() {
        return this.count <= 0 ? -1 : this.selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSelectedString() {
        String result;
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            if (this.count <= 0) {
                error = true;
                result = null;
            } else {
                result = this.elements[this.selected];
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("StringList.getSelectedString: \u0441\u043f\u0438\u0441\u043e\u043a \u043f\u0443\u0441\u0442.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int elementIndex) {
        String result;
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            if (elementIndex < 0 || elementIndex >= this.count) {
                error = true;
                result = null;
            } else {
                result = this.elements[elementIndex];
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("StringList.getString: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    public Font getFont() {
        return this.font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paint(Graphics render) {
        int width = super.getWidth();
        int clipLeft = render.getClipX();
        int clipTop = render.getClipY();
        int clipWidth = render.getClipWidth();
        int clipHeight = render.getClipHeight();
        Object object = this.monitor;
        synchronized (object) {
            int length = this.count;
            int selected = this.selected;
            String[] elements = this.elements;
            Font font = this.font;
            int line = font.getHeight();
            int srow = clipTop / line;
            int frow = (clipTop + clipHeight - 1) / line;
            render.setFont(font);
            int top = srow * line;
            int index = srow;
            while (index <= frow && index < length) {
                String element = elements[index];
                if (element == null) {
                    element = "";
                }
                if (index == selected) {
                    int wid = font.stringWidth(element);
                    int scroll = this.scroll;
                    render.setColor(RasterCanvas.getSystemColor((int)13));
                    render.fillRect(0, top, width, line);
                    render.setColor(RasterCanvas.getSystemColor((int)14));
                    int pos = width - 4;
                    render.setClip(2, top, pos, line);
                    render.drawString(element, wid > pos ? scroll + 2 : 2, top, 0);
                    render.setClip(clipLeft, clipTop, clipWidth, clipHeight);
                    if ((scroll -= 2) < -wid || scroll >= pos) {
                        scroll = pos - 2;
                    }
                    if (wid > pos) {
                        this.repaint();
                    }
                    this.scroll = scroll;
                } else {
                    render.setColor(RasterCanvas.getSystemColor((int)7));
                    render.drawString(MultilinedStringBuilder.truncate(element, font, width - 4), 2, top, 0);
                }
                top += line;
                ++index;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keyboardNotify(KeyboardEvent event) {
        int key = event.getKey();
        DeviceSettings settings = DeviceManager.getInstance().getSettings();
        switch (event.getAction()) {
            case 5: 
            case 6: {
                if (settings.getKeyUsedAs(38) == key) {
                    Object object = this.monitor;
                    synchronized (object) {
                        int len = this.count;
                        if (len > 0) {
                            int sel;
                            this.selected = sel = (this.selected + len - 1) % len;
                            this.correctScrollBarPosition(this.selected);
                            this.scroll = 32;
                        }
                        break;
                    }
                }
                if (settings.getKeyUsedAs(36) != key) break;
                Object object = this.monitor;
                synchronized (object) {
                    int len = this.count;
                    if (len > 0) {
                        int sel;
                        this.selected = sel = (this.selected + 1) % len;
                        this.correctScrollBarPosition(this.selected);
                        this.scroll = 32;
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pointerNotify(PointerEvent event) {
        int action = event.getAction();
        if (event.isButtonPressed(0) || (action == 15 || action == 11) && event.getButton() == 0) {
            Object object = this.monitor;
            synchronized (object) {
                int line = this.font.getHeight();
                int index = event.getY() / line;
                int lim = this.count - 1;
                if (index > lim) {
                    index = lim;
                }
                if (index < 0) {
                    index = 0;
                }
                this.selected = index;
                this.correctScrollBarPosition(this.selected);
                if (action != 15 && action != 11) {
                    this.scroll = 32;
                }
            }
        }
    }

    private void correctScrollBarPosition(int selected) {
        int line = this.font.getHeight();
        int top1 = selected * line;
        int top2 = line + top1;
        ScrollBar scroll = super.getScrollBar();
        int pos = scroll.getPosition();
        if (top1 < pos) {
            scroll.setPosition(top1);
        } else {
            int page = scroll.getPage();
            if (top2 > pos + page) {
                scroll.setPosition(top2 - page);
            } else {
                this.repaint();
            }
        }
    }
}

