/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;

public class ByteArrayOutputStream
extends OutputStream {
    protected int count;
    protected byte[] buf;
    private final Object monitor;

    public ByteArrayOutputStream() {
        this.buf = new byte[32];
        this.monitor = new Object();
    }

    public ByteArrayOutputStream(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("ByteArrayOutputStream: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 initialCapacity \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        this.buf = new byte[initialCapacity];
        this.monitor = new Object();
    }

    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int byteData) {
        Object object = this.monitor;
        synchronized (object) {
            int c = this.count;
            byte[] b = this.buf;
            if (c == this.buf.length) {
                byte[] byArray = b;
                b = this.buf = new byte[(c << 1) + 1];
                Array.copy(byArray, 0, this.buf, 0, c);
            }
            b[c++] = (byte)byteData;
            this.count = c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] src, int offset, int length) {
        if (src == null) {
            throw new NullPointerException("ByteArrayOutputStream.write: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound("ByteArrayOutputStream.write", src.length, offset, length);
        if (length <= 0) {
            return;
        }
        Object object = this.monitor;
        synchronized (object) {
            int c = this.count;
            int nc = c + length;
            byte[] b = this.buf;
            if (nc > this.buf.length) {
                byte[] byArray = b;
                b = this.buf = new byte[Math.max(nc, (c << 1) + 1)];
                Array.copy(byArray, 0, this.buf, 0, c);
            }
            Array.copy(src, offset, b, c, length);
            this.count = nc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String result;
        Object object = this.monitor;
        synchronized (object) {
            result = new String(this.buf, 0, this.count);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.monitor;
        synchronized (object) {
            this.count = 0;
        }
    }

    public int size() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() {
        byte[] result;
        Object object = this.monitor;
        synchronized (object) {
            int c = this.count;
            result = new byte[c];
            Array.copy(this.buf, 0, result, 0, c);
        }
        return result;
    }
}

