/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Math {
    public static final double E = 2.718281828459045;
    public static final double PI = 3.141592653589793;
    private static final int FLOAT_NEGATIVE_ZERO_BITS = Integer.MIN_VALUE;
    private static final long DOUBLE_NEGATIVE_ZERO_BITS = Long.MIN_VALUE;

    public static float abs(float x) {
        return Float.intBitsToFloat(Float.floatToIntBits(x) & Integer.MAX_VALUE);
    }

    public static float max(float x, float y) {
        return x != x ? x : (y != y ? y : (x == 0.0f && y == 0.0f && Float.floatToIntBits(x) == Integer.MIN_VALUE || x < y ? y : x));
    }

    public static float min(float x, float y) {
        return x != x ? x : (y != y ? y : (x == 0.0f && y == 0.0f && Float.floatToIntBits(y) == Integer.MIN_VALUE || x > y ? y : x));
    }

    public static double abs(double x) {
        return Double.longBitsToDouble(Double.doubleToLongBits(x) & Long.MAX_VALUE);
    }

    public static double max(double x, double y) {
        return x != x ? x : (y != y ? y : (x == 0.0 && y == 0.0 && Double.doubleToLongBits(x) == Long.MIN_VALUE || x < y ? y : x));
    }

    public static double min(double x, double y) {
        return x != x ? x : (y != y ? y : (x == 0.0 && y == 0.0 && Double.doubleToLongBits(y) == Long.MIN_VALUE || x > y ? y : x));
    }

    public static double toDegrees(double angleInRadians) {
        return angleInRadians * 57.29577951308232;
    }

    public static double toRadians(double angleInDegrees) {
        return angleInDegrees / 57.29577951308232;
    }

    public static double tan(double x) {
        return Math.sin(x) / Math.cos(x);
    }

    public static native double intPart(double var0);

    public static native double fracPart(double var0);

    public static native double sqrt(double var0);

    public static native double arctan(double var0, double var2);

    public static native double sin(double var0);

    public static native double cos(double var0);

    public static native double pow2(double var0);

    public static native double log2(double var0);

    public static native double floor(double var0);

    public static native double ceil(double var0);

    public static int abs(int x) {
        return x >= 0 ? x : -x;
    }

    public static int max(int x, int y) {
        return x >= y ? x : y;
    }

    public static int min(int x, int y) {
        return x <= y ? x : y;
    }

    public static long abs(long x) {
        return x >= 0L ? x : -x;
    }

    public static long max(long x, long y) {
        return x >= y ? x : y;
    }

    public static long min(long x, long y) {
        return x <= y ? x : y;
    }

    public static native long round(double var0);

    private Math() {
    }
}

