/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Date;
import java.util.TimeZone;
import malik.emulator.time.CLDCCalendar;
import malik.emulator.time.CalendarSystem;

public abstract class Calendar {
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_WEEK = 7;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int AM = 0;
    public static final int PM = 1;
    private boolean isTimeSet;
    protected long time;
    protected boolean[] isSet = new boolean[15];
    protected int[] fields = new int[15];
    private TimeZone zone = TimeZone.getDefault();

    public static Calendar getInstance() {
        return new CLDCCalendar(CalendarSystem.gregorian);
    }

    public static Calendar getInstance(TimeZone zone) {
        CLDCCalendar result = new CLDCCalendar(CalendarSystem.gregorian);
        result.setTimeZone(zone);
        return result;
    }

    protected Calendar() {
    }

    public boolean equals(Object anot) {
        return anot == this || anot instanceof Calendar && this.getTimeInMillis() == ((Calendar)anot).getTimeInMillis();
    }

    public void setTimeZone(TimeZone zone) {
        this.zone = zone;
        this.getTimeInMillis();
        this.computeFields();
    }

    public boolean before(Object anot) {
        return anot instanceof Calendar && this.getTimeInMillis() < ((Calendar)anot).getTimeInMillis();
    }

    public boolean after(Object anot) {
        return anot instanceof Calendar && this.getTimeInMillis() > ((Calendar)anot).getTimeInMillis();
    }

    public TimeZone getTimeZone() {
        return this.zone;
    }

    public final void set(int field, int value) {
        this.isTimeSet = false;
        this.isSet[field] = true;
        this.fields[field] = value;
    }

    public final void setTime(Date time) {
        if (time != null) {
            this.setTimeInMillis(time.getTime());
        }
    }

    public final int get(int field) {
        switch (field) {
            default: {
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                this.getTimeInMillis();
                this.computeFields();
            }
        }
        return this.fields[field];
    }

    public final Date getTime() {
        return new Date(this.getTimeInMillis());
    }

    protected abstract void computeTime();

    protected abstract void computeFields();

    protected void setTimeInMillis(long millis) {
        this.isTimeSet = true;
        this.fields[7] = 0;
        this.time = millis;
        this.computeFields();
    }

    protected long getTimeInMillis() {
        if (!this.isTimeSet) {
            this.isTimeSet = true;
            this.computeTime();
        }
        return this.time;
    }
}

