/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.TimeZone;
import malik.emulator.time.CalendarSystem;
import malik.emulator.util.StringBuilder;

public class Date {
    private long millis;

    public Date() {
        this.millis = System.currentTimeMillis();
    }

    public Date(long time) {
        this.millis = time;
    }

    public boolean equals(Object anot) {
        return anot == this || anot instanceof Date && this.millis == ((Date)anot).millis;
    }

    public int hashCode() {
        long millis = this.millis;
        return (int)(millis ^ millis >> 32);
    }

    public String toString() {
        CalendarSystem calendar = CalendarSystem.gregorian;
        TimeZone zone = TimeZone.getDefault();
        long fields = calendar.computeFields(this.millis, zone.getRawOffset());
        int year = calendar.getYear(fields);
        int month = calendar.getMonth(fields);
        int day = calendar.getDay(fields);
        int weekday = calendar.computeDayOfWeek(year, month, day);
        int hour = calendar.getHour(fields);
        int minute = calendar.getMinute(fields);
        int second = calendar.getSecond(fields);
        StringBuilder result = new StringBuilder(24);
        switch (weekday) {
            case 1: {
                result.append("Mon");
                break;
            }
            case 2: {
                result.append("Tue");
                break;
            }
            case 3: {
                result.append("Wed");
                break;
            }
            case 4: {
                result.append("Thu");
                break;
            }
            case 5: {
                result.append("Fri");
                break;
            }
            case 6: {
                result.append("Sat");
                break;
            }
            default: {
                result.append("Sun");
            }
        }
        result.append(' ');
        switch (month) {
            case 1: {
                result.append("Jan");
                break;
            }
            case 2: {
                result.append("Feb");
                break;
            }
            case 3: {
                result.append("Mar");
                break;
            }
            case 4: {
                result.append("Apr");
                break;
            }
            case 5: {
                result.append("May");
                break;
            }
            case 6: {
                result.append("Jun");
                break;
            }
            case 7: {
                result.append("Jul");
                break;
            }
            case 8: {
                result.append("Aug");
                break;
            }
            case 9: {
                result.append("Sep");
                break;
            }
            case 10: {
                result.append("Oct");
                break;
            }
            case 11: {
                result.append("Nov");
                break;
            }
            default: {
                result.append("Dec");
            }
        }
        result.append(new char[]{' ', (char)(day / 10 + 48), (char)(day % 10 + 48), ' ', (char)(hour / 10 + 48), (char)(hour % 10 + 48), ':', (char)(minute / 10 + 48), (char)(minute % 10 + 48), ':', (char)(second / 10 + 48), (char)(second % 10 + 48), ' '}).append(zone.toString()).append(' ');
        String string = Integer.toString(year, 10);
        switch (string.length()) {
            case 1: {
                result.append("000").append(string);
                break;
            }
            case 2: {
                result.append("00").append(string);
                break;
            }
            case 3: {
                result.append("0").append(string);
                break;
            }
            default: {
                result.append(string);
            }
        }
        return result.toString();
    }

    public void setTime(long time) {
        this.millis = time;
    }

    public long getTime() {
        return this.millis;
    }
}

