/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import malik.emulator.fileformats.DataHolder;
import malik.emulator.util.MapEnumeration;
import malik.emulator.util.StringBuilder;

public class Hashtable
implements DataHolder {
    private int factor;
    private int length;
    private Entry[] table;
    private final Object monitor;

    public Hashtable() {
        this(15);
    }

    public Hashtable(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Hashtable: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 initialCapacity \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.factor = initialCapacity - (initialCapacity >> 2);
        this.table = new Entry[initialCapacity];
        this.monitor = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder result = new StringBuilder().append('{');
        Object object = this.monitor;
        synchronized (object) {
            KeyEnumerator e = new KeyEnumerator(this.table);
            int i = this.length;
            while (i-- > 0) {
                result.append(e.nextElement().toString()).append('=').append(e.value().toString());
                if (i <= 0) continue;
                result.append(", ");
            }
        }
        return result.append('}').toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.monitor;
        synchronized (object) {
            Object[] t = this.table;
            Array.fill(this.table, 0, t.length, null);
            this.length = 0;
        }
    }

    public boolean isEmpty() {
        return this.length <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object value) {
        boolean result;
        if (value == null) {
            throw new NullPointerException("Hashtable.contains: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 value \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = this.monitor;
        synchronized (object) {
            result = false;
            Entry[] t = this.table;
            int i = this.table.length;
            block3: while (i-- > 0) {
                Entry e = t[i];
                while (e != null) {
                    if (value.equals(e.value)) {
                        result = true;
                        break block3;
                    }
                    e = e.next;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        boolean result;
        if (key == null) {
            return false;
        }
        Object object = this.monitor;
        synchronized (object) {
            result = false;
            Entry[] t = this.table;
            int h = key.hashCode();
            Entry e = this.table[(h & Integer.MAX_VALUE) % t.length];
            while (e != null) {
                if (h == e.hash && key.equals(e.key)) {
                    result = true;
                    break;
                }
                e = e.next;
            }
        }
        return result;
    }

    public int size() {
        return this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        Object result;
        if (key == null) {
            throw new NullPointerException("Hashtable.put: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 key \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (value == null) {
            throw new NullPointerException("Hashtable.put: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 value \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = this.monitor;
        synchronized (object) {
            block8: {
                Entry[] t = this.table;
                int h = key.hashCode();
                int i = (h & Integer.MAX_VALUE) % t.length;
                Entry e = this.table[i];
                while (e != null) {
                    if (h == e.hash && key.equals(e.key)) {
                        result = e.value;
                        e.value = value;
                        break block8;
                    }
                    e = e.next;
                }
                int len = this.length;
                if (len >= this.factor) {
                    this.rehash();
                    t = this.table;
                    i = (h & Integer.MAX_VALUE) % this.table.length;
                }
                t[i] = new Entry(h, key, value, t[i]);
                this.length = len + 1;
                result = null;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Object result;
        if (key == null) {
            return null;
        }
        Object object = this.monitor;
        synchronized (object) {
            result = null;
            Entry f = null;
            Entry[] t = this.table;
            int h = key.hashCode();
            int i = (h & Integer.MAX_VALUE) % t.length;
            Entry e = this.table[i];
            while (e != null) {
                if (h == e.hash && key.equals(e.key)) {
                    if (f != null) {
                        f.next = e.next;
                    } else {
                        t[i] = e.next;
                    }
                    --this.length;
                    result = e.value;
                    break;
                }
                f = e;
                e = e.next;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Object result;
        if (key == null) {
            return null;
        }
        Object object = this.monitor;
        synchronized (object) {
            result = null;
            Entry[] t = this.table;
            int h = key.hashCode();
            Entry e = this.table[(h & Integer.MAX_VALUE) % t.length];
            while (e != null) {
                if (h == e.hash && key.equals(e.key)) {
                    result = e.value;
                    break;
                }
                e = e.next;
            }
        }
        return result;
    }

    public Enumeration elements() {
        return new Enumerator(false, this.table);
    }

    public Enumeration keys() {
        return new KeyEnumerator(this.table);
    }

    protected void rehash() {
        Entry[] ot = this.table;
        int oc = this.table.length;
        int nc = (oc << 1) + 1;
        Entry[] nt = new Entry[nc];
        this.table = nt;
        this.factor = nc - (nc >> 2);
        int i = oc;
        while (i-- > 0) {
            Entry f = ot[i];
            while (f != null) {
                Entry e = f;
                int j = (e.hash & Integer.MAX_VALUE) % nc;
                f = f.next;
                e.next = nt[j];
                nt[j] = e;
            }
        }
    }

    private static final class Entry {
        public final int hash;
        public final Object key;
        public Object value;
        public Entry next;

        public Entry(int hash, Object key, Object value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }

    private static class Enumerator
    implements Enumeration {
        private final boolean keys;
        private int index;
        private final Entry[] table;
        private Entry next;
        protected Entry current;

        public Enumerator(boolean keys, Entry[] table) {
            this.keys = keys;
            this.index = table.length;
            this.table = table;
        }

        public boolean hasMoreElements() {
            if (this.next != null) {
                return true;
            }
            Entry[] t = this.table;
            int i = this.index;
            while (i-- > 0) {
                this.next = t[i];
                if (this.next == null) continue;
                this.index = i;
                return true;
            }
            this.index = -1;
            return false;
        }

        public Object nextElement() {
            Entry e = this.next;
            if (e == null) {
                int i = this.index;
                Entry[] t = this.table;
                while (i-- > 0 && (e = t[i]) == null) {
                }
                this.next = e;
                int n = this.index = i < 0 ? -1 : i;
            }
            if (e == null) {
                this.current = null;
                throw new NoSuchElementException("Enumeration.nextElement: \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c.");
            }
            this.current = e;
            this.next = this.current.next;
            return this.keys ? e.key : e.value;
        }
    }

    private static class KeyEnumerator
    extends Enumerator
    implements MapEnumeration {
        public KeyEnumerator(Entry[] table) {
            super(true, table);
        }

        public Object value() {
            Entry e = this.current;
            if (e == null) {
                throw new NoSuchElementException("Hashtable.keys: \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c.");
            }
            return e.value;
        }
    }
}

