/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Date;
import java.util.TimerTask;
import java.util.TimerThread;

public class Timer {
    private TimerThread thread;

    public Timer() {
        TimerThread thread;
        this.thread = thread = new TimerThread();
        thread.start();
    }

    public void cancel() {
        TimerThread thread = this.thread;
        if (thread != null) {
            this.thread = null;
            thread.terminate();
        }
    }

    public void schedule(TimerTask task, long delay) {
        long firstExecutionTime;
        if (delay < 0L || (firstExecutionTime = System.currentTimeMillis() + delay) < 0L) {
            throw new IllegalArgumentException("Timer.schedule: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 delay \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        TimerThread thread = this.thread;
        if (thread == null) {
            throw new IllegalStateException("Timer.schedule: \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u044b\u0445 \u0437\u0430\u0434\u0430\u0447 \u0431\u044b\u043b\u043e \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u043e.");
        }
        if (task != null) {
            thread.schedule(task, firstExecutionTime);
        }
    }

    public void schedule(TimerTask task, long delay, long period) {
        long firstExecutionTime;
        if (delay < 0L || (firstExecutionTime = System.currentTimeMillis() + delay) < 0L) {
            throw new IllegalArgumentException("Timer.schedule: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 delay \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        TimerThread thread = this.thread;
        if (thread == null) {
            throw new IllegalStateException("Timer.schedule: \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u044b\u0445 \u0437\u0430\u0434\u0430\u0447 \u0431\u044b\u043b\u043e \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u043e.");
        }
        if (task != null) {
            thread.schedule(task, firstExecutionTime, period, false);
        }
    }

    public void schedule(TimerTask task, Date time) {
        long firstExecutionTime = time == null ? System.currentTimeMillis() : time.getTime();
        if (firstExecutionTime < 0L) {
            throw new IllegalArgumentException("Timer.schedule: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 time \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        TimerThread thread = this.thread;
        if (thread == null) {
            throw new IllegalStateException("Timer.schedule: \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u044b\u0445 \u0437\u0430\u0434\u0430\u0447 \u0431\u044b\u043b\u043e \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u043e.");
        }
        if (task != null) {
            thread.schedule(task, firstExecutionTime);
        }
    }

    public void schedule(TimerTask task, Date firstTime, long period) {
        long firstExecutionTime = firstTime == null ? System.currentTimeMillis() : firstTime.getTime();
        if (firstExecutionTime < 0L) {
            throw new IllegalArgumentException("Timer.schedule: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 firstTime \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        TimerThread thread = this.thread;
        if (thread == null) {
            throw new IllegalStateException("Timer.schedule: \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u044b\u0445 \u0437\u0430\u0434\u0430\u0447 \u0431\u044b\u043b\u043e \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u043e.");
        }
        if (task != null) {
            thread.schedule(task, firstExecutionTime, period, false);
        }
    }

    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        long firstExecutionTime;
        if (delay < 0L || (firstExecutionTime = System.currentTimeMillis() + delay) < 0L) {
            throw new IllegalArgumentException("Timer.scheduleAtFixedRate: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 delay \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        TimerThread thread = this.thread;
        if (thread == null) {
            throw new IllegalStateException("Timer.scheduleAtFixedRate: \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u044b\u0445 \u0437\u0430\u0434\u0430\u0447 \u0431\u044b\u043b\u043e \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u043e.");
        }
        if (task != null) {
            thread.schedule(task, firstExecutionTime, period, true);
        }
    }

    public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
        long firstExecutionTime = firstTime == null ? System.currentTimeMillis() : firstTime.getTime();
        if (firstExecutionTime < 0L) {
            throw new IllegalArgumentException("Timer.scheduleAtFixedRate: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 firstTime \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        TimerThread thread = this.thread;
        if (thread == null) {
            throw new IllegalStateException("Timer.scheduleAtFixedRate: \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u044b\u0445 \u0437\u0430\u0434\u0430\u0447 \u0431\u044b\u043b\u043e \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u043e.");
        }
        if (task != null) {
            thread.schedule(task, firstExecutionTime, period, true);
        }
    }
}

