/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.application;

import malik.emulator.util.RunnableQueue;

public class RequestableQueue
extends RunnableQueue {
    protected long[] longs;

    public RequestableQueue() {
        this(16);
    }

    public RequestableQueue(int initialCapacity) {
        super(initialCapacity);
        initialCapacity = this.capacity;
        this.longs = new long[initialCapacity];
    }

    public void clear() {
        long[] q = this.longs;
        int c = this.capacity;
        int t = this.tail;
        int i = this.head;
        while (i != t) {
            q[i] = 0L;
            i = this.nextIndex(i, c);
        }
        super.clear();
    }

    public void removeHeadElement() {
        int h = this.head;
        if (h != this.tail) {
            this.longs[h] = 0L;
            this.runnables[h] = null;
            this.advanceHead(h);
        }
    }

    public void addTailElement(Runnable runnableElement) {
        long[] q1 = this.longs;
        Object[] q2 = this.runnables;
        if (this.freeElements() == 0) {
            int c = (this.capacity << 1) - 1;
            q1 = this.longs = this.expand(q1, c);
            this.runnables = (Runnable[])this.expand(q2, c);
            q2 = this.runnables;
            this.reset(c);
        }
        int t = this.tail;
        q1[t] = -1L;
        q2[t] = runnableElement;
        this.advanceTail(t);
    }

    public void addTailElement(Runnable runnableElement, long longElement) {
        long[] q1 = this.longs;
        Object[] q2 = this.runnables;
        if (this.freeElements() == 0) {
            int c = (this.capacity << 1) - 1;
            q1 = this.longs = this.expand(q1, c);
            this.runnables = (Runnable[])this.expand(q2, c);
            q2 = this.runnables;
            this.reset(c);
        }
        int t = this.tail;
        q1[t] = longElement;
        q2[t] = runnableElement;
        this.advanceTail(t);
    }

    public final long peekHeadLong() {
        return this.longs[this.head];
    }
}

