/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.fileformats.text.mapped;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import malik.emulator.fileformats.ExtendedDataInputStream;
import malik.emulator.fileformats.text.mapped.AttributedTextDecoder;
import malik.emulator.fileformats.text.mapped.CustomKeyValueList;
import malik.emulator.fileformats.text.mapped.InvalidManifestFileFormatException;

public final class ManifestDecoder
extends CustomKeyValueList
implements AttributedTextDecoder {
    private String parsed;
    private final Object monitor = new Object();

    private static int skipLineEndings(byte[] stream, int offset) {
        byte c;
        int i = offset;
        while ((c = stream[i]) == 10 || c == 13) {
            i += c == 13 && stream[i + 1] == 10 ? 2 : 1;
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadFromInputStream(InputStream stream) throws IOException {
        int size = stream.available();
        byte[] s = new byte[size + 1];
        stream.read(s, 0, size);
        Object object = this.monitor;
        synchronized (object) {
            this.clear();
            try {
                int i = size >= 3 && s[0] == -17 && s[1] == -69 && s[2] == -65 ? 3 : 0;
                while (true) {
                    i = ManifestDecoder.skipLineEndings(s, i);
                    if (s[i] == 0) return;
                    if (i < size) {
                        if (s[i = this.parseKey(s, i)] != 58) {
                            throw new InvalidManifestFileFormatException("ManifestDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0444\u0430\u0439\u043b\u0430 MANIFEST.MF.");
                        }
                        String key = this.parsed.intern();
                        i = this.parseValue(s, i + 1);
                        String value = this.parsed.intern();
                        this.set(key, value);
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.parsed = null;
            }
            return;
        }
    }

    public void loadFromInputStream(InputStream stream, String encoding) throws IOException {
        this.loadFromInputStream(stream);
    }

    public void loadFromDataStream(ExtendedDataInputStream stream) throws IOException {
        this.loadFromInputStream(stream);
    }

    public void loadFromDataStream(ExtendedDataInputStream stream, String encoding) throws IOException {
        this.loadFromInputStream(stream);
    }

    public String[] getAttributes(String key) {
        String value = this.get(key);
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() <= 0) {
            return new String[0];
        }
        int len = 1;
        int j = 0;
        while ((j = value.indexOf(44, j)) >= 0) {
            ++len;
            ++j;
        }
        String[] result = new String[len];
        int index = 0;
        j = 0;
        int i = 0;
        while ((j = value.indexOf(44, j)) >= 0) {
            result[index++] = value.substring(i, j).trim().intern();
            i = ++j;
        }
        result[index] = value.substring(i).trim().intern();
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private int parseKey(byte[] stream, int offset) throws InvalidManifestFileFormatException {
        i = offset;
        if ((c = stream[i++]) >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122) ** GOTO lbl5
        throw new InvalidManifestFileFormatException("ManifestFile.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0444\u0430\u0439\u043b\u0430 MANIFEST.MF.");
lbl-1000:
        // 1 sources

        {
            ++i;
lbl5:
            // 2 sources

            ** while ((c = stream[i]) >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122 || c == 45 || c == 95)
        }
lbl6:
        // 1 sources

        this.parsed = new String(stream, offset, i - offset);
        return i;
    }

    private int parseValue(byte[] stream, int offset) {
        int i = offset;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        if (stream[i] == 32) {
            offset = ++i;
        }
        while (true) {
            byte c;
            if ((c = stream[i]) != 0 && c != 13 && c != 10) {
                ++i;
                continue;
            }
            result.write(stream, offset, i - offset);
            if (c == 0 || (c = stream[i += c == 13 && stream[i + 1] == 10 ? 2 : 1]) != 32) break;
            offset = ++i;
        }
        this.parsed = result.toString();
        return i;
    }
}

