/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.io.cloud;

import java.io.IOException;
import java.io.InputStream;
import malik.emulator.io.vfs.ClosedFileException;
import malik.emulator.io.vfs.FileNotFoundException;
import malik.emulator.util.DataDescriptor;
import malik.emulator.util.StringBuilder;

public abstract class HandleInputStream
extends InputStream {
    private static final int NO_ERROR = 0;
    private static final int FILE_NOT_FOUND = 1;
    private static final int FILE_NAME_NOT_SPECIFIED = 3;
    private static final int BUFFER_SIZE = 512;
    private static final long BUFFER_POSITION_MASK = 511L;
    private final boolean shared;
    private final int openError;
    private final int address;
    int handle;
    private long markedPosition;
    private long currentPosition;
    private final byte[] markedBuffer;
    private final byte[] currentBuffer;
    private final String fileName;
    final DataDescriptor descriptor;

    HandleInputStream(String fileName, int access) {
        int e;
        int h;
        int len;
        if (fileName == null || (len = fileName.length()) <= 0) {
            h = 0;
            e = 3;
        } else {
            char[] name = new char[len + 1];
            fileName.getChars(0, len, name, 0);
            h = (int)MalikSystem.syscall(Array.getFirstElementAddress(name), access, 16);
            e = h == 0 ? 1 : 0;
        }
        if (h == 0) {
            this.shared = false;
            this.openError = e;
            this.address = 0;
            this.markedBuffer = null;
            this.currentBuffer = null;
            this.descriptor = null;
            this.fileName = fileName;
            return;
        }
        byte[] buffer = new byte[512];
        this.shared = false;
        this.openError = 0;
        this.address = Array.getFirstElementAddress(buffer);
        this.handle = h;
        this.markedPosition = -1L;
        this.currentPosition = -1L;
        this.markedBuffer = new byte[512];
        this.currentBuffer = buffer;
        this.fileName = fileName;
        this.descriptor = new DataDescriptor();
    }

    HandleInputStream(String fileName, DataDescriptor descriptor, int handle) {
        boolean shared = descriptor != null;
        if (!shared) {
            descriptor = new DataDescriptor();
        }
        byte[] buffer = new byte[512];
        this.shared = shared;
        this.openError = 0;
        this.address = Array.getFirstElementAddress(buffer);
        this.handle = handle;
        this.markedPosition = -1L;
        this.currentPosition = -1L;
        this.markedBuffer = new byte[512];
        this.currentBuffer = buffer;
        this.fileName = fileName;
        this.descriptor = descriptor;
    }

    public abstract long getFileSize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        this.checkOpenError();
        boolean error = false;
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            if (this.handle == 0) {
                error = true;
            } else {
                this.currentPosition = this.markedPosition;
                Array.copy(this.markedBuffer, 0, this.currentBuffer, 0, 512);
            }
        }
        if (error) {
            throw new ClosedFileException("HandleInputStream.reset: \u0444\u0430\u0439\u043b\u043e\u0432\u044b\u0439 \u043f\u043e\u0442\u043e\u043a \u0432\u0432\u043e\u0434\u0430 \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int readLimit) {
        if (this.hasOpenError()) {
            return;
        }
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            if (this.handle != 0) {
                this.markedPosition = this.currentPosition;
                Array.copy(this.currentBuffer, 0, this.markedBuffer, 0, 512);
            }
        }
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        long result;
        this.checkOpenError();
        boolean error = false;
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            if (this.handle == 0) {
                error = true;
                result = 0L;
            } else {
                long filePosition = this.currentPosition;
                result = this.getFileSize() - (filePosition >= 0L ? filePosition : 0L);
            }
        }
        if (error) {
            throw new ClosedFileException("HandleInputStream.available: \u0444\u0430\u0439\u043b\u043e\u0432\u044b\u0439 \u043f\u043e\u0442\u043e\u043a \u0432\u0432\u043e\u0434\u0430 \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return Integer.MAX_VALUE < result ? Integer.MAX_VALUE : (int)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int read() throws IOException {
        block13: {
            this.checkOpenError();
            error = 0;
            var3_2 = this.descriptor;
            synchronized (var3_2) {
                block12: {
                    if (this.handle != 0) break block12;
                    error = 1;
                    result = 0;
                    break block13;
                }
                filePosition = this.currentPosition;
                if (filePosition >= 0L) ** GOTO lbl-1000
                filePosition = 0L;
                if (!this.readFile(0L)) {
                    error = 2;
                    result = 0;
                } else if (filePosition >= this.getFileSize()) {
                    result = -1;
                    this.currentPosition = filePosition;
                } else {
                    result = this.currentBuffer[(int)(filePosition++ & 511L)] & 255;
                    this.currentPosition = filePosition;
                    if ((filePosition & 511L) == 0L && !this.readFile(filePosition)) {
                        error = 2;
                        result = 0;
                    }
                }
            }
        }
        switch (error) {
            case 1: {
                throw new ClosedFileException("HandleInputStream.read: \u0444\u0430\u0439\u043b\u043e\u0432\u044b\u0439 \u043f\u043e\u0442\u043e\u043a \u0432\u0432\u043e\u0434\u0430 \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 2: {
                throw new IOException("HandleInputStream.read: \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043f\u0440\u0438 \u0447\u0442\u0435\u043d\u0438\u0438 \u0444\u0430\u0439\u043b\u0430.");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int read(byte[] dst, int offset, int length) throws IOException {
        block17: {
            if (dst == null) {
                throw new NullPointerException("HandleInputStream.read: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
            }
            Array.checkBound("HandleInputStream.read", dst.length, offset, length);
            this.checkOpenError();
            error = 0;
            var6_5 = this.descriptor;
            synchronized (var6_5) {
                block16: {
                    if (this.handle != 0) break block16;
                    error = 1;
                    result = 0;
                    break block17;
                }
                filePosition = this.currentPosition;
                if (filePosition >= 0L) ** GOTO lbl-1000
                filePosition = 0L;
                if (!this.readFile(0L)) {
                    error = 2;
                    result = 0;
                } else if (length <= 0) {
                    result = 0;
                } else {
                    fileSize = this.getFileSize();
                    if (filePosition >= fileSize) {
                        result = -1;
                        this.currentPosition = filePosition;
                    } else {
                        bufferContent = this.currentBuffer;
                        fileRemainder = fileSize - filePosition;
                        length = (long)length <= fileRemainder ? length : (int)fileRemainder;
                        result = length;
                        this.currentPosition = filePosition + (long)result;
                        while (length > 0) {
                            bufferPosition = (int)(filePosition & 511L);
                            bufferRemainder = 512 - bufferPosition;
                            readed = bufferRemainder <= length ? bufferRemainder : length;
                            readedAsLong = readed;
                            Array.copy(bufferContent, bufferPosition, dst, offset, readed);
                            if (((filePosition += readedAsLong) & 511L) == 0L && !this.readFile(filePosition)) {
                                error = 2;
                                this.currentPosition = filePosition;
                                break;
                            }
                            offset += readed;
                            length -= readed;
                        }
                    }
                }
            }
        }
        switch (error) {
            case 1: {
                throw new ClosedFileException("HandleInputStream.read: \u0444\u0430\u0439\u043b\u043e\u0432\u044b\u0439 \u043f\u043e\u0442\u043e\u043a \u0432\u0432\u043e\u0434\u0430 \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 2: {
                throw new IOException("HandleInputStream.read: \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043f\u0440\u0438 \u0447\u0442\u0435\u043d\u0438\u0438 \u0444\u0430\u0439\u043b\u0430.");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public long skip(long quantity) throws IOException {
        block14: {
            if (quantity < 0L) {
                quantity = 0L;
            }
            this.checkOpenError();
            error = 0;
            var6_3 = this.descriptor;
            synchronized (var6_3) {
                block13: {
                    if (this.handle != 0) break block13;
                    error = 1;
                    result = 0L;
                    break block14;
                }
                filePosition = this.currentPosition;
                if (filePosition >= 0L) ** GOTO lbl-1000
                filePosition = 0L;
                if (!this.readFile(0L)) {
                    error = 2;
                    result = 0L;
                } else if (filePosition >= (fileSize = this.getFileSize())) {
                    result = 0L;
                    this.currentPosition = filePosition;
                } else {
                    fileRemainder = fileSize - filePosition;
                    result = quantity <= fileRemainder ? quantity : fileRemainder;
                    this.currentPosition = newPosition = filePosition + result;
                    if ((filePosition & -512L) != (newPosition &= -512L) && !this.readFile(newPosition)) {
                        error = 2;
                    }
                }
            }
        }
        switch (error) {
            case 1: {
                throw new ClosedFileException("HandleInputStream.skip: \u0444\u0430\u0439\u043b\u043e\u0432\u044b\u0439 \u043f\u043e\u0442\u043e\u043a \u0432\u0432\u043e\u0434\u0430 \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 2: {
                throw new IOException("HandleInputStream.skip: \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043f\u0440\u0438 \u0447\u0442\u0435\u043d\u0438\u0438 \u0444\u0430\u0439\u043b\u0430.");
            }
        }
        return result;
    }

    public String toString() {
        String name = this.fileName;
        return (this.handle != 0 ? "\u041e\u0442\u043a\u0440\u044b\u0442\u044b\u0439 \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b " : "\u0417\u0430\u043a\u0440\u044b\u0442\u044b\u0439 \u0444\u0430\u0439\u043b ").concat(name != null && name.length() > 0 ? name : "<\u0438\u043c\u044f \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e>");
    }

    public void checkOpenError() throws IOException {
        String name = this.fileName;
        switch (this.openError) {
            case 1: {
                throw new FileNotFoundException(new StringBuilder().append("HandleInputStream.checkOpenError: \u0444\u0430\u0439\u043b ").append(name).append(" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u043b\u0438 \u0437\u0430\u043d\u044f\u0442.").toString(), name);
            }
            case 3: {
                throw new IOException("HandleInputStream.checkOpenError: \u0438\u043c\u044f \u0444\u0430\u0439\u043b\u0430 \u043d\u0435 \u0431\u044b\u043b\u043e \u0437\u0430\u0434\u0430\u043d\u043e \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u044d\u0442\u043e\u0433\u043e \u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440\u0430 HandleInputStream.");
            }
        }
    }

    public boolean hasOpenError() {
        int e = this.openError;
        return e > 0 && e <= 3;
    }

    public final String getFileName() {
        return this.fileName;
    }

    final void resetPosition() {
        this.currentPosition = -1L;
    }

    private long seek(long delta) {
        return MalikSystem.syscall(this.handle, MalikSystem.getLocalVariableAddress(delta), 20);
    }

    private boolean readFile(long position) {
        boolean result;
        long oldPosition = this.seek(0L);
        long fileRemainder = this.getFileSize() - position;
        DataDescriptor descriptor = this.descriptor;
        int mustRead = 512L <= fileRemainder ? 512 : (int)fileRemainder;
        this.seek(position - oldPosition);
        descriptor.setDataInfo(this.address, 512);
        boolean bl = result = (int)MalikSystem.syscall(this.handle, descriptor.getDescriptorAddress(), 18) == mustRead;
        if (this.shared) {
            this.seek(oldPosition - this.seek(0L));
        }
        return result;
    }
}

