/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.io.vfs;

public class FileAttributes {
    public static final int READ_ONLY = 1;
    public static final int HIDDEN = 2;
    public static final int SYSTEM = 4;
    public static final int DIRECTORY = 16;
    public static final int ARCHIVE = 32;
    private int attributes;
    private long creationTime;
    private long lastWriteTime;
    private long lastAccessTime;

    public FileAttributes() {
    }

    public FileAttributes(FileAttributes source) {
        if (source == null) {
            return;
        }
        this.attributes = source.attributes;
        this.creationTime = source.creationTime;
        this.lastWriteTime = source.lastWriteTime;
        this.lastAccessTime = source.lastAccessTime;
    }

    public FileAttributes(int attributes, long creationTime, long lastWriteTime, long lastAccessTime) {
        this.attributes = attributes & 0x37;
        this.creationTime = creationTime;
        this.lastWriteTime = lastWriteTime;
        this.lastAccessTime = lastAccessTime;
    }

    public void setAttributes(int attributes, long creationTime, long lastWriteTime, long lastAccessTime) {
        this.attributes = attributes & 0x37;
        this.creationTime = creationTime;
        this.lastWriteTime = lastWriteTime;
        this.lastAccessTime = lastAccessTime;
    }

    public final boolean isDirectory() {
        return (this.attributes & 0x10) != 0;
    }

    public final boolean isReadOnly() {
        return (this.attributes & 1) != 0;
    }

    public final boolean isArchive() {
        return (this.attributes & 0x20) != 0;
    }

    public final boolean isHidden() {
        return (this.attributes & 2) != 0;
    }

    public final boolean isSystem() {
        return (this.attributes & 4) != 0;
    }

    public final int getAttributes() {
        return this.attributes;
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    public final long getLastWriteTime() {
        return this.lastWriteTime;
    }

    public final long getLastAccessTime() {
        return this.lastAccessTime;
    }
}

