/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.util;

import malik.emulator.fileformats.DataHolder;

public class StringBuilder
implements DataHolder {
    protected int length;
    protected char[] content;

    public static int optimalCapacity(int length) {
        if (length <= 7) {
            return 7;
        }
        int result = length;
        while (length != 0) {
            result |= (length >>>= 1);
        }
        return result;
    }

    public StringBuilder() {
        this.content = new char[15];
    }

    public StringBuilder(int initialCapacity) {
        this.content = new char[initialCapacity < 15 ? 15 : initialCapacity];
    }

    public String toString() {
        return new String(this.content, 0, this.length);
    }

    public void clear() {
        this.length = 0;
    }

    public void copy(int beginPosition, int endPosition, char[] dst, int offset) {
        int len = this.length;
        if (beginPosition < 0 || beginPosition > len) {
            throw new StringIndexOutOfBoundsException("StringBuilder.copy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 beginPosition \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (endPosition < beginPosition || endPosition > len) {
            throw new StringIndexOutOfBoundsException("StringBuilder.copy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 endPosition \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (dst == null) {
            throw new NullPointerException("StringBuilder.copy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int length = endPosition - beginPosition;
        Array.checkBound("StringBuilder.copy", dst.length, offset, length);
        if (length > 0) {
            Array.copy(this.content, beginPosition, dst, offset, length);
        }
    }

    public void set(int position, char character) {
        if (position < 0 || position >= this.length) {
            throw new StringIndexOutOfBoundsException("StringBuilder.set: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 position \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        this.content[position] = character;
    }

    public char get(int position) {
        if (position < 0 || position >= this.length) {
            throw new StringIndexOutOfBoundsException("StringBuilder.get: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 position \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return this.content[position];
    }

    public StringBuilder insert(int position, boolean value) {
        this.insertString(position, value ? "true" : "false");
        return this;
    }

    public StringBuilder insert(int position, char value) {
        this.insertChar(position, value);
        return this;
    }

    public StringBuilder insert(int position, float value) {
        this.insertString(position, Float.toString(value));
        return this;
    }

    public StringBuilder insert(int position, double value) {
        this.insertString(position, Double.toString(value));
        return this;
    }

    public StringBuilder insert(int position, int value) {
        this.insertString(position, Integer.toString(value, 10));
        return this;
    }

    public StringBuilder insert(int position, int value, int radix, boolean upperCase) {
        String string = Integer.toString(value, radix);
        this.insertString(position, upperCase ? string.toUpperCase() : string);
        return this;
    }

    public StringBuilder insert(int position, long value) {
        this.insertString(position, Long.toString(value, 10));
        return this;
    }

    public StringBuilder insert(int position, long value, int radix, boolean upperCase) {
        String string = Long.toString(value, radix);
        this.insertString(position, upperCase ? string.toUpperCase() : string);
        return this;
    }

    public StringBuilder insert(int position, char[] src) {
        if (src != null) {
            this.insertArray(position, src, 0, src.length);
        }
        return this;
    }

    public StringBuilder insert(int position, char[] src, int offset, int length) {
        if (src != null) {
            long bound = Array.intersectBound(src.length, offset, length);
            offset = (int)bound;
            length = (int)(bound >> 32);
            this.insertArray(position, src, offset, length);
        }
        return this;
    }

    public StringBuilder insert(int position, Object value) {
        String string;
        if (value != null && (string = value.toString()) != null) {
            this.insertString(position, string);
        }
        return this;
    }

    public StringBuilder insert(int position, String value) {
        if (value != null) {
            this.insertString(position, value);
        }
        return this;
    }

    public StringBuilder append(boolean value) {
        this.appendString(value ? "true" : "false");
        return this;
    }

    public StringBuilder append(char value) {
        this.appendChar(value);
        return this;
    }

    public StringBuilder append(float value) {
        this.appendString(Float.toString(value));
        return this;
    }

    public StringBuilder append(double value) {
        this.appendString(Double.toString(value));
        return this;
    }

    public StringBuilder append(int value) {
        this.appendString(Integer.toString(value, 10));
        return this;
    }

    public StringBuilder append(int value, int radix, boolean upperCase) {
        String string = Integer.toString(value, radix);
        this.appendString(upperCase ? string.toUpperCase() : string);
        return this;
    }

    public StringBuilder append(long value) {
        this.appendString(Long.toString(value, 10));
        return this;
    }

    public StringBuilder append(long value, int radix, boolean upperCase) {
        String string = Long.toString(value, radix);
        this.appendString(upperCase ? string.toUpperCase() : string);
        return this;
    }

    public StringBuilder append(char[] src) {
        if (src != null) {
            this.appendArray(src, 0, src.length);
        }
        return this;
    }

    public StringBuilder append(char[] src, int offset, int length) {
        if (src != null) {
            long bound = Array.intersectBound(src.length, offset, length);
            offset = (int)bound;
            length = (int)(bound >> 32);
            this.appendArray(src, offset, length);
        }
        return this;
    }

    public StringBuilder append(Object value) {
        String string;
        if (value != null && (string = value.toString()) != null) {
            this.appendString(string);
        }
        return this;
    }

    public StringBuilder append(String value) {
        if (value != null) {
            this.appendString(value);
        }
        return this;
    }

    public StringBuilder delete(int position) {
        this.deletePortion(position, position + 1);
        return this;
    }

    public StringBuilder delete(int beginPosition, int endPosition) {
        this.deletePortion(beginPosition, endPosition);
        return this;
    }

    public final boolean isEmpty() {
        return this.length <= 0;
    }

    public final int capacity() {
        return this.content.length;
    }

    public final int length() {
        return this.length;
    }

    protected void insertChar(int position, char character) {
        int oldLength = this.length;
        int newLength = 1 + oldLength;
        char[] content = this.madeLarger(newLength);
        if (position < 0) {
            position = 0;
        }
        if (position > oldLength) {
            position = oldLength;
        }
        if (position < oldLength) {
            Array.copy(content, position, content, position + 1, oldLength - position);
        }
        content[position] = character;
        this.length = newLength;
    }

    protected void insertArray(int position, char[] src, int offset, int length) {
        int oldLength = this.length;
        int newLength = length + oldLength;
        char[] content = this.madeLarger(newLength);
        if (position < 0) {
            position = 0;
        }
        if (position > oldLength) {
            position = oldLength;
        }
        if (position < oldLength) {
            Array.copy(content, position, content, position + length, oldLength - position);
        }
        Array.copy(src, offset, content, position, length);
        this.length = newLength;
    }

    protected void insertString(int position, String string) {
        int length = string.length();
        int oldLength = this.length;
        int newLength = length + oldLength;
        char[] content = this.madeLarger(newLength);
        if (position < 0) {
            position = 0;
        }
        if (position > oldLength) {
            position = oldLength;
        }
        if (position < oldLength) {
            Array.copy(content, position, content, position + length, oldLength - position);
        }
        string.getChars(0, length, content, position);
        this.length = newLength;
    }

    protected void appendChar(char character) {
        int oldLength = this.length;
        int newLength = 1 + oldLength;
        this.madeLarger((int)newLength)[oldLength] = character;
        this.length = newLength;
    }

    protected void appendArray(char[] src, int offset, int length) {
        int oldLength = this.length;
        int newLength = length + oldLength;
        Array.copy(src, offset, this.madeLarger(newLength), oldLength, length);
        this.length = newLength;
    }

    protected void appendString(String string) {
        int length = string.length();
        int oldLength = this.length;
        int newLength = length + oldLength;
        string.getChars(0, length, this.madeLarger(newLength), oldLength);
        this.length = newLength;
    }

    protected void deletePortion(int beginPosition, int endPosition) {
        int oldLength = this.length;
        if (beginPosition < 0) {
            beginPosition = 0;
        }
        if (beginPosition > oldLength) {
            beginPosition = oldLength;
        }
        if (endPosition < beginPosition) {
            endPosition = beginPosition;
        }
        if (endPosition > oldLength) {
            endPosition = oldLength;
        }
        if (beginPosition < endPosition) {
            char[] buffer = this.content;
            Array.copy(this.content, endPosition, buffer, beginPosition, oldLength - endPosition);
            this.length = oldLength - (endPosition - beginPosition);
        }
    }

    private char[] madeLarger(int length) {
        char[] result = this.content;
        int oldLength = this.content.length;
        if (length > oldLength) {
            char[] cArray = result;
            result = this.content = new char[StringBuilder.optimalCapacity(length)];
            Array.copy(cArray, 0, this.content, 0, oldLength);
        }
        return result;
    }
}

