/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.media.graphics;

import malik.emulator.media.graphics.GUIElementDescriptor;
import malik.emulator.media.graphics.GraphicBuffer;
import malik.emulator.media.graphics.GraphicBufferDescriptor;
import malik.emulator.media.graphics.GraphicBufferWithAlphaDescriptor;
import malik.emulator.media.graphics.StretchDrawDescriptor;
import malik.emulator.media.graphics.StringDrawDescriptor;
import malik.emulator.media.text.RasterFont;

public class RasterCanvas {
    public static final int TRANSFORM_NONE = 0;
    public static final int TRANSFORM_ROTATE_90 = 1;
    public static final int TRANSFORM_ROTATE_180 = 2;
    public static final int TRANSFORM_ROTATE_270 = 3;
    public static final int TRANSFORM_MIRROR = 4;
    public static final int TRANSFORM_MIRROR_ROTATE_90 = 5;
    public static final int TRANSFORM_MIRROR_ROTATE_180 = 6;
    public static final int TRANSFORM_MIRROR_ROTATE_270 = 7;
    private static final RasterCanvas SCREEN_CANVAS;
    private boolean opaque;
    private int width;
    private int height;
    private Object lock;
    private GraphicBuffer buffer;
    private GraphicBufferWithAlphaDescriptor alphaDescriptor;
    private GUIElementDescriptor elementDescriptor;
    private StringDrawDescriptor stringDescriptor;
    private StretchDrawDescriptor stretchDescriptor;

    static {
        GraphicBufferDescriptor d = new GraphicBufferDescriptor();
        MalikSystem.syscall((long)((long)d.getDescriptorAddress() << 32), (int)34);
        int s = d.sizes;
        int w = s & 0xFFFF;
        int h = s >>> 16;
        s = d.scan;
        SCREEN_CANVAS = new RasterCanvas(new GraphicBuffer(Array.createSystemIntArray((int)d.base, (int)(w + (h - 1) * s)), 0, s, w, h), true);
    }

    public static int getElementOfGUISizes(int type, int subtype, int state) {
        return (int)MalikSystem.syscall((long)(type & 0xFF | (subtype & 0xFF) << 8 | (state & 0xFF) << 16), (int)36);
    }

    public static int getSystemColor(int index) {
        return (int)MalikSystem.syscall((long)index, (int)38);
    }

    public static RasterCanvas getScreenCanvas() {
        return SCREEN_CANVAS;
    }

    public RasterCanvas(GraphicBuffer buffer) {
        this(buffer, false);
    }

    public RasterCanvas(GraphicBuffer buffer, boolean opaque) {
        if (buffer == null) {
            throw new NullPointerException("RasterCanvas: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 buffer \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        this.opaque = opaque;
        this.width = buffer.getWidth();
        this.height = buffer.getHeight();
        this.lock = new Object();
        this.buffer = buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawElementOfGUI(int clipLeft, int clipTop, int clipWidth, int clipHeight, int type, int subtype, int state, int left, int top, int width, int height) {
        int cheight;
        int ctop;
        int cwidth;
        int cleft;
        block8: {
            block7: {
                if (width <= 0 || height <= 0) {
                    throw new IllegalArgumentException("RasterCanvas.drawElementOfGUI: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.");
                }
                int w = this.width;
                cleft = Math.max(0, clipLeft);
                cwidth = Math.min(w, clipLeft + clipWidth) - cleft;
                if (cwidth > w || cwidth <= 0) break block7;
                int h = this.height;
                ctop = Math.max(0, clipTop);
                cheight = Math.min(h, clipTop + clipHeight) - ctop;
                if (cheight <= h && cheight > 0) break block8;
            }
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            GUIElementDescriptor d = this.getElementDescriptor();
            d.setAlpha(!this.opaque);
            d.assign(this.buffer, cleft, ctop, cwidth, cheight);
            d.assignElement(type, subtype, state, left - cleft, top - ctop, width, height);
            MalikSystem.syscall((long)d.getDescriptorAddress(), (int)37);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawCharacter(int clipLeft, int clipTop, int clipWidth, int clipHeight, int charCode, int x, int y, int colorARGB, RasterFont font, boolean underline, boolean strikeout, boolean alpha) {
        int cheight;
        int ctop;
        int cwidth;
        int cleft;
        block8: {
            block7: {
                if (font == null) {
                    throw new NullPointerException("RasterCanvas.drawCharacter: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 font \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
                }
                int w = this.width;
                cleft = Math.max(0, clipLeft);
                cwidth = Math.min(w, clipLeft + clipWidth) - cleft;
                if (cwidth > w || cwidth <= 0) break block7;
                int h = this.height;
                ctop = Math.max(0, clipTop);
                cheight = Math.min(h, clipTop + clipHeight) - ctop;
                if (cheight <= h && cheight > 0) break block8;
            }
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            StringDrawDescriptor d = this.getStringDescriptor();
            d.setAlpha(!this.opaque);
            d.assign(this.buffer, cleft, ctop, cwidth, cheight);
            d.assignStringUTF32(MalikSystem.getLocalVariableAddress((int)charCode), 1, x - cleft, y - ctop, colorARGB, font.getHandle(), underline, strikeout, alpha);
            MalikSystem.syscall((long)d.getDescriptorAddress(), (int)45);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawString(int clipLeft, int clipTop, int clipWidth, int clipHeight, int[] src, int offset, int length, int x, int y, int colorARGB, RasterFont font, boolean underline, boolean strikeout, boolean alpha) {
        int cheight;
        int ctop;
        int cwidth;
        int cleft;
        block10: {
            block9: {
                if (src == null) {
                    throw new NullPointerException("RasterCanvas.drawString: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
                }
                int lim = offset + length;
                int len = src.length;
                if (lim > len || lim < offset || offset > len || offset < 0) {
                    throw new IndexOutOfBoundsException("RasterCanvas.drawString: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
                }
                if (font == null) {
                    throw new NullPointerException("RasterCanvas.drawString: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 font \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
                }
                if (length == 0) break block9;
                int w = this.width;
                cleft = Math.max(0, clipLeft);
                cwidth = Math.min(w, clipLeft + clipWidth) - cleft;
                if (cwidth > w || cwidth <= 0) break block9;
                int h = this.height;
                ctop = Math.max(0, clipTop);
                cheight = Math.min(h, clipTop + clipHeight) - ctop;
                if (cheight <= h && cheight > 0) break block10;
            }
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            StringDrawDescriptor d = this.getStringDescriptor();
            d.setAlpha(!this.opaque);
            d.assign(this.buffer, cleft, ctop, cwidth, cheight);
            d.assignStringUTF32(Array.getFirstElementAddress((Object)src) + (offset << 2), length, x - cleft, y - ctop, colorARGB, font.getHandle(), underline, strikeout, alpha);
            MalikSystem.syscall((long)d.getDescriptorAddress(), (int)45);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawString(int clipLeft, int clipTop, int clipWidth, int clipHeight, char[] src, int offset, int length, int x, int y, int colorARGB, RasterFont font, boolean underline, boolean strikeout, boolean alpha) {
        int cheight;
        int ctop;
        int cwidth;
        int cleft;
        block10: {
            block9: {
                if (src == null) {
                    throw new NullPointerException("RasterCanvas.drawString: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
                }
                int lim = offset + length;
                int len = src.length;
                if (lim > len || lim < offset || offset > len || offset < 0) {
                    throw new IndexOutOfBoundsException("RasterCanvas.drawString: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
                }
                if (font == null) {
                    throw new NullPointerException("RasterCanvas.drawString: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 font \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
                }
                if (length == 0) break block9;
                int w = this.width;
                cleft = Math.max(0, clipLeft);
                cwidth = Math.min(w, clipLeft + clipWidth) - cleft;
                if (cwidth > w || cwidth <= 0) break block9;
                int h = this.height;
                ctop = Math.max(0, clipTop);
                cheight = Math.min(h, clipTop + clipHeight) - ctop;
                if (cheight <= h && cheight > 0) break block10;
            }
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            StringDrawDescriptor d = this.getStringDescriptor();
            d.setAlpha(!this.opaque);
            d.assign(this.buffer, cleft, ctop, cwidth, cheight);
            d.assignStringUTF16(Array.getFirstElementAddress((Object)src) + (offset << 1), length, x - cleft, y - ctop, colorARGB, font.getHandle(), underline, strikeout, alpha);
            MalikSystem.syscall((long)d.getDescriptorAddress(), (int)45);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawString(int clipLeft, int clipTop, int clipWidth, int clipHeight, String src, int offset, int length, int x, int y, int colorARGB, RasterFont font, boolean underline, boolean strikeout, boolean alpha) {
        int cheight;
        int ctop;
        int cwidth;
        int cleft;
        block10: {
            block9: {
                if (src == null) {
                    throw new NullPointerException("RasterCanvas.drawString: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
                }
                int lim = offset + length;
                int len = src.length();
                if (lim > len || lim < offset || offset > len || offset < 0) {
                    throw new IndexOutOfBoundsException("RasterCanvas.drawString: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
                }
                if (font == null) {
                    throw new NullPointerException("RasterCanvas.drawString: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 font \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
                }
                if (length == 0) break block9;
                int w = this.width;
                cleft = Math.max(0, clipLeft);
                cwidth = Math.min(w, clipLeft + clipWidth) - cleft;
                if (cwidth > w || cwidth <= 0) break block9;
                int h = this.height;
                ctop = Math.max(0, clipTop);
                cheight = Math.min(h, clipTop + clipHeight) - ctop;
                if (cheight <= h && cheight > 0) break block10;
            }
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            StringDrawDescriptor d = this.getStringDescriptor();
            d.setAlpha(!this.opaque);
            d.assign(this.buffer, cleft, ctop, cwidth, cheight);
            d.assignStringUTF16(Array.getFirstElementAddress((String)src) + (offset << 1), length, x - cleft, y - ctop, colorARGB, font.getHandle(), underline, strikeout, alpha);
            MalikSystem.syscall((long)d.getDescriptorAddress(), (int)45);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPixelsArea(int clipLeft, int clipTop, int clipWidth, int clipHeight, int[] src, int offset, int scanlength, int width, int height, int transform, int dstLeft, int dstTop, int dstWidth, int dstHeight, boolean alpha) {
        int cheight;
        int ctop;
        int cwidth;
        int cleft;
        block12: {
            block11: {
                int length;
                int ofs;
                if (src == null) {
                    throw new NullPointerException("RasterCanvas.drawPixelsArea: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
                }
                if (width <= 0 || height <= 0 || dstWidth <= 0 || dstHeight <= 0) {
                    throw new IllegalArgumentException("RasterCanvas.drawPixelsArea: \u0432\u0441\u0435 \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.");
                }
                if (scanlength >= 0) {
                    ofs = 0;
                    length = width + (height - 1) * scanlength;
                } else {
                    ofs = -scanlength * (height - 1);
                    length = width + ofs;
                }
                int lim = (offset -= ofs) + length;
                int len = src.length;
                if (lim > len || lim < offset || offset > len || offset < 0) {
                    throw new IndexOutOfBoundsException("RasterCanvas.drawPixelsArea: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
                }
                offset += ofs;
                int w = this.width;
                cleft = Math.max(0, clipLeft);
                cwidth = Math.min(w, clipLeft + clipWidth) - cleft;
                if (cwidth > w || cwidth <= 0) break block11;
                int h = this.height;
                ctop = Math.max(0, clipTop);
                cheight = Math.min(h, clipTop + clipHeight) - ctop;
                if (cheight <= h && cheight > 0) break block12;
            }
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            GraphicBufferWithAlphaDescriptor a = this.getAlphaDescriptor();
            a.setAlpha(alpha);
            a.assign(src, offset, scanlength, width, height);
            StretchDrawDescriptor d = this.getStretchDescriptor();
            d.setAlpha(!this.opaque);
            d.assign(this.buffer, cleft, ctop, cwidth, cheight);
            d.assignStretch(dstLeft - cleft, dstTop - ctop, dstWidth, dstHeight, a, transform);
            MalikSystem.syscall((long)d.getDescriptorAddress(), (int)39);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPixelsArea(int clipLeft, int clipTop, int clipWidth, int clipHeight, GraphicBuffer src, int left, int top, int width, int height, int transform, int dstLeft, int dstTop, int dstWidth, int dstHeight, boolean alpha) {
        int cheight;
        int ctop;
        int cwidth;
        int cleft;
        block10: {
            block9: {
                if (src == null) {
                    throw new NullPointerException("RasterCanvas.drawPixelsArea: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
                }
                if (width <= 0 || height <= 0 || dstWidth <= 0 || dstHeight <= 0) {
                    throw new IllegalArgumentException("RasterCanvas.drawPixelsArea: \u0432\u0441\u0435 \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.");
                }
                int lim = left + width;
                int len = src.getWidth();
                if (lim > len || lim < left || left > len || left < 0 || (lim = top + height) > (len = src.getHeight()) || lim < top || top > len || top < 0) {
                    throw new IllegalArgumentException("RasterCanvas.drawPixelsArea: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0433\u0438\u043e\u043d \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0431\u0443\u0444\u0435\u0440\u0430.");
                }
                int w = this.width;
                cleft = Math.max(0, clipLeft);
                cwidth = Math.min(w, clipLeft + clipWidth) - cleft;
                if (cwidth > w || cwidth <= 0) break block9;
                int h = this.height;
                ctop = Math.max(0, clipTop);
                cheight = Math.min(h, clipTop + clipHeight) - ctop;
                if (cheight <= h && cheight > 0) break block10;
            }
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            GraphicBufferWithAlphaDescriptor a = this.getAlphaDescriptor();
            a.setAlpha(alpha);
            a.assign(src, left, top, width, height);
            StretchDrawDescriptor d = this.getStretchDescriptor();
            d.setAlpha(!this.opaque);
            d.assign(this.buffer, cleft, ctop, cwidth, cheight);
            d.assignStretch(dstLeft - cleft, dstTop - ctop, dstWidth, dstHeight, a, transform);
            MalikSystem.syscall((long)d.getDescriptorAddress(), (int)39);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawHorzLine(int clipLeft, int clipTop, int clipWidth, int clipHeight, int x, int y, int length, int colorARGB, boolean alpha) {
        int cheight;
        int ctop;
        int cwidth;
        int cleft;
        block8: {
            block7: {
                if (length < 0) {
                    throw new IllegalArgumentException("RasterCanvas.drawHorzLine: \u0434\u043b\u0438\u043d\u0430 \u043b\u0438\u043d\u0438\u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0439.");
                }
                if (length == 0) break block7;
                int w = this.width;
                cleft = Math.max(0, clipLeft);
                cwidth = Math.min(w, clipLeft + clipWidth) - cleft;
                if (cwidth > w || cwidth <= 0) break block7;
                int h = this.height;
                ctop = Math.max(0, clipTop);
                cheight = Math.min(h, clipTop + clipHeight) - ctop;
                if (cheight <= h && cheight > 0) break block8;
            }
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            GraphicBufferWithAlphaDescriptor a = this.getAlphaDescriptor();
            a.setAlpha(alpha);
            a.assign(MalikSystem.getLocalVariableAddress((int)colorARGB), 1, 1, 1);
            StretchDrawDescriptor d = this.getStretchDescriptor();
            d.setAlpha(!this.opaque);
            d.assign(this.buffer, cleft, ctop, cwidth, cheight);
            d.assignStretch(x - cleft, y - ctop, length, 1, a, 0);
            MalikSystem.syscall((long)d.getDescriptorAddress(), (int)39);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawVertLine(int clipLeft, int clipTop, int clipWidth, int clipHeight, int x, int y, int length, int colorARGB, boolean alpha) {
        int cheight;
        int ctop;
        int cwidth;
        int cleft;
        block8: {
            block7: {
                if (length < 0) {
                    throw new IllegalArgumentException("RasterCanvas.drawVertLine: \u0434\u043b\u0438\u043d\u0430 \u043b\u0438\u043d\u0438\u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0439.");
                }
                if (length == 0) break block7;
                int w = this.width;
                cleft = Math.max(0, clipLeft);
                cwidth = Math.min(w, clipLeft + clipWidth) - cleft;
                if (cwidth > w || cwidth <= 0) break block7;
                int h = this.height;
                ctop = Math.max(0, clipTop);
                cheight = Math.min(h, clipTop + clipHeight) - ctop;
                if (cheight <= h && cheight > 0) break block8;
            }
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            GraphicBufferWithAlphaDescriptor a = this.getAlphaDescriptor();
            a.setAlpha(alpha);
            a.assign(MalikSystem.getLocalVariableAddress((int)colorARGB), 1, 1, 1);
            StretchDrawDescriptor d = this.getStretchDescriptor();
            d.setAlpha(!this.opaque);
            d.assign(this.buffer, cleft, ctop, cwidth, cheight);
            d.assignStretch(x - cleft, y - ctop, 1, length, a, 0);
            MalikSystem.syscall((long)d.getDescriptorAddress(), (int)39);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillRect(int clipLeft, int clipTop, int clipWidth, int clipHeight, int left, int top, int width, int height, int colorARGB, boolean alpha) {
        int cheight;
        int ctop;
        int cwidth;
        int cleft;
        block8: {
            block7: {
                if (width <= 0 || height <= 0) {
                    throw new IllegalArgumentException("RasterCanvas.fillRect: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.");
                }
                int w = this.width;
                cleft = Math.max(0, clipLeft);
                cwidth = Math.min(w, clipLeft + clipWidth) - cleft;
                if (cwidth > w || cwidth <= 0) break block7;
                int h = this.height;
                ctop = Math.max(0, clipTop);
                cheight = Math.min(h, clipTop + clipHeight) - ctop;
                if (cheight <= h && cheight > 0) break block8;
            }
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            GraphicBufferWithAlphaDescriptor a = this.getAlphaDescriptor();
            a.setAlpha(alpha);
            a.assign(MalikSystem.getLocalVariableAddress((int)colorARGB), 1, 1, 1);
            StretchDrawDescriptor d = this.getStretchDescriptor();
            d.setAlpha(!this.opaque);
            d.assign(this.buffer, cleft, ctop, cwidth, cheight);
            d.assignStretch(left - cleft, top - ctop, width, height, a, 0);
            MalikSystem.syscall((long)d.getDescriptorAddress(), (int)39);
        }
    }

    public RasterCanvas subcanvas(int left, int top, int width, int height) {
        RasterCanvas rasterCanvas;
        int h;
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("RasterCanvas.subcanvas: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.");
        }
        int lim = left + width;
        int w = this.width;
        if (lim > w || lim < left || left > w || left < 0 || (lim = top + height) > (h = this.height) || lim < top || top > h || top < 0) {
            throw new IllegalArgumentException("RasterCanvas.subcanvas: \u0437\u0430\u0434\u0430\u043d\u043d\u0430\u044f \u043f\u0440\u044f\u043c\u043e\u0443\u0433\u043e\u043b\u044c\u043d\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0440\u0430\u0441\u0442\u0440\u043e\u0432\u043e\u0439 \u043a\u0430\u043d\u0432\u044b.");
        }
        if (left == 0 && top == 0 && width == w && height == h) {
            rasterCanvas = this;
        } else {
            GraphicBuffer g = this.buffer;
            int s = g.getScanlength();
            RasterCanvas rasterCanvas2 = new RasterCanvas(new GraphicBuffer(g.getPixels(), g.getOffset() + left + top * s, s, width, height), this.opaque);
            rasterCanvas = rasterCanvas2;
        }
        return rasterCanvas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copyArea(int clipLeft, int clipTop, int clipWidth, int clipHeight, int left, int top, int width, int height, int dstLeft, int dstTop) {
        int cheight;
        int ctop;
        int cwidth;
        int cleft;
        block10: {
            block9: {
                int h;
                if (this.opaque) {
                    throw new IllegalStateException("RasterCanvas.copyArea: \u044d\u0442\u0430 \u0440\u0430\u0441\u0442\u0440\u043e\u0432\u0430\u044f \u043a\u0430\u043d\u0432\u0430 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 \u044d\u043a\u0440\u0430\u043d \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430, \u043f\u043e\u044d\u0442\u043e\u043c\u0443 \u0435\u0451 \u043f\u0438\u043a\u0441\u0435\u043b\u044b \u0447\u0438\u0442\u0430\u0442\u044c \u043d\u0435\u043b\u044c\u0437\u044f.");
                }
                if (width <= 0 || height <= 0) {
                    throw new IllegalArgumentException("RasterCanvas.copyArea: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.");
                }
                int lim = left + width;
                int w = this.width;
                if (lim > w || lim < left || left > w || left < 0 || (lim = top + height) > (h = this.height) || lim < top || top > h || top < 0) {
                    throw new IllegalArgumentException("RasterCanvas.copyArea: \u0437\u0430\u0434\u0430\u043d\u043d\u0430\u044f \u043f\u0440\u044f\u043c\u043e\u0443\u0433\u043e\u043b\u044c\u043d\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0440\u0430\u0441\u0442\u0440\u043e\u0432\u043e\u0439 \u043a\u0430\u043d\u0432\u044b.");
                }
                cleft = Math.max(0, clipLeft);
                cwidth = Math.min(w, clipLeft + clipWidth) - cleft;
                if (cwidth > w || cwidth <= 0) break block9;
                ctop = Math.max(0, clipTop);
                cheight = Math.min(h, clipTop + clipHeight) - ctop;
                if (cheight <= h && cheight > 0) break block10;
            }
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            GraphicBufferWithAlphaDescriptor a = this.getAlphaDescriptor();
            a.setAlpha(true);
            GraphicBuffer g = this.buffer;
            a.assign(g, left, top, width, height);
            StretchDrawDescriptor d = this.getStretchDescriptor();
            d.setAlpha(true);
            d.assign(g, cleft, ctop, cwidth, cheight);
            d.assignStretch(dstLeft - cleft, dstTop - ctop, width, height, a, 0);
            MalikSystem.syscall((long)d.getDescriptorAddress(), (int)39);
        }
    }

    public final void getPixels(int[] dst, int offset, int scanlength, int left, int top, int width, int height) {
        int length;
        int i;
        if (this.opaque) {
            throw new IllegalStateException("RasterCanvas.getPixels: \u044d\u0442\u0430 \u0440\u0430\u0441\u0442\u0440\u043e\u0432\u0430\u044f \u043a\u0430\u043d\u0432\u0430 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 \u044d\u043a\u0440\u0430\u043d \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430, \u043f\u043e\u044d\u0442\u043e\u043c\u0443 \u0435\u0451 \u043f\u0438\u043a\u0441\u0435\u043b\u044b \u0447\u0438\u0442\u0430\u0442\u044c \u043d\u0435\u043b\u044c\u0437\u044f.");
        }
        if (dst == null) {
            throw new NullPointerException("RasterCanvas.getPixels: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("RasterCanvas.getPixels: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.");
        }
        int lim = left + width;
        int len = this.width;
        if (lim > len || lim < left || left > len || left < 0 || (lim = top + height) > (len = this.height) || lim < top || top > len || top < 0) {
            throw new IllegalArgumentException("RasterCanvas.getPixels: \u0437\u0430\u0434\u0430\u043d\u043d\u0430\u044f \u043f\u0440\u044f\u043c\u043e\u0443\u0433\u043e\u043b\u044c\u043d\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0440\u0430\u0441\u0442\u0440\u043e\u0432\u043e\u0439 \u043a\u0430\u043d\u0432\u044b.");
        }
        if (Math.abs(scanlength) < width) {
            throw new IllegalArgumentException("RasterCanvas.getPixels: \u0434\u043b\u0438\u043d\u0430 \u043b\u0438\u043d\u0438\u0438 \u0441\u043a\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0448\u0438\u0440\u0438\u043d\u044b.");
        }
        if (scanlength >= 0) {
            i = 0;
            length = width + (height - 1) * scanlength;
        } else {
            i = -scanlength * (height - 1);
            length = width + i;
        }
        lim = (offset -= i) + length;
        len = dst.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("RasterCanvas.getPixels: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        GraphicBuffer g = this.buffer;
        int[] src = g.getPixels();
        int srcScan = g.getScanlength();
        int srcLine = g.getOffset() + left + top * srcScan;
        int dstLine = offset += i;
        i = 0;
        while (i < height) {
            Array.copy((int[])src, (int)srcLine, (int[])dst, (int)dstLine, (int)width);
            srcLine += srcScan;
            dstLine += scanlength;
            ++i;
        }
    }

    public final void updateScreen() {
        if (SCREEN_CANVAS != this) {
            throw new IllegalStateException("RasterCanvas.updateScreen: \u044d\u0442\u0430 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0440\u0430\u0441\u0442\u0440\u043e\u0432\u043e\u0439 \u043a\u0430\u043d\u0432\u044b, \u043a\u043e\u0442\u043e\u0440\u0430\u044f \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 \u044d\u043a\u0440\u0430\u043d \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430.");
        }
        MalikSystem.syscall((long)0L, (int)32);
    }

    public final boolean isScreenCanvas() {
        return SCREEN_CANVAS == this;
    }

    public final boolean isOpaque() {
        return this.opaque;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final GraphicBuffer getBuffer() {
        return this.buffer;
    }

    private GraphicBufferWithAlphaDescriptor getAlphaDescriptor() {
        GraphicBufferWithAlphaDescriptor result = this.alphaDescriptor;
        if (result == null) {
            result = this.alphaDescriptor = new GraphicBufferWithAlphaDescriptor();
        }
        return result;
    }

    private GUIElementDescriptor getElementDescriptor() {
        GUIElementDescriptor result = this.elementDescriptor;
        if (result == null) {
            result = this.elementDescriptor = new GUIElementDescriptor();
        }
        return result;
    }

    private StringDrawDescriptor getStringDescriptor() {
        StringDrawDescriptor result = this.stringDescriptor;
        if (result == null) {
            result = this.stringDescriptor = new StringDrawDescriptor();
        }
        return result;
    }

    private StretchDrawDescriptor getStretchDescriptor() {
        StretchDrawDescriptor result = this.stretchDescriptor;
        if (result == null) {
            result = this.stretchDescriptor = new StretchDrawDescriptor();
        }
        return result;
    }
}

