/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.media.sound;

import malik.emulator.application.PlayerPCMLoadBlockHandler;
import malik.emulator.application.Run;
import malik.emulator.media.sound.SoundPlayer;
import malik.emulator.media.sound.SoundPlayerException;
import malik.emulator.media.sound.SoundPlayerListener;
import malik.emulator.util.DataDescriptor;

public final class SoundPlayerSampled
implements PlayerPCMLoadBlockHandler,
SoundPlayer {
    public static final int MIN_BLOCK_LENGTH = 256;
    public static final int MAX_BLOCK_LENGTH = 65536;
    private int handle;
    private DataDescriptor descriptor;
    private SoundPlayerListener listener;
    private Object lock;

    public static SoundPlayerSampled open(int samplesPerSecond, int bitsPerSample, int channelsCount, int blockLength) throws SoundPlayerException {
        int handle = (int)MalikSystem.syscall((int)(samplesPerSecond | bitsPerSample << 16 | channelsCount - 1 << 24), (int)blockLength, (int)48);
        if (handle == 0) {
            throw new SoundPlayerException("SoundPlayerSampled.open: \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u043d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u043f\u0430\u043c\u044f\u0442\u0438 \u043d\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u043e\u0433\u043e PCM-\u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u043d\u0435 \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u044e\u0442 \u0432\u043e\u0441\u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u044c \u0437\u0432\u0443\u043a \u0432 \u0418\u041a\u041c \u0441 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c\u0438 " + samplesPerSecond + " \u0413\u0446, " + bitsPerSample + " \u0431\u0438\u0442, " + (channelsCount == 1 ? "\u043c\u043e\u043d\u043e." : (channelsCount == 2 ? "\u0441\u0442\u0435\u0440\u0435\u043e." : String.valueOf(Integer.toString(channelsCount)) + " \u043a\u0430\u043d\u0430\u043b\u043e\u0432.")));
        }
        return new SoundPlayerSampled(handle);
    }

    private SoundPlayerSampled(int handle) {
        this.handle = handle;
        this.descriptor = new DataDescriptor();
        this.lock = new Object();
        Run.getInstance().setPlayerPCMLoadBlockHandler(handle, (PlayerPCMLoadBlockHandler)this);
    }

    public void loadPCMBlock(int playerPCMHandle, int blockIndex) {
        SoundPlayerListener listener = this.listener;
        if (listener != null && playerPCMHandle == this.handle) {
            listener.loadBlock(this, blockIndex);
        }
    }

    public void setSoundPlayerListener(SoundPlayerListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            int h = this.handle;
            if (h != 0) {
                this.handle = 0;
                MalikSystem.syscall((long)h, (int)55);
                Run.getInstance().setPlayerPCMLoadBlockHandler(h, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadBlock(long[] packedSamples, int offset, int length) {
        int result;
        int h = this.handle;
        if (h == 0) {
            throw new IllegalStateException("SoundPlayer: \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 close().");
        }
        if (packedSamples == null) {
            throw new NullPointerException("SoundPlayerSampled.loadBlock: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 packedSamples \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = packedSamples.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("SoundPlayerSampled.loadBlock: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        Object object = this.lock;
        synchronized (object) {
            DataDescriptor d = this.descriptor;
            d.setDataInfo(Array.getFirstElementAddress((Object)packedSamples) + (offset << 3), length);
            result = (int)MalikSystem.syscall((int)h, (int)d.getDescriptorAddress(), (int)49);
        }
        return result;
    }

    public int reset() {
        int h = this.handle;
        if (h == 0) {
            throw new IllegalStateException("SoundPlayer: \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 close().");
        }
        return (int)MalikSystem.syscall((int)h, (int)0, (int)50);
    }

    public int start() {
        int h = this.handle;
        if (h == 0) {
            throw new IllegalStateException("SoundPlayer: \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 close().");
        }
        return (int)MalikSystem.syscall((int)h, (int)1, (int)50);
    }

    public int stop() {
        int h = this.handle;
        if (h == 0) {
            throw new IllegalStateException("SoundPlayer: \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 close().");
        }
        return (int)MalikSystem.syscall((int)h, (int)2, (int)50);
    }

    public int setVolume(int volume) {
        int h = this.handle;
        if (h == 0) {
            throw new IllegalStateException("SoundPlayer: \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 close().");
        }
        return (int)MalikSystem.syscall((int)h, (int)(volume < 0 ? 0 : (volume > 127 ? 127 : volume)), (int)54);
    }

    public int setCurrentBlockPosition(int position) {
        int h = this.handle;
        if (h == 0) {
            throw new IllegalStateException("SoundPlayer: \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 close().");
        }
        return (int)MalikSystem.syscall((int)h, (int)position, (int)52);
    }

    public int getState() {
        int h = this.handle;
        if (h == 0) {
            throw new IllegalStateException("SoundPlayer: \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 close().");
        }
        return (int)MalikSystem.syscall((int)h, (int)0, (int)51);
    }

    public int getVolume() {
        int h = this.handle;
        if (h == 0) {
            throw new IllegalStateException("SoundPlayer: \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 close().");
        }
        return (int)MalikSystem.syscall((int)h, (int)-1, (int)54);
    }

    public int getCurrentBlockPosition() {
        int h = this.handle;
        if (h == 0) {
            throw new IllegalStateException("SoundPlayer: \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 close().");
        }
        return (int)MalikSystem.syscall((int)h, (int)0, (int)53);
    }

    public int getCurrentBlockIndex() {
        int h = this.handle;
        if (h == 0) {
            throw new IllegalStateException("SoundPlayer: \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 close().");
        }
        return (int)(MalikSystem.syscall((int)h, (int)0, (int)53) >> 32);
    }

    public long getCurrentBlockAndPosition() {
        int h = this.handle;
        if (h == 0) {
            throw new IllegalStateException("SoundPlayer: \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 close().");
        }
        return MalikSystem.syscall((int)h, (int)0, (int)53);
    }
}

