/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.fileformats.sound.sampled.wavelib;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import malik.emulator.fileformats.DataEncoder;
import malik.emulator.fileformats.DataHolder;
import malik.emulator.fileformats.EmptyAdapterException;
import malik.emulator.fileformats.InvalidDataFormatException;
import malik.emulator.fileformats.OutputAdapter;
import malik.emulator.fileformats.sound.SoundEncoder;
import malik.emulator.fileformats.sound.sampled.SoundEncoderSampled;

public final class WaveEncoder
implements OutputAdapter,
SoundEncoder,
DataHolder,
DataEncoder,
SoundEncoderSampled {
    public static final int RIFF_SIGNATURE = 1380533830;
    private static final int DATA_SIGNATURE = 1684108385;
    private static final long WAVEFMT_SIGNATURE = 6287401410857104416L;
    private int channels;
    private int samplesPerSecond;
    private short[] samples;

    private static void writeShortLE(OutputStream stream, int src) throws IOException {
        stream.write(src);
        stream.write(src >> 8);
    }

    private static void writeIntLE(OutputStream stream, int src) throws IOException {
        stream.write(src);
        stream.write(src >> 8);
        stream.write(src >> 16);
        stream.write(src >> 24);
    }

    public void saveToOutputStream(OutputStream stream) throws IOException, EmptyAdapterException {
        this.saveToDataStream(new DataOutputStream(stream));
    }

    public void saveToDataStream(DataOutputStream stream) throws IOException, EmptyAdapterException {
        short[] samples = this.samples;
        if (this.samples == null) {
            throw new EmptyAdapterException("\u041a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 Wave-\u0444\u0430\u0439\u043b\u043e\u0432: \u0430\u0434\u0430\u043f\u0442\u0435\u0440 \u043f\u0443\u0441\u0442.");
        }
        int len = samples.length;
        byte[] data = new byte[len << 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int n = i++;
            short sample = samples[j];
            data[n] = (byte)sample;
            data[i++] = (byte)(sample >> 8);
            ++j;
        }
        int channels = this.channels;
        int samplesPerSecond = this.samplesPerSecond;
        stream.writeInt(1380533830);
        WaveEncoder.writeIntLE(stream, (len <<= 1) + 36);
        stream.writeLong(6287401410857104416L);
        WaveEncoder.writeIntLE(stream, 16);
        WaveEncoder.writeShortLE(stream, 1);
        WaveEncoder.writeShortLE(stream, channels);
        WaveEncoder.writeIntLE(stream, samplesPerSecond);
        WaveEncoder.writeIntLE(stream, samplesPerSecond * channels << 1);
        WaveEncoder.writeShortLE(stream, channels << 1);
        WaveEncoder.writeShortLE(stream, 16);
        stream.writeInt(1684108385);
        WaveEncoder.writeIntLE(stream, len);
        stream.write(data);
    }

    public void clear() {
        this.channels = 0;
        this.samplesPerSecond = 0;
        this.samples = null;
    }

    public boolean isEmpty() {
        return this.samples == null;
    }

    public void setSamples(int channels, int samplesPerSecond, short[] samples) throws InvalidDataFormatException {
        if (channels != 1 && channels != 2) {
            throw new InvalidDataFormatException("\u041a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 Wave-\u0444\u0430\u0439\u043b\u043e\u0432: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043a\u0430\u043d\u0430\u043b\u043e\u0432 " + channels + ".");
        }
        if (samplesPerSecond <= 0 || samplesPerSecond > 65535) {
            throw new InvalidDataFormatException("\u041a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 Wave-\u0444\u0430\u0439\u043b\u043e\u0432: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0430\u044f \u0447\u0430\u0441\u0442\u043e\u0442\u0430 \u0434\u0438\u0441\u043a\u0440\u0435\u0442\u0438\u0437\u0430\u0446\u0438\u0438 " + samplesPerSecond + ".");
        }
        if (samples == null) {
            throw new InvalidDataFormatException("\u041a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 Wave-\u0444\u0430\u0439\u043b\u043e\u0432: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 samples \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (samples.length % channels != 0) {
            throw new InvalidDataFormatException("\u041a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 Wave-\u0444\u0430\u0439\u043b\u043e\u0432: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 samples \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0443\u044e \u0434\u043b\u0438\u043d\u0443.");
        }
        this.channels = channels;
        this.samplesPerSecond = samplesPerSecond;
        this.samples = samples;
    }
}

