/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.lang.ref.WeakReference;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandEnumeration;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Container;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.GraphicsClipRestricted;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.MIDletProxy;
import javax.microedition.lcdui.ScrollBar;
import javax.microedition.lcdui.TextOutput;
import javax.microedition.lcdui.TextOutputMultilined;
import javax.microedition.lcdui.TextOutputMultilinedExt;
import javax.microedition.lcdui.Ticker;
import malik.emulator.media.graphics.RasterCanvas;

public class Alert
extends Container {
    public static final int FOREVER = -2;
    public static final Command DISMISS_COMMAND = new Command("\u0417\u0430\u043a\u0440\u044b\u0442\u044c", 4, Integer.MIN_VALUE);
    private static final Font FONT = Font.getFont(0, 1, 8);
    private boolean stayComputeScrollBars;
    private boolean hasCommandListener;
    private String text;
    private Image icon;
    private AlertType type;
    private Gauge indicator;
    private Runnable computeScrollBarsEvent;
    private TextOutputMultilined lines;

    public Alert(String title) {
        this(false, title, null, null, null, null, null, null, null, null);
    }

    public Alert(String title, String text, Image icon, AlertType type) {
        this(false, title, null, null, null, null, text, icon, type, null);
    }

    public Alert(String title, Ticker ticker, Command[] commands, Command dismissCommand, CommandListener listener, String text, Image icon, AlertType type, Gauge indicator) {
        this(true, title, ticker, commands, dismissCommand, listener, text, icon, type, indicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Alert(boolean system, String title, Ticker ticker, Command[] commands, Command dismissCommand, CommandListener listener, String text, Image icon, AlertType type, Gauge indicator) {
        super(system, title, ticker, commands, dismissCommand == null && (commands == null || commands.length <= 0) ? DISMISS_COMMAND : dismissCommand, listener, 2);
        if (indicator != null) {
            int error = 0;
            Object object = Container.getOwningLock();
            synchronized (object) {
                if (indicator.getOwner() != null) {
                    error = 1;
                } else if (!indicator.isMatchForAlert()) {
                    error = 2;
                } else {
                    indicator.setOwner(this);
                }
            }
            switch (error) {
                case 1: {
                    throw new IllegalStateException("Alert: \u0438\u043d\u0434\u0438\u043a\u0430\u0442\u043e\u0440 \u0443\u0436\u0435 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442 \u043a\u043e\u043d\u0442\u0435\u0439\u043d\u0435\u0440\u0443.");
                }
                case 2: {
                    throw new IllegalArgumentException("Alert: \u0438\u043d\u0434\u0438\u043a\u0430\u0442\u043e\u0440 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u044f\u043c \u0434\u043b\u044f \u0440\u0430\u0437\u043c\u0435\u0449\u0435\u043d\u0438\u044f \u0435\u0433\u043e \u043d\u0430 \u0434\u0438\u0430\u043b\u043e\u0433\u043e\u0432\u043e\u043c \u044d\u043a\u0440\u0430\u043d\u0435.");
                }
            }
        }
        this.hasCommandListener = listener != null;
        this.icon = icon != null ? Image.createImage(icon) : null;
        this.text = text;
        this.type = type;
        this.indicator = indicator;
        this.computeScrollBarsEvent = new ComputeScrollBarsEvent(this);
        TextOutputMultilinedExt lines = new TextOutputMultilinedExt(0);
        this.lines = lines;
        ((TextOutput)lines).setText(text);
    }

    public void addCommand(Command command) {
        if (command == DISMISS_COMMAND) {
            return;
        }
        super.removeCommand(DISMISS_COMMAND);
        super.addCommand(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommand(Command command) {
        boolean needAddDismissCommand;
        if (command == DISMISS_COMMAND) {
            return;
        }
        super.removeCommand(command);
        CommandEnumeration enumeration = this.getCommands();
        Object object = enumeration.getMonitor();
        synchronized (object) {
            needAddDismissCommand = enumeration.getCommandsCount() == 0 && enumeration.getDefaultCommand() == null;
        }
        if (needAddDismissCommand) {
            super.addCommand(DISMISS_COMMAND);
        }
    }

    public void setCommandListener(CommandListener listener) {
        this.hasCommandListener = listener != null;
        super.setCommandListener(listener);
    }

    public void setTimeout(int timeout) {
        if (timeout <= 0 && timeout != -2) {
            throw new IllegalArgumentException("Alert.setTimeout: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 timeout.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(AlertType type) {
        TextOutputMultilined textOutputMultilined = this.lines;
        synchronized (textOutputMultilined) {
            this.type = type;
            this.callSeriallyComputeScrollBars();
            this.callSeriallyPaintScreen(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(Image icon) {
        TextOutputMultilined textOutputMultilined = this.lines;
        synchronized (textOutputMultilined) {
            this.icon = icon != null ? Image.createImage(icon) : null;
            this.callSeriallyComputeScrollBars();
            this.callSeriallyPaintScreen(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void setIndicator(Gauge indicator) {
        error = 0;
        var4_3 = this.lines;
        synchronized (var4_3) {
            oldIndicator = this.indicator;
            var5_5 = Container.getOwningLock();
            synchronized (var5_5) {
                if (indicator == null) ** GOTO lbl17
                if (indicator.getOwner() != null) {
                    error = 1;
                } else if (!indicator.isMatchForAlert()) {
                    error = 2;
                } else {
                    indicator.setOwner(this);
lbl17:
                    // 2 sources

                    if (oldIndicator != null) {
                        oldIndicator.setOwner(null);
                    }
                }
            }
            if (error == 0) {
                this.indicator = indicator;
                this.callSeriallyComputeScrollBars();
                this.callSerially(new ChangeIndicatorEvent(this, oldIndicator, indicator));
                this.callSeriallyPaintScreen(4);
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalStateException("Alert.setIndicator: \u0438\u043d\u0434\u0438\u043a\u0430\u0442\u043e\u0440 \u0443\u0436\u0435 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442 \u043a\u043e\u043d\u0442\u0435\u0439\u043d\u0435\u0440\u0443.");
            }
            case 2: {
                throw new IllegalArgumentException("Alert.setIndicator: \u0438\u043d\u0434\u0438\u043a\u0430\u0442\u043e\u0440 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u044f\u043c \u0434\u043b\u044f \u0440\u0430\u0437\u043c\u0435\u0449\u0435\u043d\u0438\u044f \u0435\u0433\u043e \u043d\u0430 \u0434\u0438\u0430\u043b\u043e\u0433\u043e\u0432\u043e\u043c \u044d\u043a\u0440\u0430\u043d\u0435.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(String text) {
        TextOutputMultilined lines;
        TextOutputMultilined textOutputMultilined = lines = this.lines;
        synchronized (lines) {
            lines.setText(text);
            this.text = text;
            this.callSeriallyComputeScrollBars();
            this.callSeriallyPaintScreen(4);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public int getDefaultTimeout() {
        return -2;
    }

    public int getTimeout() {
        return -2;
    }

    public AlertType getType() {
        return this.type;
    }

    public Image getImage() {
        return this.icon;
    }

    public Gauge getIndicator() {
        return this.indicator;
    }

    public String getString() {
        return this.text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paint(GraphicsClipRestricted render, ScrollBar horzScrollBar, ScrollBar vertScrollBar) {
        TextOutputMultilined lines;
        render.setFont(FONT);
        render.setColor(RasterCanvas.getSystemColor((int)40));
        TextOutputMultilined textOutputMultilined = lines = this.lines;
        synchronized (lines) {
            Image icon;
            int l = 0;
            int s = FONT.getHeight();
            int h = this.getClientHeight();
            int ih = 0;
            int tx = horzScrollBar.getPosition();
            int ty = vertScrollBar.getPosition();
            int ct = render.getClipY();
            int cb = ct + render.getClipHeight();
            Gauge indicator = this.indicator;
            if (indicator != null) {
                ih = indicator.getHeight();
                h -= ih;
                cb -= ih;
            }
            if ((icon = this.getOutputIcon()) != null) {
                render.drawStretchRegion(icon, 0, 0, icon.getWidth(), icon.getHeight(), 0, tx, (ct + cb) / 2, 48, 48, 6);
                l = 50;
            }
            l += tx;
            int len = lines.getLinesCount();
            char[] chars = lines.getChars();
            int t = (Math.max(h, vertScrollBar.getRange() - ih) - s * len) / 2;
            int i = 0;
            while (i < len) {
                if (t < cb && t + s > ct) {
                    render.drawChars(chars, lines.getLineStart(i), lines.getLineLength(i), l, t, 0);
                }
                t += s;
                ++i;
            }
            if (indicator != null) {
                render.translate(tx, ty + h);
                render.restrictClipRect(0, 0, indicator.getWidth(), ih);
                indicator.onPaint(render);
            }
            // ** MonitorExit[var19_5] (shouldn't be in output)
            return;
        }
    }

    void onShow() {
        Gauge indicator;
        super.onShow();
        AlertType type = this.type;
        if (type != null && type.isSystem()) {
            type.playSound(MIDletProxy.getInstance().getEmulatorScreen());
        }
        if ((indicator = this.indicator) != null) {
            indicator.setVisible(true);
            try {
                ((Item)indicator).onShow();
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
        }
    }

    void onHide() {
        Gauge indicator = this.indicator;
        if (indicator != null) {
            indicator.setVisible(false);
            try {
                ((Item)indicator).onHide();
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
        }
        super.onHide();
    }

    void onSizeChanged(int width, int height) {
        this.computeScrollBars(width);
        super.onSizeChanged(width, height);
    }

    void onKeyPressed(int key, int charCode) {
        MIDletProxy proxy = MIDletProxy.getInstance();
        if (key == proxy.getKeyUsedAs(38)) {
            this.scroll(0, -this.getVertScrollBar().getPage() / 4);
            return;
        }
        if (key == proxy.getKeyUsedAs(36)) {
            this.scroll(0, this.getVertScrollBar().getPage() / 4);
            return;
        }
        super.onKeyPressed(key, charCode);
    }

    void onCommandAction(Command command) {
        if (!this.hasCommandListener && command == DISMISS_COMMAND) {
            Display display = MIDletProxy.getInstance().getEmulatorScreen();
            display.setCurrent(display.getScreenAfterAlert());
            return;
        }
        super.onCommandAction(command);
    }

    void notifyPlaceItems() {
    }

    final void setCurrent(Item item, Display display) {
        throw new IllegalStateException("Display.setCurrentItem: \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0444\u043e\u043a\u0443\u0441\u0430 \u0432\u0432\u043e\u0434\u0430 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430 - \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u043d\u0430 \u0434\u0438\u0430\u043b\u043e\u0433\u043e\u0432\u043e\u043c \u044d\u043a\u0440\u0430\u043d\u0435.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeScrollBars(int containerClientWidth) {
        TextOutputMultilined lines;
        TextOutputMultilined textOutputMultilined = lines = this.lines;
        synchronized (lines) {
            this.stayComputeScrollBars = false;
            int iconWidth = this.getOutputIcon() != null ? 50 : 0;
            int indHeight = 0;
            Gauge indicator = this.indicator;
            if (indicator != null) {
                indicator.computeSizes(containerClientWidth);
                indHeight = indicator.getHeight();
            }
            lines.split(FONT, containerClientWidth - iconWidth);
            this.getVertScrollBar().setRange(FONT.getHeight() * lines.getLinesCount() + indHeight);
            // ** MonitorExit[var6_3] (shouldn't be in output)
            return;
        }
    }

    private void callSeriallyComputeScrollBars() {
        if (this.stayComputeScrollBars) {
            return;
        }
        this.stayComputeScrollBars = true;
        this.callSerially(this.computeScrollBarsEvent);
    }

    private Image getOutputIcon() {
        AlertType type;
        Image icon = this.icon;
        return icon != null ? icon : ((type = this.type) != null ? type.getIcon() : null);
    }

    private static final class ChangeIndicatorEvent
    implements Runnable {
        private Displayable screen;
        private Item oldIndicator;
        private Item newIndicator;

        ChangeIndicatorEvent(Displayable screen, Item oldIndicator, Item newIndicator) {
            this.screen = screen;
            this.oldIndicator = oldIndicator;
            this.newIndicator = newIndicator;
        }

        public void run() {
            if (!this.screen.isReallyShown()) {
                return;
            }
            Item indicator = this.oldIndicator;
            if (indicator != null) {
                indicator.setVisible(false);
                try {
                    indicator.onHide();
                }
                catch (RuntimeException e) {
                    e.printRealStackTrace();
                }
            }
            if ((indicator = this.newIndicator) != null) {
                indicator.setVisible(true);
                try {
                    indicator.onShow();
                }
                catch (RuntimeException e) {
                    e.printRealStackTrace();
                }
            }
        }
    }

    private static final class ComputeScrollBarsEvent
    extends WeakReference
    implements Runnable {
        ComputeScrollBarsEvent(Alert thisScreen) {
            super(thisScreen);
        }

        public void run() {
            Alert thisScreen = (Alert)this.get();
            if (thisScreen == null) {
                return;
            }
            thisScreen.computeScrollBars(thisScreen.getClientWidth());
        }
    }
}

