/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.TimeZone;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.MIDletProxy;
import malik.emulator.media.graphics.RasterCanvas;
import malik.emulator.time.GregorianCalendar;
import malik.emulator.time.ListOfTimeZones;

public class DateField
extends Item {
    public static final int DATE = 1;
    public static final int TIME = 2;
    public static final int DATE_TIME = 3;
    private static final int MONTH = 0;
    private static final int YEAR = 1;
    private static final int DAY = 2;
    private static final int HOUR = 3;
    private static final int MINUTE = 4;
    private static final int OFFSET = 5;
    private static final int ZERO_OFFSET_INDEX;
    private static final int MAX_DIGIT_WIDTH;
    private static final int[] OFFSETS;
    private static final String[] NAMES;
    private static final Command BACK;
    private static final Command SELECT;
    private static final Font FONT;
    private boolean controlFocused;
    private boolean componentFocused;
    private boolean needPlaceComponents;
    private int contentWidth;
    private int contentHeight;
    private int focused;
    private int pressed;
    private int mode;
    private int offset;
    private long fields;
    private Component[] components;
    private List timeZonesList;
    private Displayable sourceScreen;

    static {
        String[] names = new String[]{"UTC-12:00", "UTC-11:00", "UTC-10:00", "UTC-09:30", "UTC-09:00", "UTC-08:30*", "UTC-08:00", "UTC-07:00", "UTC-06:00", "UTC-05:00", "UTC-04:30", "UTC-04:00", "UTC-03:30", "UTC-03:00", "UTC-02:30", "UTC-02:00", "UTC-01:00", "UTC-00:44*", "UTC-00:25*", "UTC+00:00", "UTC+00:20*", "UTC+00:30*", "UTC+01:00", "UTC+02:00", "UTC+03:00", "UTC+03:30", "UTC+04:00", "UTC+04:30", "UTC+04:51*", "UTC+05:00", "UTC+05:30", "UTC+05:40*", "UTC+05:45", "UTC+06:00", "UTC+06:30", "UTC+07:00", "UTC+07:20*", "UTC+07:30*", "UTC+08:00", "UTC+08:30", "UTC+08:45", "UTC+09:00", "UTC+09:30", "UTC+10:00", "UTC+10:30", "UTC+11:00", "UTC+11:30*", "UTC+12:00", "UTC+12:45", "UTC+13:00", "UTC+13:45", "UTC+14:00"};
        int zeroOffsetIndex = -1;
        int len = names.length;
        int[] offsets = new int[len];
        int i = len;
        while (i-- > 0) {
            String s = names[i];
            if (s.length() < 9) continue;
            int ofs = (s.charAt(4) - 48) * 36000000 + (s.charAt(5) - 48) * 3600000 + (s.charAt(7) - 48) * 600000 + (s.charAt(8) - 48) * 60000;
            int n = offsets[i] = s.charAt(3) == '-' ? -ofs : ofs;
            if (ofs != 0 || zeroOffsetIndex >= 0) continue;
            zeroOffsetIndex = i;
        }
        if (zeroOffsetIndex < 0) {
            zeroOffsetIndex = 0;
        }
        Font f = Font.getFont(0, 0, 8);
        int w = f.charWidth('0');
        char j = '1';
        while (j <= '9') {
            int tmp = f.charWidth(j);
            if (w < tmp) {
                w = tmp;
            }
            j = (char)(j + '\u0001');
        }
        ZERO_OFFSET_INDEX = zeroOffsetIndex;
        MAX_DIGIT_WIDTH = w;
        OFFSETS = offsets;
        NAMES = names;
        BACK = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 0);
        SELECT = new Command("\u0412\u044b\u0431\u0440\u0430\u0442\u044c", 4, 0);
        FONT = f;
    }

    private static int indexOfOffset(int offset) {
        int i = OFFSETS.length;
        while (i-- > 0) {
            if (OFFSETS[i] != offset) continue;
            return i;
        }
        return ZERO_OFFSET_INDEX;
    }

    public DateField(String label, int mode) {
        this(512, label, null, null, null, mode, null, null);
    }

    public DateField(String label, int mode, TimeZone zone) {
        this(512, label, null, null, null, mode, null, zone);
    }

    public DateField(int layout, String label, Command[] commands, Command defaultCommand, ItemCommandListener listener, int mode, Date time, TimeZone zone) {
        super(layout, -1, -1, label, commands, defaultCommand, listener);
        int ofs;
        if (mode < 1 || mode > 3) {
            throw new IllegalArgumentException("DateField: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 mode.");
        }
        Command[] timeZonesCommands = new Command[]{BACK};
        this.needPlaceComponents = true;
        this.focused = -1;
        this.pressed = -1;
        this.mode = mode;
        this.offset = ofs = DateField.indexOfOffset(((TimeZone)(zone == null ? ListOfTimeZones.getDefault() : zone)).getRawOffset());
        this.fields = GregorianCalendar.computeFields((long)(time == null ? System.currentTimeMillis() : time.getTime()), (int)OFFSETS[ofs]);
        this.components = new Component[]{new Month(this), new DigitalIntegral(this, true, 65535, 48), new Day(this), new DigitalIntegralWithLeadingZeros(this, false, 23, 24), new DigitalIntegralWithLeadingZeros(this, false, 59, 16), new Offset(this)};
        this.timeZonesList = new List(false, "\u0427\u0430\u0441\u043e\u0432\u043e\u0439 \u043f\u043e\u044f\u0441 (* \u2013 \u0438\u0441\u0442\u043e\u0440\u0438\u0447\u0435\u0441\u043a\u0438\u0439):", null, timeZonesCommands, List.SELECT_COMMAND, new TimeZonesListCommandHandler(this), 3, NAMES, null);
    }

    public void setInputMode(int mode) {
        if (mode < 1 || mode > 3) {
            throw new IllegalArgumentException("DateField.setInputMode: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 mode.");
        }
        this.needPlaceComponents = true;
        this.mode = mode;
        this.notifyUpdate();
    }

    public void setDate(Date time) {
        this.fields = GregorianCalendar.computeFields((long)(time == null ? System.currentTimeMillis() : time.getTime()), (int)OFFSETS[this.offset]);
        this.notifyPaint();
    }

    public int getInputMode() {
        return this.mode;
    }

    public Date getDate() {
        long f;
        int tz;
        switch (this.mode) {
            case 1: {
                tz = 0;
                f = this.fields & 0xFFFFFFFF00000000L;
                break;
            }
            case 2: {
                tz = 0;
                f = 0x7B2010100000000L | this.fields & 0xFFFF0000L;
                break;
            }
            case 3: {
                tz = OFFSETS[this.offset];
                f = this.fields & 0xFFFFFFFFFFFF0000L;
                break;
            }
            default: {
                tz = 0;
                f = 0L;
            }
        }
        return new Date(GregorianCalendar.computeTime((long)f, (int)tz));
    }

    void paintContent(Graphics render, int contentWidth, int contentHeight) {
        boolean cfocused = this.controlFocused;
        int f = this.focused;
        int p = this.pressed;
        int tx = render.getTranslateX();
        int ty = render.getTranslateY();
        long fields = this.fields;
        String offset = NAMES[this.offset];
        Component[] list = this.components;
        int i = this.components.length;
        while (i-- > 0) {
            Component comp = list[i];
            if (!comp.visible) continue;
            render.translate(tx + comp.left - render.getTranslateX(), ty + comp.top - render.getTranslateY());
            render.setFont(FONT);
            int w = comp.width;
            int h = comp.height;
            if (i == 3) {
                render.setColor(RasterCanvas.getSystemColor((int)39));
                render.setClip(0, 0, w + FONT.charWidth(':') + 2, h);
                render.drawChar(':', w + 1, 2, 20);
            }
            render.setClip(0, 0, w, h);
            comp.paint(render, w, h, cfocused && i == f, cfocused && i == p, fields, offset);
        }
    }

    void onKeyPressed(int key, int charCode) {
        int f = this.focused;
        if (f >= 0) {
            Component[] list = this.components;
            if (f < this.components.length) {
                list[f].keyPressed(MIDletProxy.getInstance().getKeyCode(key));
            }
        }
    }

    void onContentPointerPressed(int x, int y, int button) {
        int next;
        if (button == 0 && (next = this.getComponentIndexUnderPointer(x, y)) >= 0) {
            int f = this.focused;
            this.componentFocused = true;
            this.focus(next, true);
            Component comp = this.components[next];
            comp.traverse(0, f == next);
            comp.pointerPressed(x - comp.left, y - comp.top);
            this.notifyPaint();
        }
    }

    void onContentPointerDragged(int x, int y) {
        if (this.componentFocused) {
            int f = this.focused;
            Component comp = this.components[f];
            comp.pointerDragged(x - comp.left, y - comp.top);
            this.pressed = f == this.getComponentIndexUnderPointer(x, y) ? f : -1;
            if (this.pressed != this.pressed) {
                this.notifyPaint();
            }
        }
    }

    void onContentPointerReleased(int x, int y, int button) {
        if (button == 0 && this.componentFocused) {
            this.pressed = -1;
            this.componentFocused = false;
            Component comp = this.components[this.focused];
            comp.pointerReleased(x - comp.left, y - comp.top);
            this.notifyPaint();
        }
    }

    void onCommandAction(Command command) {
        if (command == SELECT) {
            this.components[this.focused].select();
            return;
        }
        super.onCommandAction(command);
    }

    void onTraverseOut() {
        this.controlFocused = false;
        this.notifyPaint();
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean onTraverseNeedStayOn(int direction, int viewportWidth, int viewportHeight, int[] visibleRectangle) {
        int cmo;
        int f;
        Component[] list;
        block25: {
            int i;
            boolean cfocused = this.controlFocused;
            this.controlFocused = true;
            if (!cfocused) {
                this.notifyPaint();
            }
            if (this.componentFocused) {
                return true;
            }
            list = this.components;
            int len = this.components.length;
            switch (direction) {
                case 1: 
                case 2: {
                    if (cfocused) break;
                    i = len;
                    while (i-- > 0) {
                        if (!list[i].visible) continue;
                        f = i;
                        this.focus(f, false);
                        break block25;
                    }
                    break;
                }
                case 5: 
                case 6: {
                    if (cfocused) break;
                    i = 0;
                    while (i < len) {
                        if (list[i].visible) {
                            f = i;
                            this.focus(f, false);
                            break block25;
                        }
                        ++i;
                    }
                    break block0;
                }
            }
            if (!cfocused) return false;
            i = this.focused;
            if (i < 0) return false;
            if (i >= len) return false;
            if (list[i].traverse(direction, true)) {
                return true;
            }
            switch (direction) {
                case 1: 
                case 2: {
                    do {
                        if (i-- > 0) continue;
                        return false;
                    } while (!list[i].visible);
                    f = i;
                    this.focus(f, false);
                    break block25;
                }
                case 5: 
                case 6: {
                    ++i;
                    while (i < len) {
                        if (list[i].visible) {
                            f = i;
                            this.focus(f, false);
                            break block25;
                        }
                        ++i;
                    }
                    return false;
                }
            }
            return false;
        }
        Component comp = list[f];
        comp.traverse(direction, false);
        int labelHeight = super.getPreferredHeight() - this.contentHeight;
        int vrs = visibleRectangle[2];
        int cms = comp.width;
        if (vrs < cms) {
            visibleRectangle[2] = vrs = cms;
        }
        int vro = visibleRectangle[0];
        int tmp = cmo = comp.left;
        if (vro > cmo) {
            visibleRectangle[0] = tmp;
        } else {
            tmp = cmo + cms - vrs;
            if (vro < tmp) {
                visibleRectangle[0] = tmp;
            }
        }
        vrs = visibleRectangle[3];
        cms = comp.height;
        if (vrs < cms) {
            visibleRectangle[3] = vrs = cms;
        }
        if ((vro = visibleRectangle[1]) > (tmp = labelHeight + (cmo = comp.top))) {
            visibleRectangle[1] = tmp;
        } else {
            tmp = labelHeight + cmo + cms - vrs;
            if (vro < tmp) {
                visibleRectangle[1] = tmp;
            }
        }
        this.notifyPaint();
        return true;
    }

    boolean keyHandling(int key) {
        int keyCode = MIDletProxy.getInstance().getKeyCode(key);
        return keyCode >= 48 && keyCode <= 57;
    }

    int getPreferredContentWidth(int contentHeight, int containerClientWidth) {
        if (this.needPlaceComponents) {
            this.needPlaceComponents = false;
            this.placeComponents();
        }
        return this.contentWidth;
    }

    int getPreferredContentHeight(int contentWidth) {
        if (this.needPlaceComponents) {
            this.needPlaceComponents = false;
            this.placeComponents();
        }
        return this.contentHeight;
    }

    private void showTimeZonesList() {
        List screen = this.timeZonesList;
        this.sourceScreen = this.getOwner();
        if (this.sourceScreen != null) {
            screen.setSelectedIndex(this.offset, true);
            MIDletProxy.getInstance().getEmulatorScreen().setCurrent(screen);
        }
    }

    private void showSourceScreen() {
        Display display = MIDletProxy.getInstance().getEmulatorScreen();
        Displayable next = this.sourceScreen;
        if (next.isSystem()) {
            display.setCurrent(next);
        } else {
            display.hideSystemScreen();
        }
        this.sourceScreen = null;
    }

    private void invokeNotifyStateChanged() {
        super.notifyStateChanged();
    }

    private void placeComponents() {
        int maxWidth = 0;
        int maxHeight = 0;
        Component[] list = this.components;
        int len = this.components.length;
        switch (this.mode) {
            case 1: {
                Component comp;
                Component prev = null;
                int i = 0;
                while (i < len) {
                    int t;
                    int l;
                    boolean vis;
                    comp = list[i];
                    switch (i) {
                        case 0: {
                            vis = true;
                            comp.visible = true;
                            l = 0;
                            comp.left = 0;
                            t = 0;
                            comp.top = 0;
                            break;
                        }
                        case 1: {
                            vis = true;
                            comp.visible = true;
                            comp.left = l = prev.left + prev.width;
                            comp.top = t = prev.top;
                            break;
                        }
                        case 2: {
                            vis = true;
                            comp.visible = true;
                            l = 0;
                            comp.left = 0;
                            comp.top = t = prev.top + prev.height;
                            break;
                        }
                        default: {
                            vis = false;
                            comp.visible = false;
                            l = 0;
                            t = 0;
                        }
                    }
                    if (vis) {
                        comp.width = comp.getWidth();
                        int r = l + comp.width;
                        comp.height = comp.getHeight();
                        int b = t + comp.height;
                        if (maxWidth < r) {
                            maxWidth = r;
                        }
                        if (maxHeight < b) {
                            maxHeight = b;
                        }
                    }
                    prev = comp;
                    ++i;
                }
                comp = list[1];
                list[1].left = maxWidth - comp.width;
                break;
            }
            case 2: {
                Component prev = null;
                int i = 0;
                while (i < len) {
                    int t;
                    int l;
                    boolean vis;
                    Component comp = list[i];
                    switch (i) {
                        case 3: {
                            vis = true;
                            comp.visible = true;
                            l = 0;
                            comp.left = 0;
                            t = 0;
                            comp.top = 0;
                            break;
                        }
                        case 4: {
                            vis = true;
                            comp.visible = true;
                            comp.left = l = prev.left + prev.width + FONT.charWidth(':') + 2;
                            comp.top = t = prev.top;
                            break;
                        }
                        default: {
                            vis = false;
                            comp.visible = false;
                            l = 0;
                            t = 0;
                        }
                    }
                    if (vis) {
                        comp.width = comp.getWidth();
                        int r = l + comp.width;
                        comp.height = comp.getHeight();
                        int b = t + comp.height;
                        if (maxWidth < r) {
                            maxWidth = r;
                        }
                        if (maxHeight < b) {
                            maxHeight = b;
                        }
                    }
                    prev = comp;
                    ++i;
                }
                break;
            }
            case 3: {
                Component comp;
                Component prev = null;
                int i = 0;
                while (i < len) {
                    int t;
                    int l;
                    comp = list[i];
                    list[i].visible = true;
                    switch (i) {
                        case 0: {
                            l = 0;
                            comp.left = 0;
                            t = 0;
                            comp.top = 0;
                            break;
                        }
                        case 2: 
                        case 3: {
                            l = 0;
                            comp.left = 0;
                            comp.top = t = prev.top + prev.height;
                            break;
                        }
                        case 4: {
                            comp.left = l = prev.left + prev.width + FONT.charWidth(':') + 2;
                            comp.top = t = prev.top;
                            break;
                        }
                        default: {
                            comp.left = l = prev.left + prev.width;
                            comp.top = t = prev.top;
                        }
                    }
                    comp.width = comp.getWidth();
                    int r = l + comp.width;
                    comp.height = comp.getHeight();
                    int b = t + comp.height;
                    if (maxWidth < r) {
                        maxWidth = r;
                    }
                    if (maxHeight < b) {
                        maxHeight = b;
                    }
                    prev = comp;
                    ++i;
                }
                comp = list[1];
                list[1].left = maxWidth - comp.width;
                comp = list[5];
                list[5].left = maxWidth - comp.width;
            }
        }
        this.contentWidth = maxWidth;
        this.contentHeight = maxHeight;
    }

    private void focus(int componentIndex, boolean fromPointer) {
        Component[] list = this.components;
        int len = this.components.length;
        int f = this.focused;
        boolean oldHasSelectCommand = f >= 0 && f < len && list[f].hasSelectCommand();
        f = componentIndex;
        boolean newHasSelectCommand = f >= 0 && f < len && list[f].hasSelectCommand();
        this.focused = componentIndex;
        if (fromPointer) {
            this.pressed = componentIndex;
        }
        if (oldHasSelectCommand && !newHasSelectCommand) {
            super.removeCommand(SELECT);
        }
        if (newHasSelectCommand && !oldHasSelectCommand) {
            super.setDefaultCommand(SELECT);
        }
    }

    private int getComponentIndexUnderPointer(int x, int y) {
        Component[] list = this.components;
        int i = this.components.length;
        while (i-- > 0) {
            int tmp;
            Component comp = list[i];
            if (!comp.visible || x < (tmp = comp.left) || x >= tmp + comp.width || y < (tmp = comp.top) || y >= tmp + comp.height) continue;
            return i;
        }
        return -1;
    }

    private static abstract class Component
    extends WeakReference {
        protected static final long DAY_MASK = 0xFF00000000L;
        public boolean visible;
        public int left;
        public int top;
        public int width;
        public int height;

        protected Component(DateField thisItem) {
            super(thisItem);
        }

        public abstract void paint(Graphics var1, int var2, int var3, boolean var4, boolean var5, long var6, String var8);

        public abstract int getWidth();

        public abstract int getHeight();

        public void keyPressed(int keyCode) {
        }

        public void pointerPressed(int x, int y) {
        }

        public void pointerDragged(int x, int y) {
        }

        public void pointerReleased(int x, int y) {
        }

        public void select() {
        }

        public boolean hasSelectCommand() {
            return false;
        }

        public boolean traverse(int direction, boolean focused) {
            return false;
        }

        protected final void repaint() {
            Item thisItem = (Item)this.get();
            if (thisItem == null) {
                return;
            }
            thisItem.notifyPaint();
        }

        protected final void setFields(long fields) {
            DateField thisItem = (DateField)this.get();
            if (thisItem == null) {
                return;
            }
            int tmp = GregorianCalendar.getNumOfDays((int)((int)(fields >>> 48)), (int)((int)(fields >> 40) & 0xFF));
            if (((int)(fields >> 32) & 0xFF) > tmp) {
                fields = fields & 0xFFFFFF00FFFFFFFFL | (long)tmp << 32 & 0xFF00000000L;
            }
            if (thisItem.fields == fields) {
                return;
            }
            thisItem.fields = fields;
            thisItem.notifyPaint();
            thisItem.invokeNotifyStateChanged();
        }

        protected final long getFields() {
            DateField thisItem = (DateField)this.get();
            return thisItem == null ? 0L : thisItem.fields;
        }
    }

    private static class Day
    extends Component {
        private static final String[] DAYS = new String[]{"\u043f\u043d", "\u0432\u0442", "\u0441\u0440", "\u0447\u0442", "\u043f\u0442", "\u0441\u0431", "\u0432\u0441"};
        private int numOfDays;
        private int focusedDay = 1;
        private int firstDayOfWeek;
        private char[] digits = new char[2];

        private static int toInnerFormat(int dayOfWeek) {
            return dayOfWeek == 0 ? 6 : dayOfWeek - 1;
        }

        public Day(DateField thisField) {
            super(thisField);
        }

        public void paint(Graphics render, int width, int height, boolean focused, boolean pressed, long fields, String offset) {
            int sd;
            int nd;
            int w = width / 7;
            int h = height / 7;
            int year = (int)(fields >>> 48);
            int month = (int)(fields >> 40) & 0xFF;
            int day = (int)(fields >> 32) & 0xFF;
            int fday = focused ? this.focusedDay : 0;
            char[] digs = this.digits;
            this.numOfDays = nd = GregorianCalendar.getNumOfDays((int)year, (int)month);
            this.firstDayOfWeek = sd = Day.toInnerFormat(GregorianCalendar.getDayOfWeek((int)year, (int)month, (int)1));
            int color = RasterCanvas.getSystemColor((int)40);
            render.setColor(color);
            int l = 0;
            int t = 0;
            int i = 0;
            while (i < 7) {
                render.drawString(DAYS[i], l + w / 2, t + 2, 17);
                l += w;
                ++i;
            }
            int outday = 1 - sd;
            t = h;
            int j = 0;
            while (j < 6) {
                l = 0;
                i = 0;
                while (i < 7) {
                    if (outday >= 1 && outday <= nd) {
                        int len;
                        int ofs;
                        render.setColor(outday == fday ? RasterCanvas.getSystemColor((int)39) : (outday != day ? color : RasterCanvas.getSystemColor((int)36)));
                        if (outday == fday) {
                            render.drawElementOfGUI(4, 3, 0, l, t, w, h);
                        } else if (outday == day) {
                            render.drawElementOfGUI(4, 0, 0, l, t, w, h);
                        }
                        digs[0] = (char)(outday / 10 + 48);
                        digs[1] = (char)(outday % 10 + 48);
                        if (outday < 10) {
                            ofs = 1;
                            len = 1;
                        } else {
                            ofs = 0;
                            len = 2;
                        }
                        render.drawChars(digs, ofs, len, l + w / 2, t + 2, 17);
                    }
                    l += w;
                    ++outday;
                    ++i;
                }
                t += h;
                ++j;
            }
        }

        public void pointerPressed(int x, int y) {
            int fday = this.getDayUnderPointer(x, y);
            if (fday > 0 && this.focusedDay != fday) {
                this.focusedDay = fday;
                this.repaint();
            }
        }

        public void pointerDragged(int x, int y) {
            int fday = this.getDayUnderPointer(x, y);
            if (fday > 0 && this.focusedDay != fday) {
                this.focusedDay = fday;
                this.repaint();
            }
        }

        public void pointerReleased(int x, int y) {
            int fday = this.getDayUnderPointer(x, y);
            if (fday > 0) {
                this.focusedDay = fday;
                this.setFields(this.getFields() & 0xFFFFFF00FFFFFFFFL | (long)fday << 32 & 0xFF00000000L);
            }
        }

        public void select() {
            this.setFields(this.getFields() & 0xFFFFFF00FFFFFFFFL | (long)this.focusedDay << 32 & 0xFF00000000L);
        }

        public boolean hasSelectCommand() {
            return true;
        }

        public boolean traverse(int direction, boolean focused) {
            switch (direction) {
                case 1: {
                    if (focused) {
                        int f;
                        this.focusedDay = f = this.focusedDay - 7;
                        this.repaint();
                        return f >= 1;
                    }
                    this.focusedDay = this.numOfDays;
                    break;
                }
                case 2: {
                    if (focused) {
                        int f;
                        this.focusedDay = f = this.focusedDay - 1;
                        this.repaint();
                        return f >= 1;
                    }
                    this.focusedDay = this.numOfDays;
                    break;
                }
                case 5: {
                    if (focused) {
                        int f;
                        this.focusedDay = f = this.focusedDay + 1;
                        this.repaint();
                        return f <= this.numOfDays;
                    }
                    this.focusedDay = 1;
                    break;
                }
                case 6: {
                    if (focused) {
                        int f;
                        this.focusedDay = f = this.focusedDay + 7;
                        this.repaint();
                        return f <= this.numOfDays;
                    }
                    this.focusedDay = 1;
                }
            }
            return true;
        }

        public int getWidth() {
            return (2 * MAX_DIGIT_WIDTH + 4) * 7;
        }

        public int getHeight() {
            return (FONT.getHeight() + 4) * 7;
        }

        private int getDayUnderPointer(int x, int y) {
            int col;
            int w = Math.max(1, this.width / 7);
            int h = Math.max(1, this.height / 7);
            int row = y / h;
            int result = 7 * row + (col = x / w) + (-6 - this.firstDayOfWeek);
            return result < 1 || result > this.numOfDays ? 0 : result;
        }
    }

    private static class DigitalIntegral
    extends Integral {
        private char[] digits = new char[this.getMaxDigits()];

        public DigitalIntegral(DateField thisItem, boolean oneBased, int maxValue, int shift) {
            super(thisItem, oneBased, maxValue, shift);
        }

        protected void paintValue(Graphics render, int width, int height, int value) {
            this.paintValue(render, width, height, value, this.digits);
        }

        protected int getValueMaxWidth() {
            return MAX_DIGIT_WIDTH * this.getMaxDigits();
        }

        protected void paintValue(Graphics render, int width, int height, int value, char[] digits) {
            int len;
            int i = len = digits.length;
            while (i-- > 0) {
                digits[i] = (char)(value % 10 + 48);
                if ((value /= 10) == 0) break;
            }
            render.drawChars(digits, i, len - i, width / 2, 0, 17);
        }
    }

    private static class DigitalIntegralWithLeadingZeros
    extends DigitalIntegral {
        public DigitalIntegralWithLeadingZeros(DateField thisItem, boolean oneBased, int maxValue, int shift) {
            super(thisItem, oneBased, maxValue, shift);
        }

        protected void paintValue(Graphics render, int width, int height, int value, char[] digits) {
            int len;
            int i = len = digits.length;
            while (i-- > 0) {
                digits[i] = (char)(value % 10 + 48);
                value /= 10;
            }
            render.drawChars(digits, 0, len, width / 2, 0, 17);
        }
    }

    private static abstract class Integral
    extends Component {
        private boolean newInput = true;
        private int maxDigits;
        private int minValue;
        private int maxValue;
        private int shift;
        private long mask;

        public Integral(DateField thisItem, boolean oneBased, int maxValue, int shift) {
            super(thisItem);
            this.maxDigits = (maxValue &= 0xFFFF) < 10 ? 1 : (maxValue < 100 ? 2 : (maxValue < 1000 ? 3 : (maxValue < 10000 ? 4 : 5)));
            this.minValue = oneBased ? 1 : 0;
            this.maxValue = maxValue;
            this.shift = shift;
            this.mask = maxValue < 256 ? 255L : 65535L;
        }

        public void paint(Graphics render, int width, int height, boolean focused, boolean pressed, long fields, String offset) {
            int t;
            Font font = render.getFont();
            int lprev = pressed ? 3 : 2;
            int lval = lprev + font.charWidth('<');
            int lnext = width - (4 - lprev) - font.charWidth('>');
            int n = t = pressed ? 3 : 2;
            int a = pressed ? 1 : (focused ? 3 : 0);
            render.setColor(RasterCanvas.getSystemColor((int)(a + 36)));
            render.drawElementOfGUI(4, a, 0, 0, 0, width, height);
            render.drawChar('<', lprev, t, 20);
            render.drawChar('>', lnext, t, 20);
            render.translate(lval, t);
            this.paintValue(render, lnext - lval, font.getHeight(), (int)(fields >> this.shift & this.mask));
        }

        public void keyPressed(int keyCode) {
            if (keyCode < 48 || keyCode > 57) {
                return;
            }
            if (this.newInput) {
                this.newInput = false;
                this.setValue(keyCode - 48);
                return;
            }
            int value = this.getValue();
            if ((value < 10 ? 1 : (value < 100 ? 2 : (value < 1000 ? 3 : (value < 10000 ? 4 : 5)))) >= this.maxDigits - 1) {
                this.newInput = true;
            }
            this.setValue(value * 10 + (keyCode - 48));
        }

        public void pointerReleased(int x, int y) {
            this.newInput = true;
            if (y < 0 || y >= this.height) {
                return;
            }
            int w = this.width;
            if (x < w / 2 && x >= 0) {
                int value = this.getValue();
                this.setValue(value <= this.minValue ? this.maxValue : value - 1);
                return;
            }
            if (x < w && x >= 0) {
                int value = this.getValue();
                this.setValue(value >= this.maxValue ? this.minValue : value + 1);
            }
        }

        public boolean traverse(int direction, boolean focused) {
            if (direction != 0) {
                this.newInput = true;
            }
            if (!focused) {
                return true;
            }
            if (direction == 2) {
                int value = this.getValue();
                this.setValue(value <= this.minValue ? this.maxValue : value - 1);
                return true;
            }
            if (direction == 5) {
                int value = this.getValue();
                this.setValue(value >= this.maxValue ? this.minValue : value + 1);
                return true;
            }
            return false;
        }

        public int getWidth() {
            Font font = FONT;
            return this.getValueMaxWidth() + font.charWidth('<') + font.charWidth('>') + 4;
        }

        public int getHeight() {
            return FONT.getHeight() + 4;
        }

        protected abstract void paintValue(Graphics var1, int var2, int var3, int var4);

        protected abstract int getValueMaxWidth();

        protected final void setValue(int value) {
            int shift = this.shift;
            long mask = this.mask << shift;
            int tmp = this.minValue;
            if (value < tmp) {
                value = tmp;
            }
            if (value > (tmp = this.maxValue)) {
                value = tmp;
            }
            this.setFields(this.getFields() & (mask ^ 0xFFFFFFFFFFFFFFFFL) | (long)value << shift & mask);
        }

        protected final int getValue() {
            return (int)(this.getFields() >> this.shift & this.mask);
        }

        protected final int getMaxDigits() {
            return this.maxDigits;
        }
    }

    private static class Month
    extends Integral {
        private static final String[] MONTHS = new String[]{"\u042f\u043d\u0432\u0430\u0440\u044c", "\u0424\u0435\u0432\u0440\u0430\u043b\u044c", "\u041c\u0430\u0440\u0442", "\u0410\u043f\u0440\u0435\u043b\u044c", "\u041c\u0430\u0439", "\u0418\u044e\u043d\u044c", "\u0418\u044e\u043b\u044c", "\u0410\u0432\u0433\u0443\u0441\u0442", "\u0421\u0435\u043d\u0442\u044f\u0431\u0440\u044c", "\u041e\u043a\u0442\u044f\u0431\u0440\u044c", "\u041d\u043e\u044f\u0431\u0440\u044c", "\u0414\u0435\u043a\u0430\u0431\u0440\u044c"};

        public Month(DateField thisItem) {
            super(thisItem, true, MONTHS.length, 40);
        }

        protected void paintValue(Graphics render, int width, int height, int value) {
            int len = MONTHS.length;
            render.drawString(MONTHS[--value < 0 ? 0 : (value >= len ? len - 1 : value)], width / 2, 0, 17);
        }

        protected int getValueMaxWidth() {
            int result = 0;
            Font font = FONT;
            int i = MONTHS.length;
            while (i-- > 0) {
                int tmp = font.stringWidth(MONTHS[i]);
                if (result >= tmp) continue;
                result = tmp;
            }
            return result;
        }
    }

    private static class Offset
    extends Component {
        public Offset(DateField thisField) {
            super(thisField);
        }

        public void paint(Graphics render, int width, int height, boolean focused, boolean pressed, long fields, String offset) {
            int t;
            int l = pressed ? 3 : 2;
            int n = t = pressed ? 3 : 2;
            int a = pressed ? 1 : (focused ? 3 : 0);
            render.setColor(RasterCanvas.getSystemColor((int)(a + 36)));
            render.drawElementOfGUI(4, a, 0, 0, 0, width, height);
            render.drawSubstring(offset, 0, 9, l, t, 20);
        }

        public void pointerReleased(int x, int y) {
            if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
                this.select();
            }
        }

        public void select() {
            DateField thisItem = (DateField)this.get();
            if (thisItem == null) {
                return;
            }
            thisItem.showTimeZonesList();
        }

        public boolean hasSelectCommand() {
            return true;
        }

        public int getWidth() {
            Font font = FONT;
            return font.stringWidth("UTC+") + 4 * MAX_DIGIT_WIDTH + font.charWidth(':') + 4;
        }

        public int getHeight() {
            return FONT.getHeight() + 4;
        }
    }

    private static final class TimeZonesListCommandHandler
    extends WeakReference
    implements CommandListener {
        TimeZonesListCommandHandler(DateField thisItem) {
            super(thisItem);
        }

        public void commandAction(Command command, Displayable screen) {
            List list;
            DateField thisItem = (DateField)this.get();
            if (thisItem == null || screen != (list = thisItem.timeZonesList)) {
                return;
            }
            if (command == List.SELECT_COMMAND) {
                int i = thisItem.offset;
                int n = list.getSelectedIndex();
                thisItem.offset = n;
                int f = n;
                thisItem.showSourceScreen();
                if (i != f) {
                    thisItem.invokeNotifyStateChanged();
                }
                return;
            }
            if (command == BACK) {
                thisItem.showSourceScreen();
            }
        }
    }
}

