/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.io.PrintStream;
import java.util.Queue;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Container;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.GraphicsClipRestricted;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.MIDletProxy;
import javax.microedition.lcdui.Rectangle;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletDispatcher;
import javax.microedition.rms.RecordStore;
import malik.emulator.application.ImmediatelyRunnable;
import malik.emulator.application.Run;
import malik.emulator.media.graphics.GraphicBuffer;
import malik.emulator.media.graphics.RasterCanvas;

public class Display {
    public static final int LIST_ELEMENT = 1;
    public static final int CHOICE_GROUP_ELEMENT = 2;
    public static final int ALERT = 3;
    public static final int COLOR_BACKGROUND = 0;
    public static final int COLOR_FOREGROUND = 1;
    public static final int COLOR_HIGHLIGHTED_BACKGROUND = 2;
    public static final int COLOR_HIGHLIGHTED_FOREGROUND = 3;
    public static final int COLOR_BORDER = 4;
    public static final int COLOR_HIGHLIGHTED_BORDER = 5;
    static final int EVENT_KEY_PRESSED = 1;
    static final int EVENT_KEY_REPEATED = 2;
    static final int EVENT_KEY_RELEASED = 3;
    static final int EVENT_POINTER_PRESSED = 5;
    static final int EVENT_POINTER_DRAGGED = 6;
    static final int EVENT_POINTER_RELEASED = 7;
    static final int EVENT_WINDOW_SHOW = 10;
    static final int EVENT_WINDOW_HIDE = 11;
    private static final int EVENT_EMPTY = 0;
    private static final int EVENT_CUSTOM = 13;
    private static final int EVENT_PAINT = 14;
    private static final int MIDLET_EVENT_QUEUE_INITIAL_SIZE = 33;
    private static boolean SERIALIZE_REPAINT;
    private static int MAXIMUM_FREQUENCY;
    private static int MINIMUM_PERIOD;
    private boolean applicationInBackground;
    private int width;
    private int height;
    private long lastRepaintTimestamp;
    private int[] guiElementsMetrics;
    private Font[] guiElementsFonts;
    private Graphics[] graphicsForModesOfSystemScreen;
    private Graphics[] graphicsForModesOfClientScreen;
    private Font defaultCommandFont;
    private Graphics graphicsForSystemScreen;
    private Graphics graphicsForClientScreen;
    private RasterCanvas screenCanvas;
    private Displayable shownSystemScreen;
    private Displayable shownClientScreen;
    private Displayable currentSystemScreen;
    private Displayable currentClientScreen;
    private Displayable currentClientAfterAlertScreen;
    private MIDletDispatcher dispatcher;
    private MIDletEventStream paintEvents;
    private MIDletEventStream clientEvents;

    static {
        Display.setSerializeRepaint(true);
        Display.setMaximumFrequency(25);
    }

    public static void setSerializeRepaint(boolean serializeRepaint) {
        SERIALIZE_REPAINT = serializeRepaint;
    }

    public static void setMaximumFrequency(int maximumFrequency) {
        maximumFrequency = maximumFrequency < 1 ? 1 : (maximumFrequency > 100 ? 100 : maximumFrequency);
        MAXIMUM_FREQUENCY = maximumFrequency;
        MINIMUM_PERIOD = 1000 / maximumFrequency + (1000 % maximumFrequency > 0 ? 1 : 0);
    }

    public static boolean isSerializeRepaint() {
        return SERIALIZE_REPAINT;
    }

    public static int getMaximumFrequency() {
        return MAXIMUM_FREQUENCY;
    }

    public static int getMinimumPeriod() {
        return MINIMUM_PERIOD;
    }

    public static Display getDisplay(MIDlet midlet) {
        if (midlet == null) {
            throw new NullPointerException("Display.getDisplay: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 midlet \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        return MIDletProxy.getInstance().getEmulatorScreen();
    }

    protected Display(RasterCanvas screenCanvas) {
        Graphics clientGraphics;
        Graphics systemGraphics;
        if (screenCanvas == null) {
            throw new NullPointerException("Display: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 screenCanvas \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (!screenCanvas.isOpaque()) {
            throw new IllegalStateException("Display: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 screenCanvas \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u0441\u044b\u043b\u0430\u0442\u044c\u0441\u044f \u043d\u0430 \u043d\u0435\u043f\u0440\u043e\u0437\u0440\u0430\u0447\u043d\u0443\u044e \u043a\u0430\u043d\u0432\u0443.");
        }
        Font titleFont = Font.getFont(0, 0, 8);
        Font tickerFont = Font.getFont(0, 1, 8);
        Font sideCommandFont = Font.getFont(0, 0, 8);
        Font defaultCommandFont = Font.getFont(0, 1, 8);
        int w = screenCanvas.getWidth();
        int h = screenCanvas.getHeight();
        int a = w * h;
        RasterCanvas systemCanvas = new RasterCanvas(new GraphicBuffer(new int[a], 0, w, w, h), true);
        RasterCanvas clientCanvas = new RasterCanvas(new GraphicBuffer(new int[a], 0, w, w, h), true);
        int p0 = 0;
        int p1 = p0 + (titleFont.getHeight() + 4);
        int p2 = p1 + (tickerFont.getHeight() + 4);
        int p3 = h - (Math.max(defaultCommandFont.getHeight(), sideCommandFont.getHeight()) + 4);
        int p4 = h;
        this.width = w;
        this.height = h;
        int[] nArray = new int[48];
        nArray[12] = p0;
        nArray[14] = p1;
        nArray[15] = p3;
        nArray[16] = p0;
        nArray[17] = p1;
        nArray[18] = p2;
        nArray[19] = p3;
        nArray[22] = p0;
        nArray[24] = w;
        nArray[26] = w;
        nArray[27] = w;
        nArray[28] = w;
        nArray[29] = w;
        nArray[30] = w;
        nArray[31] = w;
        nArray[34] = w;
        nArray[36] = p1 - p0;
        nArray[38] = p3 - p1;
        nArray[39] = p4 - p3;
        nArray[40] = p1 - p0;
        nArray[41] = p2 - p1;
        nArray[42] = p3 - p2;
        nArray[43] = p4 - p3;
        nArray[46] = p4 - p0;
        this.guiElementsMetrics = nArray;
        this.guiElementsFonts = new Font[]{titleFont, tickerFont, Font.getDefaultFont(), sideCommandFont};
        this.graphicsForModesOfSystemScreen = new Graphics[]{new GraphicsClipRestricted(systemCanvas.subcanvas(0, p1, w, p3 - p1)), new GraphicsClipRestricted(systemCanvas.subcanvas(0, p2, w, p3 - p2)), systemGraphics = new Graphics(systemCanvas)};
        this.graphicsForModesOfClientScreen = new Graphics[]{new GraphicsClipRestricted(clientCanvas.subcanvas(0, p1, w, p3 - p1)), new GraphicsClipRestricted(clientCanvas.subcanvas(0, p2, w, p3 - p2)), clientGraphics = new Graphics(clientCanvas)};
        this.defaultCommandFont = defaultCommandFont;
        this.graphicsForSystemScreen = systemGraphics;
        this.graphicsForClientScreen = clientGraphics;
        this.screenCanvas = screenCanvas;
    }

    public void callSerially(Runnable event) {
        if (event != null) {
            this.clientEvents.setEvent(event);
        }
    }

    public void setCurrent(Displayable next) {
        if (next == null) {
            return;
        }
        if (next.isSystem()) {
            this.currentSystemScreen = next;
            Run.getInstance().setEvent((Runnable)new SystemScreenChangeEvent());
            return;
        }
        this.currentClientAfterAlertScreen = next instanceof Alert ? this.currentClientScreen : null;
        this.currentClientScreen = next;
        this.clientEvents.setEvent(new ClientScreenChangeEvent());
    }

    public void setCurrent(Alert next, Displayable after) {
        if (next == null) {
            throw new NullPointerException("Display.setCurrent: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 next \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (after == null) {
            throw new NullPointerException("Display.setCurrent: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 after \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (next.isSystem() || after.isSystem()) {
            throw new IllegalArgumentException("Display.setCurrent(Alert, Displayable): \u0434\u043b\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u0445 \u044d\u043a\u0440\u0430\u043d\u043e\u0432 \u0441\u043b\u0435\u0434\u0443\u0435\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043c\u0435\u0442\u043e\u0434 setCurrent(Displayable).");
        }
        if (after instanceof Alert) {
            throw new IllegalArgumentException("Display.setCurrent(Alert, Displayable): \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 after \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u0438\u043f\u0430 Alert.");
        }
        this.currentClientAfterAlertScreen = after;
        this.currentClientScreen = next;
        this.clientEvents.setEvent(new ClientScreenChangeEvent());
    }

    public void setCurrentItem(Item item) {
        if (item == null) {
            throw new NullPointerException("Display.setCurrentItem: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 item \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Container owner = item.getOwner();
        if (owner == null) {
            throw new IllegalStateException("Display.setCurrentItem: \u044d\u043b\u0435\u043c\u0435\u043d\u0442 item \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f \u0432 \u043a\u0430\u043a\u043e\u043c-\u043b\u0438\u0431\u043e \u043a\u043e\u043d\u0442\u0435\u0439\u043d\u0435\u0440\u0435.");
        }
        owner.setCurrent(item, this);
    }

    public void hideSystemScreen() {
        this.currentSystemScreen = null;
        Run.getInstance().setEvent((Runnable)new SystemScreenChangeEvent());
    }

    public boolean flashBacklight(int duration) {
        if (duration < 0) {
            throw new IllegalArgumentException("Display.flashBacklight: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 duration \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        return this.isClientInForeground();
    }

    public boolean vibrate(int duration) {
        if (duration < 0) {
            throw new IllegalArgumentException("Display.vibrate: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 duration \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        return this.isClientInForeground();
    }

    public boolean isColor() {
        return true;
    }

    public int numColors() {
        return 0x1000000;
    }

    public int numAlphaLevels() {
        return 256;
    }

    public int getBestImageWidth(int type) {
        switch (type) {
            default: {
                throw new IllegalArgumentException("Display.getBestImageWidth: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 type.");
            }
            case 2: {
                return 24;
            }
            case 1: {
                return 32;
            }
            case 3: 
        }
        return 48;
    }

    public int getBestImageHeight(int type) {
        switch (type) {
            default: {
                throw new IllegalArgumentException("Display.getBestImageHeight: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 type.");
            }
            case 2: {
                return 24;
            }
            case 1: {
                return 32;
            }
            case 3: 
        }
        return 48;
    }

    public int getBorderStyle(boolean highlighted) {
        return 0;
    }

    public int getColor(int colorSpecifier) {
        switch (colorSpecifier) {
            default: {
                throw new IllegalArgumentException("Display.getColor: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430 colorSpecifier.");
            }
            case 1: {
                return RasterCanvas.getSystemColor((int)32);
            }
            case 2: {
                return RasterCanvas.getSystemColor((int)25);
            }
            case 3: {
                return RasterCanvas.getSystemColor((int)33);
            }
            case 0: 
            case 4: 
            case 5: 
        }
        return RasterCanvas.getSystemColor((int)5);
    }

    public Displayable getCurrent() {
        return this.currentClientScreen;
    }

    public final void flushGraphics(Canvas screen, Image image, int left, int top, int width, int height) {
        if (screen == null || !this.isShown(screen)) {
            return;
        }
        Graphics context = this.getClientGraphicsFor(screen);
        try {
            context.reset();
            context.setClip(left, top, width, height);
            context.drawImage(image, 0, 0, 20);
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
        this.paintDisplay(screen, screen.isSystem() ? this.graphicsForSystemScreen : this.graphicsForClientScreen);
    }

    public final boolean isClientInForeground() {
        return !this.applicationInBackground && this.currentSystemScreen == null;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final Displayable getActive() {
        Displayable systemScreen = this.currentSystemScreen;
        return systemScreen != null ? systemScreen : this.currentClientScreen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void startMIDlet(Class midletClass) {
        int[] nArray = this.guiElementsMetrics;
        synchronized (this.guiElementsMetrics) {
            if (this.dispatcher == null) {
                MIDletEventStream p;
                this.dispatcher = new MIDletDispatcher(midletClass);
                this.paintEvents = p = new MIDletEventStream();
                MIDletExecution c = new MIDletExecution();
                this.clientEvents = c;
                new Thread((Runnable)p, "\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0441\u043e\u0431\u044b\u0442\u0438\u0439 \u043f\u0435\u0440\u0435\u0440\u0438\u0441\u043e\u0432\u043a\u0438 \u044d\u043a\u0440\u0430\u043d\u0430").start();
                new Thread((Runnable)c, "\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0441\u043e\u0431\u044b\u0442\u0438\u0439 \u043c\u0438\u0434\u043b\u0435\u0442\u0430").start();
            }
            // ** MonitorExit[var4_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void stopMIDlet() {
        int[] nArray = this.guiElementsMetrics;
        synchronized (this.guiElementsMetrics) {
            MIDletEventStream m = this.clientEvents;
            if (m != null) {
                m.setEvent(new MIDletTerminationEvent());
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    final void terminateEventStreams() {
        this.paintEvents.terminate();
        this.clientEvents.terminate();
    }

    final void setEvent(int event, int param1, int param2, int param3) {
        switch (event) {
            case 10: {
                this.applicationInBackground = false;
                Displayable.tickerUpdate();
                break;
            }
            case 11: {
                this.applicationInBackground = true;
                Displayable.tickerUpdate();
            }
        }
        Displayable screen = this.shownSystemScreen;
        if (screen == null) {
            screen = this.shownClientScreen;
        }
        if (screen == null) {
            return;
        }
        if (screen.isSystem()) {
            this.handleEvent(screen, event, param1, param2, param3);
            return;
        }
        MIDletEventStream events = this.clientEvents;
        if (events != null) {
            events.setEvent(event, param1, param2, param3);
        }
    }

    final void callSeriallyEvent(Displayable screen, Runnable event) {
        if (event == null) {
            return;
        }
        if (screen.isSystem()) {
            Run.getInstance().setEvent(event);
            return;
        }
        MIDletEventStream events = this.clientEvents;
        if (events != null) {
            events.setEvent(event);
        }
    }

    final void callSeriallyPaint(Displayable screen) {
        if (screen.isSystem()) {
            Run run = Run.getInstance();
            Display display = this;
            display.getClass();
            run.setEvent((Runnable)display.new SystemScreenRepaintEvent(screen));
            return;
        }
        MIDletEventStream events = SERIALIZE_REPAINT ? this.clientEvents : this.paintEvents;
        if (events != null) {
            events.setPaint(screen);
        }
    }

    final void callSeriallyPaint(Displayable screen, int left, int top, int width, int height) {
        if (screen.isSystem()) {
            Run run = Run.getInstance();
            Display display = this;
            display.getClass();
            run.setEvent((Runnable)display.new SystemScreenRepaintRegionEvent(screen, left, top, left + width, top + height));
            return;
        }
        MIDletEventStream events = SERIALIZE_REPAINT ? this.clientEvents : this.paintEvents;
        if (events != null) {
            Display display = this;
            display.getClass();
            events.setEvent(display.new ClientScreenRepaintRegionEvent(screen, left, top, left + width, top + height));
        }
    }

    final void serviceRepaints(Displayable screen) {
        if (screen.isSystem()) {
            boolean init = false;
            int bottom = 0;
            int right = 0;
            int top = 0;
            int left = 0;
            Runnable[] events = Run.getInstance().getImmediatelyServices((Object)screen);
            int len = events == null ? 0 : events.length;
            int i = 0;
            while (i < len) {
                Runnable event = events[i];
                if (event != null && event instanceof Rectangle) {
                    Rectangle rect = (Rectangle)((Object)event);
                    left = init ? Math.min(left, rect.getLeft()) : rect.getLeft();
                    top = init ? Math.min(top, rect.getTop()) : rect.getTop();
                    right = init ? Math.max(right, rect.getRight()) : rect.getRight();
                    bottom = init ? Math.max(bottom, rect.getBottom()) : rect.getBottom();
                    init = true;
                }
                ++i;
            }
            if (init) {
                this.handlePaint(screen, left, top, right - left, bottom - top);
            }
            return;
        }
        MIDletEventStream eventstream = SERIALIZE_REPAINT ? this.clientEvents : this.paintEvents;
        if (eventstream != null) {
            eventstream.serviceRepaints(screen);
        }
    }

    final boolean isShown(Displayable screen) {
        return !this.applicationInBackground && (screen.isSystem() ? this.shownSystemScreen == screen : this.shownSystemScreen == null && this.shownClientScreen == screen);
    }

    final int getGUIElementLeft(Displayable screen, int guiElement) {
        return this.getGUIElementMetric(screen.getMode(), guiElement, 0);
    }

    final int getGUIElementTop(Displayable screen, int guiElement) {
        return this.getGUIElementMetric(screen.getMode(), guiElement, 1);
    }

    final int getGUIElementWidth(Displayable screen, int guiElement) {
        return this.getGUIElementMetric(screen.getMode(), guiElement, 2);
    }

    final int getGUIElementHeight(Displayable screen, int guiElement) {
        return this.getGUIElementMetric(screen.getMode(), guiElement, 3);
    }

    final Font getGUIElementFont(int guiElement) {
        Font[] fontFor;
        block3: {
            block2: {
                if (guiElement < 0) break block2;
                fontFor = this.guiElementsFonts;
                if (guiElement < this.guiElementsFonts.length) break block3;
            }
            throw new IllegalArgumentException("Display.getGUIElementFont: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 guiElement.");
        }
        return fontFor[guiElement];
    }

    final Font getDefaultCommandFont() {
        return this.defaultCommandFont;
    }

    final Graphics getClientGraphicsFor(Displayable screen) {
        return (screen.isSystem() ? this.graphicsForModesOfSystemScreen : this.graphicsForModesOfClientScreen)[screen.getMode()];
    }

    final Displayable getShownScreen() {
        Displayable screen;
        return this.applicationInBackground ? null : ((screen = this.shownSystemScreen) != null ? screen : this.shownClientScreen);
    }

    final Displayable getScreenAfterAlert() {
        return this.currentClientAfterAlertScreen;
    }

    final Exception getMIDletStartingCause() {
        MIDletDispatcher d = this.dispatcher;
        return d != null ? d.getCause() : null;
    }

    private void handleEvent(Runnable event) {
        if (event == null) {
            return;
        }
        try {
            event.run();
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
    }

    private void handleEvent(Displayable screen, int event, int param1, int param2, int param3) {
        if (screen == null) {
            return;
        }
        try {
            switch (event) {
                case 10: {
                    screen.eventShow();
                    break;
                }
                case 11: {
                    screen.eventHide();
                    break;
                }
                case 1: {
                    screen.eventKeyPressed(param1, param2 & 0xFFFF | param3 << 16);
                    break;
                }
                case 2: {
                    screen.eventKeyRepeated(param1, param2 & 0xFFFF | param3 << 16);
                    break;
                }
                case 3: {
                    screen.eventKeyReleased(param1);
                    break;
                }
                case 5: {
                    screen.eventPointerPressed(param1, param2, param3);
                    break;
                }
                case 6: {
                    screen.eventPointerDragged(param1, param2);
                    break;
                }
                case 7: {
                    screen.eventPointerReleased(param1, param2, param3);
                }
            }
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
        if (event == 10) {
            this.callSeriallyPaint(screen);
        }
    }

    private void handlePaint(Displayable screen) {
        int elements;
        if (screen == null || !this.isShown(screen) || (elements = screen.getRepaintElements()) == 0) {
            return;
        }
        Graphics context = screen.isSystem() ? this.graphicsForSystemScreen : this.graphicsForClientScreen;
        try {
            context.reset();
            screen.clearRepaintElements();
            screen.eventPaint(context, elements);
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
        this.paintDisplay(screen, context);
    }

    private void handlePaint(Displayable screen, int left, int top, int width, int height) {
        int elements;
        if (screen == null || !this.isShown(screen) || (elements = screen.getRepaintElements()) == 0) {
            return;
        }
        Graphics context = screen.isSystem() ? this.graphicsForSystemScreen : this.graphicsForClientScreen;
        try {
            context.reset();
            screen.clearRepaintElements();
            screen.eventPaint(context, elements, left, top, width, height);
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
        this.paintDisplay(screen, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintDisplay(Displayable screen, Graphics context) {
        long delay;
        if (!this.isShown(screen)) {
            return;
        }
        int[] monitor = this.guiElementsMetrics;
        int[] nArray = this.guiElementsMetrics;
        synchronized (nArray) {
            long period = MINIMUM_PERIOD;
            long currTimestamp = System.currentTimeMillis();
            long mustTimestamp = this.lastRepaintTimestamp + period;
            delay = mustTimestamp - currTimestamp;
            this.lastRepaintTimestamp = currTimestamp + (delay > period ? (delay = period) : (delay > 0L ? delay : 0L));
        }
        if (delay > 0L) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                e.printRealStackTrace();
            }
        }
        if (!this.isShown(screen)) {
            return;
        }
        nArray = monitor;
        synchronized (monitor) {
            GraphicBuffer src = context.getBuffer();
            int srcScanlength = src.getScanlength();
            GraphicBuffer dst = this.screenCanvas.getBuffer();
            int dstScanlength = dst.getScanlength();
            if (srcScanlength == dstScanlength) {
                Array.copy((int[])src.getPixels(), (int)src.getOffset(), (int[])dst.getPixels(), (int)dst.getOffset(), (int)(dst.getWidth() + (dst.getHeight() - 1) * dstScanlength));
            } else {
                int width = dst.getWidth();
                int height = dst.getHeight();
                int srcOffset = src.getOffset() + srcScanlength * src.getHeight();
                int dstOffset = dst.getOffset() + dstScanlength * height;
                int[] srcPixels = src.getPixels();
                int[] dstPixels = dst.getPixels();
                int i = height;
                while (i-- > 0) {
                    Array.copy((int[])srcPixels, (int)(srcOffset -= srcScanlength), (int[])dstPixels, (int)(dstOffset -= dstScanlength), (int)width);
                }
            }
            RasterCanvas.getScreenCanvas().updateScreen();
            // ** MonitorExit[var6_4] (shouldn't be in output)
            return;
        }
    }

    private int getGUIElementMetric(int mode, int guiElement, int metric) {
        if (guiElement < 0 || guiElement >= 4) {
            throw new IllegalArgumentException("Display.getGUIElementMetrics: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 guiElement.");
        }
        return this.guiElementsMetrics[metric * 12 + mode * 4 + guiElement];
    }

    private class ClientScreenChangeEvent
    implements Runnable {
        public void run() {
            Display display = Display.this;
            Displayable curr = display.shownClientScreen;
            Displayable next = display.currentClientScreen;
            if (display.applicationInBackground || display.shownSystemScreen != null || display.currentSystemScreen != null || curr == next) {
                display.shownClientScreen = next;
                return;
            }
            if (curr != null) {
                display.shownClientScreen = null;
                try {
                    curr.eventHide();
                }
                catch (RuntimeException e) {
                    e.printRealStackTrace();
                }
            }
            if (next != null) {
                try {
                    next.eventShow();
                }
                catch (RuntimeException e) {
                    e.printRealStackTrace();
                }
                display.shownClientScreen = next;
                Displayable.tickerUpdate();
                display.callSeriallyPaint(next);
            }
        }
    }

    private class ClientScreenRepaintRegionEvent
    implements Runnable,
    Rectangle,
    ImmediatelyRunnable {
        private int left;
        private int top;
        private int right;
        private int bottom;
        private Displayable screen;

        public ClientScreenRepaintRegionEvent(Displayable screen, int left, int top, int right, int bottom) {
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
            this.screen = screen;
        }

        public void run() {
            int l = this.left;
            int t = this.top;
            Display.this.handlePaint(this.screen, l, t, this.right - l, this.bottom - t);
        }

        public int getLeft() {
            return this.left;
        }

        public int getTop() {
            return this.top;
        }

        public int getRight() {
            return this.right;
        }

        public int getBottom() {
            return this.bottom;
        }

        public Object argument() {
            return this.screen;
        }
    }

    private class MIDletEventStream
    extends Queue
    implements Runnable {
        private boolean terminated;
        private long[] eventsFromUser = new long[33];
        private Runnable[] eventsFromApp = new Runnable[33];
        private Displayable[] eventsScreens = new Displayable[33];

        public MIDletEventStream() {
            super(33);
        }

        public void removeTailElement() {
            int t = this.tail;
            this.eventsFromUser[t] = 0L;
            this.eventsFromApp[t] = null;
            this.eventsScreens[t] = null;
            this.advanceTail();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Display display = Display.this;
            block8: while (true) {
                Displayable screen;
                Runnable fromApp;
                long fromUser;
                this.waitEvent();
                if (this.terminated) break;
                if (this.isEmpty()) continue;
                MIDletEventStream mIDletEventStream = this;
                synchronized (mIDletEventStream) {
                    fromUser = this.peekEventFromUser();
                    fromApp = this.peekEventFromApp();
                    screen = this.peekEventScreen();
                    this.removeTailElement();
                }
                if (screen == null && (short)fromUser != 13) {
                    screen = display.getCurrent();
                }
                switch ((short)fromUser) {
                    case 0: {
                        continue block8;
                    }
                    case 14: {
                        display.handlePaint(screen);
                        continue block8;
                    }
                    case 13: {
                        display.handleEvent(fromApp);
                        continue block8;
                    }
                }
                display.handleEvent(screen, (short)fromUser, (short)(fromUser >> 16), (short)(fromUser >> 32), (short)(fromUser >> 48));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceRepaints(Displayable argument) {
            boolean init = false;
            int bottom = 0;
            int right = 0;
            int top = 0;
            int left = 0;
            while (true) {
                int i;
                long fromUser = 0L;
                Runnable fromApp = null;
                Displayable screen = null;
                MIDletEventStream mIDletEventStream = this;
                synchronized (mIDletEventStream) {
                    i = this.findImmediatelyRunnable(argument);
                    if (i >= 0) {
                        long[] u = this.eventsFromUser;
                        fromUser = this.eventsFromUser[i];
                        Runnable[] a = this.eventsFromApp;
                        fromApp = this.eventsFromApp[i];
                        Displayable[] s = this.eventsScreens;
                        screen = this.eventsScreens[i];
                        u[i] = 0L;
                        a[i] = null;
                        s[i] = null;
                    }
                }
                if (i < 0) break;
                if ((char)fromUser == '\u000e') {
                    left = init ? Math.min(left, 0) : 0;
                    top = init ? Math.min(top, 0) : 0;
                    right = init ? Math.max(right, screen.getClientWidth()) : screen.getClientWidth();
                    bottom = init ? Math.max(bottom, screen.getClientHeight()) : screen.getClientHeight();
                    init = true;
                    continue;
                }
                if (!(fromApp instanceof Rectangle)) continue;
                Rectangle rect = (Rectangle)((Object)fromApp);
                left = init ? Math.min(left, rect.getLeft()) : rect.getLeft();
                top = init ? Math.min(top, rect.getTop()) : rect.getTop();
                right = init ? Math.max(right, rect.getRight()) : rect.getRight();
                bottom = init ? Math.max(bottom, rect.getBottom()) : rect.getBottom();
                init = true;
            }
            if (init) {
                Display.this.handlePaint(argument, left, top, right - left, bottom - top);
            }
        }

        public synchronized void setEvent(int event) {
            this.push(event & 0xFFFF, null, null);
            this.notify();
        }

        public synchronized void setEvent(int event, int param1, int param2, int param3) {
            this.push((long)(event & 0xFFFF) | (long)(param1 & 0xFFFF) << 16 | (long)(param2 & 0xFFFF) << 32 | (long)(param3 & 0xFFFF) << 48, null, null);
            this.notify();
        }

        public synchronized void setEvent(Runnable event) {
            this.push(13L, event, null);
            this.notify();
        }

        public synchronized void setPaint(Displayable screen) {
            this.push(14L, null, screen);
            this.notify();
        }

        public synchronized void terminate() {
            this.terminated = true;
            this.notify();
        }

        private synchronized void waitEvent() {
            while (true) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printRealStackTrace();
                    continue;
                }
                break;
            }
        }

        private void push(long eventFromUser, Runnable eventFromApp, Displayable eventScreen) {
            long[] lq = this.eventsFromUser;
            Object[] rq = this.eventsFromApp;
            Object[] dq = this.eventsScreens;
            if (this.getFreeElements() == 0) {
                int nc = (this.capacity << 1) - 1;
                lq = this.eventsFromUser = this.expand(lq, nc);
                this.eventsFromApp = (Runnable[])this.expand(rq, nc);
                rq = this.eventsFromApp;
                this.eventsScreens = (Displayable[])this.expand(dq, nc);
                dq = this.eventsScreens;
                this.reset(nc);
            }
            int h = this.head;
            lq[h] = eventFromUser;
            rq[h] = eventFromApp;
            dq[h] = eventScreen;
            this.advanceHead();
        }

        private int findImmediatelyRunnable(Object argument) {
            int t = this.tail;
            int c = this.capacity;
            long[] u = this.eventsFromUser;
            Runnable[] e = this.eventsFromApp;
            Displayable[] s = this.eventsScreens;
            int i = this.head;
            while (i != t) {
                Runnable r;
                if (((char)u[i = (c + i - 1) % c] != '\u000e' || s[i] != argument) && (!((r = e[i]) instanceof ImmediatelyRunnable) || ((ImmediatelyRunnable)r).argument() != argument)) continue;
                return i;
            }
            return -1;
        }

        private long peekEventFromUser() {
            return this.eventsFromUser[this.tail];
        }

        private Runnable peekEventFromApp() {
            return this.eventsFromApp[this.tail];
        }

        private Displayable peekEventScreen() {
            return this.eventsScreens[this.tail];
        }
    }

    private final class MIDletExecution
    extends MIDletEventStream {
        public void run() {
            Display display = Display.this;
            PrintStream printer = System.out;
            MIDletProxy proxy = MIDletProxy.getInstance();
            MIDletDispatcher dispatcher = display.dispatcher;
            printer.println("\u0417\u0430\u043f\u0443\u0441\u043a \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f\u2026");
            printer.println("\u041a\u043b\u0430\u0441\u0441 \u043c\u0438\u0434\u043b\u0435\u0442\u0430: ".concat(dispatcher.getMIDletClass().getCanonicalName()));
            dispatcher.startMIDlet();
            proxy.notifyMIDletStarted();
            if (dispatcher.mustDestroyed()) {
                printer.println("\u041d\u0435\u0443\u0434\u0430\u0447\u043d\u0430\u044f \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u2013 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0435 \u0440\u0430\u0431\u043e\u0442\u044b \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f.");
                display = null;
                dispatcher.stopMIDlet();
                dispatcher = null;
                proxy.notifyMIDletTerminated();
                return;
            }
            printer.println("\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0443\u0449\u0435\u043d\u043e \u0438 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442.");
            dispatcher = null;
            display.hideSystemScreen();
            display = null;
            super.run();
            RecordStore.closeAllRecordStores();
            printer.println("\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u043e \u0440\u0430\u0431\u043e\u0442\u0443.");
            proxy.notifyMIDletTerminated();
        }
    }

    private class MIDletTerminationEvent
    implements Runnable {
        public void run() {
            Display display = Display.this;
            display.dispatcher.stopMIDlet();
            display.terminateEventStreams();
        }
    }

    private class SystemScreenChangeEvent
    implements Runnable {
        public void run() {
            Display display = Display.this;
            Displayable curr = display.shownSystemScreen;
            Displayable next = display.currentSystemScreen;
            MIDletEventStream events = display.clientEvents;
            if (display.applicationInBackground || curr == next) {
                display.shownSystemScreen = next;
                return;
            }
            if (curr != null) {
                display.shownSystemScreen = null;
                try {
                    curr.eventHide();
                }
                catch (RuntimeException e) {
                    e.printRealStackTrace();
                }
            }
            if (events != null) {
                if (curr == null) {
                    events.setEvent(11);
                }
                if (next == null) {
                    events.setEvent(10);
                }
            }
            if (next != null) {
                try {
                    next.eventShow();
                }
                catch (RuntimeException e) {
                    e.printRealStackTrace();
                }
                display.shownSystemScreen = next;
                Displayable.tickerUpdate();
                display.callSeriallyPaint(next);
            }
        }
    }

    private class SystemScreenRepaintEvent
    implements Runnable,
    Rectangle,
    ImmediatelyRunnable {
        protected final Displayable screen;

        public SystemScreenRepaintEvent(Displayable screen) {
            this.screen = screen;
        }

        public void run() {
            Display.this.handlePaint(this.screen);
        }

        public int getLeft() {
            return 0;
        }

        public int getTop() {
            return 0;
        }

        public int getRight() {
            Displayable screen = this.screen;
            return screen == null ? Display.this.getWidth() : screen.getClientWidth();
        }

        public int getBottom() {
            Displayable screen = this.screen;
            return screen == null ? Display.this.getHeight() : screen.getClientHeight();
        }

        public Object argument() {
            return this.screen;
        }
    }

    private class SystemScreenRepaintRegionEvent
    extends SystemScreenRepaintEvent {
        private int left;
        private int top;
        private int right;
        private int bottom;

        public SystemScreenRepaintRegionEvent(Displayable screen, int left, int top, int right, int bottom) {
            super(screen);
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
        }

        public void run() {
            int l = this.left;
            int t = this.top;
            Display.this.handlePaint(this.screen, l, t, this.right - l, this.bottom - t);
        }

        public int getLeft() {
            return this.left;
        }

        public int getTop() {
            return this.top;
        }

        public int getRight() {
            return this.right;
        }

        public int getBottom() {
            return this.bottom;
        }
    }
}

