/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.MIDletProxy;
import malik.emulator.media.text.RasterFont;

public final class Font {
    public static final int FONT_STATIC_TEXT = 0;
    public static final int FONT_INPUT_TEXT = 1;
    public static final int FACE_SYSTEM = 0;
    public static final int FACE_MONOSPACE = 32;
    public static final int FACE_PROPORTIONAL = 64;
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINED = 4;
    public static final int SIZE_SMALL = 8;
    public static final int SIZE_MEDIUM = 0;
    public static final int SIZE_LARGE = 16;
    private static final Font[] RASTER_FONTS;
    private static final Font[][] FONTS;
    private int face;
    private int style;
    private int size;
    private RasterFont ref;

    static {
        Font[][] fonts = new Font[3][24];
        MIDletProxy proxy = MIDletProxy.getInstance();
        int j = fonts.length;
        while (j-- > 0) {
            Font[] f = fonts[j];
            int i = f.length;
            while (i-- > 0) {
                f[i] = new Font(proxy.getFont(i >> 3, i & 3), j << 5, i & 7, i & 0xFFFFFFF8);
            }
        }
        RASTER_FONTS = new Font[RasterFont.getRasterFontsCount()];
        FONTS = fonts;
    }

    public static Font getDefaultFont() {
        return FONTS[0][0];
    }

    public static Font getFont(int fontSpecifier) {
        switch (fontSpecifier) {
            default: {
                throw new IllegalArgumentException("Font.getFont: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 fontSpecifier.");
            }
            case 0: {
                return FONTS[0][0];
            }
            case 1: 
        }
        return FONTS[0][8];
    }

    public static Font getFont(int face, int style, int size) {
        if (face != 32 && face != 64 && face != 0) {
            throw new IllegalArgumentException("Font.getFont: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 face.");
        }
        if (style < 0 || style >= 8) {
            throw new IllegalArgumentException("Font.getFont: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 style.");
        }
        if (size != 16 && size != 0 && size != 8) {
            throw new IllegalArgumentException("Font.getFont: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 size.");
        }
        return FONTS[face >> 5][style | size];
    }

    public static Font getRasterFont(int rasterFontIndex) {
        Font result;
        block4: {
            if (rasterFontIndex < 0 || rasterFontIndex >= RASTER_FONTS.length) {
                throw new IndexOutOfBoundsException("Font.getRasterFont: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 rasterFontIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
            result = RASTER_FONTS[rasterFontIndex];
            if (result == null) {
                RasterFont font = RasterFont.getRasterFontAtIndex((int)rasterFontIndex);
                int i = FONTS.length;
                while (i-- > 0) {
                    Font[] af = FONTS[i];
                    int j = af.length;
                    while (j-- > 0) {
                        Font f = af[j];
                        if (f.ref != font || (f.style & 4) != 0) continue;
                        result = Font.RASTER_FONTS[rasterFontIndex] = f;
                        break block4;
                    }
                }
                result = Font.RASTER_FONTS[rasterFontIndex] = new Font(font, 0, 0, 0);
            }
        }
        return result;
    }

    private Font(RasterFont ref, int face, int style, int size) {
        this.face = face;
        this.style = style;
        this.size = size;
        this.ref = ref;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public boolean isUnderlined() {
        return (this.style & 4) != 0;
    }

    public int getFace() {
        return this.face;
    }

    public int getStyle() {
        return this.style;
    }

    public int getSize() {
        return this.size;
    }

    public int getHeight() {
        return this.ref.getHeight();
    }

    public int getBaselinePosition() {
        return this.ref.getBaselinePosition();
    }

    public int charWidth(char src) {
        return this.ref.charWidth((int)src);
    }

    public int charsWidth(char[] src, int offset, int length) {
        if (src == null) {
            throw new NullPointerException("Font.charsWidth: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = src.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Font.charsWidth: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return this.ref.charsWidth(src, offset, length);
    }

    public int stringWidth(String src) {
        if (src == null) {
            throw new NullPointerException("Font.stringWidth: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        return this.ref.stringWidth(src);
    }

    public int substringWidth(String src, int offset, int length) {
        if (src == null) {
            throw new NullPointerException("Font.substringWidth: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = src.length();
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new StringIndexOutOfBoundsException("Font.substringWidth: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return this.ref.substringWidth(src, offset, length);
    }

    public RasterFont getReference() {
        return this.ref;
    }
}

