/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui.game;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.TiledLayer;

public class Sprite
extends Layer {
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    private int collisionRectLeft;
    private int collisionRectTop;
    private int collisionRectWidth;
    private int collisionRectHeight;
    private int transformedCollisionRectLeft;
    private int transformedCollisionRectTop;
    private int transformedCollisionRectWidth;
    private int transformedCollisionRectHeight;
    private int transformation;
    private int refPointX;
    private int refPointY;
    private int framesPerRow;
    private int framesCount;
    private int frameWidth;
    private int frameHeight;
    private int frameIndex;
    private int[] frameSequence;
    private int[] frameSequenceDefault;
    private Image frameSet;
    private Object lock;

    private static boolean doPixelCollision(int width, int height, Image image1, int left1, int top1, int transform1, Image image2, int left2, int top2, int transform2) {
        int yinc2;
        int start2;
        int xinc2;
        int yinc1;
        int start1;
        int xinc1;
        int area = width * height;
        int[] pixels1 = new int[area];
        int[] pixels2 = new int[area];
        if ((transform1 & 4) != 0) {
            if ((transform1 & 1) != 0) {
                xinc1 = -height;
                start1 = area - height;
            } else {
                xinc1 = height;
                start1 = 0;
            }
            if ((transform1 & 2) != 0) {
                yinc1 = -1;
                start1 += height - 1;
            } else {
                yinc1 = 1;
            }
            image1.getRGB(pixels1, 0, height, left1, top1, height, width);
        } else {
            if ((transform1 & 1) != 0) {
                yinc1 = -width;
                start1 = area - width;
            } else {
                yinc1 = width;
                start1 = 0;
            }
            if ((transform1 & 2) != 0) {
                xinc1 = -1;
                start1 += width - 1;
            } else {
                xinc1 = 1;
            }
            image1.getRGB(pixels1, 0, width, left1, top1, width, height);
        }
        if ((transform2 & 4) != 0) {
            if ((transform2 & 1) != 0) {
                xinc2 = -height;
                start2 = area - height;
            } else {
                xinc2 = height;
                start2 = 0;
            }
            if ((transform2 & 2) != 0) {
                yinc2 = -1;
                start2 += height - 1;
            } else {
                yinc2 = 1;
            }
            image2.getRGB(pixels2, 0, height, left2, top2, height, width);
        } else {
            if ((transform2 & 1) != 0) {
                yinc2 = -width;
                start2 = area - width;
            } else {
                yinc2 = width;
                start2 = 0;
            }
            if ((transform2 & 2) != 0) {
                xinc2 = -1;
                start2 += width - 1;
            } else {
                xinc2 = 1;
            }
            image2.getRGB(pixels2, 0, width, left2, top2, width, height);
        }
        int startx1 = start1;
        int startx2 = start2;
        int j = height;
        while (j-- > 0) {
            int x1 = startx1;
            int x2 = startx2;
            int i = width;
            while (i-- > 0) {
                if ((pixels1[x1] & 0xFF000000) != 0 && (pixels2[x2] & 0xFF000000) != 0) {
                    return true;
                }
                x1 += xinc1;
                x2 += xinc2;
            }
            startx1 += yinc1;
            startx2 += yinc2;
        }
        return false;
    }

    private static boolean isIntersection(int r1Left, int r1Top, int r1Right, int r1Bottom, int r2Left, int r2Top, int r2Right, int r2Bottom) {
        return r1Left < r2Right && r2Left < r1Right && r1Top < r2Bottom && r2Top < r1Bottom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sprite(Sprite src) {
        super(src != null && src.isVisible(), src != null ? src.getX() : 0, src != null ? src.getY() : 0, src != null ? src.getWidth() : 0, src != null ? src.getHeight() : 0);
        if (src == null) {
            throw new NullPointerException("Sprite: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = src.lock;
        synchronized (object) {
            this.collisionRectLeft = src.collisionRectLeft;
            this.collisionRectTop = src.collisionRectTop;
            this.collisionRectWidth = src.collisionRectWidth;
            this.collisionRectHeight = src.collisionRectHeight;
            this.transformedCollisionRectLeft = src.transformedCollisionRectLeft;
            this.transformedCollisionRectTop = src.transformedCollisionRectTop;
            this.transformedCollisionRectWidth = src.transformedCollisionRectWidth;
            this.transformedCollisionRectHeight = src.transformedCollisionRectHeight;
            this.transformation = src.transformation;
            this.refPointX = src.refPointX;
            this.refPointY = src.refPointY;
            this.framesPerRow = src.framesPerRow;
            this.framesCount = src.framesCount;
            this.frameWidth = src.frameWidth;
            this.frameHeight = src.frameHeight;
            this.frameIndex = src.frameIndex;
            this.frameSequence = src.frameSequence;
            this.frameSequenceDefault = src.frameSequenceDefault;
            this.frameSet = src.frameSet;
        }
        this.lock = new Object();
    }

    public Sprite(Image frame) {
        this(frame, frame != null ? frame.getWidth() : 0, frame != null ? frame.getHeight() : 0);
    }

    public Sprite(Image frameSet, int frameWidth, int frameHeight) {
        super(frameWidth, frameHeight);
        int fc;
        int tmp;
        int height;
        if (frameSet == null) {
            throw new NullPointerException("Sprite: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 frameSet \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (frameWidth < 1 || frameHeight < 1) {
            throw new IllegalArgumentException("Sprite: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043a\u0430\u0434\u0440\u043e\u0432 \u0430\u043d\u0438\u043c\u0430\u0446\u0438\u0438 \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.");
        }
        int width = frameSet.getWidth();
        if (width % frameWidth != 0 || (height = frameSet.getHeight()) % frameHeight != 0) {
            throw new IllegalArgumentException("Sprite: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043d\u0430\u0431\u043e\u0440\u0430 \u043a\u0430\u0434\u0440\u043e\u0432 \u043c\u043e\u0433\u0443\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430\u0446\u0435\u043b\u043e \u0434\u0435\u043b\u0438\u0442\u044c\u0441\u044f \u043d\u0430 \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u0441\u0430\u043c\u0438\u0445 \u043a\u0430\u0434\u0440\u043e\u0432.");
        }
        this.collisionRectWidth = frameWidth;
        this.collisionRectHeight = frameHeight;
        this.transformedCollisionRectWidth = frameWidth;
        this.transformedCollisionRectHeight = frameHeight;
        this.framesPerRow = tmp = width / frameWidth;
        this.framesCount = fc = tmp * (height / frameHeight);
        this.frameWidth = frameWidth;
        this.frameHeight = frameHeight;
        int[] seq = new int[fc];
        this.frameSequence = seq;
        this.frameSequenceDefault = seq;
        this.frameSet = frameSet;
        this.lock = new Object();
        int i = fc;
        while (i-- > 0) {
            seq[i] = i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineCollisionRectangle(int left, int top, int width, int height) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Sprite.defineCollisionRectangle: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043e\u0431\u043b\u0430\u0441\u0442\u0438 \u043a\u043e\u043b\u043b\u0438\u0437\u0438\u0439 \u043d\u0435 \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.collisionRectLeft = left;
            this.collisionRectTop = top;
            this.collisionRectWidth = width;
            this.collisionRectHeight = height;
            this.computeTransformedBounds(this.transformation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineReferencePixel(int x, int y) {
        Object object = this.lock;
        synchronized (object) {
            this.refPointX = x;
            this.refPointY = y;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextFrame() {
        Object object = this.lock;
        synchronized (object) {
            this.frameIndex = (this.frameIndex + 1) % this.frameSequence.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prevFrame() {
        Object object = this.lock;
        synchronized (object) {
            int len = this.frameSequence.length;
            this.frameIndex = (this.frameIndex + len - 1) % len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFrame(int frameIndex) {
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            if (frameIndex < 0 || frameIndex >= this.frameSequence.length) {
                error = true;
            } else {
                this.frameIndex = frameIndex;
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("Sprite.setFrame: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 frameIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFrameSequence(int[] sequence) {
        int[] frameSequence;
        int len;
        if (sequence == null) {
            len = 0;
            frameSequence = null;
        } else {
            len = sequence.length;
            if (len < 1) {
                throw new IllegalArgumentException("Sprite.setFrameSequence: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 sequence \u043c\u043e\u0436\u0435\u0442 \u0438\u043c\u0435\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u0443\u044e \u0434\u043b\u0438\u043d\u0443.");
            }
            frameSequence = new int[len];
            Array.copy((int[])sequence, (int)0, (int[])frameSequence, (int)0, (int)len);
        }
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            block10: {
                if (frameSequence == null) {
                    frameSequence = this.frameSequenceDefault;
                } else {
                    int framesCount = this.framesCount;
                    int i = len;
                    while (i-- > 0) {
                        int frame = frameSequence[i];
                        if (frame >= 0 && frame < framesCount) continue;
                        error = true;
                        break block10;
                    }
                }
                this.frameSequence = frameSequence;
            }
        }
        if (error) {
            throw new ArrayIndexOutOfBoundsException("Sprite.setFrameSequence: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 sequence \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b, \u0432\u044b\u0445\u043e\u0434\u044f\u0449\u0438\u0435 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(Image frameSet, int frameWidth, int frameHeight) {
        int height;
        if (frameSet == null) {
            throw new NullPointerException("Sprite.setImage: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 frameSet \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (frameWidth < 1 || frameHeight < 1) {
            throw new IllegalArgumentException("Sprite.setImage: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043a\u0430\u0434\u0440\u043e\u0432 \u0430\u043d\u0438\u043c\u0430\u0446\u0438\u0438 \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.");
        }
        int width = frameSet.getWidth();
        if (width % frameWidth != 0 || (height = frameSet.getHeight()) % frameHeight != 0) {
            throw new IllegalArgumentException("Sprite.setImage: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043d\u0430\u0431\u043e\u0440\u0430 \u043a\u0430\u0434\u0440\u043e\u0432 \u043c\u043e\u0433\u0443\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430\u0446\u0435\u043b\u043e \u0434\u0435\u043b\u0438\u0442\u044c\u0441\u044f \u043d\u0430 \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u0441\u0430\u043c\u0438\u0445 \u043a\u0430\u0434\u0440\u043e\u0432.");
        }
        Object object = this.lock;
        synchronized (object) {
            int[] seq;
            if (frameWidth != this.frameWidth || frameHeight != this.frameHeight) {
                int t = this.transformation;
                int x = this.getX() + this.getTransformedPtX(t);
                int y = this.getY() + this.getTransformedPtY(t);
                this.collisionRectLeft = 0;
                this.collisionRectTop = 0;
                this.collisionRectWidth = frameWidth;
                this.collisionRectHeight = frameHeight;
                this.transformedCollisionRectLeft = 0;
                this.transformedCollisionRectTop = 0;
                if ((t & 4) != 0) {
                    this.transformedCollisionRectWidth = frameHeight;
                    this.transformedCollisionRectHeight = frameWidth;
                    this.setSize(frameHeight, frameWidth);
                } else {
                    this.transformedCollisionRectWidth = frameWidth;
                    this.transformedCollisionRectHeight = frameHeight;
                    this.setSize(frameWidth, frameHeight);
                }
                this.frameWidth = frameWidth;
                this.frameHeight = frameHeight;
                super.setPosition(x - this.getTransformedPtX(t), y - this.getTransformedPtY(t));
            }
            int tmp = width / frameWidth;
            int fc = tmp * (height / frameHeight);
            this.framesPerRow = tmp;
            tmp = this.framesCount;
            if (fc == tmp) {
                seq = null;
            } else {
                seq = new int[fc];
                int i = fc;
                while (i-- > 0) {
                    seq[i] = i;
                }
            }
            this.framesCount = fc;
            if (fc < tmp) {
                this.frameIndex = 0;
                this.frameSequence = seq;
                this.frameSequenceDefault = seq;
            } else if (fc > tmp) {
                if (this.frameSequence == this.frameSequenceDefault) {
                    this.frameSequence = seq;
                }
                this.frameSequenceDefault = seq;
            }
            this.frameSet = frameSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRefPixelPosition(int x, int y) {
        Object object = this.lock;
        synchronized (object) {
            int transform = this.transformation;
            super.setPosition(x - this.getTransformedPtX(transform), y - this.getTransformedPtY(transform));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransform(int transform) {
        if (transform < 0 || transform > 7) {
            throw new IllegalArgumentException("Sprite.setTransform: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 transform.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.setTransformHelper(transform);
        }
    }

    public int getFrameSequenceLength() {
        return this.frameSequence.length;
    }

    public int getRawFrameCount() {
        return this.framesCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRefPixelX() {
        int result;
        Object object = this.lock;
        synchronized (object) {
            result = this.getX() + this.getTransformedPtX(this.transformation);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRefPixelY() {
        int result;
        Object object = this.lock;
        synchronized (object) {
            result = this.getY() + this.getTransformedPtY(this.transformation);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(Graphics render) {
        Image frameSet;
        int frame;
        int frameHeight;
        int frameWidth;
        int framesPerRow;
        int transformation;
        int top;
        int left;
        if (render == null) {
            throw new NullPointerException("Sprite.paint: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 render \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (!this.isVisible()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            left = this.getX();
            top = this.getY();
            transformation = this.transformation;
            framesPerRow = this.framesPerRow;
            frameWidth = this.frameWidth;
            frameHeight = this.frameHeight;
            frame = this.frameSequence[this.frameIndex];
            frameSet = this.frameSet;
        }
        render.drawRegion(frameSet, frame % framesPerRow * frameWidth, frame / framesPerRow * frameHeight, frameWidth, frameHeight, transformation, left, top, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean collidesWith(Sprite src, boolean pixelLevel) {
        boolean result;
        if (src == null) {
            throw new NullPointerException("Sprite.collidesWith: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (!this.isVisible() || !src.isVisible()) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            Object object2 = src.lock;
            synchronized (object2) {
                int sprite1Left = this.getX();
                int sprite1Top = this.getY();
                int sprite1Right = sprite1Left + this.getWidth();
                int sprite1Bottom = sprite1Top + this.getHeight();
                int thisLeft = sprite1Left + this.transformedCollisionRectLeft;
                int thisTop = sprite1Top + this.transformedCollisionRectTop;
                int thisRight = thisLeft + this.transformedCollisionRectWidth;
                int thisBottom = thisTop + this.transformedCollisionRectHeight;
                int sprite2Left = src.getX();
                int sprite2Top = src.getY();
                int sprite2Right = sprite2Left + src.getWidth();
                int sprite2Bottom = sprite2Top + src.getHeight();
                int srcLeft = sprite2Left + src.transformedCollisionRectLeft;
                int srcTop = sprite2Top + src.transformedCollisionRectTop;
                int srcRight = srcLeft + src.transformedCollisionRectWidth;
                int srcBottom = srcTop + src.transformedCollisionRectHeight;
                if (!Sprite.isIntersection(thisLeft, thisTop, thisRight, thisBottom, srcLeft, srcTop, srcRight, srcBottom)) {
                    result = false;
                } else if (!pixelLevel) {
                    result = true;
                } else {
                    int resultHeight;
                    int resultLeft = Math.max(Math.max(sprite1Left, thisLeft), Math.max(sprite2Left, srcLeft));
                    int resultTop = Math.max(Math.max(sprite1Top, thisTop), Math.max(sprite2Top, srcTop));
                    int resultRight = Math.min(Math.min(sprite1Right, thisRight), Math.min(sprite2Right, srcRight));
                    int resultBottom = Math.min(Math.min(sprite1Bottom, thisBottom), Math.min(sprite2Bottom, srcBottom));
                    int resultWidth = resultRight - resultLeft;
                    result = resultWidth > 0 && (resultHeight = resultBottom - resultTop) > 0 && Sprite.doPixelCollision(resultWidth, resultHeight, this.frameSet, this.getFrameSetLeft(resultLeft, resultTop, resultRight, resultBottom), this.getFrameSetTop(resultLeft, resultTop, resultRight, resultBottom), this.transformation, src.frameSet, src.getFrameSetLeft(resultLeft, resultTop, resultRight, resultBottom), src.getFrameSetTop(resultLeft, resultTop, resultRight, resultBottom), src.transformation);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean collidesWith(TiledLayer src, boolean pixelLevel) {
        boolean result;
        if (src == null) {
            throw new NullPointerException("Sprite.collidesWith: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (!this.isVisible() || !src.isVisible()) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            Object object2 = src.getMonitor();
            synchronized (object2) {
                block25: {
                    int spriteLeft = this.getX();
                    int spriteTop = this.getY();
                    int spriteRight = spriteLeft + this.getWidth();
                    int spriteBottom = spriteTop + this.getHeight();
                    int thisLeft = spriteLeft + this.transformedCollisionRectLeft;
                    int thisTop = spriteTop + this.transformedCollisionRectTop;
                    int thisRight = thisLeft + this.transformedCollisionRectWidth;
                    int thisBottom = thisTop + this.transformedCollisionRectHeight;
                    int srcLeft = src.getX();
                    int srcTop = src.getY();
                    int srcRight = srcLeft + src.getWidth();
                    int srcBottom = srcTop + src.getHeight();
                    if (!Sprite.isIntersection(thisLeft, thisTop, thisRight, thisBottom, srcLeft, srcTop, srcRight, srcBottom)) {
                        result = false;
                    } else {
                        int resultLeft = Math.max(Math.max(spriteLeft, thisLeft), srcLeft);
                        int resultTop = Math.max(Math.max(spriteTop, thisTop), srcTop);
                        int resultRight = Math.min(Math.min(spriteRight, thisRight), srcRight);
                        int resultBottom = Math.min(Math.min(spriteBottom, thisBottom), srcBottom);
                        if (resultRight - resultLeft <= 0 || resultBottom - resultTop <= 0) {
                            result = false;
                        } else {
                            int cellsWidth = src.getCellWidth();
                            int cellsHeight = src.getCellHeight();
                            int cellLeft = (resultLeft - srcLeft) / cellsWidth;
                            int cellTop = (resultTop - srcTop) / cellsHeight;
                            int cellRight = (resultRight - srcLeft - 1) / cellsWidth;
                            int cellBottom = (resultBottom - srcTop - 1) / cellsHeight;
                            if (!pixelLevel) {
                                int row = cellTop;
                                while (row <= cellBottom) {
                                    int col = cellLeft;
                                    while (col <= cellRight) {
                                        if (src.getTileIndex(col, row) != 0) {
                                            result = true;
                                            break block25;
                                        }
                                        ++col;
                                    }
                                    ++row;
                                }
                                result = false;
                            } else {
                                int cellsPerRow = src.getTilesPerRow();
                                int transform = this.transformation;
                                Image frameSet = this.frameSet;
                                Image tileSet = src.getTileSet();
                                int row = cellTop;
                                while (row <= cellBottom) {
                                    int col = cellLeft;
                                    while (col <= cellRight) {
                                        int cell = src.getTileIndex(col, row);
                                        if (cell != 0) {
                                            int spriteX = srcLeft + col * cellsWidth;
                                            int spriteY = srcTop + row * cellsHeight;
                                            int tileX = --cell % cellsPerRow * cellsWidth;
                                            int tileY = cell / cellsPerRow * cellsHeight;
                                            int width = cellsWidth;
                                            int height = cellsHeight;
                                            int delta = resultLeft - spriteX;
                                            if (delta > 0) {
                                                spriteX += delta;
                                                tileX += delta;
                                                width -= delta;
                                            }
                                            if ((delta = spriteX + width - resultRight) > 0) {
                                                width -= delta;
                                            }
                                            if ((delta = resultTop - spriteY) > 0) {
                                                spriteY += delta;
                                                tileY += delta;
                                                height -= delta;
                                            }
                                            if ((delta = spriteY + height - resultBottom) > 0) {
                                                height -= delta;
                                            }
                                            if (Sprite.doPixelCollision(width, height, frameSet, this.getFrameSetLeft(spriteX, spriteY, width + spriteX, spriteY + height), this.getFrameSetTop(spriteX, spriteY, width + spriteX, spriteY + height), transform, tileSet, tileX, tileY, 0)) {
                                                result = true;
                                                break block25;
                                            }
                                        }
                                        ++col;
                                    }
                                    ++row;
                                }
                                result = false;
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean collidesWith(Image src, int left, int top, boolean pixelLevel) {
        boolean result;
        if (src == null) {
            throw new NullPointerException("Sprite.collidesWith: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (!this.isVisible()) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            int spriteLeft = this.getX();
            int spriteTop = this.getY();
            int spriteRight = spriteLeft + this.getWidth();
            int spriteBottom = spriteTop + this.getHeight();
            int thisLeft = spriteLeft + this.transformedCollisionRectLeft;
            int thisTop = spriteTop + this.transformedCollisionRectTop;
            int thisRight = thisLeft + this.transformedCollisionRectWidth;
            int thisBottom = thisTop + this.transformedCollisionRectHeight;
            int srcLeft = left;
            int srcTop = top;
            int srcRight = srcLeft + src.getWidth();
            int srcBottom = srcTop + src.getHeight();
            if (!Sprite.isIntersection(thisLeft, thisTop, thisRight, thisBottom, srcLeft, srcTop, srcRight, srcBottom)) {
                result = false;
            } else if (!pixelLevel) {
                result = true;
            } else {
                int resultHeight;
                int resultLeft = Math.max(Math.max(spriteLeft, thisLeft), srcLeft);
                int resultTop = Math.max(Math.max(spriteTop, thisTop), srcTop);
                int resultRight = Math.min(Math.min(spriteRight, thisRight), srcRight);
                int resultBottom = Math.min(Math.min(spriteBottom, thisBottom), srcBottom);
                int resultWidth = resultRight - resultLeft;
                result = resultWidth > 0 && (resultHeight = resultBottom - resultTop) > 0 && Sprite.doPixelCollision(resultWidth, resultHeight, this.frameSet, this.getFrameSetLeft(resultLeft, resultTop, resultRight, resultBottom), this.getFrameSetTop(resultLeft, resultTop, resultRight, resultBottom), this.transformation, src, resultLeft - srcLeft, resultTop - srcTop, 0);
            }
        }
        return result;
    }

    public final int getFrame() {
        return this.frameIndex;
    }

    private void setTransformHelper(int newTransform) {
        int oldTransform = this.transformation;
        super.move(this.getTransformedPtX(oldTransform) - this.getTransformedPtX(newTransform), this.getTransformedPtY(oldTransform) - this.getTransformedPtY(newTransform));
        this.computeTransformedBounds(newTransform);
        this.transformation = newTransform;
    }

    private void computeTransformedBounds(int transform) {
        switch (transform) {
            default: {
                return;
            }
            case 0: {
                this.transformedCollisionRectLeft = this.collisionRectLeft;
                this.transformedCollisionRectTop = this.collisionRectTop;
                this.transformedCollisionRectWidth = this.collisionRectWidth;
                this.transformedCollisionRectHeight = this.collisionRectHeight;
                this.setSize(this.frameWidth, this.frameHeight);
                return;
            }
            case 5: {
                int fh = this.frameHeight;
                int crh = this.collisionRectHeight;
                this.transformedCollisionRectLeft = fh - crh - this.collisionRectTop;
                this.transformedCollisionRectTop = this.collisionRectLeft;
                this.transformedCollisionRectWidth = crh;
                this.transformedCollisionRectHeight = this.collisionRectWidth;
                this.setSize(fh, this.frameWidth);
                return;
            }
            case 3: {
                int fw = this.frameWidth;
                int crw = this.collisionRectWidth;
                this.transformedCollisionRectLeft = fw - crw - this.collisionRectLeft;
                int fh = this.frameHeight;
                int crh = this.collisionRectHeight;
                this.transformedCollisionRectTop = fh - crh - this.collisionRectTop;
                this.transformedCollisionRectWidth = crw;
                this.transformedCollisionRectHeight = crh;
                this.setSize(fw, fh);
                return;
            }
            case 6: {
                this.transformedCollisionRectLeft = this.collisionRectTop;
                int fw = this.frameWidth;
                int crw = this.collisionRectWidth;
                this.transformedCollisionRectTop = fw - crw - this.collisionRectLeft;
                this.transformedCollisionRectWidth = this.collisionRectHeight;
                this.transformedCollisionRectHeight = crw;
                this.setSize(this.frameHeight, fw);
                return;
            }
            case 2: {
                int fw = this.frameWidth;
                int crw = this.collisionRectWidth;
                this.transformedCollisionRectLeft = fw - crw - this.collisionRectLeft;
                this.transformedCollisionRectTop = this.collisionRectTop;
                this.transformedCollisionRectWidth = crw;
                this.transformedCollisionRectHeight = this.collisionRectHeight;
                this.setSize(fw, this.frameHeight);
                return;
            }
            case 7: {
                int fh = this.frameHeight;
                int crh = this.collisionRectHeight;
                this.transformedCollisionRectLeft = fh - crh - this.collisionRectTop;
                int fw = this.frameWidth;
                int crw = this.collisionRectWidth;
                this.transformedCollisionRectTop = fw - crw - this.collisionRectLeft;
                this.transformedCollisionRectWidth = crh;
                this.transformedCollisionRectHeight = crw;
                this.setSize(fh, fw);
                return;
            }
            case 1: {
                this.transformedCollisionRectLeft = this.collisionRectLeft;
                int fh = this.frameHeight;
                int crh = this.collisionRectHeight;
                this.transformedCollisionRectTop = fh - crh - this.collisionRectTop;
                this.transformedCollisionRectWidth = this.collisionRectWidth;
                this.transformedCollisionRectHeight = crh;
                this.setSize(this.frameWidth, fh);
                return;
            }
            case 4: 
        }
        this.transformedCollisionRectLeft = this.collisionRectTop;
        this.transformedCollisionRectTop = this.collisionRectLeft;
        this.transformedCollisionRectWidth = this.collisionRectHeight;
        this.transformedCollisionRectHeight = this.collisionRectWidth;
        this.setSize(this.frameHeight, this.frameWidth);
    }

    private int getTransformedPtX(int transform) {
        switch (transform) {
            default: {
                return 0;
            }
            case 0: 
            case 1: {
                return this.refPointX;
            }
            case 5: 
            case 7: {
                return this.frameHeight - this.refPointY - 1;
            }
            case 2: 
            case 3: {
                return this.frameWidth - this.refPointX - 1;
            }
            case 4: 
            case 6: 
        }
        return this.refPointY;
    }

    private int getTransformedPtY(int transform) {
        switch (transform) {
            default: {
                return 0;
            }
            case 0: 
            case 2: {
                return this.refPointY;
            }
            case 4: 
            case 5: {
                return this.refPointX;
            }
            case 1: 
            case 3: {
                return this.frameHeight - this.refPointY - 1;
            }
            case 6: 
            case 7: 
        }
        return this.frameWidth - this.refPointX - 1;
    }

    private int getFrameSetLeft(int left, int top, int right, int bottom) {
        int result;
        switch (this.transformation) {
            default: {
                return 0;
            }
            case 0: 
            case 1: {
                result = left - this.getX();
                break;
            }
            case 4: 
            case 5: {
                result = top - this.getY();
                break;
            }
            case 2: 
            case 3: {
                result = this.getX() + this.getWidth() - right;
                break;
            }
            case 6: 
            case 7: {
                result = this.getY() + this.getHeight() - bottom;
            }
        }
        return result + this.frameSequence[this.frameIndex] % this.framesPerRow * this.frameWidth;
    }

    private int getFrameSetTop(int left, int top, int right, int bottom) {
        int result;
        switch (this.transformation) {
            default: {
                return 0;
            }
            case 0: 
            case 2: {
                result = top - this.getY();
                break;
            }
            case 5: 
            case 7: {
                result = this.getX() + this.getWidth() - right;
                break;
            }
            case 1: 
            case 3: {
                result = this.getY() + this.getHeight() - bottom;
                break;
            }
            case 4: 
            case 6: {
                result = left - this.getX();
            }
        }
        return result + this.frameSequence[this.frameIndex] / this.framesPerRow * this.frameHeight;
    }
}

