/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.midp.player;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.MediaException;
import javax.microedition.media.control.VolumeControl;
import malik.emulator.fileformats.InvalidDataFormatException;
import malik.emulator.fileformats.sound.SoundEncoder;
import malik.emulator.fileformats.sound.sampled.SoundDecoderSampled;
import malik.emulator.fileformats.sound.sampled.wavelib.WaveEncoder;
import malik.emulator.media.sound.SoundPlayer;
import malik.emulator.media.sound.SoundPlayerException;
import malik.emulator.media.sound.SoundPlayerListener;
import malik.emulator.media.sound.SoundPlayerSampled;
import malik.emulator.midp.player.ContentPlayer;
import malik.emulator.midp.player.SoundEncoderGetter;
import malik.emulator.midp.player.SupportedPlayerFormats;

public final class SampledPlayer
extends ContentPlayer
implements SoundPlayerListener,
VolumeControl,
SoundEncoderGetter {
    private boolean stopped;
    private boolean loaded;
    private boolean muted;
    private double microsOnPackedSample;
    private int volume = 100;
    private int startFromIndex;
    private int loopCountSetted = 1;
    private int loopCountRemaining;
    private int channelsCount;
    private int samplesPerSecond;
    private long[] packedSamples;
    private SoundPlayerSampled player;
    private SoundDecoderSampled decoder;
    private String contentType;

    public SampledPlayer(SoundDecoderSampled decoder, String contentType) {
        this.decoder = decoder;
        this.contentType = contentType;
    }

    public void getData(InputStream source) throws IOException, InvalidDataFormatException, MediaException {
        this.decoder.loadFromInputStream(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.state == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.state != 0) {
                SoundDecoderSampled sd;
                this.state = 0;
                this.packedSamples = null;
                SoundPlayerSampled sp = this.player;
                if (sp != null) {
                    sp.close();
                    sp = null;
                    this.player = null;
                }
                if ((sd = this.decoder) != null) {
                    sd.clear();
                    sd = null;
                    this.decoder = null;
                }
                this.deliverEvent("closed", null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void realize() throws MediaException {
        int error = 0;
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                default: {
                    break;
                }
                case 0: {
                    error = 1;
                    break;
                }
                case 100: {
                    if (!this.realizePlayer()) break;
                    error = 2;
                }
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalStateException("Player.realize: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 2: {
                this.deliverEvent("error", "Player.realize: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043c\u0430\u0441\u0441\u0438\u0432 \u043e\u0442\u0441\u0447\u0451\u0442\u043e\u0432 \u0437\u0432\u0443\u043a\u043e\u0432\u043e\u0433\u043e \u0441\u0438\u0433\u043d\u0430\u043b\u0430.");
                throw new MediaException("Player.realize: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043c\u0430\u0441\u0441\u0438\u0432 \u043e\u0442\u0441\u0447\u0451\u0442\u043e\u0432 \u0437\u0432\u0443\u043a\u043e\u0432\u043e\u0433\u043e \u0441\u0438\u0433\u043d\u0430\u043b\u0430.");
            }
        }
        super.realize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prefetch() throws MediaException {
        int error = 0;
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                default: {
                    break;
                }
                case 0: {
                    error = 1;
                    break;
                }
                case 100: {
                    if (this.realizePlayer()) {
                        error = 2;
                        break;
                    }
                    if (this.packedSamples == null) break;
                }
                case 200: {
                    if (!this.prefetchPlayer()) break;
                    error = 3;
                }
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalStateException("Player.prefetch: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 2: {
                this.deliverEvent("error", "Player.prefetch: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043c\u0430\u0441\u0441\u0438\u0432 \u043e\u0442\u0441\u0447\u0451\u0442\u043e\u0432 \u0437\u0432\u0443\u043a\u043e\u0432\u043e\u0433\u043e \u0441\u0438\u0433\u043d\u0430\u043b\u0430.");
                throw new MediaException("Player.prefetch: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043c\u0430\u0441\u0441\u0438\u0432 \u043e\u0442\u0441\u0447\u0451\u0442\u043e\u0432 \u0437\u0432\u0443\u043a\u043e\u0432\u043e\u0433\u043e \u0441\u0438\u0433\u043d\u0430\u043b\u0430.");
            }
            case 3: {
                this.deliverEvent("error", "Player.prefetch: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044e \u0418\u041a\u041c.");
                throw new MediaException("Player.prefetch: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044e \u0418\u041a\u041c.");
            }
        }
        super.prefetch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws MediaException {
        int error = 0;
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                default: {
                    break;
                }
                case 0: {
                    error = 1;
                    break;
                }
                case 100: {
                    if (this.realizePlayer()) {
                        error = 2;
                        break;
                    }
                    if (this.packedSamples == null) break;
                }
                case 200: {
                    if (this.prefetchPlayer()) {
                        error = 3;
                        break;
                    }
                }
                case 300: {
                    int position;
                    if (this.loopCountRemaining == 0) {
                        this.loopCountRemaining = this.loopCountSetted;
                    }
                    long[] psamples = this.packedSamples;
                    SoundPlayerSampled sp = this.player;
                    if (!this.loaded) {
                        this.loaded = true;
                        position = this.startFromIndex;
                        sp.loadBlock(psamples, position, Math.min(psamples.length - position, 65536));
                    } else {
                        position = this.startFromIndex + sp.getCurrentBlockIndex() * 65536 + sp.getCurrentBlockPosition();
                        sp.start();
                    }
                    long mediaTime = (long)(this.microsOnPackedSample * (double)position);
                    this.state = 400;
                    this.deliverEvent("started", new Long(mediaTime));
                }
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalStateException("Player.prefetch: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 2: {
                this.deliverEvent("error", "Player.prefetch: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043c\u0430\u0441\u0441\u0438\u0432 \u043e\u0442\u0441\u0447\u0451\u0442\u043e\u0432 \u0437\u0432\u0443\u043a\u043e\u0432\u043e\u0433\u043e \u0441\u0438\u0433\u043d\u0430\u043b\u0430.");
                throw new MediaException("Player.prefetch: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043c\u0430\u0441\u0441\u0438\u0432 \u043e\u0442\u0441\u0447\u0451\u0442\u043e\u0432 \u0437\u0432\u0443\u043a\u043e\u0432\u043e\u0433\u043e \u0441\u0438\u0433\u043d\u0430\u043b\u0430.");
            }
            case 3: {
                this.deliverEvent("error", "Player.prefetch: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044e \u0418\u041a\u041c.");
                throw new MediaException("Player.prefetch: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044e \u0418\u041a\u041c.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws MediaException {
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                default: {
                    break;
                }
                case 0: {
                    error = true;
                    break;
                }
                case 400: {
                    SoundPlayerSampled sp = this.player;
                    sp.stop();
                    int position = this.startFromIndex + sp.getCurrentBlockIndex() * 65536 + sp.getCurrentBlockPosition();
                    long mediaTime = (long)(this.microsOnPackedSample * (double)position);
                    this.state = 300;
                    this.deliverEvent("stopped", new Long(mediaTime));
                }
            }
        }
        if (error) {
            throw new IllegalStateException("Player.stop: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoopCount(int loopCount) {
        if (loopCount == 0) {
            throw new IllegalArgumentException("Player.setLoopCount: \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u0432\u0442\u043e\u0440\u043e\u0432 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043d\u0443\u043b\u0435\u0432\u044b\u043c.");
        }
        int error = 0;
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case 0: {
                    error = 1;
                    break;
                }
                case 400: {
                    error = 2;
                    break;
                }
                default: {
                    this.loopCountSetted = loopCount;
                    this.loopCountRemaining = loopCount;
                }
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalStateException("Player.setLoopCount: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 2: {
                this.deliverEvent("error", "Player.setLoopCount: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0434\u0430\u0442\u044c \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u0432\u0442\u043e\u0440\u043e\u0432 \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u0432\u043e\u0441\u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0438\u044f.");
                throw new IllegalStateException("Player.setLoopCount: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0434\u0430\u0442\u044c \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u0432\u0442\u043e\u0440\u043e\u0432 \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u0432\u043e\u0441\u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0438\u044f.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long setMediaTime(long time) throws MediaException {
        int error = 0;
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case 0: {
                    error = 1;
                    break;
                }
                case 100: {
                    error = 2;
                    break;
                }
                case 200: {
                    double microsOPS = this.microsOnPackedSample;
                    int maxpos = this.packedSamples.length;
                    long maxTime = (long)(microsOPS * (double)maxpos);
                    time = time < 0L ? 0L : (time > maxTime ? maxTime : time);
                    int position = (int)((double)time / microsOPS);
                    position = position < 0 ? 0 : (position > maxpos ? maxpos : position);
                    this.startFromIndex = position;
                    time = (long)(microsOPS * (double)position);
                    break;
                }
                case 300: {
                    double microsOPS = this.microsOnPackedSample;
                    int maxpos = this.packedSamples.length;
                    long maxTime = (long)(microsOPS * (double)maxpos);
                    time = time < 0L ? 0L : (time > maxTime ? maxTime : time);
                    int position = (int)((double)time / microsOPS);
                    position = position < 0 ? 0 : (position > maxpos ? maxpos : position);
                    this.startFromIndex = position;
                    time = (long)(microsOPS * (double)position);
                    if (!this.loaded) break;
                    this.loaded = false;
                    this.player.reset();
                    break;
                }
                case 400: {
                    double microsOPS = this.microsOnPackedSample;
                    long[] psamples = this.packedSamples;
                    int maxpos = this.packedSamples.length;
                    long maxTime = (long)(microsOPS * (double)maxpos);
                    time = time < 0L ? 0L : (time > maxTime ? maxTime : time);
                    int position = (int)((double)time / microsOPS);
                    position = position < 0 ? 0 : (position > maxpos ? maxpos : position);
                    this.startFromIndex = position;
                    time = (long)(microsOPS * (double)position);
                    this.loaded = true;
                    SoundPlayerSampled sp = this.player;
                    sp.reset();
                    sp.loadBlock(psamples, position, Math.min(psamples.length - position, 65536));
                }
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalStateException("Player.setMediaTime: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 2: {
                this.deliverEvent("error", "Player.setMediaTime: \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0435\u0449\u0451 \u043d\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0430.");
                throw new IllegalStateException("Player.setMediaTime: \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0435\u0449\u0451 \u043d\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0430.");
            }
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMediaTime() {
        long result;
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case 0: {
                    error = true;
                    result = 0L;
                    break;
                }
                case 100: {
                    result = -1L;
                    break;
                }
                default: {
                    int position;
                    if (this.loaded) {
                        SoundPlayerSampled sp = this.player;
                        position = this.startFromIndex + sp.getCurrentBlockIndex() * 65536 + sp.getCurrentBlockPosition();
                    } else {
                        position = this.startFromIndex;
                    }
                    result = (long)(this.microsOnPackedSample * (double)position);
                }
            }
        }
        if (error) {
            throw new IllegalStateException("Player.getMediaTime: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDuration() {
        long result;
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case 0: {
                    error = true;
                    result = 0L;
                    break;
                }
                case 100: {
                    result = -1L;
                    break;
                }
                default: {
                    int position = this.packedSamples.length;
                    result = (long)(this.microsOnPackedSample * (double)position);
                }
            }
        }
        if (error) {
            throw new IllegalStateException("Player.getMediaTime: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadBlock(SoundPlayer player, int blockIndex) {
        Object object = this.lock;
        synchronized (object) {
            long[] psamples = this.packedSamples;
            int len = this.packedSamples.length;
            if (blockIndex < 0) {
                int position = len;
                long duration = (long)(this.microsOnPackedSample * (double)position);
                if (--this.loopCountRemaining == 0) {
                    this.loaded = false;
                    this.state = 300;
                    this.deliverEvent("endOfMedia", new Long(duration));
                } else {
                    player.loadBlock(psamples, 0, Math.min(position, 65536));
                    this.deliverEvent("endOfMedia", new Long(duration));
                    this.deliverEvent("started", new Long(0L));
                }
            } else {
                int position = this.startFromIndex + blockIndex * 65536;
                if (position >= 0 && position < len) {
                    player.loadBlock(psamples, position, Math.min(len - position, 65536));
                }
            }
        }
    }

    public void setMute(boolean mute) {
        this.muted = mute;
        if (this.muted != this.muted) {
            SoundPlayerSampled sp = this.player;
            if (sp != null) {
                sp.setVolume(SupportedPlayerFormats.midpVolumeToDeviceVolume(mute ? 0 : this.volume));
            }
            this.deliverEvent("volumeChanged", this);
        }
    }

    public boolean isMuted() {
        return this.muted;
    }

    public int setLevel(int volume) {
        SoundPlayerSampled sp = this.player;
        volume = sp != null ? SupportedPlayerFormats.deviceVolumeToMIDPVolume(sp.setVolume(SupportedPlayerFormats.midpVolumeToDeviceVolume(this.muted ? 0 : volume))) : SupportedPlayerFormats.midpVolumeToMIDPVolume(volume);
        this.volume = volume;
        if (this.volume != volume) {
            this.deliverEvent("volumeChanged", this);
        }
        return volume;
    }

    public int getLevel() {
        return this.volume;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoundEncoder getSoundEncoder() throws InvalidDataFormatException {
        long[] psamples;
        int error = 0;
        Object object = this.lock;
        synchronized (object) {
            if (this.state == 0) {
                error = 1;
                psamples = null;
            } else {
                psamples = this.packedSamples;
                if (this.packedSamples == null) {
                    error = 2;
                }
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalStateException("SoundEncoderGetter.getSoundEncoder: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 2: {
                throw new IllegalStateException("SoundEncoderGetter.getSoundEncoder: \u0434\u0430\u043d\u043d\u044b\u0435 \u0435\u0449\u0451 \u043d\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u044b.");
            }
        }
        int len = psamples.length;
        short[] samples = new short[len << 2];
        int i = 0;
        int j = 0;
        while (j < len) {
            int n = i++;
            long psample = psamples[j];
            samples[n] = (short)psample;
            samples[i++] = (short)(psample >> 16);
            samples[i++] = (short)(psample >> 32);
            samples[i++] = (short)(psample >> 48);
            ++j;
        }
        WaveEncoder result = new WaveEncoder();
        result.setSamples(this.channelsCount, this.samplesPerSecond, samples);
        return result;
    }

    protected void unrealize() {
        SoundDecoderSampled sd = this.decoder;
        if (sd != null) {
            this.stopped = true;
            sd.stopLoading();
        }
        super.unrealize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unprefetch() {
        Object object = this.lock;
        synchronized (object) {
            SoundPlayerSampled sp = this.player;
            if (sp != null) {
                sp.close();
                this.player = null;
                this.loaded = false;
                this.startFromIndex = 0;
            }
            super.unprefetch();
        }
    }

    protected String getPlayerContentType() {
        return this.contentType;
    }

    private boolean realizePlayer() {
        this.stopped = false;
        SoundDecoderSampled sd = this.decoder;
        short[] samples = sd.getSamples();
        if (samples == null) {
            return false;
        }
        int len = samples.length;
        if (len < 4) {
            return true;
        }
        long[] psamples = new long[len >>= 2];
        int j = len - 1 << 2;
        int i = len;
        while (i-- > 0) {
            if (this.stopped) {
                return false;
            }
            psamples[i] = (long)(samples[j] & 0xFFFF) | (long)(samples[j + 1] & 0xFFFF) << 16 | (long)(samples[j + 2] & 0xFFFF) << 32 | (long)(samples[j + 3] & 0xFFFF) << 48;
            j -= 4;
        }
        int ch = sd.getChannels();
        int ss = sd.getSamplesPerSecond();
        long samplesOC = ch * ss;
        long duration = (long)len * 4000000L / samplesOC;
        this.decoder = null;
        this.microsOnPackedSample = 4000000.0 / (double)samplesOC;
        this.channelsCount = ch;
        this.samplesPerSecond = ss;
        this.packedSamples = psamples;
        this.state = 200;
        this.deliverEvent("durationUpdated", new Long(duration));
        return false;
    }

    private boolean prefetchPlayer() {
        boolean result;
        try {
            SoundPlayerSampled sp;
            this.player = sp = SoundPlayerSampled.open((int)this.samplesPerSecond, (int)16, (int)this.channelsCount, (int)Math.min(Math.max(256, this.packedSamples.length), 65536));
            sp.setSoundPlayerListener((SoundPlayerListener)this);
            sp.setVolume(this.muted ? 0 : SupportedPlayerFormats.midpVolumeToDeviceVolume(this.volume));
            this.state = 300;
            result = false;
        }
        catch (SoundPlayerException e) {
            e.printRealStackTrace();
            result = true;
        }
        return result;
    }
}

