/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.midp;

import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.MIDletProxy;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import malik.emulator.fileformats.sound.SoundEncoder;
import malik.emulator.io.cloud.FileOutputStream;
import malik.emulator.midp.ConsoleCommand;
import malik.emulator.midp.player.SampledPlayer;
import malik.emulator.midp.player.SoundEncoderGetter;
import malik.emulator.midp.player.SyntheticPlayer;

final class SoundCommand
extends ConsoleCommand
implements Runnable,
CommandListener,
ItemCommandListener,
ItemStateListener {
    private boolean terminated;
    private int soundIndex;
    private SoundEncoderGetter[] allSounds;
    private Player[] allPlayers;
    private Command commandCancel;
    private Command commandBack;
    private Command commandSaveDialog;
    private Command commandSaveToFile;
    private Gauge itemLoadingProgress;
    private StringItem itemCurrentSound;
    private Item itemPrevSound;
    private Item itemNextSound;
    private TextField itemFileNameMID;
    private TextField itemFileNameWAV;
    private Alert screenLoading;
    private Form screenSounds;
    private Form screenSaveMID;
    private Form screenSaveWAV;

    SoundCommand() {
        super("\u0437\u0432\u0443\u043a\u0438");
    }

    public void run(String[] arguments) {
        this.terminated = false;
        this.getItemLoadingProgress().setValue(0);
        MIDletProxy.getInstance().getEmulatorScreen().setCurrent(this.getScreenLoading());
        new Thread((Runnable)this, "\u041f\u043e\u0438\u0441\u043a \u0437\u0432\u0443\u043a\u043e\u0432\u2026").start();
    }

    public void run() {
        Object current;
        Gauge progress = this.itemLoadingProgress;
        if (progress == null) {
            return;
        }
        Object[] memory = Memory.getAllObjects();
        int memoryLength = memory.length;
        int soundsCount = 0;
        int i = 0;
        while (i < memoryLength) {
            if (this.terminated) {
                return;
            }
            current = memory[i];
            if (current != null && current instanceof SoundEncoderGetter && current instanceof Player) {
                ++soundsCount;
            }
            progress.setValue((i << 4) / memoryLength);
            ++i;
        }
        SoundEncoderGetter[] soundsList = new SoundEncoderGetter[soundsCount];
        Player[] playersList = new Player[soundsCount];
        soundsCount = 0;
        i = 0;
        while (i < memoryLength) {
            if (this.terminated) {
                return;
            }
            current = memory[i];
            if (current != null && current instanceof SoundEncoderGetter && current instanceof Player) {
                soundsList[soundsCount] = (SoundEncoderGetter)current;
                playersList[soundsCount] = (Player)current;
                ++soundsCount;
            }
            progress.setValue((i << 4) / memoryLength + 16);
            ++i;
        }
        progress.setValue(32);
        this.soundIndex = 0;
        this.allSounds = soundsList;
        this.allPlayers = playersList;
        MIDletProxy.getInstance().getEmulatorScreen().setCurrent(this.getScreenSounds());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commandAction(Command command, Displayable screen) {
        String fileName;
        Display display = MIDletProxy.getInstance().getEmulatorScreen();
        if (screen == this.screenLoading && command == this.commandCancel) {
            this.terminated = true;
            this.allSounds = null;
            this.allPlayers = null;
            this.commandCancel = null;
            this.itemLoadingProgress = null;
            this.screenLoading = null;
            display.setCurrent((Displayable)this.getConsoleScreen());
            return;
        }
        if (screen == this.screenSounds) {
            if (command == this.commandSaveDialog) {
                int idx = this.soundIndex;
                SoundEncoderGetter[] list = this.allSounds;
                if (idx < this.allSounds.length) {
                    SoundEncoderGetter current = list[idx];
                    if (current instanceof SyntheticPlayer) {
                        display.setCurrent(this.getScreenSaveMID());
                        return;
                    }
                    if (!(current instanceof SampledPlayer)) return;
                    display.setCurrent(this.getScreenSaveWAV());
                    return;
                }
            }
            if (command != this.commandBack) return;
            this.allSounds = null;
            this.allPlayers = null;
            this.commandCancel = null;
            this.commandBack = null;
            this.commandSaveDialog = null;
            this.commandSaveToFile = null;
            this.itemLoadingProgress = null;
            this.itemCurrentSound = null;
            this.itemPrevSound = null;
            this.itemNextSound = null;
            this.itemFileNameMID = null;
            this.itemFileNameWAV = null;
            this.screenLoading = null;
            this.screenSounds = null;
            this.screenSaveMID = null;
            this.screenSaveWAV = null;
            display.setCurrent((Displayable)this.getConsoleScreen());
            return;
        }
        if (screen == this.screenSaveMID) {
            display.setCurrent(this.getScreenSounds());
            if (command != this.commandSaveToFile) return;
            fileName = this.itemFileNameMID.getString();
        } else {
            if (screen != this.screenSaveWAV) return;
            display.setCurrent(this.getScreenSounds());
            if (command != this.commandSaveToFile) return;
            fileName = this.itemFileNameWAV.getString();
        }
        int idx = this.soundIndex;
        SoundEncoderGetter[] list = this.allSounds;
        if (idx >= this.allSounds.length) return;
        new SaveThread(list[idx], fileName).start();
    }

    public void commandAction(Command command, Item item) {
        block10: {
            if (command == List.SELECT_COMMAND) {
                Player[] list = this.allPlayers;
                int len = this.allPlayers.length;
                if (len > 0) {
                    if (item == this.itemCurrentSound) {
                        try {
                            Player current = list[this.soundIndex];
                            if (current.getState() == 400) {
                                current.stop();
                                break block10;
                            }
                            current.start();
                        }
                        catch (MediaException e) {
                            e.printRealStackTrace();
                        }
                    } else if (item == this.itemPrevSound) {
                        this.soundIndex = (this.soundIndex + len - 1) % len;
                    } else if (item == this.itemNextSound) {
                        this.soundIndex = (this.soundIndex + 1) % len;
                    }
                }
            }
        }
    }

    public void itemStateChanged(Item item) {
        TextField field = this.itemFileNameMID;
        if (item == field) {
            String fileName = field.getString();
            if (fileName != null && fileName.length() <= 0) {
                this.screenSaveMID.removeCommand(this.commandSaveToFile);
                return;
            }
            this.screenSaveMID.addCommand(this.commandSaveToFile);
            return;
        }
        field = this.itemFileNameWAV;
        if (item == field) {
            String fileName = field.getString();
            if (fileName != null && fileName.length() <= 0) {
                this.screenSaveWAV.removeCommand(this.commandSaveToFile);
                return;
            }
            this.screenSaveWAV.addCommand(this.commandSaveToFile);
        }
    }

    private Command getCommandCancel() {
        Command result = this.commandCancel;
        if (result == null) {
            result = this.commandCancel = new Command("\u041e\u0442\u043c\u0435\u043d\u0430", 3, 0);
        }
        return result;
    }

    private Command getCommandBack() {
        Command result = this.commandBack;
        if (result == null) {
            result = this.commandBack = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 0);
        }
        return result;
    }

    private Command getCommandSaveDialog() {
        Command result = this.commandSaveDialog;
        if (result == null) {
            result = this.commandSaveDialog = new Command("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c\u2026", 1, 0);
        }
        return result;
    }

    private Command getCommandSaveToFile() {
        Command result = this.commandSaveToFile;
        if (result == null) {
            result = this.commandSaveToFile = new Command("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", 4, 0);
        }
        return result;
    }

    private Gauge getItemLoadingProgress() {
        Gauge result = this.itemLoadingProgress;
        if (result == null) {
            result = this.itemLoadingProgress = new Gauge(null, false, 32, 0);
        }
        return result;
    }

    private Displayable getScreenLoading() {
        Alert result = this.screenLoading;
        if (result == null) {
            result = this.screenLoading = new Alert("\u041b\u044e\u0431\u0438\u0442\u0435 \u043a\u0440\u0430\u0441\u0438\u0442\u044c \u043f\u0430\u0441\u0445\u0430\u043b\u044c\u043d\u044b\u0435 \u044f\u0439\u0446\u0430?", null, null, this.getCommandCancel(), (CommandListener)this, "\u041f\u043e\u0438\u0441\u043a \u0437\u0432\u0443\u043a\u043e\u0432\u2026", null, AlertType.INFO, this.getItemLoadingProgress());
        }
        return result;
    }

    private Displayable getScreenSounds() {
        Form result = this.screenSounds;
        if (result == null) {
            Font font = Font.getFont((int)0, (int)0, (int)0);
            Item[] itemArray = new Item[3];
            this.itemCurrentSound = new StringItem(515, -1, -1, null, null, List.SELECT_COMMAND, (ItemCommandListener)this, "> ||", font, 2);
            itemArray[0] = this.itemCurrentSound;
            itemArray[1] = this.itemPrevSound = new StringItem(3, -1, -1, null, null, List.SELECT_COMMAND, (ItemCommandListener)this, "< \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0438\u0439", font, 2);
            itemArray[2] = this.itemNextSound = new StringItem(3, -1, -1, null, null, List.SELECT_COMMAND, (ItemCommandListener)this, "\u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 >", font, 2);
            Item[] items = itemArray;
            Command[] commands = new Command[]{this.getCommandBack(), this.getCommandSaveDialog()};
            result = this.screenSounds = new Form("\u0417\u0432\u0443\u043a\u0438", null, commands, (CommandListener)this, items, null);
        }
        return result;
    }

    private Displayable getScreenSaveMID() {
        Form result = this.screenSaveMID;
        if (result == null) {
            TextField fileName;
            Item[] itemArray = new Item[1];
            this.itemFileNameMID = fileName = new TextField("\u0418\u043c\u044f \u0444\u0430\u0439\u043b\u0430", "/\u0438\u043c\u044f.mid", 32, 0);
            itemArray[0] = fileName;
            Item[] items = itemArray;
            Command[] commands = new Command[]{this.getCommandSaveToFile(), this.getCommandBack()};
            result = this.screenSaveMID = new Form("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", null, commands, (CommandListener)this, items, (ItemStateListener)this);
            fileName.setPreferredSize(result.getWidth(), -1);
        }
        return result;
    }

    private Displayable getScreenSaveWAV() {
        Form result = this.screenSaveWAV;
        if (result == null) {
            TextField fileName;
            Item[] itemArray = new Item[1];
            this.itemFileNameWAV = fileName = new TextField("\u0418\u043c\u044f \u0444\u0430\u0439\u043b\u0430", "/\u0438\u043c\u044f.wav", 32, 0);
            itemArray[0] = fileName;
            Item[] items = itemArray;
            Command[] commands = new Command[]{this.getCommandSaveToFile(), this.getCommandBack()};
            result = this.screenSaveWAV = new Form("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", null, commands, (CommandListener)this, items, (ItemStateListener)this);
            fileName.setPreferredSize(result.getWidth(), -1);
        }
        return result;
    }

    private static final class SaveThread
    extends Thread {
        private SoundEncoderGetter sound;
        private String fileName;

        SaveThread(SoundEncoderGetter sound, String fileName) {
            super("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0437\u0432\u0443\u043a\u0430\u2026");
            this.sound = sound;
            this.fileName = fileName;
        }

        public void run() {
            String fileName = this.fileName;
            SoundEncoderGetter sound = this.sound;
            try {
                System.out.println("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0437\u0432\u0443\u043a\u0430 \u0432 \u0444\u0430\u0439\u043b " + fileName + "\u2026");
                SoundEncoder encoder = sound.getSoundEncoder();
                FileOutputStream file = new FileOutputStream(fileName);
                file.checkOpenError();
                try {
                    encoder.saveToOutputStream((OutputStream)file);
                }
                finally {
                    file.close();
                }
                System.out.println("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0437\u0432\u0443\u043a\u0430 \u0432 \u0444\u0430\u0439\u043b " + fileName + " \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e.");
            }
            catch (IOException e) {
                e.printRealStackTrace();
                System.out.println("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0437\u0432\u0443\u043a\u0430 \u0432 \u0444\u0430\u0439\u043b " + fileName + " \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e \u0441 \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438.");
            }
        }
    }
}

