/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.midp;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.TextOutput;
import javax.microedition.lcdui.TextOutputMultilined;
import javax.microedition.lcdui.TextOutputMultilinedExt;

public class TextOutputMultilinedColor
extends TextOutputMultilinedExt {
    private int maximumLines;
    private int color;
    private int colorsLength;
    private int[] colorsData;

    private static int getColorIndex(int[] colorsData, int colorsLength, int charIndex) {
        int result;
        int posApprox;
        int positionA = 0;
        int positionB = (colorsLength >> 1) - 1;
        while (true) {
            posApprox = positionA + positionB >> 1;
            int charIndexApprox = colorsData[posApprox << 1];
            if (positionA == positionB) break;
            if (charIndex < charIndexApprox) {
                positionB = posApprox - 1;
                if (positionB >= positionA) continue;
                positionB = positionA;
                continue;
            }
            if (charIndex <= charIndexApprox) break;
            positionA = posApprox + 1;
            if (positionA <= positionB) continue;
            positionA = positionB;
        }
        return colorsData[result = posApprox << 1] > charIndex ? result - 2 : result;
    }

    public TextOutputMultilinedColor(int capacity, int maximumLines, int color) {
        super(capacity);
        this.maximumLines = maximumLines;
        this.color = color;
        this.colorsLength = 3;
        int[] nArray = new int[3];
        nArray[1] = color;
        this.colorsData = nArray;
    }

    public void clear() {
        super.clear();
        this.colorsLength = 3;
        int[] c = this.colorsData;
        this.colorsData[0] = 0;
        c[1] = this.color;
        c[2] = 0;
    }

    public void setText(String text) {
        super.setText(text);
        this.colorsLength = 3;
        int[] c = this.colorsData;
        this.colorsData[0] = 0;
        c[1] = this.color;
        c[2] = text != null ? text.length() : 0;
    }

    public void append(String data) {
        super.append(data);
        this.append(data != null ? data.length() : 0);
    }

    public void append(char[] data, int offset, int length) {
        super.append(data, offset, length);
        this.append(length);
    }

    public void append(int data, int radix, boolean upperCase) {
        int length = ((TextOutput)this).length;
        super.append(data, radix, upperCase);
        this.append(((TextOutput)this).length - length);
    }

    public void setColor(int color) {
        this.color = color;
        int len = this.colorsLength - 3;
        int[] c = this.colorsData;
        if (this.colorsData[len] == c[len + 2]) {
            c[len + 1] = color;
        }
    }

    public void deleteStartLines() {
        int charsForDelete;
        int[] l;
        int linesForDelete;
        int lc;
        block9: {
            block8: {
                lc = ((TextOutputMultilined)this).linesCount;
                linesForDelete = lc - this.maximumLines;
                if (linesForDelete <= 0) break block8;
                l = ((TextOutputMultilined)this).linesBounds;
                charsForDelete = ((TextOutputMultilined)this).linesBounds[linesForDelete << 1];
                if (charsForDelete > 0) break block9;
            }
            return;
        }
        if (charsForDelete >= ((TextOutput)this).length) {
            this.clear();
            return;
        }
        int len = this.colorsLength - 2;
        int[] c = this.colorsData;
        int i = 0;
        while (i < len) {
            if (charsForDelete >= c[i] && charsForDelete < c[i + 2]) {
                c[i] = charsForDelete;
                Array.copy((int[])c, (int)i, (int[])c, (int)0, (int)(len -= i - 2));
                i = 0;
                while (i < len) {
                    int n = i;
                    c[n] = c[n] - charsForDelete;
                    i += 2;
                }
                this.colorsLength = len;
                break;
            }
            i += 2;
        }
        len = ((lc -= linesForDelete) << 1) + 1;
        Array.copy((int[])l, (int)(linesForDelete << 1), (int[])l, (int)0, (int)len);
        i = 0;
        while (i < len) {
            int n = i;
            l[n] = l[n] - charsForDelete;
            i += 2;
        }
        ((TextOutputMultilined)this).linesCount = lc;
        char[] ac = ((TextOutput)this).chars;
        len = ((TextOutput)this).length - charsForDelete;
        Array.copy((char[])((TextOutput)this).chars, (int)charsForDelete, (char[])ac, (int)0, (int)len);
        ((TextOutput)this).length = len;
    }

    public void paintLines(Graphics render, int left, int top, int lineStart, int linesCount) {
        int lim = lineStart + linesCount;
        int len = ((TextOutputMultilined)this).linesCount;
        if (lim > len || lim < lineStart || lineStart > len || lineStart < 0) {
            throw new IndexOutOfBoundsException("TextOutputMultilinedColor.paintLines: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        char[] ac = ((TextOutput)this).chars;
        int[] l = ((TextOutputMultilined)this).linesBounds;
        int[] c = this.colorsData;
        len = this.colorsLength;
        Font f = render.getFont();
        int h = f.getHeight();
        int y = top;
        int i = lineStart;
        while (i < lim) {
            int x = left;
            int llim = i << 1;
            int j = l[llim];
            int llen = l[llim + 1];
            llim = j + llen;
            while (j < llim) {
                int cidx = TextOutputMultilinedColor.getColorIndex(c, len, j);
                int clen = c[cidx + 2] - j;
                int rlen = llen < clen ? llen : clen;
                if (rlen <= 0) break;
                llen -= rlen;
                render.setColor(c[cidx + 1]);
                render.drawChars(ac, j, rlen, x, y, 20);
                x += f.charsWidth(ac, j, rlen);
                j += rlen;
            }
            y += h;
            ++i;
        }
    }

    private void append(int charsCount) {
        if (charsCount <= 0) {
            return;
        }
        int[] c = this.colorsData;
        int len = this.colorsLength - 1;
        int col = this.color;
        if (this.colorsData[len - 1] == col) {
            int n = len;
            c[n] = c[n] + charsCount;
            return;
        }
        if (++len == c.length) {
            int[] nArray = c;
            c = this.colorsData = new int[(len << 1) + 1];
            Array.copy((int[])nArray, (int)0, (int[])this.colorsData, (int)0, (int)len);
        }
        c[len++] = col;
        c[len++] = c[len - 3] + charsCount;
        this.colorsLength = len;
    }
}

