/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.compression.zlib;

import malik.emulator.compression.zlib.Checksum32;
import malik.emulator.compression.zlib.Zlib;

public class CRC32
extends Zlib
implements Checksum32 {
    private static final int[] TABLE;
    private int crc;

    static {
        int[] table = new int[256];
        int i = 0;
        while (i < 256) {
            int c = i;
            int j = 8;
            while (j-- > 0) {
                int n = c = (c & 1) != 0 ? 0xEDB88320 ^ c >>> 1 : c >>> 1;
            }
            table[i] = c;
            ++i;
        }
        TABLE = table;
    }

    public CRC32() {
    }

    public CRC32(int crc) {
        this.crc = crc;
    }

    public void update(byte[] buf, int offset, int length) {
        int c = ~this.crc;
        while (length-- > 0) {
            c = TABLE[(c ^ buf[offset++]) & 0xFF] ^ c >>> 8;
        }
        this.crc = ~c;
    }

    public void reset(int init) {
        this.crc = init;
    }

    public void reset() {
        this.crc = 0;
    }

    public int getValue() {
        return this.crc;
    }

    public Checksum32 copy() {
        return new CRC32(this.crc);
    }
}

