/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.fileformats.sound.sampled.wavelib;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import malik.emulator.fileformats.DataDecoder;
import malik.emulator.fileformats.DataHolder;
import malik.emulator.fileformats.InputAdapter;
import malik.emulator.fileformats.InvalidDataFormatException;
import malik.emulator.fileformats.sound.SoundDecoder;
import malik.emulator.fileformats.sound.sampled.SoundDecoderSampled;

public final class WaveDecoder
implements InputAdapter,
SoundDecoder,
DataHolder,
DataDecoder,
SoundDecoderSampled {
    public static final long RIFF_SIGNATURE = 1380533830L;
    private static final int WAVE_SIGNATURE = 1463899717;
    private static final int FMT_SIGNATURE = 1718449184;
    private static final int DATA_SIGNATURE = 1684108385;
    private boolean stopped;
    private int channels;
    private int samplesPerSecond;
    private int bitsPerSample;
    private byte[] data;
    private short[] samples;

    private static int readUnsignedShortLE(InputStream stream) throws IOException {
        int b2;
        int b1 = stream.read();
        if ((b1 | (b2 = stream.read())) < 0) {
            throw new EOFException("DataInputStream: \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043a\u043e\u043d\u0435\u0446 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        return b2 << 8 | b1;
    }

    private static int readIntLE(InputStream stream) throws IOException {
        int b4;
        int b3;
        int b2;
        int b1 = stream.read();
        if ((b1 | (b2 = stream.read()) | (b3 = stream.read()) | (b4 = stream.read())) < 0) {
            throw new EOFException("DataInputStream: \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043a\u043e\u043d\u0435\u0446 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        return b4 << 24 | b3 << 16 | b2 << 8 | b1;
    }

    public void loadFromInputStream(InputStream stream) throws IOException, InvalidDataFormatException {
        this.loadFromDataStream(new DataInputStream(stream));
    }

    public void loadFromDataStream(DataInputStream stream) throws IOException, InvalidDataFormatException {
        boolean headerHandled = false;
        boolean dataHandled = false;
        int align = 0;
        int riffSize = WaveDecoder.readIntLE(stream) - 4;
        if (riffSize < 0 || stream.readInt() != 1463899717) {
            throw new InvalidDataFormatException("\u0414\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 Wave-\u0444\u0430\u0439\u043b\u043e\u0432: \u0442\u0438\u043f \u0444\u0430\u0439\u043b\u0430 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e WAVE.");
        }
        this.clear();
        while (riffSize > 0) {
            int chunkStart = stream.readInt();
            int chunkLength = WaveDecoder.readIntLE(stream);
            if ((riffSize -= chunkLength + 8) < 0) {
                throw new InvalidDataFormatException("\u0414\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 Wave-\u0444\u0430\u0439\u043b\u043e\u0432: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0444\u0430\u0439\u043b\u0430.");
            }
            switch (chunkStart) {
                default: {
                    stream.skip(chunkLength);
                    break;
                }
                case 1718449184: {
                    if (chunkLength < 16) {
                        throw new InvalidDataFormatException("\u0414\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 Wave-\u0444\u0430\u0439\u043b\u043e\u0432: \u043c\u0430\u043b\u0435\u043d\u044c\u043a\u0430\u044f \u0434\u043b\u0438\u043d\u0430 \u0432\u0430\u0436\u043d\u043e\u0433\u043e \u043a\u0443\u0441\u043a\u0430 fmt.");
                    }
                    headerHandled = true;
                    int cm = WaveDecoder.readUnsignedShortLE(stream);
                    int nc = WaveDecoder.readUnsignedShortLE(stream);
                    int ss = WaveDecoder.readIntLE(stream);
                    int bs = WaveDecoder.readIntLE(stream);
                    int ba = WaveDecoder.readUnsignedShortLE(stream);
                    int bt = WaveDecoder.readUnsignedShortLE(stream);
                    if (cm != 1 || nc != 1 && nc != 2 || ss <= 0 || ss > 65535 || bt != 8 && bt != 16 || bs != ss * nc * bt >> 3 || ba != nc * bt >> 3) {
                        throw new InvalidDataFormatException("\u0414\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 Wave-\u0444\u0430\u0439\u043b\u043e\u0432: \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0442\u0430\u043a\u043e\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
                    }
                    if ((chunkLength -= 16) > 0) {
                        stream.skip(chunkLength);
                    }
                    align = ba;
                    this.channels = nc;
                    this.samplesPerSecond = ss;
                    this.bitsPerSample = bt;
                    break;
                }
                case 1684108385: {
                    if (!headerHandled) {
                        this.clear();
                        throw new InvalidDataFormatException("\u0414\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 Wave-\u0444\u0430\u0439\u043b\u043e\u0432: \u043a\u0443\u0441\u043e\u043a \u0444\u043e\u0440\u043c\u0430\u0442\u0430 fmt \u043c\u043e\u0436\u0435\u0442 \u0438\u0434\u0442\u0438 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0435\u0440\u0435\u0434 \u043a\u0443\u0441\u043a\u043e\u043c \u0434\u0430\u043d\u043d\u044b\u0445 data.");
                    }
                    if (chunkLength % align != 0) {
                        this.clear();
                        throw new InvalidDataFormatException("\u0414\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 Wave-\u0444\u0430\u0439\u043b\u043e\u0432: \u0440\u0430\u0437\u043c\u0435\u0440 \u043a\u0443\u0441\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435 \u043a\u0440\u0430\u0442\u0435\u043d \u0432\u044b\u0440\u0430\u0432\u043d\u0438\u0432\u0430\u043d\u0438\u044e.");
                    }
                    dataHandled = true;
                    byte[] data = new byte[chunkLength];
                    stream.read(data);
                    this.data = data;
                    this.samples = null;
                }
            }
            if ((chunkLength & 1) == 0 || riffSize <= 0) continue;
            --riffSize;
            stream.skip(1L);
        }
        if (!dataHandled) {
            this.clear();
            throw new InvalidDataFormatException("\u0414\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 Wave-\u0444\u0430\u0439\u043b\u043e\u0432: \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432\u0430\u0436\u043d\u044b\u0439 \u043a\u0443\u0441\u043e\u043a \u0434\u0430\u043d\u043d\u044b\u0445 data.");
        }
    }

    public void stopLoading() {
        this.stopped = true;
    }

    public void clear() {
        this.stopped = false;
        this.channels = 0;
        this.samplesPerSecond = 0;
        this.bitsPerSample = 0;
        this.data = null;
        this.samples = null;
    }

    public boolean isEmpty() {
        return this.data == null && this.samples == null;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getSamplesPerSecond() {
        return this.samplesPerSecond;
    }

    public short[] getSamples() {
        short[] result = this.samples;
        if (this.samples == null) {
            byte[] data = this.data;
            if (this.data == null) {
                return null;
            }
            int bt = this.bitsPerSample >> 3;
            int len = data.length / bt;
            result = new short[len];
            boolean stop = false;
            block0 : switch (bt) {
                case 1: {
                    int i = len;
                    while (i-- > 0) {
                        if (this.stopped) {
                            stop = true;
                            break block0;
                        }
                        result[i] = (short)((data[i] ^ 0x80) << 8);
                    }
                    break;
                }
                case 2: {
                    int j = len - 1 << 1;
                    int i = len;
                    while (i-- > 0) {
                        if (this.stopped) {
                            stop = true;
                            break block0;
                        }
                        result[i] = (short)(data[j] & 0xFF | data[j + 1] << 8);
                        j -= 2;
                    }
                    break;
                }
            }
            if (stop) {
                return null;
            }
            this.samples = result;
            this.data = null;
        }
        return result;
    }
}

