/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.system;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import malik.emulator.microedition.DeviceManager;
import malik.emulator.microedition.system.BackgroundConsoleCommand;
import malik.emulator.microedition.system.Console;
import malik.emulator.microedition.system.SystemManager;

abstract class SearchConsoleCommand
extends BackgroundConsoleCommand
implements Runnable {
    private static final int SEARCH = 1;
    private static final int CANCELLED = 2;
    private static final int INITIALIZED = 3;
    private static final int UNINITIALIZED = 0;
    private boolean calledFromConsole;
    private int state;
    protected final SystemManager manager;

    protected SearchConsoleCommand(String name, SystemManager manager) {
        super(name);
        this.manager = manager;
    }

    public void run() {
        switch (this.state) {
            case 1: {
                this.state = 3;
                this.showFoundScreen(DeviceManager.getInstance().getMainDisplay());
                this.manager.switchToSystemDisplay();
                break;
            }
            case 2: {
                this.state = 0;
            }
        }
    }

    protected abstract void searchProcess();

    protected abstract void showProgressScreen(Display var1);

    protected abstract void showFoundScreen(Display var1);

    protected void execute(String[] arguments, Console console) {
        this.calledFromConsole = true;
        this.startSearchProcess();
    }

    protected void executeInBackground() {
        this.calledFromConsole = false;
        this.startSearchProcess();
    }

    protected final void cancelSearchProcess() {
        if (this.state == 1) {
            this.state = 2;
            this.returnToSystem();
        }
    }

    protected final void returnToSystem() {
        if (this.calledFromConsole) {
            DeviceManager.getInstance().getMainDisplay().setCurrent((Displayable)this.manager.console);
            return;
        }
        this.manager.switchToApplicationDisplay();
    }

    private void startSearchProcess() {
        int s = this.state;
        this.state = 1;
        if (this.calledFromConsole) {
            this.showProgressScreen(DeviceManager.getInstance().getMainDisplay());
        }
        if (s == 2 || s == 1) {
            return;
        }
        new Thread(){

            public void run() {
                SearchConsoleCommand parent = SearchConsoleCommand.this;
                parent.searchProcess();
                DeviceManager.getInstance().getMainDisplay().callSerially((Runnable)parent);
            }
        }.start();
    }
}

