/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.system.protocol;

import java.io.IOException;
import java.util.Hashtable;
import malik.emulator.microedition.system.protocol.InboundConnection;
import malik.emulator.util.RunnableQueue;

public final class InboundConnections {
    public static final int TCP = 0;
    public static final int UDP = 1;
    public static final InboundConnections instance = new InboundConnections();
    final Hashtable connections = new Hashtable();
    final RunnableQueue events = new RunnableQueue();

    private InboundConnections() {
        new Thread("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0441\u043e\u0431\u044b\u0442\u0438\u0439 \u043e\u0442 \u0432\u0445\u043e\u0434\u044f\u0449\u0438\u0445 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0439"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                RunnableQueue events = InboundConnections.this.events;
                while (true) {
                    Runnable event = null;
                    RunnableQueue runnableQueue = events;
                    synchronized (runnableQueue) {
                        while (true) {
                            try {
                                events.wait();
                            }
                            catch (InterruptedException e) {
                                e.printRealStackTrace();
                                continue;
                            }
                            break;
                        }
                        if (!events.isEmpty()) {
                            event = events.peekHeadRunnable();
                            events.removeHeadElement();
                        }
                    }
                    if (event == null) continue;
                    try {
                        event.run();
                        continue;
                    }
                    catch (RuntimeException e) {
                        e.printRealStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerLocalPort(int protocol, int localPort) throws IOException {
        if (protocol < 0 || protocol > 1) {
            throw new IllegalArgumentException("InboundConnections.registerLocalPort: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 protocol \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (localPort < 0 || localPort > 65535) {
            throw new IllegalArgumentException("InboundConnections.registerLocalPort: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 localPort \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        boolean error = false;
        RunnableQueue runnableQueue = this.events;
        synchronized (runnableQueue) {
            Hashtable connections = this.connections;
            Integer key = new Integer(protocol << 16 | localPort);
            if (connections.containsKey(key)) {
                error = true;
            } else {
                connections.put(key, this);
            }
        }
        if (error) {
            throw new IOException("InboundConnections.registerLocalPort: \u043f\u043e\u0440\u0442 \u0443\u0436\u0435 \u0437\u0430\u0440\u0435\u0437\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInboundConnection(int protocol, int localPort, InboundConnection inboundConnection) {
        if (protocol < 0 || protocol > 1) {
            throw new IllegalArgumentException("InboundConnections.registerInboundConnection: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 protocol \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (localPort < 0 || localPort > 65535) {
            throw new IllegalArgumentException("InboundConnections.registerInboundConnection: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 localPort \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (inboundConnection == null) {
            throw new NullPointerException("InboundConnections.registerInboundConnection: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 inboundConnection \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        RunnableQueue runnableQueue = this.events;
        synchronized (runnableQueue) {
            Hashtable connections = this.connections;
            Integer key = new Integer(protocol << 16 | localPort);
            if (!connections.containsKey(key)) {
                error = true;
            } else {
                connections.put(key, inboundConnection);
            }
        }
        if (error) {
            throw new IllegalStateException("InboundConnections.registerInboundConnection: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u043f\u043e\u0440\u0442 \u043d\u0435 \u0431\u044b\u043b \u0437\u0430\u0440\u0435\u0437\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyReceiveData(int protocol, int localPort, final Object data) {
        RunnableQueue events;
        if (protocol < 0 || protocol > 1) {
            throw new IllegalArgumentException("InboundConnections.notifyReceiveData: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 protocol \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (localPort < 0 || localPort > 65535) {
            throw new IllegalArgumentException("InboundConnections.notifyReceiveData: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 localPort \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        RunnableQueue runnableQueue = events = this.events;
        synchronized (events) {
            final Integer key = new Integer(protocol << 16 | localPort);
            events.addTailElement(new Runnable(){

                public void run() {
                    Object connection = InboundConnections.this.connections.get(key);
                    if (connection instanceof InboundConnection) {
                        ((InboundConnection)connection).receiveData(data);
                    }
                }
            });
            events.notify();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterInboundConnection(int protocol, int localPort) {
        if (protocol < 0 || protocol > 1) {
            throw new IllegalArgumentException("InboundConnections.unregisterInboundConnection: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 protocol \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (localPort < 0 || localPort > 65535) {
            throw new IllegalArgumentException("InboundConnections.unregisterInboundConnection: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 localPort \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        RunnableQueue runnableQueue = this.events;
        synchronized (runnableQueue) {
            this.connections.remove(new Integer(protocol << 16 | localPort));
        }
    }
}

