/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.system.protocol.file;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.file.ConnectionClosedException;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.IllegalModeException;
import malik.emulator.io.cloud.CloudFileSystem;
import malik.emulator.io.vfs.FileAttributes;
import malik.emulator.io.vfs.FileEnumeration;
import malik.emulator.io.vfs.VirtualFileSystemReadOnly;
import malik.emulator.io.vfs.VirtualFileSystemReadWrite;
import malik.emulator.microedition.io.CustomConnection;
import malik.emulator.microedition.system.protocol.file.File;
import malik.emulator.util.StringBuilder;

public final class VFSConnection
extends CustomConnection
implements FileConnection {
    private static final String[] FORBIDDEN_EXTENSIONS = new String[]{"bindbg", "properties"};
    private static final String[] FORBIDDEN_DIRECTORIES = new String[]{"/meta-inf", "/res", "/rms", "/ui"};
    private final int mode;
    private String path;
    private final String host;
    private final VirtualFileSystemReadOnly placero;
    private final VirtualFileSystemReadWrite placerw;

    public static boolean isForbiddenPath(VirtualFileSystemReadOnly place, String path) {
        if (place == null || place == CloudFileSystem.instance) {
            int i;
            String[] rules;
            if ((path = path != null ? path.toLowerCase() : "").lastIndexOf(47) <= 0) {
                rules = FORBIDDEN_EXTENSIONS;
                i = FORBIDDEN_EXTENSIONS.length;
                while (i-- > 0) {
                    if (!path.endsWith(".".concat(rules[i]))) continue;
                    return true;
                }
            }
            rules = FORBIDDEN_DIRECTORIES;
            i = FORBIDDEN_DIRECTORIES.length;
            while (i-- > 0) {
                String rule = rules[i];
                if (!path.equals(rule) && !path.startsWith(rule.concat("/"))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isObjectExists(VirtualFileSystemReadOnly place, String path) {
        try {
            (place == null ? CloudFileSystem.instance : place).readAttributes(path, null);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private static boolean isMatches(String name, String[] matches) {
        int len;
        if (matches == null || (len = matches.length) <= 0) {
            return false;
        }
        if (len-- > 1) {
            int pos = 0;
            int i = 0;
            while (i <= len) {
                String s = matches[i];
                if (i == len) {
                    if (name.length() - s.length() < pos || !name.endsWith(s)) {
                        return false;
                    }
                } else if (i == 0) {
                    if (!name.startsWith(s)) {
                        return false;
                    }
                    pos = s.length();
                } else {
                    int fpos = name.indexOf(s, pos);
                    if (fpos < 0) {
                        return false;
                    }
                    pos = fpos + s.length();
                }
                ++i;
            }
            return true;
        }
        return name.equals(matches[0]);
    }

    private static long directorySize(VirtualFileSystemReadOnly place, String path, boolean includeSubDirectories) throws IOException {
        long result = 0L;
        FileEnumeration enumr = place.findFirst(path);
        if (enumr != null) {
            try {
                do {
                    String name;
                    if (VFSConnection.isForbiddenPath(place, path.concat(name = enumr.getName()))) continue;
                    if (!enumr.isDirectory()) {
                        result += enumr.getSize();
                        continue;
                    }
                    if (!includeSubDirectories) continue;
                    result += VFSConnection.directorySize(place, new StringBuilder().append(path).append(name).append('/').toString(), true);
                } while (enumr.findNext());
            }
            finally {
                enumr.close();
            }
        }
        return result;
    }

    private static String[] getMatches(String filter) {
        if (filter == null) {
            return null;
        }
        int len = 1;
        int j = 0;
        while ((j = filter.indexOf(42, j)) >= 0) {
            ++len;
            ++j;
        }
        String[] result = new String[len];
        int index = 0;
        j = 0;
        int i = 0;
        while ((j = filter.indexOf(42, j)) >= 0) {
            result[index++] = filter.substring(i, j);
            i = ++j;
        }
        result[index] = filter.substring(i);
        return result;
    }

    public VFSConnection(String url, VirtualFileSystemReadOnly place, String path, int mode) {
        super(url);
        int len1 = url.length();
        int len2 = path.length();
        if (len1 < len2) {
            len1 = len2;
        }
        if (place == null) {
            place = CloudFileSystem.instance;
        }
        this.mode = mode;
        this.path = path;
        this.host = url.substring(0, len1 - len2);
        this.placero = place;
        this.placerw = place instanceof VirtualFileSystemReadWrite ? (VirtualFileSystemReadWrite)place : null;
    }

    public void setURL(String url) {
        throw new IllegalStateException("CustomConnection.setURL: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0430\u0434\u0440\u0435\u0441 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f.");
    }

    public void mkdir() throws IOException {
        VirtualFileSystemReadWrite place;
        if (this.isConnectionClosed()) {
            throw new ConnectionClosedException("FileConnection.mkdir: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
        }
        if ((this.mode & 2) == 0) {
            throw new IllegalModeException("FileConnection.mkdir: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0437\u0430\u043f\u0438\u0441\u0438.");
        }
        String path = this.path;
        int lim = path.length() - 1;
        if (lim > 0 && path.charAt(lim) == '/') {
            path = path.substring(0, lim);
        }
        if (VFSConnection.isObjectExists((VirtualFileSystemReadOnly)(place = this.placerw), path)) {
            throw new IOException("FileConnection.mkdir: \u043e\u0431\u044a\u0435\u043a\u0442 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
        }
        int pos = path.lastIndexOf(47);
        if (pos > 1 && !VFSConnection.isObjectExists((VirtualFileSystemReadOnly)place, path.substring(0, pos))) {
            throw new IOException("FileConnection.mkdir: \u043f\u0440\u043e\u043c\u0435\u0436\u0443\u0442\u043e\u0447\u043d\u044b\u0435 \u043f\u0430\u043f\u043a\u0438 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0442.");
        }
        place.createDirectory(path);
    }

    public void create() throws IOException {
        if (this.isConnectionClosed()) {
            throw new ConnectionClosedException("FileConnection.create: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
        }
        if ((this.mode & 2) == 0) {
            throw new IllegalModeException("FileConnection.create: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0437\u0430\u043f\u0438\u0441\u0438.");
        }
        String path = this.path;
        if (path.endsWith("/")) {
            throw new IOException("FileConnection.create: \u0430\u0434\u0440\u0435\u0441 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u0437\u0430\u043a\u0430\u043d\u0447\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u00ab/\u00bb.");
        }
        VirtualFileSystemReadWrite place = this.placerw;
        if (VFSConnection.isObjectExists((VirtualFileSystemReadOnly)place, path)) {
            throw new IOException("FileConnection.create: \u043e\u0431\u044a\u0435\u043a\u0442 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
        }
        place.createFile(path).close();
    }

    public void delete() throws IOException {
        VirtualFileSystemReadWrite place;
        File file;
        if (this.isConnectionClosed()) {
            throw new ConnectionClosedException("FileConnection.delete: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
        }
        if ((this.mode & 2) == 0) {
            throw new IllegalModeException("FileConnection.delete: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0437\u0430\u043f\u0438\u0441\u0438.");
        }
        String path = this.path;
        int lim = path.length() - 1;
        if (lim > 0 && path.charAt(lim) == '/') {
            path = path.substring(0, lim);
        }
        if ((file = File.getOpened((VirtualFileSystemReadOnly)(place = this.placerw), path)) != null) {
            file.close();
        }
        FileAttributes attrs = new FileAttributes();
        place.readAttributes(path, attrs);
        if (attrs.isDirectory()) {
            place.deleteDirectory(path);
            return;
        }
        place.deleteFile(path);
    }

    public void rename(String newName) throws IOException {
        String newPath;
        VirtualFileSystemReadWrite place;
        if (this.isConnectionClosed()) {
            throw new ConnectionClosedException("FileConnection.rename: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
        }
        if ((this.mode & 2) == 0) {
            throw new IllegalModeException("FileConnection.rename: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0437\u0430\u043f\u0438\u0441\u0438.");
        }
        if (newName == null) {
            throw new NullPointerException("FileConnection.rename: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 newName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (newName.indexOf(47) >= 0) {
            throw new IllegalArgumentException("FileConnection.rename: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 newName \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u00ab/\u00bb.");
        }
        String oldPath = this.path;
        int lim = oldPath.length() - 1;
        if (lim <= 0) {
            throw new IOException("FileConnection.rename: \u043d\u0435\u043b\u044c\u0437\u044f \u043f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u0442\u044c \u043f\u0430\u043f\u043a\u0443 \u0441 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435\u043c.");
        }
        boolean hasDir = oldPath.charAt(lim) == '/';
        if (hasDir) {
            oldPath = oldPath.substring(0, lim);
        }
        if (VFSConnection.isForbiddenPath((VirtualFileSystemReadOnly)(place = this.placerw), newPath = oldPath.substring(0, oldPath.lastIndexOf(47) + 1).concat(newName))) {
            throw new SecurityException("FileConnection.rename: \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u043c\u0443 \u043e\u0431\u044a\u0435\u043a\u0442\u0443 \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d \u0434\u043b\u044f \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430 file.");
        }
        File file = File.getOpened((VirtualFileSystemReadOnly)place, oldPath);
        if (file != null) {
            file.close();
        }
        place.move(oldPath, newPath);
        if (hasDir) {
            newPath = newPath.concat("/");
        }
        this.path = newPath;
        super.setURL(this.host.concat(this.path));
    }

    public void truncate(long position) throws IOException {
        VirtualFileSystemReadOnly place;
        File file;
        boolean closed;
        if (this.isConnectionClosed()) {
            throw new ConnectionClosedException("FileConnection.truncate: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
        }
        if ((this.mode & 2) == 0) {
            throw new IllegalModeException("FileConnection.truncate: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0437\u0430\u043f\u0438\u0441\u0438.");
        }
        if (position < 0L) {
            throw new IllegalArgumentException("FileConnection.truncate: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 position \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        String path = this.path;
        int lim = path.length() - 1;
        if (lim > 0 && path.charAt(lim) == '/') {
            path = path.substring(0, lim);
        }
        if (closed = (file = File.getOpened(place = this.placero, path)) == null) {
            file = File.open(place, path, 2);
        }
        try {
            file.truncate(position);
        }
        finally {
            if (closed) {
                file.close();
            }
        }
    }

    public void setHidden(boolean hidden) throws IOException {
        if (this.isConnectionClosed()) {
            throw new ConnectionClosedException("FileConnection.setHidden: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
        }
        if ((this.mode & 2) == 0) {
            throw new IllegalModeException("FileConnection.setHidden: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0437\u0430\u043f\u0438\u0441\u0438.");
        }
        String path = this.path;
        int lim = path.length() - 1;
        if (lim > 0 && path.charAt(lim) == '/') {
            path = path.substring(0, lim);
        }
        VirtualFileSystemReadWrite place = this.placerw;
        FileAttributes attrs = new FileAttributes();
        place.readAttributes(path, attrs);
        int a = attrs.getAttributes();
        a = hidden ? (a |= 2) : (a &= 0xFFFFFFFD);
        attrs.setAttributes(a, attrs.getCreationTime(), attrs.getLastWriteTime(), attrs.getLastAccessTime());
        place.writeAttributes(path, attrs);
    }

    public void setReadable(boolean readable) throws IOException {
    }

    public void setWritable(boolean writable) throws IOException {
        if (this.isConnectionClosed()) {
            throw new ConnectionClosedException("FileConnection.setWritable: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
        }
        if ((this.mode & 2) == 0) {
            throw new IllegalModeException("FileConnection.setWritable: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0437\u0430\u043f\u0438\u0441\u0438.");
        }
        String path = this.path;
        int lim = path.length() - 1;
        if (lim > 0 && path.charAt(lim) == '/') {
            path = path.substring(0, lim);
        }
        VirtualFileSystemReadWrite place = this.placerw;
        FileAttributes attrs = new FileAttributes();
        place.readAttributes(path, attrs);
        int a = attrs.getAttributes();
        a = writable ? (a &= 0xFFFFFFFE) : (a |= 1);
        attrs.setAttributes(a, attrs.getCreationTime(), attrs.getLastWriteTime(), attrs.getLastAccessTime());
        place.writeAttributes(path, attrs);
    }

    public void setFileConnection(String objectName) throws IOException {
        if (this.isConnectionClosed()) {
            throw new ConnectionClosedException("FileConnection.setFileConnection: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
        }
        if (objectName == null) {
            throw new NullPointerException("FileConnection.setFileConnection: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 objectName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (objectName.indexOf(47) >= 0) {
            throw new IllegalArgumentException("FileConnection.setFileConnection: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 objectName \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u00ab/\u00bb.");
        }
        String path = this.path;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        VirtualFileSystemReadOnly place = this.placero;
        int len = path.length();
        if (len > 1) {
            FileAttributes attrs = new FileAttributes();
            place.readAttributes(path, attrs);
            if (!attrs.isDirectory()) {
                throw new IOException("FileConnection.setFileConnection: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441\u0432\u044f\u0437\u0430\u043d\u043e \u043d\u0435 \u0441 \u043f\u0430\u043f\u043a\u043e\u0439.");
            }
        }
        if (".".equals(objectName)) {
            return;
        }
        if ("..".equals(objectName)) {
            if (len <= 0) {
                throw new IllegalArgumentException("FileConnection.setFileConnection: \u0446\u0435\u043b\u0435\u0432\u043e\u0439 \u043f\u0443\u0442\u044c \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
            }
            if ((path = path.substring(0, path.lastIndexOf(47))).length() <= 0) {
                path = "/";
            }
        } else {
            path = new StringBuilder().append(path).append('/').append(objectName).toString();
        }
        if (VFSConnection.isForbiddenPath(place, path)) {
            throw new SecurityException("FileConnection.setFileConnection: \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u043c\u0443 \u043e\u0431\u044a\u0435\u043a\u0442\u0443 \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d \u0434\u043b\u044f \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430 file.");
        }
        if (path.length() > 1) {
            try {
                place.readAttributes(path, null);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("FileConnection.setFileConnection: \u0446\u0435\u043b\u0435\u0432\u043e\u0439 \u043f\u0443\u0442\u044c \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
            }
        }
        this.path = path;
        super.setURL(this.host.concat(this.path));
    }

    public boolean exists() {
        if (this.isConnectionClosed()) {
            throw new ConnectionClosedException("FileConnection.exists: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
        }
        if ((this.mode & 1) == 0) {
            throw new IllegalModeException("FileConnection.exists: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f.");
        }
        String path = this.path;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.length() > 1) {
            try {
                this.placero.readAttributes(path, null);
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        FileAttributes attrs;
        if (this.isConnectionClosed()) {
            throw new ConnectionClosedException("FileConnection.canWrite: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
        }
        if ((this.mode & 1) == 0) {
            throw new IllegalModeException("FileConnection.canWrite: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f.");
        }
        String path = this.path;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.length() <= 0) {
            return true;
        }
        try {
            attrs = new FileAttributes();
            this.placero.readAttributes(path, attrs);
        }
        catch (IOException iOException) {
            return false;
        }
        return !attrs.isReadOnly();
    }

    public boolean isOpen() {
        return !this.isConnectionClosed();
    }

    public boolean isHidden() {
        FileAttributes attrs;
        if (this.isConnectionClosed()) {
            throw new ConnectionClosedException("FileConnection.isHidden: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
        }
        if ((this.mode & 1) == 0) {
            throw new IllegalModeException("FileConnection.isHidden: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f.");
        }
        String path = this.path;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.length() <= 0) {
            return false;
        }
        try {
            attrs = new FileAttributes();
            this.placero.readAttributes(path, attrs);
        }
        catch (IOException iOException) {
            return false;
        }
        return attrs.isHidden();
    }

    public boolean isDirectory() {
        FileAttributes attrs;
        if (this.isConnectionClosed()) {
            throw new ConnectionClosedException("FileConnection.isDirectory: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
        }
        if ((this.mode & 1) == 0) {
            throw new IllegalModeException("FileConnection.isDirectory: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f.");
        }
        String path = this.path;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.length() <= 0) {
            return true;
        }
        try {
            attrs = new FileAttributes();
            this.placero.readAttributes(path, attrs);
        }
        catch (IOException iOException) {
            return false;
        }
        return attrs.isDirectory();
    }

    public long usedSize() {
        if (this.isConnectionClosed()) {
            throw new ConnectionClosedException("FileConnection.usedSize: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
        }
        if ((this.mode & 1) == 0) {
            throw new IllegalModeException("FileConnection.usedSize: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f.");
        }
        throw new SecurityException("FileConnection.usedSize: \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u043a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u043f\u0430\u043f\u043a\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d \u0434\u043b\u044f \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430 file.");
    }

    public long totalSize() {
        if (this.isConnectionClosed()) {
            throw new ConnectionClosedException("FileConnection.totalSize: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
        }
        if ((this.mode & 1) == 0) {
            throw new IllegalModeException("FileConnection.totalSize: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f.");
        }
        throw new SecurityException("FileConnection.totalSize: \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u043a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u043f\u0430\u043f\u043a\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d \u0434\u043b\u044f \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430 file.");
    }

    public long availableSize() {
        if (this.isConnectionClosed()) {
            throw new ConnectionClosedException("FileConnection.availableSize: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
        }
        if ((this.mode & 1) == 0) {
            throw new IllegalModeException("FileConnection.availableSize: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f.");
        }
        throw new SecurityException("FileConnection.availableSize: \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u043a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u043f\u0430\u043f\u043a\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d \u0434\u043b\u044f \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430 file.");
    }

    public long lastModified() {
        FileAttributes attrs;
        if (this.isConnectionClosed()) {
            throw new ConnectionClosedException("FileConnection.lastModified: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
        }
        if ((this.mode & 1) == 0) {
            throw new IllegalModeException("FileConnection.lastModified: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f.");
        }
        String path = this.path;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            attrs = new FileAttributes();
            this.placero.readAttributes(path, attrs);
        }
        catch (IOException iOException) {
            return 0L;
        }
        return attrs.getLastWriteTime();
    }

    public long fileSize() throws IOException {
        long result;
        block11: {
            if (this.isConnectionClosed()) {
                throw new ConnectionClosedException("FileConnection.fileSize: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
            }
            if ((this.mode & 1) == 0) {
                throw new IllegalModeException("FileConnection.fileSize: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f.");
            }
            String path = this.path;
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.length() <= 0) {
                throw new IOException("FileConnection.fileSize: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441\u0432\u044f\u0437\u0430\u043d\u043e \u0441 \u043f\u0430\u043f\u043a\u043e\u0439.");
            }
            try {
                FileEnumeration enumr = this.placero.findFirst(path);
                if (enumr != null) {
                    try {
                        result = enumr.isDirectory() ? -2L : enumr.getSize();
                        break block11;
                    }
                    finally {
                        enumr.close();
                    }
                }
                result = -1L;
            }
            catch (IOException iOException) {
                result = -1L;
            }
        }
        if (result == -2L) {
            throw new IOException("FileConnection.fileSize: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441\u0432\u044f\u0437\u0430\u043d\u043e \u0441 \u043f\u0430\u043f\u043a\u043e\u0439.");
        }
        return result;
    }

    public long directorySize(boolean includeSubDirectories) throws IOException {
        long result;
        String path;
        if (this.isConnectionClosed()) {
            throw new ConnectionClosedException("FileConnection.directorySize: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
        }
        if ((this.mode & 1) == 0) {
            throw new IllegalModeException("FileConnection.directorySize: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f.");
        }
        String pathd = this.path;
        if (pathd.endsWith("/")) {
            path = pathd.substring(0, pathd.length() - 1);
        } else {
            path = pathd;
            pathd = path.concat("/");
        }
        try {
            if (path.length() > 0) {
                VirtualFileSystemReadOnly place = this.placero;
                FileAttributes attrs = new FileAttributes();
                place.readAttributes(path, attrs);
                result = attrs.isDirectory() ? VFSConnection.directorySize(place, pathd, includeSubDirectories) : -2L;
            } else {
                result = VFSConnection.directorySize(this.placero, "/", includeSubDirectories);
            }
        }
        catch (IOException iOException) {
            result = -1L;
        }
        if (result == -2L) {
            throw new IOException("FileConnection.directorySize: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441\u0432\u044f\u0437\u0430\u043d\u043e \u043d\u0435 \u0441 \u043f\u0430\u043f\u043a\u043e\u0439.");
        }
        return result;
    }

    public InputStream openInputStream() throws IOException {
        if (this.isConnectionClosed()) {
            throw new ConnectionClosedException("FileConnection.openInputStream: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
        }
        int mode = this.mode;
        if ((mode & 1) == 0) {
            throw new IllegalModeException("FileConnection.openInputStream: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f.");
        }
        String path = this.path;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.length() <= 0) {
            throw new IOException("FileConnection.openInputStream: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441\u0432\u044f\u0437\u0430\u043d\u043e \u0441 \u043f\u0430\u043f\u043a\u043e\u0439.");
        }
        VirtualFileSystemReadOnly place = this.placero;
        FileAttributes attrs = new FileAttributes();
        place.readAttributes(path, attrs);
        if (attrs.isDirectory()) {
            throw new IOException("FileConnection.openInputStream: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441\u0432\u044f\u0437\u0430\u043d\u043e \u0441 \u043f\u0430\u043f\u043a\u043e\u0439.");
        }
        File file = File.getOpened(place, path);
        return (file != null ? file : File.open(place, path, mode)).openInputStream();
    }

    public DataInputStream openDataInputStream() throws IOException {
        InputStream result = this.openInputStream();
        return new DataInputStream(result);
    }

    public OutputStream openOutputStream() throws IOException {
        if (this.isConnectionClosed()) {
            throw new ConnectionClosedException("FileConnection.openOutputStream: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
        }
        int mode = this.mode;
        if ((mode & 2) == 0) {
            throw new IllegalModeException("FileConnection.openOutputStream: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0437\u0430\u043f\u0438\u0441\u0438.");
        }
        String path = this.path;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.length() <= 0) {
            throw new IOException("FileConnection.openOutputStream: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441\u0432\u044f\u0437\u0430\u043d\u043e \u0441 \u043f\u0430\u043f\u043a\u043e\u0439.");
        }
        VirtualFileSystemReadOnly place = this.placero;
        FileAttributes attrs = new FileAttributes();
        place.readAttributes(path, attrs);
        if (attrs.isDirectory()) {
            throw new IOException("FileConnection.openOutputStream: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441\u0432\u044f\u0437\u0430\u043d\u043e \u0441 \u043f\u0430\u043f\u043a\u043e\u0439.");
        }
        File file = File.getOpened(place, path);
        return (file != null ? file : File.open(place, path, mode)).openOutputStream();
    }

    public OutputStream openOutputStream(long position) throws IOException {
        if (this.isConnectionClosed()) {
            throw new ConnectionClosedException("FileConnection.openOutputStream: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
        }
        int mode = this.mode;
        if ((mode & 2) == 0) {
            throw new IllegalModeException("FileConnection.openOutputStream: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0437\u0430\u043f\u0438\u0441\u0438.");
        }
        String path = this.path;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.length() <= 0) {
            throw new IOException("FileConnection.openOutputStream: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441\u0432\u044f\u0437\u0430\u043d\u043e \u0441 \u043f\u0430\u043f\u043a\u043e\u0439.");
        }
        VirtualFileSystemReadOnly place = this.placero;
        FileAttributes attrs = new FileAttributes();
        place.readAttributes(path, attrs);
        if (attrs.isDirectory()) {
            throw new IOException("FileConnection.openOutputStream: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441\u0432\u044f\u0437\u0430\u043d\u043e \u0441 \u043f\u0430\u043f\u043a\u043e\u0439.");
        }
        File file = File.getOpened(place, path);
        return (file != null ? file : File.open(place, path, mode)).openOutputStream(position);
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        OutputStream result = this.openOutputStream();
        return new DataOutputStream(result);
    }

    public Enumeration list(String filter, boolean includeHidden) throws IOException {
        String path;
        if (this.isConnectionClosed()) {
            throw new ConnectionClosedException("FileConnection.list: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
        }
        if ((this.mode & 1) == 0) {
            throw new IllegalModeException("FileConnection.list: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f.");
        }
        if (filter == null) {
            throw new NullPointerException("FileConnection.list: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 filter \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (filter.indexOf(47) >= 0) {
            throw new IllegalArgumentException("FileConnection.list: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 filter \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u00ab/\u00bb.");
        }
        int len = filter.length();
        if (len <= 0) {
            filter = "*";
            len = "*".length();
        }
        String filter2 = filter.endsWith(".*") ? filter.substring(0, len - ".*".length()) : null;
        String pathd = this.path;
        if (pathd.endsWith("/")) {
            path = pathd.substring(0, pathd.length() - 1);
        } else {
            path = pathd;
            pathd = path.concat("/");
        }
        VirtualFileSystemReadOnly place = this.placero;
        if (path.length() > 1) {
            FileAttributes attrs = new FileAttributes();
            place.readAttributes(path, attrs);
            if (!attrs.isDirectory()) {
                throw new IOException("FileConnection.list: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441\u0432\u044f\u0437\u0430\u043d\u043e \u043d\u0435 \u0441 \u043f\u0430\u043f\u043a\u043e\u0439.");
            }
        }
        String[] filter1matches = VFSConnection.getMatches(filter);
        String[] filter2matches = VFSConnection.getMatches(filter2);
        Vector<String> result = new Vector<String>();
        FileEnumeration enumr = place.findFirst(pathd);
        if (enumr != null) {
            try {
                do {
                    if (!includeHidden && enumr.isHidden()) continue;
                    boolean dir = enumr.isDirectory();
                    String name = enumr.getName();
                    if (!dir && !VFSConnection.isMatches(name, filter1matches) && !VFSConnection.isMatches(name, filter2matches)) continue;
                    result.addElement(dir ? name.concat("/") : name);
                } while (enumr.findNext());
            }
            finally {
                enumr.close();
            }
        }
        return result.elements();
    }

    public Enumeration list() throws IOException {
        String path;
        if (this.isConnectionClosed()) {
            throw new ConnectionClosedException("FileConnection.list: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
        }
        if ((this.mode & 1) == 0) {
            throw new IllegalModeException("FileConnection.list: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f.");
        }
        String pathd = this.path;
        if (pathd.endsWith("/")) {
            path = pathd.substring(0, pathd.length() - 1);
        } else {
            path = pathd;
            pathd = path.concat("/");
        }
        VirtualFileSystemReadOnly place = this.placero;
        if (path.length() > 1) {
            FileAttributes attrs = new FileAttributes();
            place.readAttributes(path, attrs);
            if (!attrs.isDirectory()) {
                throw new IOException("FileConnection.list: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441\u0432\u044f\u0437\u0430\u043d\u043e \u043d\u0435 \u0441 \u043f\u0430\u043f\u043a\u043e\u0439.");
            }
        }
        Vector<String> result = new Vector<String>();
        FileEnumeration enumr = place.findFirst(pathd);
        if (enumr != null) {
            try {
                do {
                    if (enumr.isHidden()) continue;
                    String name = enumr.getName();
                    result.addElement(enumr.isDirectory() ? name.concat("/") : name);
                } while (enumr.findNext());
            }
            finally {
                enumr.close();
            }
        }
        return result.elements();
    }

    public String getName() {
        String path = this.path;
        return path.substring(path.lastIndexOf(47, path.length() - (path.endsWith("/") ? 2 : 1)) + 1);
    }

    public String getPath() {
        String path = this.path;
        return path.substring(0, path.lastIndexOf(47, path.length() - (path.endsWith("/") ? 2 : 1)) + 1);
    }
}

