/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import malik.emulator.i18n.Helper;

public class OutputStreamWriter
extends Writer {
    private Writer writer;

    public OutputStreamWriter(OutputStream stream) {
        if (stream == null) {
            throw new NullPointerException("OutputStreamWriter: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 stream \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        this.writer = Helper.getStreamWriter(stream);
    }

    public OutputStreamWriter(OutputStream stream, String encoding) throws UnsupportedEncodingException {
        if (stream == null) {
            throw new NullPointerException("OutputStreamWriter: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 stream \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        this.writer = Helper.getStreamWriter(stream, encoding);
    }

    public void close() throws IOException {
        Writer writer = this.writer;
        if (writer == null) {
            return;
        }
        this.writer = null;
        this.lock = null;
        writer.close();
    }

    public void flush() throws IOException {
        this.ensureOpen().flush();
    }

    public void write(int src) throws IOException {
        this.ensureOpen().write(src);
    }

    public void write(char[] src) throws IOException {
        if (src == null) {
            throw new NullPointerException("OutputStreamWriter.write: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        this.ensureOpen().write(src);
    }

    public void write(char[] src, int offset, int length) throws IOException {
        if (src == null) {
            throw new NullPointerException("OutputStreamWriter.write: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = src.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("OutputStreamWriter.write: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        this.ensureOpen().write(src, offset, length);
    }

    public void write(String src) throws IOException {
        if (src == null) {
            throw new NullPointerException("OutputStreamWriter.write: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        this.ensureOpen().write(src);
    }

    public void write(String src, int offset, int length) throws IOException {
        if (src == null) {
            throw new NullPointerException("OutputStreamWriter.write: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = src.length();
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new StringIndexOutOfBoundsException("OutputStreamWriter.write: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        this.ensureOpen().write(src, offset, length);
    }

    private Writer ensureOpen() throws IOException {
        Writer result = this.writer;
        if (result == null) {
            throw new IOException("OutputStreamWriter: \u0441\u0438\u043c\u0432\u043e\u043b\u044c\u043d\u044b\u0439 \u043f\u043e\u0442\u043e\u043a \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return result;
    }
}

