/*
 * Decompiled with CFR 0.152.
 */
package java.util;

public abstract class Queue {
    protected int capacity;
    protected int head;
    protected int tail;

    protected Queue() {
    }

    protected Queue(int capacity) {
        this.capacity = capacity;
    }

    public abstract void removeTailElement();

    public void clear() {
        this.tail = this.head;
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public int capacity() {
        return this.capacity - 1;
    }

    public int length() {
        int h = this.head;
        int t = this.tail;
        return h >= t ? h - t : h - t + this.capacity;
    }

    protected void reset(int newCapacity) {
        int h = this.head;
        int t = this.tail;
        this.head = h >= t ? h - t : h - t + this.capacity;
        this.tail = 0;
        this.capacity = newCapacity;
    }

    protected void advanceHead() {
        this.head = (this.head + 1) % this.capacity;
    }

    protected void advanceHead(int elements) {
        this.head = (this.head + elements) % this.capacity;
    }

    protected void advanceTail() {
        this.tail = (this.tail + 1) % this.capacity;
    }

    protected void advanceTail(int elements) {
        this.tail = (this.tail + elements) % this.capacity;
    }

    protected int getFreeElements() {
        int h = this.head;
        int t = this.tail;
        return (h >= t ? this.capacity - (h - t) : t - h) - 1;
    }

    protected long[] expand(long[] queue, int newCapacity) {
        if (queue == null) {
            throw new NullPointerException("Queue.expand: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 queue \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = this.capacity;
        if (queue.length != len) {
            throw new IllegalArgumentException("Queue.expand: \u0434\u043b\u0438\u043d\u0430 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0435\u0451 \u0451\u043c\u043a\u043e\u0441\u0442\u0438.");
        }
        if (newCapacity <= len) {
            throw new IllegalArgumentException("Queue.expand: \u043d\u043e\u0432\u0430\u044f \u0451\u043c\u043a\u043e\u0441\u0442\u044c \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0431\u043e\u043b\u044c\u0448\u0435 \u043f\u0440\u0435\u0436\u043d\u0435\u0439.");
        }
        long[] result = new long[newCapacity];
        int h = this.head;
        int t = this.tail;
        if (h < t) {
            int tmp = len - t;
            Array.copy(queue, t, result, 0, tmp);
            Array.copy(queue, 0, result, tmp, h);
        } else {
            Array.copy(queue, t, result, 0, h - t);
        }
        return result;
    }

    protected Object[] expand(Object[] queue, int newCapacity) {
        if (queue == null) {
            throw new NullPointerException("Queue.expand: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 queue \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = this.capacity;
        if (queue.length != len) {
            throw new IllegalArgumentException("Queue.expand: \u0434\u043b\u0438\u043d\u0430 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0435\u0451 \u0451\u043c\u043a\u043e\u0441\u0442\u0438.");
        }
        if (newCapacity <= len) {
            throw new IllegalArgumentException("Queue.expand: \u043d\u043e\u0432\u0430\u044f \u0451\u043c\u043a\u043e\u0441\u0442\u044c \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0431\u043e\u043b\u044c\u0448\u0435 \u043f\u0440\u0435\u0436\u043d\u0435\u0439.");
        }
        Object[] result = (Object[])Array.create(newCapacity, queue.getClass());
        int h = this.head;
        int t = this.tail;
        if (h < t) {
            int tmp = len - t;
            Array.copy(queue, t, result, 0, tmp);
            Array.copy(queue, 0, result, tmp, h);
        } else {
            Array.copy(queue, t, result, 0, h - t);
        }
        return result;
    }
}

