/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.MIDletProxy;
import javax.microedition.lcdui.Ticker;

public abstract class Canvas
extends Displayable {
    public static final int UP = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 5;
    public static final int DOWN = 6;
    public static final int FIRE = 8;
    public static final int GAME_A = 9;
    public static final int GAME_B = 10;
    public static final int GAME_C = 11;
    public static final int GAME_D = 12;
    public static final int KEY_POUND = 35;
    public static final int KEY_STAR = 42;
    public static final int KEY_NUM0 = 48;
    public static final int KEY_NUM1 = 49;
    public static final int KEY_NUM2 = 50;
    public static final int KEY_NUM3 = 51;
    public static final int KEY_NUM4 = 52;
    public static final int KEY_NUM5 = 53;
    public static final int KEY_NUM6 = 54;
    public static final int KEY_NUM7 = 55;
    public static final int KEY_NUM8 = 56;
    public static final int KEY_NUM9 = 57;
    private static boolean KEY_REPEATED_EVENTS;
    protected int keyStates;
    private boolean clientFocused;
    private boolean suppressKeyEvents;

    public static void setKeyRepeatedEvent(boolean keyRepeatedEvents) {
        KEY_REPEATED_EVENTS = keyRepeatedEvents;
    }

    public static boolean isKeyRepeatedEvent() {
        return KEY_REPEATED_EVENTS;
    }

    private static String getMIDletName() {
        return MIDletProxy.getInstance().getMIDletDescriptor().get("MIDlet-Name");
    }

    protected Canvas() {
        this(false, false, Canvas.getMIDletName(), null, null, null, null, false);
    }

    protected Canvas(boolean fullScreenMode, boolean suppressKeyEvents) {
        this(false, fullScreenMode, Canvas.getMIDletName(), null, null, null, null, suppressKeyEvents);
    }

    protected Canvas(boolean fullScreenMode, String title, Ticker ticker, Command[] commands, Command defaultCommand, CommandListener listener, boolean suppressKeyEvents) {
        this(true, fullScreenMode, title, ticker, commands, defaultCommand, listener, suppressKeyEvents);
    }

    private Canvas(boolean system, boolean fullScreenMode, String title, Ticker ticker, Command[] commands, Command defaultCommand, CommandListener listener, boolean suppressKeyEvents) {
        super(system, fullScreenMode, title, ticker, commands, defaultCommand, listener);
        this.suppressKeyEvents = suppressKeyEvents;
    }

    public void setFullScreenMode(boolean fullScreen) {
        super.setFullScreenMode(fullScreen);
    }

    public int getWidth() {
        return super.getWidth();
    }

    public int getHeight() {
        return super.getHeight();
    }

    public boolean isDoubleBuffered() {
        return true;
    }

    public boolean hasRepeatEvents() {
        return true;
    }

    public boolean hasPointerEvents() {
        return true;
    }

    public boolean hasPointerMotionEvents() {
        return true;
    }

    public int getGameAction(int keyCode) {
        return MIDletProxy.getInstance().keyCodeToGameAction(keyCode);
    }

    public int getKeyCode(int gameAction) {
        return MIDletProxy.getInstance().gameActionToKeyCode(gameAction);
    }

    public String getKeyName(int keyCode) {
        return MIDletProxy.getInstance().getKeyName(keyCode);
    }

    public final void repaint() {
        this.callSeriallyPaintClient(0, 0, this.getClientWidth(), this.getClientHeight());
    }

    public final void repaint(int left, int top, int width, int height) {
        this.callSeriallyPaintClient(left, top, width, height);
    }

    public final void serviceRepaints() {
        MIDletProxy.getInstance().getEmulatorScreen().serviceRepaints(this);
    }

    protected abstract void paint(Graphics var1);

    protected void sizeChanged(int width, int height) {
    }

    protected void showNotify() {
    }

    protected void hideNotify() {
    }

    protected void keyPressed(int keyCode) {
    }

    protected void keyRepeated(int keyCode) {
    }

    protected void keyReleased(int keyCode) {
    }

    protected void pointerPressed(int x, int y) {
    }

    protected void pointerDragged(int x, int y) {
    }

    protected void pointerReleased(int x, int y) {
    }

    void paintClient(Graphics render, int width, int height, int clipLeft, int clipTop, int clipWidth, int clipHeight) {
        Graphics clientRender = this.getClientContext();
        clientRender.reset();
        clientRender.setClip(clipLeft, clipTop, clipWidth, clipHeight);
        this.paint(clientRender);
    }

    void onShow() {
        super.onShow();
        this.keyStates = 0;
        this.clientFocused = false;
        try {
            this.showNotify();
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
    }

    void onHide() {
        this.keyStates = 0;
        this.clientFocused = false;
        try {
            this.hideNotify();
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
        super.onHide();
    }

    void onKeyPressed(int key, int charCode) {
        MIDletProxy proxy;
        int keyCode;
        if (!super.keyHandling(key) && (keyCode = (proxy = MIDletProxy.getInstance()).getKeyCode(key)) != 0) {
            int gameAction = proxy.keyCodeToGameAction(keyCode);
            if (gameAction != 0) {
                this.keyStates |= 1 << gameAction;
            }
            if (!this.suppressKeyEvents || gameAction == 0) {
                try {
                    this.keyPressed(keyCode);
                }
                catch (RuntimeException e) {
                    e.printRealStackTrace();
                }
            }
            return;
        }
        super.onKeyPressed(key, charCode);
    }

    void onKeyRepeated(int key, int charCode) {
        int keyCode;
        if (!(!KEY_REPEATED_EVENTS || super.keyHandling(key) || (keyCode = MIDletProxy.getInstance().getKeyCode(key)) == 0 || this.suppressKeyEvents && MIDletProxy.getInstance().keyCodeToGameAction(keyCode) != 0)) {
            try {
                this.keyRepeated(keyCode);
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
            return;
        }
        super.onKeyRepeated(key, charCode);
    }

    void onKeyReleased(int key) {
        MIDletProxy proxy;
        int keyCode;
        if (!super.keyHandling(key) && (keyCode = (proxy = MIDletProxy.getInstance()).getKeyCode(key)) != 0) {
            int gameAction = proxy.keyCodeToGameAction(keyCode);
            if (gameAction != 0) {
                this.keyStates &= ~(1 << gameAction);
            }
            if (!this.suppressKeyEvents || gameAction == 0) {
                try {
                    this.keyReleased(keyCode);
                }
                catch (RuntimeException e) {
                    e.printRealStackTrace();
                }
            }
            return;
        }
        super.onKeyReleased(key);
    }

    void onPointerPressed(int x, int y, int button) {
        int t;
        int l;
        Display display = MIDletProxy.getInstance().getEmulatorScreen();
        if (button == 0 && !super.coordinateHandling(x, y) && x >= (l = display.getGUIElementLeft(this, 2)) && x < l + display.getGUIElementWidth(this, 2) && y >= (t = display.getGUIElementTop(this, 2)) && y < t + display.getGUIElementHeight(this, 2)) {
            this.clientFocused = true;
            try {
                this.pointerPressed(x - l, y - t);
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
            return;
        }
        super.onPointerPressed(x, y, button);
    }

    void onPointerDragged(int x, int y) {
        if (this.clientFocused) {
            Display display = MIDletProxy.getInstance().getEmulatorScreen();
            int l = display.getGUIElementLeft(this, 2);
            int t = display.getGUIElementTop(this, 2);
            try {
                this.pointerDragged(x - l, y - t);
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
            return;
        }
        super.onPointerDragged(x, y);
    }

    void onPointerReleased(int x, int y, int button) {
        if (this.clientFocused && button == 0) {
            this.clientFocused = false;
            Display display = MIDletProxy.getInstance().getEmulatorScreen();
            int l = display.getGUIElementLeft(this, 2);
            int t = display.getGUIElementTop(this, 2);
            try {
                this.pointerReleased(x - l, y - t);
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
            return;
        }
        super.onPointerReleased(x, y, button);
    }
}

