/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;

public class Command {
    public static final int SCREEN = 1;
    public static final int BACK = 2;
    public static final int CANCEL = 3;
    public static final int OK = 4;
    public static final int HELP = 5;
    public static final int STOP = 6;
    public static final int EXIT = 7;
    public static final int ITEM = 8;
    private int type;
    private int priority;
    private int truncatedWidth;
    private Font truncatedFont;
    private String label;
    private String longLabel;
    private String truncated;

    public Command(String label, int type, int priority) {
        this(label, null, type, priority);
    }

    public Command(String label, String longLabel, int type, int priority) {
        if (label == null) {
            throw new NullPointerException("Command: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 label \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (type < 1 || type > 8) {
            throw new IllegalArgumentException("Command: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 type.");
        }
        this.type = type;
        this.priority = priority;
        this.label = label;
        this.longLabel = longLabel;
    }

    public int getCommandType() {
        return this.type;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLongLabel() {
        return this.longLabel;
    }

    public final int getRealType() {
        return this.type;
    }

    public final int getRealPriority() {
        return this.priority;
    }

    public final String getRealLabel() {
        return this.label;
    }

    public final String getTruncatedLabel(Font font, int width) {
        String result;
        if (font == this.truncatedFont && width == this.truncatedWidth) {
            return this.truncated;
        }
        this.truncatedWidth = width;
        this.truncatedFont = font;
        this.truncated = result = Displayable.truncate(this.label, font, width);
        return result;
    }
}

