/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Graphics;
import malik.emulator.media.graphics.GraphicBuffer;
import malik.emulator.media.graphics.RasterCanvas;

public class GraphicsClipRestricted
extends Graphics {
    private boolean restricted;
    private int left;
    private int top;
    private int width;
    private int height;

    GraphicsClipRestricted(GraphicBuffer buffer) {
        super(buffer);
        this.width = buffer.getWidth();
        this.height = buffer.getHeight();
    }

    GraphicsClipRestricted(RasterCanvas canvas) {
        super(canvas);
        this.width = canvas.getWidth();
        this.height = canvas.getHeight();
    }

    public void reset() {
        super.reset();
        this.restricted = false;
        this.left = 0;
        this.top = 0;
        RasterCanvas canvas = this.getCanvas();
        this.width = canvas.getWidth();
        this.height = canvas.getHeight();
    }

    public void setClip(int left, int top, int width, int height) {
        super.setClip(left, top, width, height);
        if (this.restricted) {
            this.clipRect(this.left - this.getTranslateX(), this.top - this.getTranslateY(), this.width, this.height);
        }
    }

    public void restrictClipRect(int left, int top, int width, int height) {
        int absLeft = left + this.getTranslateX();
        int absTop = top + this.getTranslateY();
        int clipLeft = this.left;
        int clipTop = this.top;
        int clipWidth = this.width;
        int clipHeight = this.height;
        this.restricted = true;
        this.left = Math.max(absLeft, clipLeft);
        this.width = Math.min(absLeft + width, clipLeft + clipWidth) - this.left;
        this.top = Math.max(absTop, clipTop);
        this.height = Math.min(absTop + height, clipTop + clipHeight) - this.top;
        this.clipRect(left, top, width, height);
    }
}

