/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.system;

import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ButtonSet
extends CustomItem {
    private final int width;
    private final int height;
    private int pressed;
    private int count;
    private int[][] buttons;
    private final Image background;
    private final Object monitor;

    public ButtonSet(String label, Image background) {
        super(label);
        if (background == null) {
            throw new NullPointerException("ButtonSet: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 background \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        this.width = background.getWidth() >> 1;
        this.height = background.getHeight();
        this.pressed = -1;
        this.buttons = new int[1][];
        this.background = background;
        this.monitor = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setButton(int buttonID, int left, int top, int width, int height) {
        int buttonLeft = Math.max(0, left);
        int buttonTop = Math.max(0, top);
        int buttonRight = Math.min(this.width, left + width);
        int buttonBottom = Math.min(this.height, top + height);
        if (buttonLeft >= buttonRight || buttonTop >= buttonBottom) {
            return;
        }
        Object object = this.monitor;
        synchronized (object) {
            Object buttons = this.buttons;
            int index = this.indexOf(buttonID, (int[][])buttons);
            if (index >= 0) {
                int[] nArray = buttons[index];
                int[] info = nArray;
                nArray[1] = buttonLeft;
                info[2] = buttonTop;
                info[3] = buttonRight;
                info[4] = buttonBottom;
            } else {
                int len = this.count;
                if (len == ((int[][])buttons).length) {
                    int[][] nArray = buttons;
                    int[][] nArrayArray = new int[(len << 1) + 1][];
                    buttons = nArrayArray;
                    Array.copy((Object[])nArray, (int)0, (Object[])nArrayArray, (int)0, (int)len);
                    this.buttons = buttons;
                }
                buttons[len++] = new int[]{buttonID, buttonLeft, buttonTop, buttonRight, buttonBottom};
                this.count = len;
            }
        }
    }

    public int getPressedButtonID() {
        int p = this.pressed;
        return p >= 0 ? this.buttons[p][0] : 0;
    }

    protected void paint(Graphics render, int contentWidth, int contentHeight) {
        int width = this.width;
        int height = this.height;
        int pressed = this.pressed;
        Image background = this.background;
        render.drawRegion(background, 0, 0, width, height, 0, 0, 0, 0);
        if (pressed >= 0) {
            int[] button = this.buttons[pressed];
            int left = button[1];
            int top = button[2];
            render.drawRegion(background, width + left, top, button[3] - left, button[4] - top, 0, left, top, 0);
        }
    }

    protected void pointerPressed(int x, int y) {
        int index = this.indexOf(x, y, this.buttons);
        if (index >= 0 && index != this.pressed) {
            this.pressed = index;
            super.notifyStateChanged();
            super.repaint();
        }
    }

    protected int getMinContentWidth() {
        return this.width;
    }

    protected int getMinContentHeight() {
        return this.height;
    }

    protected int getPrefContentWidth(int contentHeight) {
        return this.width;
    }

    protected int getPrefContentHeight(int contentWidth) {
        return this.height;
    }

    private int indexOf(int buttonID, int[][] buttons) {
        int i = this.count;
        while (i-- > 0) {
            if (buttons[i][0] != buttonID) continue;
            return i;
        }
        return -1;
    }

    private int indexOf(int x, int y, int[][] buttons) {
        int i = this.count;
        while (i-- > 0) {
            int[] button = buttons[i];
            if (x < button[1] || y < button[2] || x >= button[3] || y >= button[4]) continue;
            return i;
        }
        return -1;
    }
}

