/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.system;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Spacer;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.Ticker;
import malik.emulator.microedition.lcdui.ScrollBarStyle;

public class SettingsForm
extends Form {
    private boolean helpOpened;
    final Item helpShowButton;
    final Item helpHideButton;
    private final Item helpSeparator;
    private final StringItem helpContents;
    private final StringItem applyButton;
    private final StringItem backButton;

    private static Item[] concatItems(Item item1, Item item2, Item[] items, Item item3, Item item4) {
        int srcLen = items != null ? items.length : 0;
        int dstLen = 4 + srcLen;
        Object[] result = new Item[dstLen];
        if (srcLen > 0) {
            Array.copy((Object[])items, (int)0, (Object[])result, (int)2, (int)srcLen);
        }
        result[0] = item1;
        result[1] = item2;
        result[dstLen - 2] = item3;
        result[dstLen - 1] = item4;
        return result;
    }

    private static Item createHelpSeparator() {
        Spacer result = new Spacer(0, 0);
        result.setLayout(512);
        return result;
    }

    private static Item createHelpShowButton() {
        Font font = Font.getFont((int)0, (int)0, (int)8);
        StringItem result = new StringItem(null, "\u0421\u043f\u0440\u0430\u0432\u043a\u0430 >", 2);
        result.setFont(font);
        result.setLayout(1);
        result.setDefaultCommand(List.SELECT_COMMAND);
        return result;
    }

    private static Item createHelpHideButton() {
        Font font = Font.getFont((int)0, (int)0, (int)8);
        StringItem result = new StringItem(null, "< \u0421\u043a\u0440\u044b\u0442\u044c \u0441\u043f\u0440\u0430\u0432\u043a\u0443", 2);
        result.setFont(font);
        result.setLayout(514);
        result.setDefaultCommand(List.SELECT_COMMAND);
        return result;
    }

    private static StringItem createBackButton() {
        Font font = Font.getFont((int)0, (int)1, (int)8);
        StringItem result = new StringItem(null, "\u041d\u0430\u0437\u0430\u0434", 2);
        result.setFont(font);
        result.setLayout(514);
        result.setDefaultCommand(List.SELECT_COMMAND);
        return result;
    }

    private static StringItem createApplyButton() {
        Font font = Font.getFont((int)0, (int)1, (int)8);
        StringItem result = new StringItem(null, "\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c", 2);
        result.setFont(font);
        result.setLayout(258);
        result.setDefaultCommand(List.SELECT_COMMAND);
        return result;
    }

    private static StringItem createHelpContents() {
        Font font = Font.getFont((int)0, (int)0, (int)8);
        StringItem result = new StringItem("\u0421\u043f\u0440\u0430\u0432\u043a\u0430", null, 0);
        result.setFont(font);
        result.setLayout(2560);
        return result;
    }

    public SettingsForm(String title) {
        this(title, null, false, null, null);
    }

    public SettingsForm(String title, Item[] items) {
        this(title, null, false, null, items);
    }

    public SettingsForm(String title, Ticker ticker, boolean fullScreen, ScrollBarStyle style, Item[] items) {
        super(title, ticker, fullScreen, style, SettingsForm.concatItems(SettingsForm.createHelpShowButton(), SettingsForm.createHelpSeparator(), items, (Item)SettingsForm.createApplyButton(), (Item)SettingsForm.createBackButton()));
        int len = super.size();
        ItemCommandListener listener = new ItemCommandListener(){

            public void commandAction(Command command, Item item) {
                SettingsForm parent = SettingsForm.this;
                if (item == parent.helpShowButton) {
                    parent.showHelp();
                } else if (item == parent.helpHideButton) {
                    parent.hideHelp();
                    parent.getVerticalScrollBar().setPosition(0);
                }
            }
        };
        Item helpShowButton = super.get(0);
        Item helpHideButton = SettingsForm.createHelpHideButton();
        helpShowButton.setItemCommandListener(listener);
        helpHideButton.setItemCommandListener(listener);
        this.helpShowButton = helpShowButton;
        this.helpHideButton = helpHideButton;
        this.helpSeparator = super.get(1);
        this.helpContents = SettingsForm.createHelpContents();
        this.applyButton = (StringItem)super.get(len - 2);
        this.backButton = (StringItem)super.get(len - 1);
    }

    public void insert(int itemIndex, Item item) {
        super.insert(itemIndex < 0 || itemIndex > super.size() - 4 ? -1 : itemIndex + 2, item);
    }

    public void delete(int itemIndex) {
        super.delete(itemIndex < 0 || itemIndex >= super.size() - 4 ? -1 : itemIndex + 2);
    }

    public void deleteAll() {
        super.deleteAll();
        if (this.helpOpened) {
            super.append((Item)this.helpContents);
            super.append(this.helpHideButton);
        } else {
            super.append(this.helpShowButton);
            super.append(this.helpSeparator);
        }
        super.append((Item)this.applyButton);
        super.append((Item)this.backButton);
    }

    public void set(int itemIndex, Item item) {
        super.set(itemIndex < 0 || itemIndex >= super.size() - 4 ? -1 : itemIndex + 2, item);
    }

    public int size() {
        return super.size() - 4;
    }

    public int append(Item item) {
        int result = super.size() - 4;
        super.insert(result + 2, item);
        return result;
    }

    public Item get(int itemIndex) {
        return super.get(itemIndex < 0 || itemIndex >= super.size() - 4 ? -1 : itemIndex + 2);
    }

    public void setButtonListener(ItemCommandListener listener) {
        this.applyButton.setItemCommandListener(listener);
        this.backButton.setItemCommandListener(listener);
    }

    public void setHelpContents(String help) {
        this.helpContents.setText(help);
    }

    public String getHelpContents() {
        return this.helpContents.getText();
    }

    public StringItem getHelpContentsItem() {
        return this.helpContents;
    }

    public StringItem getApplyButton() {
        return this.applyButton;
    }

    public StringItem getBackButton() {
        return this.backButton;
    }

    final void showHelp() {
        this.helpOpened = true;
        super.set(0, (Item)this.helpContents);
        super.set(1, this.helpHideButton);
    }

    final void hideHelp() {
        this.helpOpened = false;
        super.set(0, this.helpShowButton);
        super.set(1, this.helpSeparator);
    }
}

