/*
 * Decompiled with CFR 0.152.
 */
package javax.bluetooth;

import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.ServiceRegistrationException;
import javax.microedition.io.Connection;
import javax.microedition.lcdui.MIDletProxy;

public class LocalDevice {
    private static final LocalDevice INSTANCE = new LocalDevice();
    private int discoverable = 0;
    private DiscoveryAgent agent = new DiscoveryAgent();

    public static boolean isPowerOn() {
        return true;
    }

    public static String getProperty(String key) {
        return key == null || !key.startsWith("bluetooth.") ? null : System.getProperty(key);
    }

    public static LocalDevice getLocalDevice() throws BluetoothStateException {
        return INSTANCE;
    }

    private LocalDevice() {
    }

    public void updateRecord(ServiceRecord record) throws ServiceRegistrationException {
        if (record == null) {
            throw new NullPointerException("LocalDevice.updateRecord: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 record \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
    }

    public boolean setDiscoverable(int mode) throws BluetoothStateException {
        if (mode != 0 && (mode < 10390272 || mode > 10390335)) {
            throw new IllegalArgumentException("LocalDevice.setDiscoverable: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 mode.");
        }
        this.discoverable = mode;
        return true;
    }

    public int getDiscoverable() {
        return this.discoverable;
    }

    public String getFriendlyName() {
        return MIDletProxy.getInstance().getMIDletDescriptor().get("MIDlet-Name");
    }

    public String getBluetoothAddress() {
        return "0000000021CD";
    }

    public DeviceClass getDeviceClass() {
        return null;
    }

    public DiscoveryAgent getDiscoveryAgent() {
        return this.agent;
    }

    public ServiceRecord getRecord(Connection notifier) {
        throw new IllegalArgumentException("LocalDevice.getRecord: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 notifier.");
    }
}

