/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.midp;

import java.io.PrintListener;
import java.lang.ref.WeakReference;
import javax.microedition.lcdui.CommandListener;
import malik.emulator.midp.ConsoleScreen;

public final class SystemConsole
extends ConsoleScreen {
    private static final int OUT_COLOR = 49152;
    private static final int ERR_COLOR = 0xFF4040;
    private boolean greeted;
    private boolean doubleOutput;
    private PrintListener outListener;
    private PrintListener errListener;

    SystemConsole(String title, CommandListener listener) {
        super(title, listener);
        Printer outListener = new Printer(this, 49152);
        Printer errListener = new Printer(this, 0xFF4040);
        System.out.addPrintListener(outListener);
        System.err.addPrintListener(errListener);
        this.doubleOutput = true;
        this.outListener = outListener;
        this.errListener = errListener;
    }

    public void printHelp() {
        this.setColor(49152);
        this.print("\u042d\u0442\u0438\u043c \u0446\u0432\u0435\u0442\u043e\u043c");
        this.setColor(this.getOutputColor());
        this.print(" \u043f\u0435\u0447\u0430\u0442\u0430\u0435\u0442\u0441\u044f \u0442\u043e, \u0447\u0442\u043e \u0431\u044b\u043b\u043e \u0432\u044b\u0432\u0435\u0434\u0435\u043d\u043e \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435\u043c \u0447\u0435\u0440\u0435\u0437 System.out\n");
        this.setColor(0xFF4040);
        this.print("\u042d\u0442\u0438\u043c \u0446\u0432\u0435\u0442\u043e\u043c");
        this.setColor(this.getOutputColor());
        this.print(" \u043f\u0435\u0447\u0430\u0442\u0430\u0435\u0442\u0441\u044f \u0442\u043e, \u0447\u0442\u043e \u0431\u044b\u043b\u043e \u0432\u044b\u0432\u0435\u0434\u0435\u043d\u043e \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435\u043c \u0447\u0435\u0440\u0435\u0437 System.err\n");
        super.printHelp();
    }

    public void setDoubleOutput(boolean doubleOutput) {
        this.doubleOutput = doubleOutput;
        if (this.doubleOutput) {
            System.out.addPrintListener(this.outListener);
            System.err.addPrintListener(this.errListener);
        } else {
            System.out.removePrintListener(this.outListener);
            System.err.removePrintListener(this.errListener);
        }
    }

    public boolean isDoubleOutput() {
        return this.doubleOutput;
    }

    public int getWidth() {
        return super.getWidth();
    }

    public int getHeight() {
        return super.getHeight();
    }

    protected void $finalize$() {
        System.out.removePrintListener(this.outListener);
        System.err.removePrintListener(this.errListener);
    }

    protected void onShow() {
        super.onShow();
        if (!this.greeted) {
            this.greeted = true;
            this.setColor(0xC0C0C0);
            this.print("\u0414\u043e\u0431\u0440\u043e \u043f\u043e\u0436\u0430\u043b\u043e\u0432\u0430\u0442\u044c \u0432 " + super.getTitle() + "!\n\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u0443 \u00ab?\u00bb \u043d\u0430 \u043a\u043e\u043d\u0441\u043e\u043b\u0438, \u0447\u0442\u043e\u0431\u044b \u0443\u0432\u0438\u0434\u0435\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u043a\u043e\u043c\u0430\u043d\u0434.\n");
        }
    }

    private static final class Printer
    extends WeakReference
    implements PrintListener {
        private int color;

        Printer(ConsoleScreen thisScreen, int color) {
            super(thisScreen);
            this.color = color;
        }

        public void write(byte[] src, int offset, int length) {
            ConsoleScreen thisScreen = (ConsoleScreen)((Object)this.get());
            if (thisScreen != null) {
                thisScreen.setColor(this.color);
                thisScreen.write(src, offset, length);
            }
        }

        public void print(char src) {
            ConsoleScreen thisScreen = (ConsoleScreen)((Object)this.get());
            if (thisScreen != null) {
                thisScreen.setColor(this.color);
                thisScreen.print(src);
            }
        }

        public void print(char[] src) {
            ConsoleScreen thisScreen = (ConsoleScreen)((Object)this.get());
            if (thisScreen != null) {
                thisScreen.setColor(this.color);
                thisScreen.print(src);
            }
        }

        public void print(String src) {
            ConsoleScreen thisScreen = (ConsoleScreen)((Object)this.get());
            if (thisScreen != null) {
                thisScreen.setColor(this.color);
                thisScreen.print(src);
            }
        }

        public void println() {
            ConsoleScreen thisScreen = (ConsoleScreen)((Object)this.get());
            if (thisScreen != null) {
                thisScreen.setColor(this.color);
                thisScreen.println();
            }
        }
    }
}

