/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.compression.zlib;

import java.io.ByteArrayOutputStream;
import malik.emulator.compression.zlib.Adler32;
import malik.emulator.compression.zlib.CRC32;
import malik.emulator.compression.zlib.GZIPHeader;
import malik.emulator.compression.zlib.InfBlocks;
import malik.emulator.compression.zlib.ZStream;
import malik.emulator.compression.zlib.Zlib;

final class Inflate
extends Zlib {
    private static final int PRESET_DICT = 32;
    private static final int Z_DEFLATED = 8;
    private static final int DICT4 = 2;
    private static final int DICT3 = 3;
    private static final int DICT2 = 4;
    private static final int DICT1 = 5;
    private static final int DICT0 = 6;
    private static final int BLOCKS = 7;
    private static final int CHECK4 = 8;
    private static final int CHECK3 = 9;
    private static final int CHECK2 = 10;
    private static final int CHECK1 = 11;
    private static final int DONE = 12;
    private static final int BAD = 13;
    private static final int HEAD = 14;
    private static final int LENGTH = 15;
    private static final int TIME = 16;
    private static final int OS = 17;
    private static final int EXLEN = 18;
    private static final int EXTRA = 19;
    private static final int NAME = 20;
    private static final int COMMENT = 21;
    private static final int HCRC = 22;
    private static final int FLAGS = 23;
    private static final byte[] MARK;
    public int mode;
    public int wrap;
    private boolean empty;
    private int method;
    private int marker;
    private int wbits;
    private int was = -1;
    private int need;
    private int flags;
    private int needBytes = -1;
    private byte[] crcbuf = new byte[4];
    private ByteArrayOutputStream tmpString;
    private InfBlocks blocks;
    private GZIPHeader gheader;
    private ZStream stream;

    static {
        byte[] byArray = new byte[4];
        byArray[2] = -1;
        byArray[3] = -1;
        MARK = byArray;
    }

    Inflate(ZStream stream) {
        this.stream = stream;
    }

    public int inflateEnd() {
        if (this.blocks != null) {
            this.blocks.free(this.stream);
        }
        return 0;
    }

    public int inflateInit(int w) {
        this.stream.msg = null;
        this.blocks = null;
        this.wrap = 0;
        if (w < 0) {
            w = -w;
        } else {
            this.wrap = (w >> 4) + 1;
            if (w < 48) {
                w &= 0xF;
            }
        }
        if (w < 8 || w > 15) {
            this.inflateEnd();
            return -2;
        }
        if (this.blocks != null && this.wbits != w) {
            this.blocks.free(this.stream);
            this.blocks = null;
        }
        this.wbits = w;
        this.blocks = new InfBlocks(this.stream, 1 << w);
        this.inflateReset();
        return 0;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public int inflate(int f) {
        if (this.stream == null || this.stream.nextIn == null) {
            if (f != 4) return -2;
            if (this.mode != 14) return -2;
            return 0;
        }
        f = f == 4 ? -5 : 0;
        r = -5;
        block24: while (true) {
            switch (this.mode) {
                default: {
                    return -2;
                }
                case 14: {
                    if (this.wrap == 0) {
                        this.mode = 7;
                        continue block24;
                    }
                    r = this.readBytes(this.stream, 2, r, f);
                    if (this.empty) {
                        return r;
                    }
                    if ((this.wrap & 2) != 0 && (long)this.need == 35615L) {
                        this.stream.adler = new CRC32();
                        this.checksum(2, this.need);
                        if (this.gheader == null) {
                            this.gheader = new GZIPHeader();
                        }
                        this.mode = 23;
                        continue block24;
                    }
                    this.flags = 0;
                    this.method = this.need & 255;
                    b = this.need >> 8 & 255;
                    if ((this.wrap & 1) == 0 || ((this.method << 8) + b) % 31 != 0) {
                        this.mode = 13;
                        this.stream.msg = "incorrect header check";
                        continue block24;
                    }
                    if ((this.method & 15) != 8) {
                        this.mode = 13;
                        this.stream.msg = "unknown compression method";
                        continue block24;
                    }
                    if ((this.method >> 4) + 8 > this.wbits) {
                        this.mode = 13;
                        this.stream.msg = "invalid window size";
                        continue block24;
                    }
                    this.stream.adler = new Adler32();
                    if ((b & 32) == 0) {
                        this.mode = 7;
                        continue block24;
                    }
                    this.mode = 2;
                }
                case 2: {
                    if (this.stream.availIn == 0) {
                        return r;
                    }
                    r = f;
                    --this.stream.availIn;
                    ++this.stream.totalIn;
                    this.need = (this.stream.nextIn[this.stream.nextInIndex++] & 255) << 24 & -16777216;
                    this.mode = 3;
                }
                case 3: {
                    if (this.stream.availIn == 0) {
                        return r;
                    }
                    r = f;
                    --this.stream.availIn;
                    ++this.stream.totalIn;
                    this.need += (this.stream.nextIn[this.stream.nextInIndex++] & 255) << 16 & 0xFF0000;
                    this.mode = 4;
                }
                case 4: {
                    if (this.stream.availIn == 0) {
                        return r;
                    }
                    r = f;
                    --this.stream.availIn;
                    ++this.stream.totalIn;
                    this.need += (this.stream.nextIn[this.stream.nextInIndex++] & 255) << 8 & 65280;
                    this.mode = 5;
                }
                case 5: {
                    if (this.stream.availIn == 0) {
                        return r;
                    }
                    r = f;
                    --this.stream.availIn;
                    ++this.stream.totalIn;
                    this.need = (int)((long)this.need + ((long)this.stream.nextIn[this.stream.nextInIndex++] & 255L));
                    this.stream.adler.reset(this.need);
                    this.mode = 6;
                    return 2;
                }
                case 6: {
                    this.mode = 13;
                    this.stream.msg = "need dictionary";
                    this.marker = 0;
                    return -2;
                }
                case 7: {
                    r = this.blocks.proc(this.stream, r);
                    if (r == -3) {
                        this.mode = 13;
                        this.marker = 0;
                        continue block24;
                    }
                    if (r == 0) {
                        r = f;
                    }
                    if (r != 1) {
                        return r;
                    }
                    r = f;
                    this.was = this.stream.adler.getValue();
                    this.blocks.reset(this.stream);
                    if (this.wrap == 0) {
                        this.mode = 12;
                        continue block24;
                    }
                    this.mode = 8;
                }
                case 8: {
                    if (this.stream.availIn == 0) {
                        return r;
                    }
                    r = f;
                    --this.stream.availIn;
                    ++this.stream.totalIn;
                    this.need = (this.stream.nextIn[this.stream.nextInIndex++] & 255) << 24 & -16777216;
                    this.mode = 9;
                }
                case 9: {
                    if (this.stream.availIn == 0) {
                        return r;
                    }
                    r = f;
                    --this.stream.availIn;
                    ++this.stream.totalIn;
                    this.need += (this.stream.nextIn[this.stream.nextInIndex++] & 255) << 16 & 0xFF0000;
                    this.mode = 10;
                }
                case 10: {
                    if (this.stream.availIn == 0) {
                        return r;
                    }
                    r = f;
                    --this.stream.availIn;
                    ++this.stream.totalIn;
                    this.need += (this.stream.nextIn[this.stream.nextInIndex++] & 255) << 8 & 65280;
                    this.mode = 11;
                }
                case 11: {
                    if (this.stream.availIn == 0) {
                        return r;
                    }
                    r = f;
                    --this.stream.availIn;
                    ++this.stream.totalIn;
                    this.need += this.stream.nextIn[this.stream.nextInIndex++] & 255;
                    if (this.flags != 0) {
                        this.need = (this.need & -16777216) >>> 24 | (this.need & 0xFF0000) >>> 8 | (this.need & 65280) << 8 | (this.need & 255) << 24;
                    }
                    if (this.was != this.need) {
                        this.stream.msg = "incorrect data check";
                    } else if (this.flags != 0 && this.gheader != null) {
                        this.gheader.crc = this.need;
                    }
                    this.mode = 15;
                }
                case 15: {
                    if (this.wrap != 0 && this.flags != 0) {
                        r = this.readBytes(this.stream, 4, r, f);
                        if (this.empty) {
                            return r;
                        }
                        if (this.stream.msg != null && this.stream.msg.equals("incorrect data check")) {
                            this.mode = 13;
                            this.marker = 5;
                            continue block24;
                        }
                        if ((long)this.need != (this.stream.totalOut & 0xFFFFFFFFL)) {
                            this.stream.msg = "incorrect length check";
                            this.mode = 13;
                            continue block24;
                        }
                        this.stream.msg = null;
                    } else if (this.stream.msg != null && this.stream.msg.equals("incorrect data check")) {
                        this.mode = 13;
                        this.marker = 5;
                        continue block24;
                    }
                    this.mode = 12;
                }
                case 12: {
                    return 1;
                }
                case 13: {
                    return -3;
                }
                case 23: {
                    r = this.readBytes(this.stream, 2, r, f);
                    if (this.empty) {
                        return r;
                    }
                    this.flags = this.need & 65535;
                    if ((this.flags & 255) != 8) {
                        this.stream.msg = "unknown compression method";
                        this.mode = 13;
                        continue block24;
                    }
                    if ((this.flags & 57344) != 0) {
                        this.stream.msg = "unknown header flags set";
                        this.mode = 13;
                        continue block24;
                    }
                    if ((this.flags & 512) != 0) {
                        this.checksum(2, this.need);
                    }
                    this.mode = 16;
                }
                case 16: {
                    r = this.readBytes(this.stream, 4, r, f);
                    if (this.empty) {
                        return r;
                    }
                    if (this.gheader != null) {
                        this.gheader.time = this.need;
                    }
                    if ((this.flags & 512) != 0) {
                        this.checksum(4, this.need);
                    }
                    this.mode = 17;
                }
                case 17: {
                    r = this.readBytes(this.stream, 2, r, f);
                    if (this.empty) {
                        return r;
                    }
                    if (this.gheader != null) {
                        this.gheader.xflags = this.need & 255;
                        this.gheader.os = this.need >> 8 & 255;
                    }
                    if ((this.flags & 512) != 0) {
                        this.checksum(2, this.need);
                    }
                    this.mode = 18;
                }
                case 18: {
                    if ((this.flags & 1024) != 0) {
                        r = this.readBytes(this.stream, 2, r, f);
                        if (this.empty) {
                            return r;
                        }
                        if (this.gheader != null) {
                            this.gheader.extra = new byte[this.need & 65535];
                        }
                        if ((this.flags & 512) != 0) {
                            this.checksum(2, this.need);
                        }
                    } else if (this.gheader != null) {
                        this.gheader.extra = null;
                    }
                    this.mode = 19;
                }
                case 19: {
                    if ((this.flags & 1024) == 0) ** GOTO lbl227
                    r = this.readBytes(this.stream, r, f);
                    if (this.empty) {
                        return r;
                    }
                    if (this.gheader == null) ** GOTO lbl229
                    foo = this.tmpString.toByteArray();
                    this.tmpString = null;
                    if (foo.length == this.gheader.extra.length) {
                        Array.copy((byte[])foo, (int)0, (byte[])this.gheader.extra, (int)0, (int)foo.length);
                    } else {
                        this.stream.msg = "bad extra field length";
                        this.mode = 13;
                        continue block24;
                    }
lbl227:
                    // 1 sources

                    if (this.gheader != null) {
                        this.gheader.extra = null;
                    }
lbl229:
                    // 5 sources

                    this.mode = 20;
                }
                case 20: {
                    if ((this.flags & 2048) != 0) {
                        r = this.readString(this.stream, r, f);
                        if (this.empty) {
                            return r;
                        }
                        if (this.gheader != null) {
                            this.gheader.name = this.tmpString.toByteArray();
                        }
                        this.tmpString = null;
                    } else if (this.gheader != null) {
                        this.gheader.name = null;
                    }
                    this.mode = 21;
                }
                case 21: {
                    if ((this.flags & 4096) != 0) {
                        r = this.readString(this.stream, r, f);
                        if (this.empty) {
                            return r;
                        }
                        if (this.gheader != null) {
                            this.gheader.comment = this.tmpString.toByteArray();
                        }
                        this.tmpString = null;
                    } else if (this.gheader != null) {
                        this.gheader.comment = null;
                    }
                    this.mode = 22;
                    break;
                }
                case 22: 
            }
            if ((this.flags & 512) != 0) {
                r = this.readBytes(this.stream, 2, r, f);
                if (this.empty) {
                    return r;
                }
                if (this.gheader != null) {
                    this.gheader.hcrc = this.need & 65535;
                }
                if ((long)this.need != ((long)this.stream.adler.getValue() & 65535L)) {
                    this.mode = 13;
                    this.stream.msg = "header crc mismatch";
                    this.marker = 5;
                    continue;
                }
            }
            this.stream.adler = new CRC32();
            this.mode = 7;
        }
    }

    public int inflateSetDictionary(byte[] dictionary, int dictLength) {
        if (this.stream == null || this.mode != 6 && this.wrap != 0) {
            return -2;
        }
        int index = 0;
        int length = dictLength;
        if (this.mode == 6) {
            int adlerNeed = this.stream.adler.getValue();
            this.stream.adler.reset();
            this.stream.adler.update(dictionary, 0, dictLength);
            if (this.stream.adler.getValue() != adlerNeed) {
                return -3;
            }
        }
        this.stream.adler.reset();
        if (length >= 1 << this.wbits) {
            length = (1 << this.wbits) - 1;
            index = dictLength - length;
        }
        this.blocks.setDictionary(dictionary, index, length);
        this.mode = 7;
        return 0;
    }

    public int inflateSync() {
        int n;
        if (this.stream == null) {
            return -2;
        }
        if (this.mode != 13) {
            this.mode = 13;
            this.marker = 0;
        }
        if ((n = this.stream.availIn) == 0) {
            return -5;
        }
        int p = this.stream.nextInIndex;
        int m = this.marker;
        while (n != 0 && m < 4) {
            m = this.stream.nextIn[p] == MARK[m] ? ++m : (this.stream.nextIn[p] != 0 ? 0 : 4 - m);
            ++p;
            --n;
        }
        this.stream.totalIn += (long)(p - this.stream.nextInIndex);
        this.stream.nextInIndex = p;
        this.stream.availIn = n;
        this.marker = m;
        if (m != 4) {
            return -3;
        }
        long r = this.stream.totalIn;
        long w = this.stream.totalOut;
        this.inflateReset();
        this.stream.totalIn = r;
        this.stream.totalOut = w;
        this.mode = 7;
        return 0;
    }

    public int inflateSyncPoint() {
        if (this.stream == null || this.blocks == null) {
            return -2;
        }
        return this.blocks.syncPoint();
    }

    private void checksum(int n, int v) {
        int i = 0;
        while (i < n) {
            this.crcbuf[i] = (byte)(v & 0xFF);
            v >>= 8;
            ++i;
        }
        this.stream.adler.update(this.crcbuf, 0, n);
    }

    private int inflateReset() {
        if (this.stream == null) {
            return -2;
        }
        this.stream.totalOut = 0L;
        this.stream.totalIn = 0L;
        this.stream.msg = null;
        this.mode = 14;
        this.needBytes = -1;
        this.blocks.reset(this.stream);
        return 0;
    }

    private int readBytes(ZStream z, int n, int r, int f) {
        if (this.needBytes == -1) {
            this.needBytes = n;
            this.need = 0;
        }
        while (this.needBytes > 0) {
            if (z.availIn == 0) {
                this.empty = true;
                return r;
            }
            r = f;
            --z.availIn;
            ++z.totalIn;
            this.need |= (z.nextIn[z.nextInIndex++] & 0xFF) << (n - this.needBytes) * 8;
            --this.needBytes;
        }
        if (n == 2) {
            this.need = (int)((long)this.need & 0xFFFFL);
        } else if (n == 4) {
            this.need &= 0xFFFFFFFF;
        }
        this.needBytes = -1;
        this.empty = false;
        return r;
    }

    private int readBytes(ZStream z, int r, int f) {
        if (this.tmpString == null) {
            this.tmpString = new ByteArrayOutputStream();
        }
        while (this.need > 0) {
            if (z.availIn == 0) {
                this.empty = true;
                return r;
            }
            r = f;
            --z.availIn;
            ++z.totalIn;
            this.tmpString.write(z.nextIn, z.nextInIndex, 1);
            z.adler.update(z.nextIn, z.nextInIndex, 1);
            ++z.nextInIndex;
            --this.need;
        }
        this.empty = false;
        return r;
    }

    private int readString(ZStream z, int r, int f) {
        if (this.tmpString == null) {
            this.tmpString = new ByteArrayOutputStream();
        }
        byte b = 0;
        do {
            if (z.availIn == 0) {
                this.empty = true;
                return r;
            }
            r = f;
            --z.availIn;
            ++z.totalIn;
            b = z.nextIn[z.nextInIndex];
            if (b != 0) {
                this.tmpString.write(z.nextIn, z.nextInIndex, 1);
            }
            z.adler.update(z.nextIn, z.nextInIndex, 1);
            ++z.nextInIndex;
        } while (b != 0);
        this.empty = false;
        return r;
    }
}

